/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.TestTypeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class TestTypeRequestMarshaller
implements Marshaller<Request<TestTypeRequest>, TestTypeRequest> {
    public Request<TestTypeRequest> marshall(TestTypeRequest testTypeRequest) {
        if (testTypeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)testTypeRequest, "AmazonCloudFormation");
        request.addParameter("Action", "TestType");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (testTypeRequest.getArn() != null) {
            request.addParameter("Arn", StringUtils.fromString((String)testTypeRequest.getArn()));
        }
        if (testTypeRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString((String)testTypeRequest.getType()));
        }
        if (testTypeRequest.getTypeName() != null) {
            request.addParameter("TypeName", StringUtils.fromString((String)testTypeRequest.getTypeName()));
        }
        if (testTypeRequest.getVersionId() != null) {
            request.addParameter("VersionId", StringUtils.fromString((String)testTypeRequest.getVersionId()));
        }
        if (testTypeRequest.getLogDeliveryBucket() != null) {
            request.addParameter("LogDeliveryBucket", StringUtils.fromString((String)testTypeRequest.getLogDeliveryBucket()));
        }
        return request;
    }
}

