/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devopsguru.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.devopsguru.model.CloudFormationHealth;
import com.amazonaws.services.devopsguru.model.ServiceHealth;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeResourceCollectionHealthResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<CloudFormationHealth> cloudFormation;
    private List<ServiceHealth> service;
    private String nextToken;

    public List<CloudFormationHealth> getCloudFormation() {
        return this.cloudFormation;
    }

    public void setCloudFormation(Collection<CloudFormationHealth> cloudFormation) {
        if (cloudFormation == null) {
            this.cloudFormation = null;
            return;
        }
        this.cloudFormation = new ArrayList<CloudFormationHealth>(cloudFormation);
    }

    public DescribeResourceCollectionHealthResult withCloudFormation(CloudFormationHealth ... cloudFormation) {
        if (this.cloudFormation == null) {
            this.setCloudFormation(new ArrayList<CloudFormationHealth>(cloudFormation.length));
        }
        for (CloudFormationHealth ele : cloudFormation) {
            this.cloudFormation.add(ele);
        }
        return this;
    }

    public DescribeResourceCollectionHealthResult withCloudFormation(Collection<CloudFormationHealth> cloudFormation) {
        this.setCloudFormation(cloudFormation);
        return this;
    }

    public List<ServiceHealth> getService() {
        return this.service;
    }

    public void setService(Collection<ServiceHealth> service) {
        if (service == null) {
            this.service = null;
            return;
        }
        this.service = new ArrayList<ServiceHealth>(service);
    }

    public DescribeResourceCollectionHealthResult withService(ServiceHealth ... service) {
        if (this.service == null) {
            this.setService(new ArrayList<ServiceHealth>(service.length));
        }
        for (ServiceHealth ele : service) {
            this.service.add(ele);
        }
        return this;
    }

    public DescribeResourceCollectionHealthResult withService(Collection<ServiceHealth> service) {
        this.setService(service);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeResourceCollectionHealthResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCloudFormation() != null) {
            sb.append("CloudFormation: ").append(this.getCloudFormation()).append(",");
        }
        if (this.getService() != null) {
            sb.append("Service: ").append(this.getService()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceCollectionHealthResult)) {
            return false;
        }
        DescribeResourceCollectionHealthResult other = (DescribeResourceCollectionHealthResult)obj;
        if (other.getCloudFormation() == null ^ this.getCloudFormation() == null) {
            return false;
        }
        if (other.getCloudFormation() != null && !other.getCloudFormation().equals(this.getCloudFormation())) {
            return false;
        }
        if (other.getService() == null ^ this.getService() == null) {
            return false;
        }
        if (other.getService() != null && !other.getService().equals(this.getService())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCloudFormation() == null ? 0 : this.getCloudFormation().hashCode());
        hashCode = 31 * hashCode + (this.getService() == null ? 0 : this.getService().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeResourceCollectionHealthResult clone() {
        try {
            return (DescribeResourceCollectionHealthResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

