/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CreateTrafficMirrorFilterRuleRequest;
import com.amazonaws.services.ec2.model.TrafficMirrorPortRangeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateTrafficMirrorFilterRuleRequestMarshaller
implements Marshaller<Request<CreateTrafficMirrorFilterRuleRequest>, CreateTrafficMirrorFilterRuleRequest> {
    public Request<CreateTrafficMirrorFilterRuleRequest> marshall(CreateTrafficMirrorFilterRuleRequest createTrafficMirrorFilterRuleRequest) {
        TrafficMirrorPortRangeRequest sourcePortRange;
        TrafficMirrorPortRangeRequest destinationPortRange;
        if (createTrafficMirrorFilterRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTrafficMirrorFilterRuleRequest, "AmazonEC2");
        request.addParameter("Action", "CreateTrafficMirrorFilterRule");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTrafficMirrorFilterRuleRequest.getTrafficMirrorFilterId() != null) {
            request.addParameter("TrafficMirrorFilterId", StringUtils.fromString((String)createTrafficMirrorFilterRuleRequest.getTrafficMirrorFilterId()));
        }
        if (createTrafficMirrorFilterRuleRequest.getTrafficDirection() != null) {
            request.addParameter("TrafficDirection", StringUtils.fromString((String)createTrafficMirrorFilterRuleRequest.getTrafficDirection()));
        }
        if (createTrafficMirrorFilterRuleRequest.getRuleNumber() != null) {
            request.addParameter("RuleNumber", StringUtils.fromInteger((Integer)createTrafficMirrorFilterRuleRequest.getRuleNumber()));
        }
        if (createTrafficMirrorFilterRuleRequest.getRuleAction() != null) {
            request.addParameter("RuleAction", StringUtils.fromString((String)createTrafficMirrorFilterRuleRequest.getRuleAction()));
        }
        if ((destinationPortRange = createTrafficMirrorFilterRuleRequest.getDestinationPortRange()) != null) {
            if (destinationPortRange.getFromPort() != null) {
                request.addParameter("DestinationPortRange.FromPort", StringUtils.fromInteger((Integer)destinationPortRange.getFromPort()));
            }
            if (destinationPortRange.getToPort() != null) {
                request.addParameter("DestinationPortRange.ToPort", StringUtils.fromInteger((Integer)destinationPortRange.getToPort()));
            }
        }
        if ((sourcePortRange = createTrafficMirrorFilterRuleRequest.getSourcePortRange()) != null) {
            if (sourcePortRange.getFromPort() != null) {
                request.addParameter("SourcePortRange.FromPort", StringUtils.fromInteger((Integer)sourcePortRange.getFromPort()));
            }
            if (sourcePortRange.getToPort() != null) {
                request.addParameter("SourcePortRange.ToPort", StringUtils.fromInteger((Integer)sourcePortRange.getToPort()));
            }
        }
        if (createTrafficMirrorFilterRuleRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromInteger((Integer)createTrafficMirrorFilterRuleRequest.getProtocol()));
        }
        if (createTrafficMirrorFilterRuleRequest.getDestinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString((String)createTrafficMirrorFilterRuleRequest.getDestinationCidrBlock()));
        }
        if (createTrafficMirrorFilterRuleRequest.getSourceCidrBlock() != null) {
            request.addParameter("SourceCidrBlock", StringUtils.fromString((String)createTrafficMirrorFilterRuleRequest.getSourceCidrBlock()));
        }
        if (createTrafficMirrorFilterRuleRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createTrafficMirrorFilterRuleRequest.getDescription()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createTrafficMirrorFilterRuleRequest.getClientToken()));
        return request;
    }
}

