/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackagevod.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediapackagevod.model.EncryptionContractConfiguration;
import com.amazonaws.services.mediapackagevod.model.transform.SpekeKeyProviderMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SpekeKeyProvider
implements Serializable,
Cloneable,
StructuredPojo {
    private EncryptionContractConfiguration encryptionContractConfiguration;
    private String roleArn;
    private List<String> systemIds;
    private String url;

    public void setEncryptionContractConfiguration(EncryptionContractConfiguration encryptionContractConfiguration) {
        this.encryptionContractConfiguration = encryptionContractConfiguration;
    }

    public EncryptionContractConfiguration getEncryptionContractConfiguration() {
        return this.encryptionContractConfiguration;
    }

    public SpekeKeyProvider withEncryptionContractConfiguration(EncryptionContractConfiguration encryptionContractConfiguration) {
        this.setEncryptionContractConfiguration(encryptionContractConfiguration);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public SpekeKeyProvider withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public List<String> getSystemIds() {
        return this.systemIds;
    }

    public void setSystemIds(Collection<String> systemIds) {
        if (systemIds == null) {
            this.systemIds = null;
            return;
        }
        this.systemIds = new ArrayList<String>(systemIds);
    }

    public SpekeKeyProvider withSystemIds(String ... systemIds) {
        if (this.systemIds == null) {
            this.setSystemIds(new ArrayList<String>(systemIds.length));
        }
        for (String ele : systemIds) {
            this.systemIds.add(ele);
        }
        return this;
    }

    public SpekeKeyProvider withSystemIds(Collection<String> systemIds) {
        this.setSystemIds(systemIds);
        return this;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public SpekeKeyProvider withUrl(String url) {
        this.setUrl(url);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryptionContractConfiguration() != null) {
            sb.append("EncryptionContractConfiguration: ").append(this.getEncryptionContractConfiguration()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getSystemIds() != null) {
            sb.append("SystemIds: ").append(this.getSystemIds()).append(",");
        }
        if (this.getUrl() != null) {
            sb.append("Url: ").append(this.getUrl());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpekeKeyProvider)) {
            return false;
        }
        SpekeKeyProvider other = (SpekeKeyProvider)obj;
        if (other.getEncryptionContractConfiguration() == null ^ this.getEncryptionContractConfiguration() == null) {
            return false;
        }
        if (other.getEncryptionContractConfiguration() != null && !other.getEncryptionContractConfiguration().equals(this.getEncryptionContractConfiguration())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getSystemIds() == null ^ this.getSystemIds() == null) {
            return false;
        }
        if (other.getSystemIds() != null && !other.getSystemIds().equals(this.getSystemIds())) {
            return false;
        }
        if (other.getUrl() == null ^ this.getUrl() == null) {
            return false;
        }
        return other.getUrl() == null || other.getUrl().equals(this.getUrl());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryptionContractConfiguration() == null ? 0 : this.getEncryptionContractConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getSystemIds() == null ? 0 : this.getSystemIds().hashCode());
        hashCode = 31 * hashCode + (this.getUrl() == null ? 0 : this.getUrl().hashCode());
        return hashCode;
    }

    public SpekeKeyProvider clone() {
        try {
            return (SpekeKeyProvider)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SpekeKeyProviderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

