/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroupstaggingapi.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TagResourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> resourceARNList;
    private Map<String, String> tags;

    public List<String> getResourceARNList() {
        return this.resourceARNList;
    }

    public void setResourceARNList(Collection<String> resourceARNList) {
        if (resourceARNList == null) {
            this.resourceARNList = null;
            return;
        }
        this.resourceARNList = new ArrayList<String>(resourceARNList);
    }

    public TagResourcesRequest withResourceARNList(String ... resourceARNList) {
        if (this.resourceARNList == null) {
            this.setResourceARNList(new ArrayList<String>(resourceARNList.length));
        }
        for (String ele : resourceARNList) {
            this.resourceARNList.add(ele);
        }
        return this;
    }

    public TagResourcesRequest withResourceARNList(Collection<String> resourceARNList) {
        this.setResourceARNList(resourceARNList);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public TagResourcesRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public TagResourcesRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public TagResourcesRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceARNList() != null) {
            sb.append("ResourceARNList: ").append(this.getResourceARNList()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagResourcesRequest)) {
            return false;
        }
        TagResourcesRequest other = (TagResourcesRequest)obj;
        if (other.getResourceARNList() == null ^ this.getResourceARNList() == null) {
            return false;
        }
        if (other.getResourceARNList() != null && !other.getResourceARNList().equals(this.getResourceARNList())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceARNList() == null ? 0 : this.getResourceARNList().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public TagResourcesRequest clone() {
        return (TagResourcesRequest)super.clone();
    }
}

