/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentIdentifier;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListDocumentsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<DocumentIdentifier> documentIdentifiers;
    private String nextToken;

    public List<DocumentIdentifier> getDocumentIdentifiers() {
        if (this.documentIdentifiers == null) {
            this.documentIdentifiers = new SdkInternalList();
        }
        return this.documentIdentifiers;
    }

    public void setDocumentIdentifiers(Collection<DocumentIdentifier> documentIdentifiers) {
        if (documentIdentifiers == null) {
            this.documentIdentifiers = null;
            return;
        }
        this.documentIdentifiers = new SdkInternalList(documentIdentifiers);
    }

    public ListDocumentsResult withDocumentIdentifiers(DocumentIdentifier ... documentIdentifiers) {
        if (this.documentIdentifiers == null) {
            this.setDocumentIdentifiers((Collection<DocumentIdentifier>)new SdkInternalList(documentIdentifiers.length));
        }
        for (DocumentIdentifier ele : documentIdentifiers) {
            this.documentIdentifiers.add((Object)ele);
        }
        return this;
    }

    public ListDocumentsResult withDocumentIdentifiers(Collection<DocumentIdentifier> documentIdentifiers) {
        this.setDocumentIdentifiers(documentIdentifiers);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListDocumentsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentIdentifiers() != null) {
            sb.append("DocumentIdentifiers: ").append(this.getDocumentIdentifiers()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentsResult)) {
            return false;
        }
        ListDocumentsResult other = (ListDocumentsResult)obj;
        if (other.getDocumentIdentifiers() == null ^ this.getDocumentIdentifiers() == null) {
            return false;
        }
        if (other.getDocumentIdentifiers() != null && !other.getDocumentIdentifiers().equals(this.getDocumentIdentifiers())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentIdentifiers() == null ? 0 : this.getDocumentIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListDocumentsResult clone() {
        try {
            return (ListDocumentsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

