/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.sdb.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AmazonSimpleDBUtil {
    private static String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public static String encodeZeroPadding(int n, int n2) {
        String string = Integer.toString(n);
        int n3 = n2 - string.length();
        StringBuffer stringBuffer = new StringBuffer(n3 + string.length());
        for (int i = 0; i < n3; ++i) {
            stringBuffer.insert(i, '0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String encodeZeroPadding(float f, int n) {
        String string = Float.toString(f);
        int n2 = string.indexOf(46);
        n2 = n2 >= 0 ? n2 : string.length();
        int n3 = n - n2;
        StringBuffer stringBuffer = new StringBuffer(n3 + string.length());
        for (int i = 0; i < n3; ++i) {
            stringBuffer.insert(i, '0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static int decodeZeroPaddingInt(String string) {
        return Integer.parseInt(string, 10);
    }

    public static float decodeZeroPaddingFloat(String string) {
        return Float.valueOf(string).floatValue();
    }

    public static String encodeRealNumberRange(int n, int n2, int n3) {
        long l = n + n3;
        String string = Long.toString(l);
        int n4 = n2 - string.length();
        StringBuffer stringBuffer = new StringBuffer(n4 + string.length());
        for (int i = 0; i < n4; ++i) {
            stringBuffer.insert(i, '0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String encodeRealNumberRange(float f, int n, int n2, int n3) {
        int n4 = (int)Math.pow(10.0, n2);
        long l = Math.round(f * (float)n4);
        long l2 = n3 * n4;
        long l3 = l + l2;
        String string = Long.toString(l3);
        int n5 = string.length();
        int n6 = n + n2 - n5;
        StringBuffer stringBuffer = new StringBuffer(n6 + string.length());
        for (int i = 0; i < n6; ++i) {
            stringBuffer.insert(i, '0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static int decodeRealNumberRangeInt(String string, int n) {
        long l = Long.parseLong(string, 10);
        return (int)(l - (long)n);
    }

    public static float decodeRealNumberRangeFloat(String string, int n, int n2) {
        long l = Long.parseLong(string, 10);
        int n3 = (int)Math.pow(10.0, n);
        double d = l - (long)(n2 * n3);
        return (float)(d / (double)n3);
    }

    public static String encodeDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        String string = simpleDateFormat.format(date);
        return string.substring(0, string.length() - 2) + ":" + string.substring(string.length() - 2);
    }

    public static Date decodeDate(String string) throws ParseException {
        String string2 = string.substring(0, string.length() - 3) + string.substring(string.length() - 2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        return simpleDateFormat.parse(string2);
    }
}

