/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.util;

import com.amazonaws.secretsmanager.util.PropertyException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;

public final class Config {
    public static final String CONFIG_FILE_NAME = "secretsmanager.properties";
    private Properties config;
    private String prefix;

    private Config(String prefix, Properties config) {
        this.config = config;
        this.prefix = prefix;
    }

    private static Properties loadPropertiesFromConfigFile(String resourceName) {
        Properties newConfig = new Properties(System.getProperties());
        try (InputStream configFile = ClassLoader.getSystemResourceAsStream(resourceName);){
            if (configFile != null) {
                newConfig.load(configFile);
                configFile.close();
            }
        }
        catch (IOException e) {
            throw new PropertyException("An error occured when loading the property file, secretsmanager.properties", e);
        }
        return newConfig;
    }

    public static Config loadConfigFrom(String resourceName) {
        return new Config(null, Config.loadPropertiesFromConfigFile(resourceName));
    }

    public static Config loadMainConfig() {
        return Config.loadConfigFrom(CONFIG_FILE_NAME);
    }

    private boolean isSubproperty(String propertyName, String subprefix) {
        return propertyName.indexOf(subprefix + ".") == 0;
    }

    private String getSubproperty(String fullPropertyName, String subprefix) {
        return fullPropertyName.substring(subprefix.length() + 1);
    }

    public Config getSubconfig(String subprefix) {
        Enumeration<?> propertyNames = this.config.propertyNames();
        Properties subconfig = null;
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            if (!this.isSubproperty(name, subprefix)) continue;
            if (subconfig == null) {
                subconfig = new Properties();
            }
            String subpropertyName = this.getSubproperty(name, subprefix);
            subconfig.setProperty(subpropertyName, this.config.getProperty(name));
        }
        if (subconfig == null) {
            return null;
        }
        if (this.prefix != null) {
            return new Config(this.prefix + "." + subprefix, subconfig);
        }
        return new Config(subprefix, subconfig);
    }

    public String fullPropertyName(String propertyName) {
        if (this.prefix != null) {
            return this.prefix + "." + propertyName;
        }
        return propertyName;
    }

    public String getStringPropertyWithDefault(String propertyName, String defaultValue) {
        String propertyValue = this.config.getProperty(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        return propertyValue;
    }

    public int getIntPropertyWithDefault(String propertyName, int defaultValue) {
        String propertyValue = this.config.getProperty(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException e) {
            throw new PropertyException(this.fullPropertyName(propertyName) + " must be of type int. Please check " + CONFIG_FILE_NAME + " or your system properties for typos.", e);
        }
    }

    public long getLongPropertyWithDefault(String propertyName, long defaultValue) {
        String propertyValue = this.config.getProperty(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(propertyValue);
        }
        catch (NumberFormatException e) {
            throw new PropertyException(this.fullPropertyName(propertyName) + " must be of type long. Please check " + CONFIG_FILE_NAME + " or your system properties for typos.", e);
        }
    }

    public Class getClassPropertyWithDefault(String propertyName, Class defaultValue) {
        String propertyValue = this.config.getProperty(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        try {
            return Class.forName(propertyValue);
        }
        catch (ClassNotFoundException e) {
            throw new PropertyException(this.fullPropertyName(propertyName) + " must be a valid class name. Please check " + CONFIG_FILE_NAME + " or your system properties for typos.", e);
        }
    }

    private void throwIfPropertyIsNotSet(String propertyName) {
        if (this.config.getProperty(propertyName) == null) {
            throw new NoSuchElementException(this.fullPropertyName(propertyName) + " property must be specified either in " + CONFIG_FILE_NAME + " or in the system properties.");
        }
    }

    public String getRequiredStringProperty(String propertyName) {
        this.throwIfPropertyIsNotSet(propertyName);
        String propertyValue = this.config.getProperty(propertyName);
        return propertyValue;
    }

    public int getRequiredIntProperty(String propertyName) {
        this.throwIfPropertyIsNotSet(propertyName);
        return this.getIntPropertyWithDefault(propertyName, 0);
    }

    public long getRequiredLongProperty(String propertyName) {
        this.throwIfPropertyIsNotSet(propertyName);
        return this.getLongPropertyWithDefault(propertyName, 0L);
    }

    public Class getRequiredClassProperty(String propertyName) {
        this.throwIfPropertyIsNotSet(propertyName);
        return this.getClassPropertyWithDefault(propertyName, null);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        Properties this$config = this.config;
        Properties other$config = other.config;
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        String this$prefix = this.prefix;
        String other$prefix = other.prefix;
        return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Properties $config = this.config;
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        String $prefix = this.prefix;
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        return result;
    }
}

