/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.ApacheCombinedServletLogFormatter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsFilterChainManager;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContext;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletRegistration;
import com.amazonaws.serverless.proxy.internal.servlet.FilterChainManager;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterChain;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AwsLambdaServletContainerHandler<RequestType, ResponseType, ContainerRequestType extends HttpServletRequest, ContainerResponseType extends HttpServletResponse>
extends LambdaContainerHandler<RequestType, ResponseType, ContainerRequestType, ContainerResponseType> {
    private Logger log = LoggerFactory.getLogger(AwsLambdaServletContainerHandler.class);
    private FilterChainManager<AwsServletContext> filterChainManager;
    protected StartupHandler startupHandler;
    protected ServletContext servletContext;

    protected AwsLambdaServletContainerHandler(Class<RequestType> requestTypeClass, Class<ResponseType> responseTypeClass, RequestReader<RequestType, ContainerRequestType> requestReader, ResponseWriter<ContainerResponseType, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler) {
        super(requestTypeClass, responseTypeClass, requestReader, responseWriter, securityContextWriter, exceptionHandler);
        this.setLogFormatter(new ApacheCombinedServletLogFormatter());
        this.setServletContext(new AwsServletContext(this));
    }

    public void onStartup(StartupHandler h) {
        this.startupHandler = h;
        this.startupHandler.onStartup(this.getServletContext());
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    protected void setServletContext(ServletContext context) {
        this.servletContext = context;
        this.filterChainManager = new AwsFilterChainManager((AwsServletContext)this.servletContext);
    }

    protected FilterChain getFilterChain(HttpServletRequest req, Servlet servlet) {
        return this.filterChainManager.getFilterChain(req, servlet);
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, Servlet servlet) throws IOException, ServletException {
        if (AwsHttpServletRequest.class.isAssignableFrom(request.getClass())) {
            ((AwsHttpServletRequest)request).setContainerHandler(this);
        }
        FilterChain chain = this.getFilterChain(request, servlet);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (!response.isCommitted() && request.getDispatcherType() != DispatcherType.ASYNC) {
            response.flushBuffer();
        }
    }

    @Override
    public void initialize() throws ContainerInitializationException {
        ArrayList registrations = new ArrayList(this.getServletContext().getServletRegistrations().values());
        registrations.sort(AwsServletRegistration::compareTo);
        for (AwsServletRegistration r : registrations) {
            if (r.getLoadOnStartup() == -1) continue;
            try {
                if (r.getServlet() == null) continue;
                r.getServlet().init(r.getServletConfig());
            }
            catch (ServletException e) {
                throw new ContainerInitializationException("Could not initialize servlet " + r.getName(), (Exception)((Object)e));
            }
        }
    }

    public static interface StartupHandler {
        public void onStartup(ServletContext var1);
    }
}

