/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.model.MultiValuedTreeMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.http.Part;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;

public class AwsProxyRequestPart
implements Part {
    private String name;
    private String submittedFileName;
    private long size;
    private String contentType;
    private MultiValuedTreeMap<String, String> headers;
    private byte[] content;

    public AwsProxyRequestPart(byte[] content) {
        this.content = (byte[])content.clone();
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public String getSubmittedFileName() {
        return this.submittedFileName;
    }

    public long getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_OUT"})
    public void write(String s) throws IOException {
        String canonicalFilePath = SecurityUtils.getValidFilePath(s);
        try (FileOutputStream fos = new FileOutputStream(canonicalFilePath);){
            fos.write(this.content);
        }
    }

    public void delete() throws IOException {
    }

    public String getHeader(String s) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.getFirst(s);
    }

    public Collection<String> getHeaders(String s) {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        return this.headers.get(s);
    }

    public Collection<String> getHeaderNames() {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        return this.headers.keySet();
    }

    public void addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new MultiValuedTreeMap(String.CASE_INSENSITIVE_ORDER);
        }
        if (this.headers.containsKey(key)) {
            this.headers.add(key, value);
        } else {
            this.headers.putSingle(key, value);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSubmittedFileName(String submittedFileName) {
        this.submittedFileName = submittedFileName;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setHeaders(MultiValuedTreeMap<String, String> headers) {
        this.headers = headers;
    }
}

