/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.adapters;

import android.databinding.BindingAdapter;
import android.databinding.BindingMethod;
import android.databinding.BindingMethods;
import android.databinding.InverseBindingListener;
import android.databinding.InverseBindingMethod;
import android.databinding.InverseBindingMethods;
import android.view.View;
import android.widget.AdapterView;

@BindingMethods(value={@BindingMethod(type=AdapterView.class, attribute="android:onItemClick", method="setOnItemClickListener"), @BindingMethod(type=AdapterView.class, attribute="android:onItemLongClick", method="setOnItemLongClickListener")})
@InverseBindingMethods(value={@InverseBindingMethod(type=AdapterView.class, attribute="android:selectedItemPosition")})
public class AdapterViewBindingAdapter {
    @BindingAdapter(value={"android:selectedItemPosition"})
    public static void setSelectedItemPosition(AdapterView view, int position) {
        if (view.getSelectedItemPosition() != position) {
            view.setSelection(position);
        }
    }

    @BindingAdapter(value={"android:onItemSelected", "android:onNothingSelected", "android:selectedItemPositionAttrChanged"}, requireAll=false)
    public static void setOnItemSelectedListener(AdapterView view, OnItemSelected selected, OnNothingSelected nothingSelected, InverseBindingListener attrChanged) {
        if (selected == null && nothingSelected == null && attrChanged == null) {
            view.setOnItemSelectedListener(null);
        } else {
            view.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)new OnItemSelectedComponentListener(selected, nothingSelected, attrChanged));
        }
    }

    public static interface OnNothingSelected {
        public void onNothingSelected(AdapterView<?> var1);
    }

    public static interface OnItemSelected {
        public void onItemSelected(AdapterView<?> var1, View var2, int var3, long var4);
    }

    public static class OnItemSelectedComponentListener
    implements AdapterView.OnItemSelectedListener {
        private final OnItemSelected mSelected;
        private final OnNothingSelected mNothingSelected;
        private final InverseBindingListener mAttrChanged;

        public OnItemSelectedComponentListener(OnItemSelected selected, OnNothingSelected nothingSelected, InverseBindingListener attrChanged) {
            this.mSelected = selected;
            this.mNothingSelected = nothingSelected;
            this.mAttrChanged = attrChanged;
        }

        public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
            if (this.mSelected != null) {
                this.mSelected.onItemSelected(parent, view, position, id);
            }
            if (this.mAttrChanged != null) {
                this.mAttrChanged.onChange();
            }
        }

        public void onNothingSelected(AdapterView<?> parent) {
            if (this.mNothingSelected != null) {
                this.mNothingSelected.onNothingSelected(parent);
            }
            if (this.mAttrChanged != null) {
                this.mAttrChanged.onChange();
            }
        }
    }
}

