/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.adapters;

import android.annotation.TargetApi;
import android.databinding.BindingAdapter;
import android.databinding.BindingMethod;
import android.databinding.BindingMethods;
import android.databinding.adapters.ListenerUtil;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import com.android.databinding.library.baseAdapters.R;

@BindingMethods(value={@BindingMethod(type=View.class, attribute="android:backgroundTint", method="setBackgroundTintList"), @BindingMethod(type=View.class, attribute="android:fadeScrollbars", method="setScrollbarFadingEnabled"), @BindingMethod(type=View.class, attribute="android:getOutline", method="setOutlineProvider"), @BindingMethod(type=View.class, attribute="android:nextFocusForward", method="setNextFocusForwardId"), @BindingMethod(type=View.class, attribute="android:nextFocusLeft", method="setNextFocusLeftId"), @BindingMethod(type=View.class, attribute="android:nextFocusRight", method="setNextFocusRightId"), @BindingMethod(type=View.class, attribute="android:nextFocusUp", method="setNextFocusUpId"), @BindingMethod(type=View.class, attribute="android:nextFocusDown", method="setNextFocusDownId"), @BindingMethod(type=View.class, attribute="android:requiresFadingEdge", method="setVerticalFadingEdgeEnabled"), @BindingMethod(type=View.class, attribute="android:scrollbarDefaultDelayBeforeFade", method="setScrollBarDefaultDelayBeforeFade"), @BindingMethod(type=View.class, attribute="android:scrollbarFadeDuration", method="setScrollBarFadeDuration"), @BindingMethod(type=View.class, attribute="android:scrollbarSize", method="setScrollBarSize"), @BindingMethod(type=View.class, attribute="android:scrollbarStyle", method="setScrollBarStyle"), @BindingMethod(type=View.class, attribute="android:transformPivotX", method="setPivotX"), @BindingMethod(type=View.class, attribute="android:transformPivotY", method="setPivotY"), @BindingMethod(type=View.class, attribute="android:onDrag", method="setOnDragListener"), @BindingMethod(type=View.class, attribute="android:onClick", method="setOnClickListener"), @BindingMethod(type=View.class, attribute="android:onApplyWindowInsets", method="setOnApplyWindowInsetsListener"), @BindingMethod(type=View.class, attribute="android:onCreateContextMenu", method="setOnCreateContextMenuListener"), @BindingMethod(type=View.class, attribute="android:onFocusChange", method="setOnFocusChangeListener"), @BindingMethod(type=View.class, attribute="android:onGenericMotion", method="setOnGenericMotionListener"), @BindingMethod(type=View.class, attribute="android:onHover", method="setOnHoverListener"), @BindingMethod(type=View.class, attribute="android:onKey", method="setOnKeyListener"), @BindingMethod(type=View.class, attribute="android:onLongClick", method="setOnLongClickListener"), @BindingMethod(type=View.class, attribute="android:onSystemUiVisibilityChange", method="setOnSystemUiVisibilityChangeListener"), @BindingMethod(type=View.class, attribute="android:onTouch", method="setOnTouchListener")})
public class ViewBindingAdapter {
    public static int FADING_EDGE_NONE = 0;
    public static int FADING_EDGE_HORIZONTAL = 1;
    public static int FADING_EDGE_VERTICAL = 2;

    @BindingAdapter(value={"android:padding"})
    public static void setPadding(View view, float paddingFloat) {
        int padding = ViewBindingAdapter.pixelsToDimensionPixelSize(paddingFloat);
        view.setPadding(padding, padding, padding, padding);
    }

    @BindingAdapter(value={"android:paddingBottom"})
    public static void setPaddingBottom(View view, float paddingFloat) {
        int padding = ViewBindingAdapter.pixelsToDimensionPixelSize(paddingFloat);
        view.setPadding(view.getPaddingLeft(), view.getPaddingTop(), view.getPaddingRight(), padding);
    }

    @BindingAdapter(value={"android:paddingEnd"})
    public static void setPaddingEnd(View view, float paddingFloat) {
        int padding = ViewBindingAdapter.pixelsToDimensionPixelSize(paddingFloat);
        if (Build.VERSION.SDK_INT >= 17) {
            view.setPaddingRelative(view.getPaddingStart(), view.getPaddingTop(), padding, view.getPaddingBottom());
        } else {
            view.setPadding(view.getPaddingLeft(), view.getPaddingTop(), padding, view.getPaddingBottom());
        }
    }

    @BindingAdapter(value={"android:paddingLeft"})
    public static void setPaddingLeft(View view, float paddingFloat) {
        int padding = ViewBindingAdapter.pixelsToDimensionPixelSize(paddingFloat);
        view.setPadding(padding, view.getPaddingTop(), view.getPaddingRight(), view.getPaddingBottom());
    }

    @BindingAdapter(value={"android:paddingRight"})
    public static void setPaddingRight(View view, float paddingFloat) {
        int padding = ViewBindingAdapter.pixelsToDimensionPixelSize(paddingFloat);
        view.setPadding(view.getPaddingLeft(), view.getPaddingTop(), padding, view.getPaddingBottom());
    }

    @BindingAdapter(value={"android:paddingStart"})
    public static void setPaddingStart(View view, float paddingFloat) {
        int padding = ViewBindingAdapter.pixelsToDimensionPixelSize(paddingFloat);
        if (Build.VERSION.SDK_INT >= 17) {
            view.setPaddingRelative(padding, view.getPaddingTop(), view.getPaddingEnd(), view.getPaddingBottom());
        } else {
            view.setPadding(padding, view.getPaddingTop(), view.getPaddingRight(), view.getPaddingBottom());
        }
    }

    @BindingAdapter(value={"android:paddingTop"})
    public static void setPaddingTop(View view, float paddingFloat) {
        int padding = ViewBindingAdapter.pixelsToDimensionPixelSize(paddingFloat);
        view.setPadding(view.getPaddingLeft(), padding, view.getPaddingRight(), view.getPaddingBottom());
    }

    @BindingAdapter(value={"android:requiresFadingEdge"})
    public static void setRequiresFadingEdge(View view, int value) {
        boolean vertical = (value & FADING_EDGE_VERTICAL) != 0;
        boolean horizontal = (value & FADING_EDGE_HORIZONTAL) != 0;
        view.setVerticalFadingEdgeEnabled(vertical);
        view.setHorizontalFadingEdgeEnabled(horizontal);
    }

    @BindingAdapter(value={"android:onClickListener", "android:clickable"})
    public static void setClickListener(View view, View.OnClickListener clickListener, boolean clickable) {
        view.setOnClickListener(clickListener);
        view.setClickable(clickable);
    }

    @BindingAdapter(value={"android:onClick", "android:clickable"})
    public static void setOnClick(View view, View.OnClickListener clickListener, boolean clickable) {
        view.setOnClickListener(clickListener);
        view.setClickable(clickable);
    }

    @BindingAdapter(value={"android:onLongClickListener", "android:longClickable"})
    public static void setOnLongClickListener(View view, View.OnLongClickListener clickListener, boolean clickable) {
        view.setOnLongClickListener(clickListener);
        view.setLongClickable(clickable);
    }

    @BindingAdapter(value={"android:onLongClick", "android:longClickable"})
    public static void setOnLongClick(View view, View.OnLongClickListener clickListener, boolean clickable) {
        view.setOnLongClickListener(clickListener);
        view.setLongClickable(clickable);
    }

    @BindingAdapter(value={"android:onViewDetachedFromWindow", "android:onViewAttachedToWindow"}, requireAll=false)
    public static void setOnAttachStateChangeListener(View view, final OnViewDetachedFromWindow detach, final OnViewAttachedToWindow attach) {
        if (Build.VERSION.SDK_INT >= 12) {
            View.OnAttachStateChangeListener newListener = detach == null && attach == null ? null : new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                    if (attach != null) {
                        attach.onViewAttachedToWindow(v);
                    }
                }

                public void onViewDetachedFromWindow(View v) {
                    if (detach != null) {
                        detach.onViewDetachedFromWindow(v);
                    }
                }
            };
            View.OnAttachStateChangeListener oldListener = ListenerUtil.trackListener(view, newListener, R.id.onAttachStateChangeListener);
            if (oldListener != null) {
                view.removeOnAttachStateChangeListener(oldListener);
            }
            if (newListener != null) {
                view.addOnAttachStateChangeListener(newListener);
            }
        }
    }

    @BindingAdapter(value={"android:onLayoutChange"})
    public static void setOnLayoutChangeListener(View view, View.OnLayoutChangeListener oldValue, View.OnLayoutChangeListener newValue) {
        if (Build.VERSION.SDK_INT >= 11) {
            if (oldValue != null) {
                view.removeOnLayoutChangeListener(oldValue);
            }
            if (newValue != null) {
                view.addOnLayoutChangeListener(newValue);
            }
        }
    }

    @BindingAdapter(value={"android:background"})
    public static void setBackground(View view, Drawable drawable) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable);
        } else {
            view.setBackgroundDrawable(drawable);
        }
    }

    private static int pixelsToDimensionPixelSize(float pixels) {
        int result = (int)(pixels + 0.5f);
        if (result != 0) {
            return result;
        }
        if (pixels == 0.0f) {
            return 0;
        }
        if (pixels > 0.0f) {
            return 1;
        }
        return -1;
    }

    @TargetApi(value=12)
    public static interface OnViewAttachedToWindow {
        public void onViewAttachedToWindow(View var1);
    }

    @TargetApi(value=12)
    public static interface OnViewDetachedFromWindow {
        public void onViewDetachedFromWindow(View var1);
    }
}

