/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;

public class CallbackWrapper {
    public static String SOURCE_ID = "sourceId";
    public static String ARG_PREFIX = "callbackArg_";
    public final ModelClass klass;
    public final ModelMethod method;
    public final String key;
    private static final String V1_PACKAGE = "android.databinding.generated.callback";
    private static final String CALLBACK_PACKAGE_SUFFIX = ".generated.callback";
    private static final String LISTENER_NAME = "Listener";
    private String mClassName;
    private String mListenerMethodName;
    private boolean mInitialized;
    private final String mPackage;

    public CallbackWrapper(ModelClass klass2, ModelMethod method, String modulePackage, boolean enableV2) {
        this.klass = klass2;
        this.method = method;
        this.mPackage = enableV2 ? modulePackage + CALLBACK_PACKAGE_SUFFIX : V1_PACKAGE;
        this.key = CallbackWrapper.uniqueKey(klass2, method);
    }

    public void prepare(String className, String listenerMethodName) {
        if (this.mInitialized) {
            L.e((String)"trying to initialize listener wrapper twice.", (Object[])new Object[0]);
        }
        this.mInitialized = true;
        this.mClassName = className;
        this.mListenerMethodName = listenerMethodName;
    }

    public String getPackage() {
        return this.mPackage;
    }

    public String getClassName() {
        Preconditions.check((boolean)this.mInitialized, (String)"Listener wrapper is not initialized yet.", (Object[])new Object[0]);
        return this.mClassName;
    }

    public String getListenerInterfaceName() {
        return LISTENER_NAME;
    }

    public String getListenerMethodName() {
        Preconditions.check((boolean)this.mInitialized, (String)"Listener wrapper is not initialized yet.", (Object[])new Object[0]);
        return this.mListenerMethodName;
    }

    public static String uniqueKey(ModelClass klass2, ModelMethod method) {
        String base = klass2.getCanonicalName() + "#" + method.getName();
        for (ModelClass param : method.getParameterTypes()) {
            base = base + param + ",";
        }
        return base;
    }

    public String getCannonicalName() {
        return this.getPackage() + "." + this.getClassName();
    }

    public String getCannonicalListenerName() {
        return this.getPackage() + "." + this.getClassName() + "." + this.getListenerInterfaceName();
    }

    public String constructForIdentifier(int listenerId) {
        return "new " + this.getCannonicalName() + "(this, " + listenerId + ")";
    }

    public int getMinApi() {
        return Math.min(this.method.getMinApi(), this.klass.getMinApi());
    }
}

