/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.view;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v7.appcompat.R;
import android.util.DisplayMetrics;
import android.view.ViewConfiguration;

public class ActionBarPolicy {
    private Context mContext;

    public static ActionBarPolicy get(Context context) {
        return new ActionBarPolicy(context);
    }

    private ActionBarPolicy(Context context) {
        this.mContext = context;
    }

    public int getMaxActionButtons() {
        int heightDp;
        int widthDp;
        Configuration config = this.mContext.getResources().getConfiguration();
        int sdk = Build.VERSION.SDK_INT;
        if (sdk >= 12) {
            widthDp = config.screenWidthDp;
            heightDp = config.screenHeightDp;
        } else {
            DisplayMetrics metrics = this.mContext.getResources().getDisplayMetrics();
            widthDp = (int)((float)metrics.widthPixels / metrics.density);
            heightDp = (int)((float)metrics.heightPixels / metrics.density);
        }
        int smallest = sdk >= 13 ? config.smallestScreenWidthDp : Math.min(widthDp, heightDp);
        if (smallest > 600 || widthDp > 600 || widthDp > 960 && heightDp > 720 || widthDp > 720 && heightDp > 960) {
            return 5;
        }
        if (widthDp >= 500 || widthDp > 640 && heightDp > 480 || widthDp > 480 && heightDp > 640) {
            return 4;
        }
        if (widthDp >= 360) {
            return 3;
        }
        return 2;
    }

    public boolean showsOverflowMenuButton() {
        if (Build.VERSION.SDK_INT >= 19) {
            return true;
        }
        return !ViewConfigurationCompat.hasPermanentMenuKey((ViewConfiguration)ViewConfiguration.get((Context)this.mContext));
    }

    public int getEmbeddedMenuWidthLimit() {
        return this.mContext.getResources().getDisplayMetrics().widthPixels / 2;
    }

    public boolean hasEmbeddedTabs() {
        return this.mContext.getResources().getBoolean(R.bool.abc_action_bar_embed_tabs);
    }

    public int getTabContainerHeight() {
        TypedArray a = this.mContext.obtainStyledAttributes(null, R.styleable.ActionBar, R.attr.actionBarStyle, 0);
        int height = a.getLayoutDimension(R.styleable.ActionBar_height, 0);
        Resources r = this.mContext.getResources();
        if (!this.hasEmbeddedTabs()) {
            height = Math.min(height, r.getDimensionPixelSize(R.dimen.abc_action_bar_stacked_max_height));
        }
        a.recycle();
        return height;
    }

    public boolean enableHomeButtonByDefault() {
        return this.mContext.getApplicationInfo().targetSdkVersion < 14;
    }

    public int getStackedTabMaxWidth() {
        return this.mContext.getResources().getDimensionPixelSize(R.dimen.abc_action_bar_stacked_tab_max_width);
    }
}

