/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.database.DataSetObservable;
import android.os.AsyncTask;
import android.support.v4.os.AsyncTaskCompat;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class ActivityChooserModel
extends DataSetObservable {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = ActivityChooserModel.class.getSimpleName();
    private static final String TAG_HISTORICAL_RECORDS = "historical-records";
    private static final String TAG_HISTORICAL_RECORD = "historical-record";
    private static final String ATTRIBUTE_ACTIVITY = "activity";
    private static final String ATTRIBUTE_TIME = "time";
    private static final String ATTRIBUTE_WEIGHT = "weight";
    public static final String DEFAULT_HISTORY_FILE_NAME = "activity_choser_model_history.xml";
    public static final int DEFAULT_HISTORY_MAX_LENGTH = 50;
    private static final int DEFAULT_ACTIVITY_INFLATION = 5;
    private static final float DEFAULT_HISTORICAL_RECORD_WEIGHT = 1.0f;
    private static final String HISTORY_FILE_EXTENSION = ".xml";
    private static final int INVALID_INDEX = -1;
    private static final Object sRegistryLock = new Object();
    private static final Map<String, ActivityChooserModel> sDataModelRegistry = new HashMap<String, ActivityChooserModel>();
    private final Object mInstanceLock = new Object();
    private final List<ActivityResolveInfo> mActivities = new ArrayList<ActivityResolveInfo>();
    private final List<HistoricalRecord> mHistoricalRecords = new ArrayList<HistoricalRecord>();
    private final Context mContext;
    private final String mHistoryFileName;
    private Intent mIntent;
    private ActivitySorter mActivitySorter = new DefaultSorter();
    private int mHistoryMaxSize = 50;
    private boolean mCanReadHistoricalData = true;
    private boolean mReadShareHistoryCalled = false;
    private boolean mHistoricalRecordsChanged = true;
    private boolean mReloadActivities = false;
    private OnChooseActivityListener mActivityChoserModelPolicy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActivityChooserModel get(Context context, String historyFileName) {
        Object object = sRegistryLock;
        synchronized (object) {
            ActivityChooserModel dataModel = sDataModelRegistry.get(historyFileName);
            if (dataModel == null) {
                dataModel = new ActivityChooserModel(context, historyFileName);
                sDataModelRegistry.put(historyFileName, dataModel);
            }
            return dataModel;
        }
    }

    private ActivityChooserModel(Context context, String historyFileName) {
        this.mContext = context.getApplicationContext();
        this.mHistoryFileName = !TextUtils.isEmpty((CharSequence)historyFileName) && !historyFileName.endsWith(HISTORY_FILE_EXTENSION) ? historyFileName + HISTORY_FILE_EXTENSION : historyFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntent(Intent intent) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mIntent == intent) {
                return;
            }
            this.mIntent = intent;
            this.mReloadActivities = true;
            this.ensureConsistentState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intent getIntent() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            return this.mIntent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActivityCount() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            return this.mActivities.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveInfo getActivity(int index) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            return this.mActivities.get((int)index).resolveInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActivityIndex(ResolveInfo activity) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            List<ActivityResolveInfo> activities = this.mActivities;
            int activityCount = activities.size();
            for (int i = 0; i < activityCount; ++i) {
                ActivityResolveInfo currentActivity = activities.get(i);
                if (currentActivity.resolveInfo != activity) continue;
                return i;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intent chooseActivity(int index) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            Intent choiceIntentCopy;
            boolean handled;
            if (this.mIntent == null) {
                return null;
            }
            this.ensureConsistentState();
            ActivityResolveInfo chosenActivity = this.mActivities.get(index);
            ComponentName chosenName = new ComponentName(chosenActivity.resolveInfo.activityInfo.packageName, chosenActivity.resolveInfo.activityInfo.name);
            Intent choiceIntent = new Intent(this.mIntent);
            choiceIntent.setComponent(chosenName);
            if (this.mActivityChoserModelPolicy != null && (handled = this.mActivityChoserModelPolicy.onChooseActivity(this, choiceIntentCopy = new Intent(choiceIntent)))) {
                return null;
            }
            HistoricalRecord historicalRecord = new HistoricalRecord(chosenName, System.currentTimeMillis(), 1.0f);
            this.addHistoricalRecord(historicalRecord);
            return choiceIntent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnChooseActivityListener(OnChooseActivityListener listener) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.mActivityChoserModelPolicy = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveInfo getDefaultActivity() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            if (!this.mActivities.isEmpty()) {
                return this.mActivities.get((int)0).resolveInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultActivity(int index) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            ActivityResolveInfo newDefaultActivity = this.mActivities.get(index);
            ActivityResolveInfo oldDefaultActivity = this.mActivities.get(0);
            float weight = oldDefaultActivity != null ? oldDefaultActivity.weight - newDefaultActivity.weight + 5.0f : 1.0f;
            ComponentName defaultName = new ComponentName(newDefaultActivity.resolveInfo.activityInfo.packageName, newDefaultActivity.resolveInfo.activityInfo.name);
            HistoricalRecord historicalRecord = new HistoricalRecord(defaultName, System.currentTimeMillis(), weight);
            this.addHistoricalRecord(historicalRecord);
        }
    }

    private void persistHistoricalDataIfNeeded() {
        if (!this.mReadShareHistoryCalled) {
            throw new IllegalStateException("No preceding call to #readHistoricalData");
        }
        if (!this.mHistoricalRecordsChanged) {
            return;
        }
        this.mHistoricalRecordsChanged = false;
        if (!TextUtils.isEmpty((CharSequence)this.mHistoryFileName)) {
            AsyncTaskCompat.executeParallel((AsyncTask)new PersistHistoryAsyncTask(), (Object[])new Object[]{new ArrayList<HistoricalRecord>(this.mHistoricalRecords), this.mHistoryFileName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActivitySorter(ActivitySorter activitySorter) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mActivitySorter == activitySorter) {
                return;
            }
            this.mActivitySorter = activitySorter;
            if (this.sortActivitiesIfNeeded()) {
                this.notifyChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistoryMaxSize(int historyMaxSize) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mHistoryMaxSize == historyMaxSize) {
                return;
            }
            this.mHistoryMaxSize = historyMaxSize;
            this.pruneExcessiveHistoricalRecordsIfNeeded();
            if (this.sortActivitiesIfNeeded()) {
                this.notifyChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryMaxSize() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            return this.mHistoryMaxSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistorySize() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            return this.mHistoricalRecords.size();
        }
    }

    private void ensureConsistentState() {
        boolean stateChanged = this.loadActivitiesIfNeeded();
        this.pruneExcessiveHistoricalRecordsIfNeeded();
        if (stateChanged |= this.readHistoricalDataIfNeeded()) {
            this.sortActivitiesIfNeeded();
            this.notifyChanged();
        }
    }

    private boolean sortActivitiesIfNeeded() {
        if (this.mActivitySorter != null && this.mIntent != null && !this.mActivities.isEmpty() && !this.mHistoricalRecords.isEmpty()) {
            this.mActivitySorter.sort(this.mIntent, this.mActivities, Collections.unmodifiableList(this.mHistoricalRecords));
            return true;
        }
        return false;
    }

    private boolean loadActivitiesIfNeeded() {
        if (this.mReloadActivities && this.mIntent != null) {
            this.mReloadActivities = false;
            this.mActivities.clear();
            List resolveInfos = this.mContext.getPackageManager().queryIntentActivities(this.mIntent, 0);
            int resolveInfoCount = resolveInfos.size();
            for (int i = 0; i < resolveInfoCount; ++i) {
                ResolveInfo resolveInfo = (ResolveInfo)resolveInfos.get(i);
                this.mActivities.add(new ActivityResolveInfo(resolveInfo));
            }
            return true;
        }
        return false;
    }

    private boolean readHistoricalDataIfNeeded() {
        if (this.mCanReadHistoricalData && this.mHistoricalRecordsChanged && !TextUtils.isEmpty((CharSequence)this.mHistoryFileName)) {
            this.mCanReadHistoricalData = false;
            this.mReadShareHistoryCalled = true;
            this.readHistoricalDataImpl();
            return true;
        }
        return false;
    }

    private boolean addHistoricalRecord(HistoricalRecord historicalRecord) {
        boolean added = this.mHistoricalRecords.add(historicalRecord);
        if (added) {
            this.mHistoricalRecordsChanged = true;
            this.pruneExcessiveHistoricalRecordsIfNeeded();
            this.persistHistoricalDataIfNeeded();
            this.sortActivitiesIfNeeded();
            this.notifyChanged();
        }
        return added;
    }

    private void pruneExcessiveHistoricalRecordsIfNeeded() {
        int pruneCount = this.mHistoricalRecords.size() - this.mHistoryMaxSize;
        if (pruneCount <= 0) {
            return;
        }
        this.mHistoricalRecordsChanged = true;
        for (int i = 0; i < pruneCount; ++i) {
            HistoricalRecord historicalRecord = this.mHistoricalRecords.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHistoricalDataImpl() {
        FileInputStream fis = null;
        try {
            fis = this.mContext.openFileInput(this.mHistoryFileName);
        }
        catch (FileNotFoundException fnfe) {
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((InputStream)fis, "UTF-8");
            int type = 0;
            while (type != 1 && type != 2) {
                type = parser.next();
            }
            if (!TAG_HISTORICAL_RECORDS.equals(parser.getName())) {
                throw new XmlPullParserException("Share records file does not start with historical-records tag.");
            }
            List<HistoricalRecord> historicalRecords = this.mHistoricalRecords;
            historicalRecords.clear();
            while ((type = parser.next()) != 1) {
                if (type == 3 || type == 4) continue;
                String nodeName = parser.getName();
                if (!TAG_HISTORICAL_RECORD.equals(nodeName)) {
                    throw new XmlPullParserException("Share records file not well-formed.");
                }
                String activity = parser.getAttributeValue(null, ATTRIBUTE_ACTIVITY);
                long time = Long.parseLong(parser.getAttributeValue(null, ATTRIBUTE_TIME));
                float weight = Float.parseFloat(parser.getAttributeValue(null, ATTRIBUTE_WEIGHT));
                HistoricalRecord readRecord = new HistoricalRecord(activity, time, weight);
                historicalRecords.add(readRecord);
            }
        }
        catch (XmlPullParserException xppe) {
            Log.e((String)LOG_TAG, (String)("Error reading historical recrod file: " + this.mHistoryFileName), (Throwable)xppe);
        }
        catch (IOException ioe) {
            Log.e((String)LOG_TAG, (String)("Error reading historical recrod file: " + this.mHistoryFileName), (Throwable)ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException xppe) {}
            }
        }
    }

    private final class PersistHistoryAsyncTask
    extends AsyncTask<Object, Void, Void> {
        private PersistHistoryAsyncTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void doInBackground(Object ... args) {
            List historicalRecords = (List)args[0];
            String historyFileName = (String)args[1];
            FileOutputStream fos = null;
            try {
                fos = ActivityChooserModel.this.mContext.openFileOutput(historyFileName, 0);
            }
            catch (FileNotFoundException fnfe) {
                Log.e((String)LOG_TAG, (String)("Error writing historical record file: " + historyFileName), (Throwable)fnfe);
                return null;
            }
            XmlSerializer serializer = Xml.newSerializer();
            try {
                serializer.setOutput((OutputStream)fos, null);
                serializer.startDocument("UTF-8", Boolean.valueOf(true));
                serializer.startTag(null, ActivityChooserModel.TAG_HISTORICAL_RECORDS);
                int recordCount = historicalRecords.size();
                for (int i = 0; i < recordCount; ++i) {
                    HistoricalRecord record = (HistoricalRecord)historicalRecords.remove(0);
                    serializer.startTag(null, ActivityChooserModel.TAG_HISTORICAL_RECORD);
                    serializer.attribute(null, ActivityChooserModel.ATTRIBUTE_ACTIVITY, record.activity.flattenToString());
                    serializer.attribute(null, ActivityChooserModel.ATTRIBUTE_TIME, String.valueOf(record.time));
                    serializer.attribute(null, ActivityChooserModel.ATTRIBUTE_WEIGHT, String.valueOf(record.weight));
                    serializer.endTag(null, ActivityChooserModel.TAG_HISTORICAL_RECORD);
                }
                serializer.endTag(null, ActivityChooserModel.TAG_HISTORICAL_RECORDS);
                serializer.endDocument();
            }
            catch (IllegalArgumentException iae) {
                Log.e((String)LOG_TAG, (String)("Error writing historical record file: " + ActivityChooserModel.this.mHistoryFileName), (Throwable)iae);
            }
            catch (IllegalStateException ise) {
                Log.e((String)LOG_TAG, (String)("Error writing historical record file: " + ActivityChooserModel.this.mHistoryFileName), (Throwable)ise);
            }
            catch (IOException ioe) {
                Log.e((String)LOG_TAG, (String)("Error writing historical record file: " + ActivityChooserModel.this.mHistoryFileName), (Throwable)ioe);
            }
            finally {
                ActivityChooserModel.this.mCanReadHistoricalData = true;
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iae) {}
                }
            }
            return null;
        }
    }

    private final class DefaultSorter
    implements ActivitySorter {
        private static final float WEIGHT_DECAY_COEFFICIENT = 0.95f;
        private final Map<ComponentName, ActivityResolveInfo> mPackageNameToActivityMap = new HashMap<ComponentName, ActivityResolveInfo>();

        private DefaultSorter() {
        }

        @Override
        public void sort(Intent intent, List<ActivityResolveInfo> activities, List<HistoricalRecord> historicalRecords) {
            Map<ComponentName, ActivityResolveInfo> componentNameToActivityMap = this.mPackageNameToActivityMap;
            componentNameToActivityMap.clear();
            int activityCount = activities.size();
            for (int i = 0; i < activityCount; ++i) {
                ActivityResolveInfo activity = activities.get(i);
                activity.weight = 0.0f;
                ComponentName componentName = new ComponentName(activity.resolveInfo.activityInfo.packageName, activity.resolveInfo.activityInfo.name);
                componentNameToActivityMap.put(componentName, activity);
            }
            int lastShareIndex = historicalRecords.size() - 1;
            float nextRecordWeight = 1.0f;
            for (int i = lastShareIndex; i >= 0; --i) {
                HistoricalRecord historicalRecord = historicalRecords.get(i);
                ComponentName componentName = historicalRecord.activity;
                ActivityResolveInfo activity = componentNameToActivityMap.get(componentName);
                if (activity == null) continue;
                activity.weight += historicalRecord.weight * nextRecordWeight;
                nextRecordWeight *= 0.95f;
            }
            Collections.sort(activities);
        }
    }

    public final class ActivityResolveInfo
    implements Comparable<ActivityResolveInfo> {
        public final ResolveInfo resolveInfo;
        public float weight;

        public ActivityResolveInfo(ResolveInfo resolveInfo) {
            this.resolveInfo = resolveInfo;
        }

        public int hashCode() {
            return 31 + Float.floatToIntBits(this.weight);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ActivityResolveInfo other = (ActivityResolveInfo)obj;
            return Float.floatToIntBits(this.weight) == Float.floatToIntBits(other.weight);
        }

        @Override
        public int compareTo(ActivityResolveInfo another) {
            return Float.floatToIntBits(another.weight) - Float.floatToIntBits(this.weight);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append("resolveInfo:").append(this.resolveInfo.toString());
            builder.append("; weight:").append(new BigDecimal(this.weight));
            builder.append("]");
            return builder.toString();
        }
    }

    public static final class HistoricalRecord {
        public final ComponentName activity;
        public final long time;
        public final float weight;

        public HistoricalRecord(String activityName, long time, float weight) {
            this(ComponentName.unflattenFromString((String)activityName), time, weight);
        }

        public HistoricalRecord(ComponentName activityName, long time, float weight) {
            this.activity = activityName;
            this.time = time;
            this.weight = weight;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.activity == null ? 0 : this.activity.hashCode());
            result = 31 * result + (int)(this.time ^ this.time >>> 32);
            result = 31 * result + Float.floatToIntBits(this.weight);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HistoricalRecord other = (HistoricalRecord)obj;
            if (this.activity == null ? other.activity != null : !this.activity.equals((Object)other.activity)) {
                return false;
            }
            if (this.time != other.time) {
                return false;
            }
            return Float.floatToIntBits(this.weight) == Float.floatToIntBits(other.weight);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append("; activity:").append(this.activity);
            builder.append("; time:").append(this.time);
            builder.append("; weight:").append(new BigDecimal(this.weight));
            builder.append("]");
            return builder.toString();
        }
    }

    public static interface OnChooseActivityListener {
        public boolean onChooseActivity(ActivityChooserModel var1, Intent var2);
    }

    public static interface ActivitySorter {
        public void sort(Intent var1, List<ActivityResolveInfo> var2, List<HistoricalRecord> var3);
    }

    public static interface ActivityChooserModelClient {
        public void setActivityChooserModel(ActivityChooserModel var1);
    }
}

