/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.view.menu;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.v4.view.GravityCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;
import android.support.v7.view.menu.MenuAdapter;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.view.menu.MenuPopup;
import android.support.v7.view.menu.MenuPresenter;
import android.support.v7.view.menu.SubMenuBuilder;
import android.support.v7.widget.MenuItemHoverListener;
import android.support.v7.widget.MenuPopupWindow;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

final class CascadingMenuPopup
extends MenuPopup
implements MenuPresenter,
View.OnKeyListener,
PopupWindow.OnDismissListener {
    static final int HORIZ_POSITION_LEFT = 0;
    static final int HORIZ_POSITION_RIGHT = 1;
    static final int SUBMENU_TIMEOUT_MS = 200;
    private final Context mContext;
    private final int mMenuMaxWidth;
    private final int mPopupStyleAttr;
    private final int mPopupStyleRes;
    private final boolean mOverflowOnly;
    final Handler mSubMenuHoverHandler;
    private final List<MenuBuilder> mPendingMenus = new LinkedList<MenuBuilder>();
    final List<CascadingMenuInfo> mShowingMenus = new ArrayList<CascadingMenuInfo>();
    private final ViewTreeObserver.OnGlobalLayoutListener mGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            if (CascadingMenuPopup.this.isShowing() && CascadingMenuPopup.this.mShowingMenus.size() > 0 && !CascadingMenuPopup.this.mShowingMenus.get((int)0).window.isModal()) {
                View anchor = CascadingMenuPopup.this.mShownAnchorView;
                if (anchor == null || !anchor.isShown()) {
                    CascadingMenuPopup.this.dismiss();
                } else {
                    for (CascadingMenuInfo info : CascadingMenuPopup.this.mShowingMenus) {
                        info.window.show();
                    }
                }
            }
        }
    };
    private final MenuItemHoverListener mMenuItemHoverListener = new MenuItemHoverListener(){

        @Override
        public void onItemHoverExit(@NonNull MenuBuilder menu, @NonNull MenuItem item) {
            CascadingMenuPopup.this.mSubMenuHoverHandler.removeCallbacksAndMessages((Object)menu);
        }

        @Override
        public void onItemHoverEnter(final @NonNull MenuBuilder menu, final @NonNull MenuItem item) {
            CascadingMenuPopup.this.mSubMenuHoverHandler.removeCallbacksAndMessages(null);
            int menuIndex = -1;
            int count = CascadingMenuPopup.this.mShowingMenus.size();
            for (int i = 0; i < count; ++i) {
                if (menu != CascadingMenuPopup.this.mShowingMenus.get((int)i).menu) continue;
                menuIndex = i;
                break;
            }
            if (menuIndex == -1) {
                return;
            }
            int nextIndex = menuIndex + 1;
            final CascadingMenuInfo nextInfo = nextIndex < CascadingMenuPopup.this.mShowingMenus.size() ? CascadingMenuPopup.this.mShowingMenus.get(nextIndex) : null;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (nextInfo != null) {
                        CascadingMenuPopup.this.mShouldCloseImmediately = true;
                        nextInfo.menu.close(false);
                        CascadingMenuPopup.this.mShouldCloseImmediately = false;
                    }
                    if (item.isEnabled() && item.hasSubMenu()) {
                        menu.performItemAction(item, 4);
                    }
                }
            };
            long uptimeMillis = SystemClock.uptimeMillis() + 200L;
            CascadingMenuPopup.this.mSubMenuHoverHandler.postAtTime(runnable, (Object)menu, uptimeMillis);
        }
    };
    private int mRawDropDownGravity = 0;
    private int mDropDownGravity = 0;
    private View mAnchorView;
    View mShownAnchorView;
    private int mLastPosition;
    private boolean mHasXOffset;
    private boolean mHasYOffset;
    private int mXOffset;
    private int mYOffset;
    private boolean mForceShowIcon;
    private boolean mShowTitle;
    private MenuPresenter.Callback mPresenterCallback;
    private ViewTreeObserver mTreeObserver;
    private PopupWindow.OnDismissListener mOnDismissListener;
    boolean mShouldCloseImmediately;

    public CascadingMenuPopup(@NonNull Context context, @NonNull View anchor, @AttrRes int popupStyleAttr, @StyleRes int popupStyleRes, boolean overflowOnly) {
        this.mContext = context;
        this.mAnchorView = anchor;
        this.mPopupStyleAttr = popupStyleAttr;
        this.mPopupStyleRes = popupStyleRes;
        this.mOverflowOnly = overflowOnly;
        this.mForceShowIcon = false;
        this.mLastPosition = this.getInitialMenuPosition();
        Resources res = context.getResources();
        this.mMenuMaxWidth = Math.max(res.getDisplayMetrics().widthPixels / 2, res.getDimensionPixelSize(R.dimen.abc_config_prefDialogWidth));
        this.mSubMenuHoverHandler = new Handler();
    }

    @Override
    public void setForceShowIcon(boolean forceShow) {
        this.mForceShowIcon = forceShow;
    }

    private MenuPopupWindow createPopupWindow() {
        MenuPopupWindow popupWindow = new MenuPopupWindow(this.mContext, null, this.mPopupStyleAttr, this.mPopupStyleRes);
        popupWindow.setHoverListener(this.mMenuItemHoverListener);
        popupWindow.setOnItemClickListener(this);
        popupWindow.setOnDismissListener(this);
        popupWindow.setAnchorView(this.mAnchorView);
        popupWindow.setDropDownGravity(this.mDropDownGravity);
        popupWindow.setModal(true);
        popupWindow.setInputMethodMode(2);
        return popupWindow;
    }

    @Override
    public void show() {
        if (this.isShowing()) {
            return;
        }
        for (MenuBuilder menu : this.mPendingMenus) {
            this.showMenu(menu);
        }
        this.mPendingMenus.clear();
        this.mShownAnchorView = this.mAnchorView;
        if (this.mShownAnchorView != null) {
            boolean addGlobalListener = this.mTreeObserver == null;
            this.mTreeObserver = this.mShownAnchorView.getViewTreeObserver();
            if (addGlobalListener) {
                this.mTreeObserver.addOnGlobalLayoutListener(this.mGlobalLayoutListener);
            }
        }
    }

    @Override
    public void dismiss() {
        int length = this.mShowingMenus.size();
        if (length > 0) {
            CascadingMenuInfo[] addedMenus = this.mShowingMenus.toArray(new CascadingMenuInfo[length]);
            for (int i = length - 1; i >= 0; --i) {
                CascadingMenuInfo info = addedMenus[i];
                if (!info.window.isShowing()) continue;
                info.window.dismiss();
            }
        }
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        if (event.getAction() == 1 && keyCode == 82) {
            this.dismiss();
            return true;
        }
        return false;
    }

    private int getInitialMenuPosition() {
        int layoutDirection = ViewCompat.getLayoutDirection((View)this.mAnchorView);
        return layoutDirection == 1 ? 0 : 1;
    }

    private int getNextMenuPosition(int nextMenuWidth) {
        ListView lastListView = this.mShowingMenus.get(this.mShowingMenus.size() - 1).getListView();
        int[] screenLocation = new int[2];
        lastListView.getLocationOnScreen(screenLocation);
        Rect displayFrame = new Rect();
        this.mShownAnchorView.getWindowVisibleDisplayFrame(displayFrame);
        if (this.mLastPosition == 1) {
            int right = screenLocation[0] + lastListView.getWidth() + nextMenuWidth;
            if (right > displayFrame.right) {
                return 0;
            }
            return 1;
        }
        int left = screenLocation[0] - nextMenuWidth;
        if (left < 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public void addMenu(MenuBuilder menu) {
        menu.addMenuPresenter(this, this.mContext);
        if (this.isShowing()) {
            this.showMenu(menu);
        } else {
            this.mPendingMenus.add(menu);
        }
    }

    private void showMenu(@NonNull MenuBuilder menu) {
        View parentView;
        CascadingMenuInfo parentInfo;
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        MenuAdapter adapter = new MenuAdapter(menu, inflater, this.mOverflowOnly);
        if (!this.isShowing() && this.mForceShowIcon) {
            adapter.setForceShowIcon(true);
        } else if (this.isShowing()) {
            adapter.setForceShowIcon(MenuPopup.shouldPreserveIconSpacing(menu));
        }
        int menuWidth = CascadingMenuPopup.measureIndividualMenuWidth((ListAdapter)adapter, null, this.mContext, this.mMenuMaxWidth);
        MenuPopupWindow popupWindow = this.createPopupWindow();
        popupWindow.setAdapter((ListAdapter)adapter);
        popupWindow.setContentWidth(menuWidth);
        popupWindow.setDropDownGravity(this.mDropDownGravity);
        if (this.mShowingMenus.size() > 0) {
            parentInfo = this.mShowingMenus.get(this.mShowingMenus.size() - 1);
            parentView = this.findParentViewForSubmenu(parentInfo, menu);
        } else {
            parentInfo = null;
            parentView = null;
        }
        if (parentView != null) {
            popupWindow.setTouchModal(false);
            popupWindow.setEnterTransition(null);
            int nextMenuPosition = this.getNextMenuPosition(menuWidth);
            boolean showOnRight = nextMenuPosition == 1;
            this.mLastPosition = nextMenuPosition;
            int[] tempLocation = new int[2];
            parentView.getLocationInWindow(tempLocation);
            int parentOffsetLeft = parentInfo.window.getHorizontalOffset() + tempLocation[0];
            int parentOffsetTop = parentInfo.window.getVerticalOffset() + tempLocation[1];
            int x = (this.mDropDownGravity & 5) == 5 ? (showOnRight ? parentOffsetLeft + menuWidth : parentOffsetLeft - parentView.getWidth()) : (showOnRight ? parentOffsetLeft + parentView.getWidth() : parentOffsetLeft - menuWidth);
            popupWindow.setHorizontalOffset(x);
            int y = parentOffsetTop;
            popupWindow.setVerticalOffset(y);
        } else {
            if (this.mHasXOffset) {
                popupWindow.setHorizontalOffset(this.mXOffset);
            }
            if (this.mHasYOffset) {
                popupWindow.setVerticalOffset(this.mYOffset);
            }
            Rect epicenterBounds = this.getEpicenterBounds();
            popupWindow.setEpicenterBounds(epicenterBounds);
        }
        CascadingMenuInfo menuInfo = new CascadingMenuInfo(popupWindow, menu, this.mLastPosition);
        this.mShowingMenus.add(menuInfo);
        popupWindow.show();
        if (parentInfo == null && this.mShowTitle && menu.getHeaderTitle() != null) {
            ListView listView = popupWindow.getListView();
            FrameLayout titleItemView = (FrameLayout)inflater.inflate(R.layout.abc_popup_menu_header_item_layout, (ViewGroup)listView, false);
            TextView titleView = (TextView)titleItemView.findViewById(16908310);
            titleItemView.setEnabled(false);
            titleView.setText(menu.getHeaderTitle());
            listView.addHeaderView((View)titleItemView, null, false);
            popupWindow.show();
        }
    }

    private MenuItem findMenuItemForSubmenu(@NonNull MenuBuilder parent, @NonNull MenuBuilder submenu) {
        int count = parent.size();
        for (int i = 0; i < count; ++i) {
            MenuItem item = parent.getItem(i);
            if (!item.hasSubMenu() || submenu != item.getSubMenu()) continue;
            return item;
        }
        return null;
    }

    @Nullable
    private View findParentViewForSubmenu(@NonNull CascadingMenuInfo parentInfo, @NonNull MenuBuilder submenu) {
        MenuAdapter menuAdapter;
        int headersCount;
        MenuItem owner = this.findMenuItemForSubmenu(parentInfo.menu, submenu);
        if (owner == null) {
            return null;
        }
        ListView listView = parentInfo.getListView();
        ListAdapter listAdapter = listView.getAdapter();
        if (listAdapter instanceof HeaderViewListAdapter) {
            HeaderViewListAdapter headerAdapter = (HeaderViewListAdapter)listAdapter;
            headersCount = headerAdapter.getHeadersCount();
            menuAdapter = (MenuAdapter)headerAdapter.getWrappedAdapter();
        } else {
            headersCount = 0;
            menuAdapter = (MenuAdapter)listAdapter;
        }
        int ownerPosition = -1;
        int count = menuAdapter.getCount();
        for (int i = 0; i < count; ++i) {
            if (owner != menuAdapter.getItem(i)) continue;
            ownerPosition = i;
            break;
        }
        if (ownerPosition == -1) {
            return null;
        }
        int ownerViewPosition = (ownerPosition += headersCount) - listView.getFirstVisiblePosition();
        if (ownerViewPosition < 0 || ownerViewPosition >= listView.getChildCount()) {
            return null;
        }
        return listView.getChildAt(ownerViewPosition);
    }

    @Override
    public boolean isShowing() {
        return this.mShowingMenus.size() > 0 && this.mShowingMenus.get((int)0).window.isShowing();
    }

    public void onDismiss() {
        CascadingMenuInfo dismissedInfo = null;
        int count = this.mShowingMenus.size();
        for (int i = 0; i < count; ++i) {
            CascadingMenuInfo info = this.mShowingMenus.get(i);
            if (info.window.isShowing()) continue;
            dismissedInfo = info;
            break;
        }
        if (dismissedInfo != null) {
            dismissedInfo.menu.close(false);
        }
    }

    @Override
    public void updateMenuView(boolean cleared) {
        for (CascadingMenuInfo info : this.mShowingMenus) {
            CascadingMenuPopup.toMenuAdapter(info.getListView().getAdapter()).notifyDataSetChanged();
        }
    }

    @Override
    public void setCallback(MenuPresenter.Callback cb) {
        this.mPresenterCallback = cb;
    }

    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenu) {
        for (CascadingMenuInfo info : this.mShowingMenus) {
            if (subMenu != info.menu) continue;
            info.getListView().requestFocus();
            return true;
        }
        if (subMenu.hasVisibleItems()) {
            this.addMenu(subMenu);
            if (this.mPresenterCallback != null) {
                this.mPresenterCallback.onOpenSubMenu(subMenu);
            }
            return true;
        }
        return false;
    }

    private int findIndexOfAddedMenu(@NonNull MenuBuilder menu) {
        int count = this.mShowingMenus.size();
        for (int i = 0; i < count; ++i) {
            CascadingMenuInfo info = this.mShowingMenus.get(i);
            if (menu != info.menu) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void onCloseMenu(MenuBuilder menu, boolean allMenusAreClosing) {
        int menuIndex = this.findIndexOfAddedMenu(menu);
        if (menuIndex < 0) {
            return;
        }
        int nextMenuIndex = menuIndex + 1;
        if (nextMenuIndex < this.mShowingMenus.size()) {
            CascadingMenuInfo childInfo = this.mShowingMenus.get(nextMenuIndex);
            childInfo.menu.close(false);
        }
        CascadingMenuInfo info = this.mShowingMenus.remove(menuIndex);
        info.menu.removeMenuPresenter(this);
        if (this.mShouldCloseImmediately) {
            info.window.setExitTransition(null);
            info.window.setAnimationStyle(0);
        }
        info.window.dismiss();
        int count = this.mShowingMenus.size();
        this.mLastPosition = count > 0 ? this.mShowingMenus.get((int)(count - 1)).position : this.getInitialMenuPosition();
        if (count == 0) {
            this.dismiss();
            if (this.mPresenterCallback != null) {
                this.mPresenterCallback.onCloseMenu(menu, true);
            }
            if (this.mTreeObserver != null) {
                if (this.mTreeObserver.isAlive()) {
                    this.mTreeObserver.removeGlobalOnLayoutListener(this.mGlobalLayoutListener);
                }
                this.mTreeObserver = null;
            }
            this.mOnDismissListener.onDismiss();
        } else if (allMenusAreClosing) {
            CascadingMenuInfo rootInfo = this.mShowingMenus.get(0);
            rootInfo.menu.close(false);
        }
    }

    @Override
    public boolean flagActionItems() {
        return false;
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return null;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
    }

    @Override
    public void setGravity(int dropDownGravity) {
        if (this.mRawDropDownGravity != dropDownGravity) {
            this.mRawDropDownGravity = dropDownGravity;
            this.mDropDownGravity = GravityCompat.getAbsoluteGravity((int)dropDownGravity, (int)ViewCompat.getLayoutDirection((View)this.mAnchorView));
        }
    }

    @Override
    public void setAnchorView(@NonNull View anchor) {
        if (this.mAnchorView != anchor) {
            this.mAnchorView = anchor;
            this.mDropDownGravity = GravityCompat.getAbsoluteGravity((int)this.mRawDropDownGravity, (int)ViewCompat.getLayoutDirection((View)this.mAnchorView));
        }
    }

    @Override
    public void setOnDismissListener(PopupWindow.OnDismissListener listener) {
        this.mOnDismissListener = listener;
    }

    @Override
    public ListView getListView() {
        return this.mShowingMenus.isEmpty() ? null : this.mShowingMenus.get(this.mShowingMenus.size() - 1).getListView();
    }

    @Override
    public void setHorizontalOffset(int x) {
        this.mHasXOffset = true;
        this.mXOffset = x;
    }

    @Override
    public void setVerticalOffset(int y) {
        this.mHasYOffset = true;
        this.mYOffset = y;
    }

    @Override
    public void setShowTitle(boolean showTitle) {
        this.mShowTitle = showTitle;
    }

    @Override
    protected boolean closeMenuOnSubMenuOpened() {
        return false;
    }

    private static class CascadingMenuInfo {
        public final MenuPopupWindow window;
        public final MenuBuilder menu;
        public final int position;

        public CascadingMenuInfo(@NonNull MenuPopupWindow window, @NonNull MenuBuilder menu, int position) {
            this.window = window;
            this.menu = menu;
            this.position = position;
        }

        public ListView getListView() {
            return this.window.getListView();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HorizPosition {
    }
}

