/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets;

import android.support.constraint.solver.LinearSystem;
import android.support.constraint.solver.SolverVariable;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.Guideline;
import java.util.ArrayList;

public class Optimizer {
    public static final int OPTIMIZATION_NONE = 1;
    public static final int OPTIMIZATION_ALL = 2;
    public static final int OPTIMIZATION_BASIC = 4;
    public static final int OPTIMIZATION_CHAIN = 8;
    static boolean[] flags = new boolean[3];
    static final int FLAG_USE_OPTIMIZE = 0;
    static final int FLAG_CHAIN_DANGLING = 1;
    static final int FLAG_RECOMPUTE_BOUNDS = 2;
    private static final boolean DEBUG_OPTIMIZE = false;
    private static final boolean TRACE_OPTIMIZE = false;
    private static final boolean NEW_OPTIMIZER = true;

    static void applyDirectResolutionHorizontalChain(ConstraintWidgetContainer container, LinearSystem system, int numMatchConstraints, ConstraintWidget widget) {
        ConstraintWidget firstWidget = widget;
        int widgetSize = 0;
        int firstPosition = 0;
        ConstraintWidget previous = null;
        int count = 0;
        float totalWeights = 0.0f;
        while (widget != null) {
            boolean isGone;
            boolean bl = isGone = widget.getVisibility() == 8;
            if (!isGone) {
                ++count;
                if (widget.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    widgetSize += widget.getWidth();
                    widgetSize += widget.mLeft.mTarget != null ? widget.mLeft.getMargin() : 0;
                    widgetSize += widget.mRight.mTarget != null ? widget.mRight.getMargin() : 0;
                } else {
                    totalWeights += widget.mWeight[0];
                }
            }
            previous = widget;
            widget = widget.mRight.mTarget != null ? widget.mRight.mTarget.mOwner : null;
            if (widget == null || widget.mLeft.mTarget != null && (widget.mLeft.mTarget == null || widget.mLeft.mTarget.mOwner == previous)) continue;
            widget = null;
        }
        int lastPosition = 0;
        if (previous != null) {
            ConstraintWidget endTarget;
            int n = lastPosition = previous.mRight.mTarget != null ? previous.mRight.mTarget.mOwner.getX() : 0;
            if (previous.mRight.mTarget != null && (endTarget = previous.mRight.mTarget.mOwner) == container) {
                lastPosition = container.getRight();
            }
        }
        float total = lastPosition - firstPosition;
        float spreadSpace = total - (float)widgetSize;
        float split = spreadSpace / (float)(count + 1);
        widget = firstWidget;
        float currentPosition = 0.0f;
        if (numMatchConstraints == 0) {
            currentPosition = split;
        } else {
            split = spreadSpace / (float)numMatchConstraints;
        }
        while (widget != null) {
            int right;
            int left = widget.mLeft.mTarget != null ? widget.mLeft.getMargin() : 0;
            int n = right = widget.mRight.mTarget != null ? widget.mRight.getMargin() : 0;
            if (widget.getVisibility() != 8) {
                system.addEquality(widget.mLeft.mSolverVariable, (int)((currentPosition += (float)left) + 0.5f));
                currentPosition = widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT ? (totalWeights == 0.0f ? (currentPosition += split - (float)left - (float)right) : (currentPosition += spreadSpace * widget.mWeight[0] / totalWeights - (float)left - (float)right)) : (currentPosition += (float)widget.getWidth());
                system.addEquality(widget.mRight.mSolverVariable, (int)(currentPosition + 0.5f));
                if (numMatchConstraints == 0) {
                    currentPosition += split;
                }
                currentPosition += (float)right;
            } else {
                float position = currentPosition - split / 2.0f;
                system.addEquality(widget.mLeft.mSolverVariable, (int)(position + 0.5f));
                system.addEquality(widget.mRight.mSolverVariable, (int)(position + 0.5f));
            }
            previous = widget;
            ConstraintWidget constraintWidget = widget = widget.mRight.mTarget != null ? widget.mRight.mTarget.mOwner : null;
            if (widget != null && widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner != previous) {
                widget = null;
            }
            if (widget != container) continue;
            widget = null;
        }
    }

    static void applyDirectResolutionVerticalChain(ConstraintWidgetContainer container, LinearSystem system, int numMatchConstraints, ConstraintWidget widget) {
        ConstraintWidget firstWidget = widget;
        int widgetSize = 0;
        int firstPosition = 0;
        ConstraintWidget previous = null;
        int count = 0;
        float totalWeights = 0.0f;
        while (widget != null) {
            boolean isGone;
            boolean bl = isGone = widget.getVisibility() == 8;
            if (!isGone) {
                ++count;
                if (widget.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    widgetSize += widget.getHeight();
                    widgetSize += widget.mTop.mTarget != null ? widget.mTop.getMargin() : 0;
                    widgetSize += widget.mBottom.mTarget != null ? widget.mBottom.getMargin() : 0;
                } else {
                    totalWeights += widget.mWeight[1];
                }
            }
            previous = widget;
            widget = widget.mBottom.mTarget != null ? widget.mBottom.mTarget.mOwner : null;
            if (widget == null || widget.mTop.mTarget != null && (widget.mTop.mTarget == null || widget.mTop.mTarget.mOwner == previous)) continue;
            widget = null;
        }
        int lastPosition = 0;
        if (previous != null) {
            ConstraintWidget endTarget;
            int n = lastPosition = previous.mBottom.mTarget != null ? previous.mBottom.mTarget.mOwner.getX() : 0;
            if (previous.mBottom.mTarget != null && (endTarget = previous.mBottom.mTarget.mOwner) == container) {
                lastPosition = container.getBottom();
            }
        }
        float total = lastPosition - firstPosition;
        float spreadSpace = total - (float)widgetSize;
        float split = spreadSpace / (float)(count + 1);
        widget = firstWidget;
        float currentPosition = 0.0f;
        if (numMatchConstraints == 0) {
            currentPosition = split;
        } else {
            split = spreadSpace / (float)numMatchConstraints;
        }
        while (widget != null) {
            int bottom;
            int top = widget.mTop.mTarget != null ? widget.mTop.getMargin() : 0;
            int n = bottom = widget.mBottom.mTarget != null ? widget.mBottom.getMargin() : 0;
            if (widget.getVisibility() != 8) {
                system.addEquality(widget.mTop.mSolverVariable, (int)((currentPosition += (float)top) + 0.5f));
                currentPosition = widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT ? (totalWeights == 0.0f ? (currentPosition += split - (float)top - (float)bottom) : (currentPosition += spreadSpace * widget.mWeight[1] / totalWeights - (float)top - (float)bottom)) : (currentPosition += (float)widget.getHeight());
                system.addEquality(widget.mBottom.mSolverVariable, (int)(currentPosition + 0.5f));
                if (numMatchConstraints == 0) {
                    currentPosition += split;
                }
                currentPosition += (float)bottom;
            } else {
                float position = currentPosition - split / 2.0f;
                system.addEquality(widget.mTop.mSolverVariable, (int)(position + 0.5f));
                system.addEquality(widget.mBottom.mSolverVariable, (int)(position + 0.5f));
            }
            previous = widget;
            ConstraintWidget constraintWidget = widget = widget.mBottom.mTarget != null ? widget.mBottom.mTarget.mOwner : null;
            if (widget != null && widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner != previous) {
                widget = null;
            }
            if (widget != container) continue;
            widget = null;
        }
    }

    static void checkMatchParent(ConstraintWidgetContainer container, LinearSystem system, ConstraintWidget widget) {
        if (container.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
            widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
            int left = widget.mLeft.mMargin;
            int right = container.getWidth() - widget.mRight.mMargin;
            system.addEquality(widget.mLeft.mSolverVariable, left);
            system.addEquality(widget.mRight.mSolverVariable, right);
            widget.setHorizontalDimension(left, right);
            widget.mHorizontalResolution = 2;
        }
        if (container.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
            widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
            int top = widget.mTop.mMargin;
            int bottom = container.getHeight() - widget.mBottom.mMargin;
            system.addEquality(widget.mTop.mSolverVariable, top);
            system.addEquality(widget.mBottom.mSolverVariable, bottom);
            if (widget.mBaselineDistance > 0 || widget.getVisibility() == 8) {
                widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
            }
            widget.setVerticalDimension(top, bottom);
            widget.mVerticalResolution = 2;
        }
    }

    static void checkHorizontalSimpleDependency(ConstraintWidgetContainer container, LinearSystem system, ConstraintWidget widget) {
        if (widget.mHorizontalResolution == 1) {
            return;
        }
        if (widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            widget.mHorizontalResolution = 1;
            return;
        }
        if (container.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
            widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
            int left = widget.mLeft.mMargin;
            int right = container.getWidth() - widget.mRight.mMargin;
            system.addEquality(widget.mLeft.mSolverVariable, left);
            system.addEquality(widget.mRight.mSolverVariable, right);
            widget.setHorizontalDimension(left, right);
            widget.mHorizontalResolution = 2;
            return;
        }
        if (widget.mLeft.mTarget != null && widget.mRight.mTarget != null) {
            if (widget.mLeft.mTarget.mOwner == container && widget.mRight.mTarget.mOwner == container) {
                int left = 0;
                int right = 0;
                int leftMargin = widget.mLeft.getMargin();
                int rightMargin = widget.mRight.getMargin();
                if (container.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    left = leftMargin;
                    right = container.getWidth() - rightMargin;
                } else {
                    int w = widget.getWidth();
                    int dim = container.getWidth() - leftMargin - rightMargin - w;
                    left = leftMargin + (int)((float)dim * widget.mHorizontalBiasPercent + 0.5f);
                    right = left + widget.getWidth();
                }
                widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
                widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
                system.addEquality(widget.mLeft.mSolverVariable, left);
                system.addEquality(widget.mRight.mSolverVariable, right);
                widget.mHorizontalResolution = 2;
                widget.setHorizontalDimension(left, right);
                return;
            }
            widget.mHorizontalResolution = 1;
            return;
        }
        if (widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner == container) {
            int left = widget.mLeft.getMargin();
            int right = left + widget.getWidth();
            widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
            widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
            system.addEquality(widget.mLeft.mSolverVariable, left);
            system.addEquality(widget.mRight.mSolverVariable, right);
            widget.mHorizontalResolution = 2;
            widget.setHorizontalDimension(left, right);
        } else if (widget.mRight.mTarget != null && widget.mRight.mTarget.mOwner == container) {
            widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
            widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
            int right = container.getWidth() - widget.mRight.getMargin();
            int left = right - widget.getWidth();
            system.addEquality(widget.mLeft.mSolverVariable, left);
            system.addEquality(widget.mRight.mSolverVariable, right);
            widget.mHorizontalResolution = 2;
            widget.setHorizontalDimension(left, right);
        } else if (widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner.mHorizontalResolution == 2) {
            SolverVariable target = widget.mLeft.mTarget.mSolverVariable;
            widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
            widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
            int left = (int)(target.computedValue + (float)widget.mLeft.getMargin() + 0.5f);
            int right = left + widget.getWidth();
            system.addEquality(widget.mLeft.mSolverVariable, left);
            system.addEquality(widget.mRight.mSolverVariable, right);
            widget.mHorizontalResolution = 2;
            widget.setHorizontalDimension(left, right);
        } else if (widget.mRight.mTarget != null && widget.mRight.mTarget.mOwner.mHorizontalResolution == 2) {
            SolverVariable target = widget.mRight.mTarget.mSolverVariable;
            widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
            widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
            int right = (int)(target.computedValue - (float)widget.mRight.getMargin() + 0.5f);
            int left = right - widget.getWidth();
            system.addEquality(widget.mLeft.mSolverVariable, left);
            system.addEquality(widget.mRight.mSolverVariable, right);
            widget.mHorizontalResolution = 2;
            widget.setHorizontalDimension(left, right);
        } else {
            boolean hasRight;
            boolean hasLeft = widget.mLeft.mTarget != null;
            boolean bl = hasRight = widget.mRight.mTarget != null;
            if (!hasLeft && !hasRight) {
                if (widget instanceof Guideline) {
                    Guideline guideline = (Guideline)widget;
                    if (guideline.getOrientation() == 1) {
                        widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
                        widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
                        float position = 0.0f;
                        position = guideline.getRelativeBegin() != -1 ? (float)guideline.getRelativeBegin() : (guideline.getRelativeEnd() != -1 ? (float)(container.getWidth() - guideline.getRelativeEnd()) : (float)container.getWidth() * guideline.getRelativePercent());
                        int value = (int)(position + 0.5f);
                        system.addEquality(widget.mLeft.mSolverVariable, value);
                        system.addEquality(widget.mRight.mSolverVariable, value);
                        widget.mHorizontalResolution = 2;
                        widget.mVerticalResolution = 2;
                        widget.setHorizontalDimension(value, value);
                        widget.setVerticalDimension(0, container.getHeight());
                    }
                } else {
                    widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
                    widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
                    int left = widget.getX();
                    int right = left + widget.getWidth();
                    system.addEquality(widget.mLeft.mSolverVariable, left);
                    system.addEquality(widget.mRight.mSolverVariable, right);
                    widget.mHorizontalResolution = 2;
                }
            }
        }
    }

    static void checkVerticalSimpleDependency(ConstraintWidgetContainer container, LinearSystem system, ConstraintWidget widget) {
        if (widget.mVerticalResolution == 1) {
            return;
        }
        if (widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            widget.mVerticalResolution = 1;
            return;
        }
        if (container.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
            widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
            int top = widget.mTop.mMargin;
            int bottom = container.getHeight() - widget.mBottom.mMargin;
            system.addEquality(widget.mTop.mSolverVariable, top);
            system.addEquality(widget.mBottom.mSolverVariable, bottom);
            if (widget.mBaselineDistance > 0 || widget.getVisibility() == 8) {
                widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
            }
            widget.setVerticalDimension(top, bottom);
            widget.mVerticalResolution = 2;
            return;
        }
        if (widget.mTop.mTarget != null && widget.mBottom.mTarget != null) {
            if (widget.mTop.mTarget.mOwner == container && widget.mBottom.mTarget.mOwner == container) {
                int top = 0;
                int bottom = 0;
                int topMargin = widget.mTop.getMargin();
                int bottomMargin = widget.mBottom.getMargin();
                if (container.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    top = topMargin;
                    bottom = top + widget.getHeight();
                } else {
                    int h = widget.getHeight();
                    int dim = container.getHeight() - topMargin - bottomMargin - h;
                    top = (int)((float)topMargin + (float)dim * widget.mVerticalBiasPercent + 0.5f);
                    bottom = top + widget.getHeight();
                }
                widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
                widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
                system.addEquality(widget.mTop.mSolverVariable, top);
                system.addEquality(widget.mBottom.mSolverVariable, bottom);
                if (widget.mBaselineDistance > 0 || widget.getVisibility() == 8) {
                    widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                    system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
                }
                widget.mVerticalResolution = 2;
                widget.setVerticalDimension(top, bottom);
                return;
            }
            widget.mVerticalResolution = 1;
            return;
        }
        if (widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner == container) {
            int top = widget.mTop.getMargin();
            int bottom = top + widget.getHeight();
            widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
            widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
            system.addEquality(widget.mTop.mSolverVariable, top);
            system.addEquality(widget.mBottom.mSolverVariable, bottom);
            if (widget.mBaselineDistance > 0 || widget.getVisibility() == 8) {
                widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
            }
            widget.mVerticalResolution = 2;
            widget.setVerticalDimension(top, bottom);
        } else if (widget.mBottom.mTarget != null && widget.mBottom.mTarget.mOwner == container) {
            widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
            widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
            int bottom = container.getHeight() - widget.mBottom.getMargin();
            int top = bottom - widget.getHeight();
            system.addEquality(widget.mTop.mSolverVariable, top);
            system.addEquality(widget.mBottom.mSolverVariable, bottom);
            if (widget.mBaselineDistance > 0 || widget.getVisibility() == 8) {
                widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
            }
            widget.mVerticalResolution = 2;
            widget.setVerticalDimension(top, bottom);
        } else if (widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner.mVerticalResolution == 2) {
            SolverVariable target = widget.mTop.mTarget.mSolverVariable;
            widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
            widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
            int top = (int)(target.computedValue + (float)widget.mTop.getMargin() + 0.5f);
            int bottom = top + widget.getHeight();
            system.addEquality(widget.mTop.mSolverVariable, top);
            system.addEquality(widget.mBottom.mSolverVariable, bottom);
            if (widget.mBaselineDistance > 0 || widget.getVisibility() == 8) {
                widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
            }
            widget.mVerticalResolution = 2;
            widget.setVerticalDimension(top, bottom);
        } else if (widget.mBottom.mTarget != null && widget.mBottom.mTarget.mOwner.mVerticalResolution == 2) {
            SolverVariable target = widget.mBottom.mTarget.mSolverVariable;
            widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
            widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
            int bottom = (int)(target.computedValue - (float)widget.mBottom.getMargin() + 0.5f);
            int top = bottom - widget.getHeight();
            system.addEquality(widget.mTop.mSolverVariable, top);
            system.addEquality(widget.mBottom.mSolverVariable, bottom);
            if (widget.mBaselineDistance > 0 || widget.getVisibility() == 8) {
                widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
            }
            widget.mVerticalResolution = 2;
            widget.setVerticalDimension(top, bottom);
        } else if (widget.mBaseline.mTarget != null && widget.mBaseline.mTarget.mOwner.mVerticalResolution == 2) {
            SolverVariable target = widget.mBaseline.mTarget.mSolverVariable;
            widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
            widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
            int top = (int)(target.computedValue - (float)widget.mBaselineDistance + 0.5f);
            int bottom = top + widget.getHeight();
            system.addEquality(widget.mTop.mSolverVariable, top);
            system.addEquality(widget.mBottom.mSolverVariable, bottom);
            widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
            system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
            widget.mVerticalResolution = 2;
            widget.setVerticalDimension(top, bottom);
        } else {
            boolean hasBottom;
            boolean hasBaseline = widget.mBaseline.mTarget != null;
            boolean hasTop = widget.mTop.mTarget != null;
            boolean bl = hasBottom = widget.mBottom.mTarget != null;
            if (!(hasBaseline || hasTop || hasBottom)) {
                if (widget instanceof Guideline) {
                    Guideline guideline = (Guideline)widget;
                    if (guideline.getOrientation() == 0) {
                        widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
                        widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
                        float position = 0.0f;
                        position = guideline.getRelativeBegin() != -1 ? (float)guideline.getRelativeBegin() : (guideline.getRelativeEnd() != -1 ? (float)(container.getHeight() - guideline.getRelativeEnd()) : (float)container.getHeight() * guideline.getRelativePercent());
                        int value = (int)(position + 0.5f);
                        system.addEquality(widget.mTop.mSolverVariable, value);
                        system.addEquality(widget.mBottom.mSolverVariable, value);
                        widget.mVerticalResolution = 2;
                        widget.mHorizontalResolution = 2;
                        widget.setVerticalDimension(value, value);
                        widget.setHorizontalDimension(0, container.getWidth());
                    }
                } else {
                    widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
                    widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
                    int top = widget.getY();
                    int bottom = top + widget.getHeight();
                    system.addEquality(widget.mTop.mSolverVariable, top);
                    system.addEquality(widget.mBottom.mSolverVariable, bottom);
                    if (widget.mBaselineDistance > 0 || widget.getVisibility() == 8) {
                        widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                        system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
                    }
                    widget.mVerticalResolution = 2;
                }
            }
        }
    }

    static boolean optimize(LinearSystem system, ConstraintWidgetContainer container) {
        ConstraintWidget widget;
        int i;
        int count = container.mChildren.size();
        boolean done = false;
        boolean dv = false;
        boolean dh = false;
        boolean n = false;
        boolean horizontalParentWrap = container.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        boolean verticalParentWrap = container.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        for (i = 0; i < count; ++i) {
            widget = (ConstraintWidget)container.mChildren.get(i);
            if (horizontalParentWrap) {
                widget.mLeft.resolutionStatus = 2;
                widget.mRight.resolutionStatus = 2;
            } else {
                widget.mLeft.resolutionStatus = 0;
                widget.mRight.resolutionStatus = 0;
            }
            if (verticalParentWrap) {
                widget.mTop.resolutionStatus = 2;
                widget.mBottom.resolutionStatus = 2;
                widget.mBaseline.resolutionStatus = 2;
                continue;
            }
            widget.mTop.resolutionStatus = 0;
            widget.mBottom.resolutionStatus = 0;
            widget.mBaseline.resolutionStatus = 0;
        }
        for (i = 0; i < count; ++i) {
            int beginSpace;
            float space;
            widget = (ConstraintWidget)container.mChildren.get(i);
            ConstraintAnchor begin = widget.mListAnchors[0];
            ConstraintAnchor end = widget.mListAnchors[1];
            boolean parentWrap = horizontalParentWrap;
            if (begin.resolutionStatus == 0 && end.resolutionStatus == 0) {
                if (begin.mTarget != null && end.mTarget != null) {
                    if (!parentWrap && begin.mTarget == container.mLeft && end.mTarget == container.mRight && widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.FIXED) {
                        space = container.mWidth - widget.mWidth - begin.getMargin() - end.getMargin();
                        beginSpace = (int)(space * widget.mHorizontalBiasPercent + 0.5f) + begin.getMargin();
                        begin.resolve(system, beginSpace, null);
                        end.resolve(system, beginSpace + widget.mWidth, null);
                    }
                } else if (begin.mTarget != null && begin.mTarget == container.mLeft) {
                    begin.resolve(system, begin.getMargin(), null);
                } else if (end.mTarget != null && end.mTarget == container.mRight) {
                    end.resolve(system, container.mWidth - end.getMargin(), null);
                }
            }
            begin = widget.mListAnchors[2];
            end = widget.mListAnchors[3];
            parentWrap = verticalParentWrap;
            if (begin.resolutionStatus != 0 || end.resolutionStatus != 0) continue;
            if (begin.mTarget != null && end.mTarget != null) {
                if (parentWrap || begin.mTarget != container.mTop || end.mTarget != container.mBottom || widget.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.FIXED) continue;
                space = container.mHeight - widget.mHeight - begin.getMargin() - end.getMargin();
                beginSpace = (int)(space * widget.mVerticalBiasPercent + 0.5f) + begin.getMargin();
                begin.resolve(system, beginSpace, null);
                end.resolve(system, beginSpace + widget.mHeight, null);
                continue;
            }
            if (begin.mTarget != null && begin.mTarget == container.mTop) {
                begin.resolve(system, begin.getMargin(), null);
                continue;
            }
            if (end.mTarget == null || end.mTarget != container.mBottom) continue;
            end.resolve(system, container.mHeight - end.getMargin(), null);
        }
        for (i = 0; i < count; ++i) {
            boolean fixedDimension;
            widget = (ConstraintWidget)container.mChildren.get(i);
            boolean bl = fixedDimension = widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.FIXED || widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            if (fixedDimension) {
                ConstraintAnchor left = widget.mListAnchors[0];
                ConstraintAnchor right = widget.mListAnchors[1];
                if (left.resolutionStatus == 1 && right.resolutionStatus == 0) {
                    if (left.resolvedAnchor == null) {
                        right.resolve(system, left.resolvedValue + widget.getWidth(), null);
                    } else {
                        right.resolve(system, widget.getWidth(), left);
                    }
                } else if (left.resolutionStatus == 0 && right.resolutionStatus == 1) {
                    if (right.resolvedAnchor == null) {
                        left.resolve(system, right.resolvedValue - widget.getWidth(), null);
                    } else {
                        left.resolve(system, -widget.getWidth(), right);
                    }
                }
            }
            boolean bl2 = fixedDimension = widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.FIXED || widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            if (!fixedDimension) continue;
            ConstraintAnchor top = widget.mTop;
            ConstraintAnchor bottom = widget.mBottom;
            if (top.resolutionStatus == 1 && bottom.resolutionStatus == 0) {
                if (top.resolvedAnchor == null) {
                    bottom.resolve(system, top.resolvedValue + widget.getHeight(), null);
                    continue;
                }
                bottom.resolve(system, widget.getHeight(), top);
                continue;
            }
            if (top.resolutionStatus != 0 || bottom.resolutionStatus != 1) continue;
            if (bottom.resolvedAnchor == null) {
                top.resolve(system, bottom.resolvedValue - widget.getHeight(), null);
                continue;
            }
            top.resolve(system, -widget.getHeight(), bottom);
        }
        for (i = 0; i < count; ++i) {
            widget = (ConstraintWidget)container.mChildren.get(i);
            if (widget.mLeft.resolutionStatus != 1) {
                return false;
            }
            if (widget.mRight.resolutionStatus != 1) {
                return false;
            }
            if (widget.mTop.resolutionStatus != 1) {
                return false;
            }
            if (widget.mBottom.resolutionStatus == 1) continue;
            return false;
        }
        for (i = 0; i < count; ++i) {
            widget = (ConstraintWidget)container.mChildren.get(i);
            int left = widget.mLeft.resolvedValue;
            int top = widget.mTop.resolvedValue;
            int right = widget.mRight.resolvedValue;
            int bottom = widget.mBottom.resolvedValue;
            widget.setFrame(left, top, right, bottom);
        }
        return true;
    }

    public static void findHorizontalWrapRecursive(ConstraintWidget widget, boolean[] flags) {
        if (widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mDimensionRatio > 0.0f) {
            flags[0] = false;
            return;
        }
        if (widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mMatchConstraintDefaultWidth == 2) {
            flags[0] = false;
            return;
        }
        int w = widget.getOptimizerWrapWidth();
        if (widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mDimensionRatio > 0.0f) {
            flags[0] = false;
            return;
        }
        int distToRight = w;
        int distToLeft = w;
        ConstraintWidget leftWidget = null;
        ConstraintWidget rightWidget = null;
        widget.mHorizontalWrapVisited = true;
        if (widget instanceof Guideline) {
            Guideline guideline = (Guideline)widget;
            if (guideline.getOrientation() == 1) {
                distToLeft = 0;
                distToRight = 0;
                if (guideline.getRelativeBegin() != -1) {
                    distToLeft = guideline.getRelativeBegin();
                } else if (guideline.getRelativeEnd() != -1) {
                    distToRight = guideline.getRelativeEnd();
                } else if (guideline.getRelativePercent() != -1.0f) {
                    flags[0] = false;
                    return;
                }
            }
        } else if (!widget.mRight.isConnected() && !widget.mLeft.isConnected()) {
            distToLeft += widget.getX();
        } else {
            if (widget.mRight.mTarget != null && widget.mLeft.mTarget != null && widget.mIsWidthWrapContent && widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                flags[0] = false;
                return;
            }
            if (widget.mRight.mTarget != null && widget.mLeft.mTarget != null && (widget.mRight.mTarget == widget.mLeft.mTarget || widget.mRight.mTarget.mOwner == widget.mLeft.mTarget.mOwner && widget.mRight.mTarget.mOwner != widget.mParent)) {
                flags[0] = false;
                return;
            }
            if (widget.mRight.mTarget != null) {
                rightWidget = widget.mRight.mTarget.mOwner;
                distToRight += widget.mRight.getMargin();
                if (!rightWidget.isRoot() && !rightWidget.mHorizontalWrapVisited) {
                    Optimizer.findHorizontalWrapRecursive(rightWidget, flags);
                }
            }
            if (widget.mLeft.mTarget != null) {
                leftWidget = widget.mLeft.mTarget.mOwner;
                distToLeft += widget.mLeft.getMargin();
                if (!leftWidget.isRoot() && !leftWidget.mHorizontalWrapVisited) {
                    Optimizer.findHorizontalWrapRecursive(leftWidget, flags);
                }
            }
            if (widget.mRight.mTarget != null && !rightWidget.isRoot()) {
                if (widget.mRight.mTarget.mType == ConstraintAnchor.Type.RIGHT) {
                    distToRight += rightWidget.mDistToRight - rightWidget.getOptimizerWrapWidth();
                } else if (widget.mRight.mTarget.getType() == ConstraintAnchor.Type.LEFT) {
                    distToRight += rightWidget.mDistToRight;
                }
                boolean bl = widget.mRightHasCentered = rightWidget.mRightHasCentered || rightWidget.mLeft.mTarget != null && rightWidget.mRight.mTarget != null && rightWidget.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                if (widget.mRightHasCentered && (rightWidget.mLeft.mTarget == null || rightWidget.mLeft.mTarget.mOwner != widget)) {
                    distToRight += distToRight - rightWidget.mDistToRight;
                }
            }
            if (widget.mLeft.mTarget != null && !leftWidget.isRoot()) {
                if (widget.mLeft.mTarget.getType() == ConstraintAnchor.Type.LEFT) {
                    distToLeft += leftWidget.mDistToLeft - leftWidget.getOptimizerWrapWidth();
                } else if (widget.mLeft.mTarget.getType() == ConstraintAnchor.Type.RIGHT) {
                    distToLeft += leftWidget.mDistToLeft;
                }
                boolean bl = widget.mLeftHasCentered = leftWidget.mLeftHasCentered || leftWidget.mLeft.mTarget != null && leftWidget.mRight.mTarget != null && leftWidget.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                if (widget.mLeftHasCentered && (leftWidget.mRight.mTarget == null || leftWidget.mRight.mTarget.mOwner != widget)) {
                    distToLeft += distToLeft - leftWidget.mDistToLeft;
                }
            }
        }
        if (widget.getVisibility() == 8) {
            distToLeft -= widget.mWidth;
            distToRight -= widget.mWidth;
        }
        widget.mDistToLeft = distToLeft;
        widget.mDistToRight = distToRight;
    }

    public static void findVerticalWrapRecursive(ConstraintWidget widget, boolean[] flags) {
        int h;
        if (widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mDimensionRatio > 0.0f) {
            flags[0] = false;
            return;
        }
        if (widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mMatchConstraintDefaultHeight == 2) {
            flags[0] = false;
            return;
        }
        int distToTop = h = widget.getOptimizerWrapHeight();
        int distToBottom = h;
        ConstraintWidget topWidget = null;
        ConstraintWidget bottomWidget = null;
        widget.mVerticalWrapVisited = true;
        if (widget instanceof Guideline) {
            Guideline guideline = (Guideline)widget;
            if (guideline.getOrientation() == 0) {
                distToTop = 0;
                distToBottom = 0;
                if (guideline.getRelativeBegin() != -1) {
                    distToTop = guideline.getRelativeBegin();
                } else if (guideline.getRelativeEnd() != -1) {
                    distToBottom = guideline.getRelativeEnd();
                } else if (guideline.getRelativePercent() != -1.0f) {
                    flags[0] = false;
                    return;
                }
            }
        } else if (widget.mBaseline.mTarget == null && widget.mTop.mTarget == null && widget.mBottom.mTarget == null) {
            distToTop += widget.getY();
        } else {
            if (widget.mBottom.mTarget != null && widget.mTop.mTarget != null && widget.mIsHeightWrapContent && widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                flags[0] = false;
                return;
            }
            if (widget.mBottom.mTarget != null && widget.mTop.mTarget != null && (widget.mBottom.mTarget == widget.mTop.mTarget || widget.mBottom.mTarget.mOwner == widget.mTop.mTarget.mOwner && widget.mBottom.mTarget.mOwner != widget.mParent)) {
                flags[0] = false;
                return;
            }
            if (widget.mBaseline.isConnected()) {
                ConstraintWidget baseLineWidget = widget.mBaseline.mTarget.getOwner();
                if (!baseLineWidget.mVerticalWrapVisited) {
                    Optimizer.findVerticalWrapRecursive(baseLineWidget, flags);
                }
                distToTop = Math.max(baseLineWidget.mDistToTop - baseLineWidget.mHeight + h, h);
                distToBottom = Math.max(baseLineWidget.mDistToBottom - baseLineWidget.mHeight + h, h);
                if (widget.getVisibility() == 8) {
                    distToTop -= widget.mHeight;
                    distToBottom -= widget.mHeight;
                }
                widget.mDistToTop = distToTop;
                widget.mDistToBottom = distToBottom;
                return;
            }
            if (widget.mTop.isConnected()) {
                topWidget = widget.mTop.mTarget.getOwner();
                distToTop += widget.mTop.getMargin();
                if (!topWidget.isRoot() && !topWidget.mVerticalWrapVisited) {
                    Optimizer.findVerticalWrapRecursive(topWidget, flags);
                }
            }
            if (widget.mBottom.isConnected()) {
                bottomWidget = widget.mBottom.mTarget.getOwner();
                distToBottom += widget.mBottom.getMargin();
                if (!bottomWidget.isRoot() && !bottomWidget.mVerticalWrapVisited) {
                    Optimizer.findVerticalWrapRecursive(bottomWidget, flags);
                }
            }
            if (widget.mTop.mTarget != null && !topWidget.isRoot()) {
                if (widget.mTop.mTarget.getType() == ConstraintAnchor.Type.TOP) {
                    distToTop += topWidget.mDistToTop - topWidget.getOptimizerWrapHeight();
                } else if (widget.mTop.mTarget.getType() == ConstraintAnchor.Type.BOTTOM) {
                    distToTop += topWidget.mDistToTop;
                }
                boolean bl = widget.mTopHasCentered = topWidget.mTopHasCentered || topWidget.mTop.mTarget != null && topWidget.mTop.mTarget.mOwner != widget && topWidget.mBottom.mTarget != null && topWidget.mBottom.mTarget.mOwner != widget && topWidget.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                if (widget.mTopHasCentered && (topWidget.mBottom.mTarget == null || topWidget.mBottom.mTarget.mOwner != widget)) {
                    distToTop += distToTop - topWidget.mDistToTop;
                }
            }
            if (widget.mBottom.mTarget != null && !bottomWidget.isRoot()) {
                if (widget.mBottom.mTarget.getType() == ConstraintAnchor.Type.BOTTOM) {
                    distToBottom += bottomWidget.mDistToBottom - bottomWidget.getOptimizerWrapHeight();
                } else if (widget.mBottom.mTarget.getType() == ConstraintAnchor.Type.TOP) {
                    distToBottom += bottomWidget.mDistToBottom;
                }
                boolean bl = widget.mBottomHasCentered = bottomWidget.mBottomHasCentered || bottomWidget.mTop.mTarget != null && bottomWidget.mTop.mTarget.mOwner != widget && bottomWidget.mBottom.mTarget != null && bottomWidget.mBottom.mTarget.mOwner != widget && bottomWidget.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                if (widget.mBottomHasCentered && (bottomWidget.mTop.mTarget == null || bottomWidget.mTop.mTarget.mOwner != widget)) {
                    distToBottom += distToBottom - bottomWidget.mDistToBottom;
                }
            }
        }
        if (widget.getVisibility() == 8) {
            distToTop -= widget.mHeight;
            distToBottom -= widget.mHeight;
        }
        widget.mDistToTop = distToTop;
        widget.mDistToBottom = distToBottom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void findWrapSize(ConstraintWidgetContainer constraintWidgetContainer, ArrayList<ConstraintWidget> children, boolean[] flags) {
        block19: {
            maxTopDist = 0;
            maxLeftDist = 0;
            maxRightDist = 0;
            maxBottomDist = 0;
            maxConnectWidth = 0;
            maxConnectHeight = 0;
            size = children.size();
            flags[0] = true;
            try {
                j = 0;
lbl11:
                // 2 sources

                while (j < size) {
                    widget = children.get(j);
                    if (widget.isRoot()) ** GOTO lbl79
                    if (!widget.mHorizontalWrapVisited) {
                        Optimizer.findHorizontalWrapRecursive(widget, flags);
                    }
                    if (!flags[0]) {
                        j = 0;
                        break block19;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl81
            }
            catch (Throwable var14_16) {
                j = 0;
                while (true) {
                    if (j >= size) {
                        throw var14_16;
                    }
                    child = children.get(j);
                    child.mHorizontalWrapVisited = false;
                    child.mVerticalWrapVisited = false;
                    child.mLeftHasCentered = false;
                    child.mRightHasCentered = false;
                    child.mTopHasCentered = false;
                    child.mBottomHasCentered = false;
                    ++j;
                }
            }
        }
        while (true) {
            if (j >= size) {
                return;
            }
            child = children.get(j);
            child.mHorizontalWrapVisited = false;
            child.mVerticalWrapVisited = false;
            child.mLeftHasCentered = false;
            child.mRightHasCentered = false;
            child.mTopHasCentered = false;
            child.mBottomHasCentered = false;
            ++j;
        }
lbl-1000:
        // 1 sources

        {
            if (!widget.mVerticalWrapVisited) {
                Optimizer.findVerticalWrapRecursive(widget, flags);
            }
            if (flags[0]) ** GOTO lbl-1000
            j = 0;
        }
        while (true) {
            if (j >= size) {
                return;
            }
            child = children.get(j);
            child.mHorizontalWrapVisited = false;
            child.mVerticalWrapVisited = false;
            child.mLeftHasCentered = false;
            child.mRightHasCentered = false;
            child.mTopHasCentered = false;
            child.mBottomHasCentered = false;
            ++j;
        }
lbl-1000:
        // 1 sources

        {
            connectWidth = widget.mDistToLeft + widget.mDistToRight - widget.getWidth();
            connectHeight = widget.mDistToTop + widget.mDistToBottom - widget.getHeight();
            if (widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                connectWidth = widget.getWidth() + widget.mLeft.mMargin + widget.mRight.mMargin;
            }
            if (widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                connectHeight = widget.getHeight() + widget.mTop.mMargin + widget.mBottom.mMargin;
            }
            if (widget.getVisibility() == 8) {
                connectWidth = 0;
                connectHeight = 0;
            }
            maxLeftDist = Math.max(maxLeftDist, widget.mDistToLeft);
            maxRightDist = Math.max(maxRightDist, widget.mDistToRight);
            maxBottomDist = Math.max(maxBottomDist, widget.mDistToBottom);
            maxTopDist = Math.max(maxTopDist, widget.mDistToTop);
            maxConnectWidth = Math.max(maxConnectWidth, connectWidth);
            maxConnectHeight = Math.max(maxConnectHeight, connectHeight);
lbl79:
            // 2 sources

            ++j;
            ** GOTO lbl11
lbl81:
            // 1 sources

            max = Math.max(maxLeftDist, maxRightDist);
            constraintWidgetContainer.mWrapWidth = Math.max(constraintWidgetContainer.mMinWidth, Math.max(max, maxConnectWidth));
            max = Math.max(maxTopDist, maxBottomDist);
            constraintWidgetContainer.mWrapHeight = Math.max(constraintWidgetContainer.mMinHeight, Math.max(max, maxConnectHeight));
            j = 0;
        }
        while (true) {
            if (j >= size) {
                return;
            }
            child = children.get(j);
            child.mHorizontalWrapVisited = false;
            child.mVerticalWrapVisited = false;
            child.mLeftHasCentered = false;
            child.mRightHasCentered = false;
            child.mTopHasCentered = false;
            child.mBottomHasCentered = false;
            ++j;
        }
    }
}

