/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets;

import android.support.constraint.solver.LinearSystem;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;

public class Optimizer {
    public static final int OPTIMIZATION_NONE = 1;
    public static final int OPTIMIZATION_ALL = 2;
    public static final int OPTIMIZATION_BASIC = 4;
    public static final int OPTIMIZATION_CHAIN = 8;
    static boolean[] flags = new boolean[3];
    static final int FLAG_USE_OPTIMIZE = 0;
    static final int FLAG_CHAIN_DANGLING = 1;
    static final int FLAG_RECOMPUTE_BOUNDS = 2;
    private static final boolean DEBUG_OPTIMIZE = false;
    private static final boolean TRACE_OPTIMIZE = false;

    static void checkMatchParent(ConstraintWidgetContainer container, LinearSystem system, ConstraintWidget widget) {
        if (container.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
            widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
            int left = widget.mLeft.mMargin;
            int right = container.getWidth() - widget.mRight.mMargin;
            system.addEquality(widget.mLeft.mSolverVariable, left);
            system.addEquality(widget.mRight.mSolverVariable, right);
            widget.setHorizontalDimension(left, right);
            widget.mHorizontalResolution = 2;
        }
        if (container.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
            widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
            int top = widget.mTop.mMargin;
            int bottom = container.getHeight() - widget.mBottom.mMargin;
            system.addEquality(widget.mTop.mSolverVariable, top);
            system.addEquality(widget.mBottom.mSolverVariable, bottom);
            if (widget.mBaselineDistance > 0 || widget.getVisibility() == 8) {
                widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
            }
            widget.setVerticalDimension(top, bottom);
            widget.mVerticalResolution = 2;
        }
    }

    static boolean optimize(LinearSystem system, ConstraintWidgetContainer container) {
        ConstraintWidget widget;
        int i;
        int count = container.mChildren.size();
        boolean horizontalParentWrap = container.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        boolean verticalParentWrap = container.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        for (i = 0; i < count; ++i) {
            widget = (ConstraintWidget)container.mChildren.get(i);
            if (horizontalParentWrap) {
                widget.mLeft.resolutionStatus = 2;
                widget.mRight.resolutionStatus = 2;
            } else {
                widget.mLeft.resolutionStatus = 0;
                widget.mRight.resolutionStatus = 0;
            }
            if (verticalParentWrap) {
                widget.mTop.resolutionStatus = 2;
                widget.mBottom.resolutionStatus = 2;
                widget.mBaseline.resolutionStatus = 2;
                continue;
            }
            widget.mTop.resolutionStatus = 0;
            widget.mBottom.resolutionStatus = 0;
            widget.mBaseline.resolutionStatus = 0;
        }
        for (i = 0; i < count; ++i) {
            int beginSpace;
            float space;
            widget = (ConstraintWidget)container.mChildren.get(i);
            ConstraintAnchor begin = widget.mListAnchors[0];
            ConstraintAnchor end = widget.mListAnchors[1];
            boolean parentWrap = horizontalParentWrap;
            if (begin.resolutionStatus == 0 && end.resolutionStatus == 0) {
                if (begin.mTarget != null && end.mTarget != null) {
                    if (!parentWrap && begin.mTarget == container.mLeft && end.mTarget == container.mRight && widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.FIXED) {
                        space = container.mWidth - widget.mWidth - begin.getMargin() - end.getMargin();
                        beginSpace = (int)(space * widget.mHorizontalBiasPercent + 0.5f) + begin.getMargin();
                        begin.resolve(system, beginSpace, null);
                        end.resolve(system, beginSpace + widget.mWidth, null);
                    }
                } else if (begin.mTarget != null && begin.mTarget == container.mLeft) {
                    begin.resolve(system, begin.getMargin(), null);
                } else if (end.mTarget != null && end.mTarget == container.mRight) {
                    end.resolve(system, container.mWidth - end.getMargin(), null);
                }
            }
            begin = widget.mListAnchors[2];
            end = widget.mListAnchors[3];
            parentWrap = verticalParentWrap;
            if (begin.resolutionStatus != 0 || end.resolutionStatus != 0) continue;
            if (begin.mTarget != null && end.mTarget != null) {
                if (parentWrap || begin.mTarget != container.mTop || end.mTarget != container.mBottom || widget.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.FIXED) continue;
                space = container.mHeight - widget.mHeight - begin.getMargin() - end.getMargin();
                beginSpace = (int)(space * widget.mVerticalBiasPercent + 0.5f) + begin.getMargin();
                begin.resolve(system, beginSpace, null);
                end.resolve(system, beginSpace + widget.mHeight, null);
                continue;
            }
            if (begin.mTarget != null && begin.mTarget == container.mTop) {
                begin.resolve(system, begin.getMargin(), null);
                continue;
            }
            if (end.mTarget == null || end.mTarget != container.mBottom) continue;
            end.resolve(system, container.mHeight - end.getMargin(), null);
        }
        for (i = 0; i < count; ++i) {
            boolean fixedDimension;
            widget = (ConstraintWidget)container.mChildren.get(i);
            boolean bl = fixedDimension = widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.FIXED || widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            if (fixedDimension) {
                ConstraintAnchor left = widget.mListAnchors[0];
                ConstraintAnchor right = widget.mListAnchors[1];
                if (left.resolutionStatus == 1 && right.resolutionStatus == 0) {
                    if (left.resolvedAnchor == null) {
                        right.resolve(system, left.resolvedValue + widget.getWidth(), null);
                    } else {
                        right.resolve(system, widget.getWidth(), left);
                    }
                } else if (left.resolutionStatus == 0 && right.resolutionStatus == 1) {
                    if (right.resolvedAnchor == null) {
                        left.resolve(system, right.resolvedValue - widget.getWidth(), null);
                    } else {
                        left.resolve(system, -widget.getWidth(), right);
                    }
                }
            }
            boolean bl2 = fixedDimension = widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.FIXED || widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            if (!fixedDimension) continue;
            ConstraintAnchor top = widget.mTop;
            ConstraintAnchor bottom = widget.mBottom;
            if (top.resolutionStatus == 1 && bottom.resolutionStatus == 0) {
                if (top.resolvedAnchor == null) {
                    bottom.resolve(system, top.resolvedValue + widget.getHeight(), null);
                    continue;
                }
                bottom.resolve(system, widget.getHeight(), top);
                continue;
            }
            if (top.resolutionStatus != 0 || bottom.resolutionStatus != 1) continue;
            if (bottom.resolvedAnchor == null) {
                top.resolve(system, bottom.resolvedValue - widget.getHeight(), null);
                continue;
            }
            top.resolve(system, -widget.getHeight(), bottom);
        }
        for (i = 0; i < count; ++i) {
            widget = (ConstraintWidget)container.mChildren.get(i);
            if (widget.mLeft.resolutionStatus != 1) {
                return false;
            }
            if (widget.mRight.resolutionStatus != 1) {
                return false;
            }
            if (widget.mTop.resolutionStatus != 1) {
                return false;
            }
            if (widget.mBottom.resolutionStatus == 1) continue;
            return false;
        }
        for (i = 0; i < count; ++i) {
            widget = (ConstraintWidget)container.mChildren.get(i);
            int left = widget.mLeft.resolvedValue;
            int top = widget.mTop.resolvedValue;
            int right = widget.mRight.resolvedValue;
            int bottom = widget.mBottom.resolvedValue;
            widget.setFrame(left, top, right, bottom);
        }
        return true;
    }
}

