/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets;

import android.support.constraint.solver.LinearSystem;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.ResolutionNode;

public class Optimizer {
    public static final int OPTIMIZATION_NONE = 0;
    public static final int OPTIMIZATION_DIRECT = 1;
    public static final int OPTIMIZATION_BARRIER = 2;
    public static final int OPTIMIZATION_CHAIN = 4;
    public static final int OPTIMIZATION_RATIO = 8;
    public static final int OPTIMIZATION_STANDARD = 3;
    static boolean[] flags = new boolean[3];
    static final int FLAG_USE_OPTIMIZE = 0;
    static final int FLAG_CHAIN_DANGLING = 1;
    static final int FLAG_RECOMPUTE_BOUNDS = 2;

    static void checkMatchParent(ConstraintWidgetContainer container, LinearSystem system, ConstraintWidget widget) {
        if (container.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            int left = widget.mLeft.mMargin;
            int right = container.getWidth() - widget.mRight.mMargin;
            widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
            widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
            system.addEquality(widget.mLeft.mSolverVariable, left);
            system.addEquality(widget.mRight.mSolverVariable, right);
            widget.mHorizontalResolution = 2;
            widget.setHorizontalDimension(left, right);
        }
        if (container.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            int top = widget.mTop.mMargin;
            int bottom = container.getHeight() - widget.mBottom.mMargin;
            widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
            widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
            system.addEquality(widget.mTop.mSolverVariable, top);
            system.addEquality(widget.mBottom.mSolverVariable, bottom);
            if (widget.mBaselineDistance > 0 || widget.getVisibility() == 8) {
                widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
            }
            widget.mVerticalResolution = 2;
            widget.setVerticalDimension(top, bottom);
        }
    }

    private static boolean optimizableMatchConstraint(ConstraintWidget constraintWidget, int orientation) {
        if (constraintWidget.mListDimensionBehaviors[orientation] != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            return false;
        }
        if (constraintWidget.mDimensionRatio != 0.0f) {
            if (constraintWidget.mListDimensionBehaviors[orientation == 0 ? 1 : 0] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                return false;
            }
            return false;
        }
        if (orientation == 0) {
            if (constraintWidget.mMatchConstraintDefaultWidth != 0) {
                return false;
            }
            if (constraintWidget.mMatchConstraintMinWidth != 0 || constraintWidget.mMatchConstraintMaxWidth != 0) {
                return false;
            }
        } else {
            if (constraintWidget.mMatchConstraintDefaultHeight != 0) {
                return false;
            }
            if (constraintWidget.mMatchConstraintMinHeight != 0 || constraintWidget.mMatchConstraintMaxHeight != 0) {
                return false;
            }
        }
        return true;
    }

    static void analyze(ConstraintWidget widget) {
        widget.updateResolutionNodes();
        ResolutionNode leftNode = widget.mLeft.getResolutionNode();
        ResolutionNode topNode = widget.mTop.getResolutionNode();
        ResolutionNode rightNode = widget.mRight.getResolutionNode();
        ResolutionNode bottomNode = widget.mBottom.getResolutionNode();
        if (leftNode.type != 4 && rightNode.type != 4) {
            if (widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.FIXED) {
                if (widget.mLeft.mTarget == null && widget.mRight.mTarget == null) {
                    leftNode.setType(1);
                    rightNode.setType(1);
                    rightNode.dependsOn(leftNode, widget.getWidth());
                } else if (widget.mLeft.mTarget != null && widget.mRight.mTarget == null) {
                    leftNode.setType(1);
                    rightNode.setType(1);
                    rightNode.dependsOn(leftNode, widget.getWidth());
                } else if (widget.mLeft.mTarget == null && widget.mRight.mTarget != null) {
                    leftNode.setType(1);
                    rightNode.setType(1);
                    leftNode.dependsOn(rightNode, -widget.getWidth());
                } else if (widget.mLeft.mTarget != null && widget.mRight.mTarget != null) {
                    leftNode.setType(2);
                    rightNode.setType(2);
                    leftNode.setOpposite(rightNode, -widget.getWidth());
                    rightNode.setOpposite(leftNode, widget.getWidth());
                }
            } else if (widget.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && Optimizer.optimizableMatchConstraint(widget, 0)) {
                int width = widget.getWidth();
                if (widget.mDimensionRatio != 0.0f) {
                    width = (int)((float)widget.getHeight() * widget.mDimensionRatio);
                }
                leftNode.setType(1);
                rightNode.setType(1);
                if (widget.mLeft.mTarget == null && widget.mRight.mTarget == null) {
                    rightNode.dependsOn(leftNode, width);
                } else if (widget.mLeft.mTarget != null && widget.mRight.mTarget == null) {
                    rightNode.dependsOn(leftNode, width);
                } else if (widget.mLeft.mTarget == null && widget.mRight.mTarget != null) {
                    leftNode.dependsOn(rightNode, -width);
                } else if (widget.mLeft.mTarget != null && widget.mRight.mTarget != null) {
                    if (widget.mDimensionRatio == 0.0f) {
                        leftNode.setType(3);
                        rightNode.setType(3);
                        leftNode.setOpposite(rightNode, 0.0f);
                        rightNode.setOpposite(leftNode, 0.0f);
                    } else {
                        leftNode.setType(2);
                        rightNode.setType(2);
                        leftNode.setOpposite(rightNode, -width);
                        rightNode.setOpposite(leftNode, width);
                        widget.setWidth(width);
                    }
                }
            }
        }
        if (topNode.type != 4 && bottomNode.type != 4) {
            if (widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.FIXED) {
                if (widget.mTop.mTarget == null && widget.mBottom.mTarget == null) {
                    topNode.setType(1);
                    bottomNode.setType(1);
                    bottomNode.dependsOn(topNode, widget.getHeight());
                    if (widget.mBaseline.mTarget != null) {
                        widget.mBaseline.getResolutionNode().setType(1);
                        topNode.dependsOn(1, widget.mBaseline.getResolutionNode(), -widget.mBaselineDistance);
                    }
                } else if (widget.mTop.mTarget != null && widget.mBottom.mTarget == null) {
                    topNode.setType(1);
                    bottomNode.setType(1);
                    bottomNode.dependsOn(topNode, widget.getHeight());
                    if (widget.mBaselineDistance > 0) {
                        widget.mBaseline.getResolutionNode().dependsOn(1, topNode, widget.mBaselineDistance);
                    }
                } else if (widget.mTop.mTarget == null && widget.mBottom.mTarget != null) {
                    topNode.setType(1);
                    bottomNode.setType(1);
                    topNode.dependsOn(bottomNode, -widget.getHeight());
                    if (widget.mBaselineDistance > 0) {
                        widget.mBaseline.getResolutionNode().dependsOn(1, topNode, widget.mBaselineDistance);
                    }
                } else if (widget.mTop.mTarget != null && widget.mBottom.mTarget != null) {
                    topNode.setType(2);
                    bottomNode.setType(2);
                    topNode.setOpposite(bottomNode, -widget.getHeight());
                    bottomNode.setOpposite(topNode, widget.getHeight());
                    if (widget.mBaselineDistance > 0) {
                        widget.mBaseline.getResolutionNode().dependsOn(1, topNode, widget.mBaselineDistance);
                    }
                }
            } else if (widget.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && Optimizer.optimizableMatchConstraint(widget, 1)) {
                int height = widget.getHeight();
                if (widget.mDimensionRatio != 0.0f) {
                    height = (int)((float)widget.getWidth() * widget.mDimensionRatio);
                }
                topNode.setType(1);
                bottomNode.setType(1);
                if (widget.mTop.mTarget == null && widget.mBottom.mTarget == null) {
                    bottomNode.dependsOn(topNode, height);
                } else if (widget.mTop.mTarget != null && widget.mBottom.mTarget == null) {
                    bottomNode.dependsOn(topNode, height);
                } else if (widget.mTop.mTarget == null && widget.mBottom.mTarget != null) {
                    topNode.dependsOn(bottomNode, -height);
                } else if (widget.mTop.mTarget != null && widget.mBottom.mTarget != null) {
                    if (widget.mDimensionRatio == 0.0f) {
                        topNode.setType(3);
                        bottomNode.setType(3);
                        topNode.setOpposite(bottomNode, 0.0f);
                        bottomNode.setOpposite(topNode, 0.0f);
                    } else {
                        topNode.setType(2);
                        bottomNode.setType(2);
                        topNode.setOpposite(bottomNode, -height);
                        bottomNode.setOpposite(topNode, height);
                        widget.setHeight(height);
                        if (widget.mBaselineDistance > 0) {
                            widget.mBaseline.getResolutionNode().dependsOn(1, topNode, widget.mBaselineDistance);
                        }
                    }
                }
            }
        }
    }

    static boolean applyChainOptimized(ConstraintWidgetContainer container, LinearSystem system, int orientation, int offset, ConstraintWidget first) {
        block55: {
            float distance;
            float firstOffset;
            float extraMargin;
            ResolutionNode firstNode;
            int numVisibleWidgets;
            boolean isChainSpreadInside;
            boolean isChainSpread;
            ConstraintWidget lastVisibleWidget;
            ConstraintWidget firstVisibleWidget;
            ConstraintWidget next;
            ConstraintWidget widget;
            block54: {
                widget = first;
                next = null;
                firstVisibleWidget = null;
                lastVisibleWidget = null;
                boolean done = false;
                int numMatchConstraints = 0;
                float totalWeights = 0.0f;
                ConstraintWidget firstMatchConstraintsWidget = null;
                ConstraintWidget previousMatchConstraintsWidget = null;
                boolean isWrapContent = container.mListDimensionBehaviors[orientation] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                isChainSpread = false;
                isChainSpreadInside = false;
                boolean isChainPacked = false;
                ConstraintWidget head = first;
                if (orientation == 0 && container.isRtl()) {
                    while (!done) {
                        ConstraintAnchor nextAnchor = widget.mListAnchors[offset + 1].mTarget;
                        if (nextAnchor != null) {
                            next = nextAnchor.mOwner;
                            if (next.mListAnchors[offset].mTarget == null || next.mListAnchors[offset].mTarget.mOwner != widget) {
                                next = null;
                            }
                        } else {
                            next = null;
                        }
                        if (next != null) {
                            widget = next;
                            continue;
                        }
                        done = true;
                    }
                    head = widget;
                    widget = first;
                    next = null;
                    done = false;
                }
                if (orientation == 0) {
                    isChainSpread = head.mHorizontalChainStyle == 0;
                    isChainSpreadInside = head.mHorizontalChainStyle == 1;
                    isChainPacked = head.mHorizontalChainStyle == 2;
                } else {
                    isChainSpread = head.mVerticalChainStyle == 0;
                    isChainSpreadInside = head.mVerticalChainStyle == 1;
                    isChainPacked = head.mVerticalChainStyle == 2;
                }
                float totalSize = 0.0f;
                float totalMargins = 0.0f;
                numVisibleWidgets = 0;
                while (!done) {
                    ConstraintAnchor nextAnchor;
                    widget.mListNextVisibleWidget[orientation] = null;
                    if (widget.getVisibility() != 8) {
                        if (lastVisibleWidget != null) {
                            lastVisibleWidget.mListNextVisibleWidget[orientation] = widget;
                        }
                        if (firstVisibleWidget == null) {
                            firstVisibleWidget = widget;
                        }
                        lastVisibleWidget = widget;
                        ++numVisibleWidgets;
                        totalSize = orientation == 0 ? (totalSize += (float)widget.getWidth()) : (totalSize += (float)widget.getHeight());
                        if (widget != firstVisibleWidget) {
                            totalSize += (float)widget.mListAnchors[offset].getMargin();
                        }
                        totalMargins += (float)widget.mListAnchors[offset].getMargin();
                        totalMargins += (float)widget.mListAnchors[offset + 1].getMargin();
                    }
                    ConstraintAnchor begin = widget.mListAnchors[offset];
                    widget.mListNextMatchConstraintsWidget[orientation] = null;
                    if (widget.getVisibility() != 8 && widget.mListDimensionBehaviors[orientation] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        ++numMatchConstraints;
                        if (orientation == 0) {
                            if (widget.mMatchConstraintDefaultWidth != 0) {
                                return false;
                            }
                            if (widget.mMatchConstraintMinWidth != 0 || widget.mMatchConstraintMaxWidth != 0) {
                                return false;
                            }
                        } else {
                            if (widget.mMatchConstraintDefaultHeight != 0) {
                                return false;
                            }
                            if (widget.mMatchConstraintMinHeight != 0 || widget.mMatchConstraintMaxHeight != 0) {
                                return false;
                            }
                        }
                        totalWeights += widget.mWeight[orientation];
                        if (firstMatchConstraintsWidget == null) {
                            firstMatchConstraintsWidget = widget;
                        } else {
                            previousMatchConstraintsWidget.mListNextMatchConstraintsWidget[orientation] = widget;
                        }
                        previousMatchConstraintsWidget = widget;
                    }
                    if ((nextAnchor = widget.mListAnchors[offset + 1].mTarget) != null) {
                        next = nextAnchor.mOwner;
                        if (next.mListAnchors[offset].mTarget == null || next.mListAnchors[offset].mTarget.mOwner != widget) {
                            next = null;
                        }
                    } else {
                        next = null;
                    }
                    if (next != null) {
                        widget = next;
                        continue;
                    }
                    done = true;
                }
                ConstraintWidget last = widget;
                firstNode = first.mListAnchors[offset].getResolutionNode();
                ResolutionNode lastNode = last.mListAnchors[offset + 1].getResolutionNode();
                if (firstNode.target == null || lastNode.target == null) {
                    return false;
                }
                if (firstNode.target.state != 1 && lastNode.target.state != 1) {
                    return false;
                }
                if (numMatchConstraints > 0 && numMatchConstraints != numVisibleWidgets) {
                    return false;
                }
                extraMargin = 0.0f;
                if (isChainPacked || isChainSpread || isChainSpreadInside) {
                    if (firstVisibleWidget != null) {
                        extraMargin = firstVisibleWidget.mListAnchors[offset].getMargin();
                    }
                    if (lastVisibleWidget != null) {
                        extraMargin += (float)lastVisibleWidget.mListAnchors[offset + 1].getMargin();
                    }
                }
                firstOffset = firstNode.target.resolvedOffset;
                float lastOffset = lastNode.target.resolvedOffset;
                distance = 0.0f;
                distance = firstOffset < lastOffset ? lastOffset - firstOffset - totalSize : firstOffset - lastOffset - totalSize;
                if (numMatchConstraints > 0 && numMatchConstraints == numVisibleWidgets) {
                    if (widget.getParent() != null && widget.getParent().mListDimensionBehaviors[orientation] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        return false;
                    }
                    distance += totalSize;
                    distance -= totalMargins;
                    widget = firstVisibleWidget;
                    float position = firstOffset;
                    if (isChainSpread) {
                        distance -= totalMargins - extraMargin;
                    }
                    if (isChainSpread) {
                        position += (float)widget.mListAnchors[offset + 1].getMargin();
                        next = widget.mListNextVisibleWidget[orientation];
                        if (next != null) {
                            position += (float)next.mListAnchors[offset].getMargin();
                        }
                    }
                    while (widget != null) {
                        if (LinearSystem.sMetrics != null) {
                            --LinearSystem.sMetrics.nonresolvedWidgets;
                            ++LinearSystem.sMetrics.resolvedWidgets;
                            ++LinearSystem.sMetrics.chainConnectionResolved;
                        }
                        if ((next = widget.mListNextVisibleWidget[orientation]) != null || widget == lastVisibleWidget) {
                            float dimension = distance / (float)numMatchConstraints;
                            if (totalWeights > 0.0f) {
                                dimension = widget.mWeight[orientation] * distance / totalWeights;
                            }
                            widget.mListAnchors[offset].getResolutionNode().resolve(firstNode.resolvedTarget, position += (float)widget.mListAnchors[offset].getMargin());
                            widget.mListAnchors[offset + 1].getResolutionNode().resolve(firstNode.resolvedTarget, position + dimension);
                            widget.mListAnchors[offset].getResolutionNode().addResolvedValue(system);
                            widget.mListAnchors[offset + 1].getResolutionNode().addResolvedValue(system);
                            position += dimension;
                            position += (float)widget.mListAnchors[offset + 1].getMargin();
                        }
                        widget = next;
                    }
                    return true;
                }
                if (distance < totalSize) {
                    return false;
                }
                if (!isChainPacked) break block54;
                distance -= extraMargin;
                widget = firstVisibleWidget;
                distance = firstOffset + distance * first.getHorizontalBiasPercent();
                while (widget != null) {
                    if (LinearSystem.sMetrics != null) {
                        --LinearSystem.sMetrics.nonresolvedWidgets;
                        ++LinearSystem.sMetrics.resolvedWidgets;
                        ++LinearSystem.sMetrics.chainConnectionResolved;
                    }
                    if ((next = widget.mListNextVisibleWidget[orientation]) != null || widget == lastVisibleWidget) {
                        float dimension = 0.0f;
                        dimension = orientation == 0 ? (float)widget.getWidth() : (float)widget.getHeight();
                        widget.mListAnchors[offset].getResolutionNode().resolve(firstNode.resolvedTarget, distance += (float)widget.mListAnchors[offset].getMargin());
                        widget.mListAnchors[offset + 1].getResolutionNode().resolve(firstNode.resolvedTarget, distance + dimension);
                        widget.mListAnchors[offset].getResolutionNode().addResolvedValue(system);
                        widget.mListAnchors[offset + 1].getResolutionNode().addResolvedValue(system);
                        distance += dimension;
                        distance += (float)widget.mListAnchors[offset + 1].getMargin();
                    }
                    widget = next;
                }
                break block55;
            }
            if (!isChainSpread && !isChainSpreadInside) break block55;
            if (isChainSpread) {
                distance -= extraMargin;
            } else if (isChainSpreadInside) {
                distance -= extraMargin;
            }
            widget = firstVisibleWidget;
            float gap = distance / (float)(numVisibleWidgets + 1);
            if (isChainSpreadInside) {
                gap = numVisibleWidgets > 1 ? distance / (float)(numVisibleWidgets - 1) : distance / 2.0f;
            }
            distance = firstOffset + gap;
            if (isChainSpreadInside && numVisibleWidgets > 1) {
                distance = firstOffset + (float)firstVisibleWidget.mListAnchors[offset].getMargin();
            }
            if (isChainSpread && firstVisibleWidget != null) {
                distance += (float)firstVisibleWidget.mListAnchors[offset].getMargin();
            }
            while (widget != null) {
                if (LinearSystem.sMetrics != null) {
                    --LinearSystem.sMetrics.nonresolvedWidgets;
                    ++LinearSystem.sMetrics.resolvedWidgets;
                    ++LinearSystem.sMetrics.chainConnectionResolved;
                }
                if ((next = widget.mListNextVisibleWidget[orientation]) != null || widget == lastVisibleWidget) {
                    float dimension = 0.0f;
                    dimension = orientation == 0 ? (float)widget.getWidth() : (float)widget.getHeight();
                    widget.mListAnchors[offset].getResolutionNode().resolve(firstNode.resolvedTarget, distance);
                    widget.mListAnchors[offset + 1].getResolutionNode().resolve(firstNode.resolvedTarget, distance + dimension);
                    widget.mListAnchors[offset].getResolutionNode().addResolvedValue(system);
                    widget.mListAnchors[offset + 1].getResolutionNode().addResolvedValue(system);
                    distance += dimension + gap;
                }
                widget = next;
            }
        }
        return true;
    }
}

