/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver;

import android.support.constraint.solver.ArrayRow;
import android.support.constraint.solver.Cache;
import android.support.constraint.solver.GoalRow;
import android.support.constraint.solver.Metrics;
import android.support.constraint.solver.SolverVariable;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import java.util.Arrays;
import java.util.HashMap;

public class LinearSystem {
    public static final boolean FULL_DEBUG = false;
    private static final boolean DEBUG = false;
    private static int POOL_SIZE = 1000;
    int mVariablesID = 0;
    private HashMap<String, SolverVariable> mVariables = null;
    private Row mGoal;
    private int TABLE_SIZE;
    private int mMaxColumns = this.TABLE_SIZE = 32;
    ArrayRow[] mRows = null;
    public boolean graphOptimizer = false;
    private boolean[] mAlreadyTestedCandidates = new boolean[this.TABLE_SIZE];
    int mNumColumns = 1;
    int mNumRows = 0;
    private int mMaxRows = this.TABLE_SIZE;
    final Cache mCache;
    private SolverVariable[] mPoolVariables = new SolverVariable[POOL_SIZE];
    private int mPoolVariablesCount = 0;
    private ArrayRow[] tempClientsCopy = new ArrayRow[this.TABLE_SIZE];
    public static Metrics sMetrics;
    private final Row mTempGoal;

    public LinearSystem() {
        this.mRows = new ArrayRow[this.TABLE_SIZE];
        this.releaseRows();
        this.mCache = new Cache();
        this.mGoal = new GoalRow(this.mCache);
        this.mTempGoal = new ArrayRow(this.mCache);
    }

    public void fillMetrics(Metrics metrics) {
        sMetrics = metrics;
    }

    public static Metrics getMetrics() {
        return sMetrics;
    }

    private void increaseTableSize() {
        this.TABLE_SIZE *= 2;
        this.mRows = Arrays.copyOf(this.mRows, this.TABLE_SIZE);
        this.mCache.mIndexedVariables = Arrays.copyOf(this.mCache.mIndexedVariables, this.TABLE_SIZE);
        this.mAlreadyTestedCandidates = new boolean[this.TABLE_SIZE];
        this.mMaxColumns = this.TABLE_SIZE;
        this.mMaxRows = this.TABLE_SIZE;
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.tableSizeIncrease;
            LinearSystem.sMetrics.lastTableSize = LinearSystem.sMetrics.maxTableSize = Math.max(LinearSystem.sMetrics.maxTableSize, (long)this.TABLE_SIZE);
        }
    }

    private void releaseRows() {
        for (int i = 0; i < this.mRows.length; ++i) {
            ArrayRow row = this.mRows[i];
            if (row != null) {
                this.mCache.arrayRowPool.release(row);
            }
            this.mRows[i] = null;
        }
    }

    public void reset() {
        int i;
        for (i = 0; i < this.mCache.mIndexedVariables.length; ++i) {
            SolverVariable variable = this.mCache.mIndexedVariables[i];
            if (variable == null) continue;
            variable.reset();
        }
        this.mCache.solverVariablePool.releaseAll((SolverVariable[])this.mPoolVariables, this.mPoolVariablesCount);
        this.mPoolVariablesCount = 0;
        Arrays.fill(this.mCache.mIndexedVariables, null);
        if (this.mVariables != null) {
            this.mVariables.clear();
        }
        this.mVariablesID = 0;
        this.mGoal.clear();
        this.mNumColumns = 1;
        for (i = 0; i < this.mNumRows; ++i) {
            this.mRows[i].used = false;
        }
        this.releaseRows();
        this.mNumRows = 0;
    }

    public SolverVariable createObjectVariable(Object anchor) {
        if (anchor == null) {
            return null;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = null;
        if (anchor instanceof ConstraintAnchor) {
            variable = ((ConstraintAnchor)anchor).getSolverVariable();
            if (variable == null) {
                ((ConstraintAnchor)anchor).resetSolverVariable(this.mCache);
                variable = ((ConstraintAnchor)anchor).getSolverVariable();
            }
            if (variable.id == -1 || variable.id > this.mVariablesID || this.mCache.mIndexedVariables[variable.id] == null) {
                if (variable.id != -1) {
                    variable.reset();
                }
                ++this.mVariablesID;
                ++this.mNumColumns;
                variable.id = this.mVariablesID;
                variable.mType = SolverVariable.Type.UNRESTRICTED;
                this.mCache.mIndexedVariables[this.mVariablesID] = variable;
            }
        }
        return variable;
    }

    public ArrayRow createRow() {
        ArrayRow row = this.mCache.arrayRowPool.acquire();
        if (row == null) {
            row = new ArrayRow(this.mCache);
        } else {
            row.reset();
        }
        SolverVariable.increaseErrorId();
        return row;
    }

    public SolverVariable createSlackVariable() {
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.slackvariables;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(SolverVariable.Type.SLACK, null);
        ++this.mVariablesID;
        ++this.mNumColumns;
        variable.id = this.mVariablesID;
        this.mCache.mIndexedVariables[this.mVariablesID] = variable;
        return variable;
    }

    public SolverVariable createExtraVariable() {
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.extravariables;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(SolverVariable.Type.SLACK, null);
        ++this.mVariablesID;
        ++this.mNumColumns;
        variable.id = this.mVariablesID;
        this.mCache.mIndexedVariables[this.mVariablesID] = variable;
        return variable;
    }

    private void addError(ArrayRow row) {
        row.addError(this, 0);
    }

    private void addSingleError(ArrayRow row, int sign) {
        this.addSingleError(row, sign, 0);
    }

    void addSingleError(ArrayRow row, int sign, int strength) {
        String prefix = null;
        SolverVariable error = this.createErrorVariable(strength, prefix);
        row.addSingleError(error, sign);
    }

    private SolverVariable createVariable(String name, SolverVariable.Type type) {
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.variables;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(type, null);
        variable.setName(name);
        ++this.mVariablesID;
        ++this.mNumColumns;
        variable.id = this.mVariablesID;
        if (this.mVariables == null) {
            this.mVariables = new HashMap();
        }
        this.mVariables.put(name, variable);
        this.mCache.mIndexedVariables[this.mVariablesID] = variable;
        return variable;
    }

    public SolverVariable createErrorVariable(int strength, String prefix) {
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.errors;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(SolverVariable.Type.ERROR, prefix);
        ++this.mVariablesID;
        ++this.mNumColumns;
        variable.id = this.mVariablesID;
        variable.strength = strength;
        this.mCache.mIndexedVariables[this.mVariablesID] = variable;
        this.mGoal.addError(variable);
        return variable;
    }

    private SolverVariable acquireSolverVariable(SolverVariable.Type type, String prefix) {
        SolverVariable variable = this.mCache.solverVariablePool.acquire();
        if (variable == null) {
            variable = new SolverVariable(type, prefix);
            variable.setType(type, prefix);
        } else {
            variable.reset();
            variable.setType(type, prefix);
        }
        if (this.mPoolVariablesCount >= POOL_SIZE) {
            this.mPoolVariables = Arrays.copyOf(this.mPoolVariables, POOL_SIZE *= 2);
        }
        this.mPoolVariables[this.mPoolVariablesCount++] = variable;
        return variable;
    }

    Row getGoal() {
        return this.mGoal;
    }

    ArrayRow getRow(int n) {
        return this.mRows[n];
    }

    float getValueFor(String name) {
        SolverVariable v = this.getVariable(name, SolverVariable.Type.UNRESTRICTED);
        if (v == null) {
            return 0.0f;
        }
        return v.computedValue;
    }

    public int getObjectVariableValue(Object anchor) {
        SolverVariable variable = ((ConstraintAnchor)anchor).getSolverVariable();
        if (variable != null) {
            return (int)(variable.computedValue + 0.5f);
        }
        return 0;
    }

    SolverVariable getVariable(String name, SolverVariable.Type type) {
        SolverVariable variable;
        if (this.mVariables == null) {
            this.mVariables = new HashMap();
        }
        if ((variable = this.mVariables.get(name)) == null) {
            variable = this.createVariable(name, type);
        }
        return variable;
    }

    public void minimize() throws Exception {
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.minimize;
        }
        if (this.graphOptimizer) {
            if (sMetrics != null) {
                ++LinearSystem.sMetrics.graphOptimizer;
            }
            boolean fullySolved = true;
            for (int i = 0; i < this.mNumRows; ++i) {
                ArrayRow r = this.mRows[i];
                if (r.isSimpleDefinition) continue;
                fullySolved = false;
                break;
            }
            if (!fullySolved) {
                this.minimizeGoal(this.mGoal);
            } else {
                if (sMetrics != null) {
                    ++LinearSystem.sMetrics.fullySolved;
                }
                this.computeValues();
            }
        } else {
            this.minimizeGoal(this.mGoal);
        }
    }

    void minimizeGoal(Row goal) throws Exception {
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.minimizeGoal;
            LinearSystem.sMetrics.maxVariables = Math.max(LinearSystem.sMetrics.maxVariables, (long)this.mNumColumns);
            LinearSystem.sMetrics.maxRows = Math.max(LinearSystem.sMetrics.maxRows, (long)this.mNumRows);
        }
        this.updateRowFromVariables((ArrayRow)goal);
        this.enforceBFS(goal);
        this.optimize(goal, false);
        this.computeValues();
    }

    private final void updateRowFromVariables(ArrayRow row) {
        if (this.mNumRows > 0) {
            row.variables.updateFromSystem(row, this.mRows);
            if (row.variables.currentSize == 0) {
                row.isSimpleDefinition = true;
            }
        }
    }

    public void addConstraint(ArrayRow row) {
        if (row == null) {
            return;
        }
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.constraints;
            if (row.isSimpleDefinition) {
                ++LinearSystem.sMetrics.simpleconstraints;
            }
        }
        if (this.mNumRows + 1 >= this.mMaxRows || this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        boolean added = false;
        if (!row.isSimpleDefinition) {
            this.updateRowFromVariables(row);
            if (row.isEmpty()) {
                return;
            }
            row.ensurePositiveConstant();
            if (row.chooseSubject(this)) {
                SolverVariable extra;
                row.variable = extra = this.createExtraVariable();
                this.addRow(row);
                added = true;
                this.mTempGoal.initFromRow(row);
                this.optimize(this.mTempGoal, true);
                if (extra.definitionId == -1) {
                    SolverVariable pivotCandidate;
                    if (row.variable == extra && (pivotCandidate = row.pickPivot(extra)) != null) {
                        if (sMetrics != null) {
                            ++LinearSystem.sMetrics.pivots;
                        }
                        row.pivot(pivotCandidate);
                    }
                    if (!row.isSimpleDefinition) {
                        row.variable.updateReferencesWithNewDefinition(row);
                    }
                    --this.mNumRows;
                }
            }
            if (!row.hasKeyVariable()) {
                return;
            }
        }
        if (!added) {
            this.addRow(row);
        }
    }

    private final void addRow(ArrayRow row) {
        if (this.mRows[this.mNumRows] != null) {
            this.mCache.arrayRowPool.release(this.mRows[this.mNumRows]);
        }
        this.mRows[this.mNumRows] = row;
        row.variable.definitionId = this.mNumRows++;
        row.variable.updateReferencesWithNewDefinition(row);
    }

    private final int optimize(Row goal, boolean b) {
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.optimize;
        }
        boolean done = false;
        int tries = 0;
        for (int i = 0; i < this.mNumColumns; ++i) {
            this.mAlreadyTestedCandidates[i] = false;
        }
        while (!done) {
            SolverVariable pivotCandidate;
            if (sMetrics != null) {
                ++LinearSystem.sMetrics.iterations;
            }
            if (++tries >= 2 * this.mNumColumns) {
                return tries;
            }
            if (goal.getKey() != null) {
                this.mAlreadyTestedCandidates[goal.getKey().id] = true;
            }
            if ((pivotCandidate = goal.getPivotCandidate(this, this.mAlreadyTestedCandidates)) != null) {
                if (this.mAlreadyTestedCandidates[pivotCandidate.id]) {
                    return tries;
                }
                this.mAlreadyTestedCandidates[pivotCandidate.id] = true;
            }
            if (pivotCandidate != null) {
                float min = Float.MAX_VALUE;
                int pivotRowIndex = -1;
                for (int i = 0; i < this.mNumRows; ++i) {
                    float value;
                    float a_j;
                    ArrayRow current = this.mRows[i];
                    SolverVariable variable = current.variable;
                    if (variable.mType == SolverVariable.Type.UNRESTRICTED || current.isSimpleDefinition || !current.hasVariable(pivotCandidate) || !((a_j = current.variables.get(pivotCandidate)) < 0.0f) || !((value = -current.constantValue / a_j) < min)) continue;
                    min = value;
                    pivotRowIndex = i;
                }
                if (pivotRowIndex > -1) {
                    ArrayRow pivotEquation = this.mRows[pivotRowIndex];
                    pivotEquation.variable.definitionId = -1;
                    if (sMetrics != null) {
                        ++LinearSystem.sMetrics.pivots;
                    }
                    pivotEquation.pivot(pivotCandidate);
                    pivotEquation.variable.definitionId = pivotRowIndex;
                    pivotEquation.variable.updateReferencesWithNewDefinition(pivotEquation);
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        return tries;
    }

    private int enforceBFS(Row goal) throws Exception {
        int tries = 0;
        boolean infeasibleSystem = false;
        for (int i = 0; i < this.mNumRows; ++i) {
            SolverVariable variable = this.mRows[i].variable;
            if (variable.mType == SolverVariable.Type.UNRESTRICTED || !(this.mRows[i].constantValue < 0.0f)) continue;
            infeasibleSystem = true;
            break;
        }
        if (infeasibleSystem) {
            boolean done = false;
            tries = 0;
            while (!done) {
                if (sMetrics != null) {
                    ++LinearSystem.sMetrics.bfs;
                }
                ++tries;
                float min = Float.MAX_VALUE;
                int strength = 0;
                int pivotRowIndex = -1;
                int pivotColumnIndex = -1;
                for (int i = 0; i < this.mNumRows; ++i) {
                    ArrayRow current = this.mRows[i];
                    SolverVariable variable = current.variable;
                    if (variable.mType == SolverVariable.Type.UNRESTRICTED || current.isSimpleDefinition || !(current.constantValue < 0.0f)) continue;
                    for (int j = 1; j < this.mNumColumns; ++j) {
                        SolverVariable candidate = this.mCache.mIndexedVariables[j];
                        float a_j = current.variables.get(candidate);
                        if (a_j <= 0.0f) continue;
                        for (int k = 0; k < 7; ++k) {
                            float value = candidate.strengthVector[k] / a_j;
                            if (!(value < min && k == strength) && k <= strength) continue;
                            min = value;
                            pivotRowIndex = i;
                            pivotColumnIndex = j;
                            strength = k;
                        }
                    }
                }
                if (pivotRowIndex != -1) {
                    ArrayRow pivotEquation = this.mRows[pivotRowIndex];
                    pivotEquation.variable.definitionId = -1;
                    if (sMetrics != null) {
                        ++LinearSystem.sMetrics.pivots;
                    }
                    pivotEquation.pivot(this.mCache.mIndexedVariables[pivotColumnIndex]);
                    pivotEquation.variable.definitionId = pivotRowIndex;
                    pivotEquation.variable.updateReferencesWithNewDefinition(pivotEquation);
                    continue;
                }
                done = true;
            }
        }
        return tries;
    }

    private void computeValues() {
        for (int i = 0; i < this.mNumRows; ++i) {
            ArrayRow row = this.mRows[i];
            row.variable.computedValue = row.constantValue;
        }
    }

    private void displayRows() {
        this.displaySolverVariables();
        String s = "";
        for (int i = 0; i < this.mNumRows; ++i) {
            s = s + this.mRows[i];
            s = s + "\n";
        }
        s = s + this.mGoal + "\n";
        System.out.println(s);
    }

    void displayReadableRows() {
        this.displaySolverVariables();
        String s = " #  ";
        for (int i = 0; i < this.mNumRows; ++i) {
            s = s + this.mRows[i].toReadableString();
            s = s + "\n #  ";
        }
        if (this.mGoal != null) {
            s = s + this.mGoal + "\n";
        }
        System.out.println(s);
    }

    public void displayVariablesReadableRows() {
        this.displaySolverVariables();
        String s = "";
        for (int i = 0; i < this.mNumRows; ++i) {
            if (this.mRows[i].variable.mType != SolverVariable.Type.UNRESTRICTED) continue;
            s = s + this.mRows[i].toReadableString();
            s = s + "\n";
        }
        s = s + this.mGoal + "\n";
        System.out.println(s);
    }

    public int getMemoryUsed() {
        int actualRowSize = 0;
        for (int i = 0; i < this.mNumRows; ++i) {
            if (this.mRows[i] == null) continue;
            actualRowSize += this.mRows[i].sizeInBytes();
        }
        return actualRowSize;
    }

    public int getNumEquations() {
        return this.mNumRows;
    }

    public int getNumVariables() {
        return this.mVariablesID;
    }

    void displaySystemInformations() {
        int count = 0;
        int rowSize = 0;
        for (int i = 0; i < this.TABLE_SIZE; ++i) {
            if (this.mRows[i] == null) continue;
            rowSize += this.mRows[i].sizeInBytes();
        }
        int actualRowSize = 0;
        for (int i = 0; i < this.mNumRows; ++i) {
            if (this.mRows[i] == null) continue;
            actualRowSize += this.mRows[i].sizeInBytes();
        }
        System.out.println("Linear System -> Table size: " + this.TABLE_SIZE + " (" + this.getDisplaySize(this.TABLE_SIZE * this.TABLE_SIZE) + ") -- row sizes: " + this.getDisplaySize(rowSize) + ", actual size: " + this.getDisplaySize(actualRowSize) + " rows: " + this.mNumRows + "/" + this.mMaxRows + " cols: " + this.mNumColumns + "/" + this.mMaxColumns + " " + count + " occupied cells, " + this.getDisplaySize(count));
    }

    private void displaySolverVariables() {
        String s = "Display Rows (" + this.mNumRows + "x" + this.mNumColumns + ")\n";
        System.out.println(s);
    }

    private String getDisplaySize(int n) {
        int mb = n * 4 / 1024 / 1024;
        if (mb > 0) {
            return "" + mb + " Mb";
        }
        int kb = n * 4 / 1024;
        if (kb > 0) {
            return "" + kb + " Kb";
        }
        return "" + n * 4 + " bytes";
    }

    public Cache getCache() {
        return this.mCache;
    }

    private String getDisplayStrength(int strength) {
        if (strength == 1) {
            return "LOW";
        }
        if (strength == 2) {
            return "MEDIUM";
        }
        if (strength == 3) {
            return "HIGH";
        }
        if (strength == 4) {
            return "HIGHEST";
        }
        if (strength == 5) {
            return "EQUALITY";
        }
        if (strength == 6) {
            return "FIXED";
        }
        return "NONE";
    }

    public void addGreaterThan(SolverVariable a, SolverVariable b, int margin, int strength) {
        ArrayRow row = this.createRow();
        SolverVariable slack = this.createSlackVariable();
        slack.strength = 0;
        row.createRowGreaterThan(a, b, slack, margin);
        if (strength != 6) {
            float slackValue = row.variables.get(slack);
            this.addSingleError(row, (int)(-1.0f * slackValue), strength);
        }
        this.addConstraint(row);
    }

    public void addGreaterThan(SolverVariable a, int b) {
        ArrayRow row = this.createRow();
        SolverVariable slack = this.createSlackVariable();
        slack.strength = 0;
        row.createRowGreaterThan(a, b, slack);
        this.addConstraint(row);
    }

    public void addGreaterBarrier(SolverVariable a, SolverVariable b, boolean hasMatchConstraintWidgets) {
        ArrayRow row = this.createRow();
        SolverVariable slack = this.createSlackVariable();
        slack.strength = 0;
        row.createRowGreaterThan(a, b, slack, 0);
        if (hasMatchConstraintWidgets) {
            float slackValue = row.variables.get(slack);
            this.addSingleError(row, (int)(-1.0f * slackValue), 1);
        }
        this.addConstraint(row);
    }

    public void addLowerThan(SolverVariable a, SolverVariable b, int margin, int strength) {
        ArrayRow row = this.createRow();
        SolverVariable slack = this.createSlackVariable();
        slack.strength = 0;
        row.createRowLowerThan(a, b, slack, margin);
        if (strength != 6) {
            float slackValue = row.variables.get(slack);
            this.addSingleError(row, (int)(-1.0f * slackValue), strength);
        }
        this.addConstraint(row);
    }

    public void addLowerBarrier(SolverVariable a, SolverVariable b, boolean hasMatchConstraintWidgets) {
        ArrayRow row = this.createRow();
        SolverVariable slack = this.createSlackVariable();
        slack.strength = 0;
        row.createRowLowerThan(a, b, slack, 0);
        if (hasMatchConstraintWidgets) {
            float slackValue = row.variables.get(slack);
            this.addSingleError(row, (int)(-1.0f * slackValue), 1);
        }
        this.addConstraint(row);
    }

    public void addCentering(SolverVariable a, SolverVariable b, int m1, float bias, SolverVariable c, SolverVariable d, int m2, int strength) {
        ArrayRow row = this.createRow();
        row.createRowCentering(a, b, m1, bias, c, d, m2);
        if (strength != 6) {
            row.addError(this, strength);
        }
        this.addConstraint(row);
    }

    public void addRatio(SolverVariable a, SolverVariable b, SolverVariable c, SolverVariable d, float ratio, int strength) {
        ArrayRow row = this.createRow();
        row.createRowDimensionRatio(a, b, c, d, ratio);
        if (strength != 6) {
            row.addError(this, strength);
        }
        this.addConstraint(row);
    }

    public ArrayRow addEquality(SolverVariable a, SolverVariable b, int margin, int strength) {
        ArrayRow row = this.createRow();
        row.createRowEquals(a, b, margin);
        if (strength != 6) {
            row.addError(this, strength);
        }
        this.addConstraint(row);
        return row;
    }

    public void addEquality(SolverVariable a, int value) {
        int idx = a.definitionId;
        if (a.definitionId != -1) {
            ArrayRow row = this.mRows[idx];
            if (row.isSimpleDefinition) {
                row.constantValue = value;
            } else if (row.variables.currentSize == 0) {
                row.isSimpleDefinition = true;
                row.constantValue = value;
            } else {
                ArrayRow newRow = this.createRow();
                newRow.createRowEquals(a, value);
                this.addConstraint(newRow);
            }
        } else {
            ArrayRow row = this.createRow();
            row.createRowDefinition(a, value);
            this.addConstraint(row);
        }
    }

    public void addEquality(SolverVariable a, int value, int strength) {
        int idx = a.definitionId;
        if (a.definitionId != -1) {
            ArrayRow row = this.mRows[idx];
            if (row.isSimpleDefinition) {
                row.constantValue = value;
            } else {
                ArrayRow newRow = this.createRow();
                newRow.createRowEquals(a, value);
                newRow.addError(this, strength);
                this.addConstraint(newRow);
            }
        } else {
            ArrayRow row = this.createRow();
            row.createRowDefinition(a, value);
            row.addError(this, strength);
            this.addConstraint(row);
        }
    }

    public static ArrayRow createRowEquals(LinearSystem linearSystem, SolverVariable variableA, SolverVariable variableB, int margin, boolean withError) {
        ArrayRow row = linearSystem.createRow();
        row.createRowEquals(variableA, variableB, margin);
        if (withError) {
            linearSystem.addSingleError(row, 1);
        }
        return row;
    }

    public static ArrayRow createRowDimensionPercent(LinearSystem linearSystem, SolverVariable variableA, SolverVariable variableB, SolverVariable variableC, float percent, boolean withError) {
        ArrayRow row = linearSystem.createRow();
        if (withError) {
            linearSystem.addError(row);
        }
        return row.createRowDimensionPercent(variableA, variableB, variableC, percent);
    }

    public static ArrayRow createRowGreaterThan(LinearSystem linearSystem, SolverVariable variableA, SolverVariable variableB, int margin, boolean withError) {
        SolverVariable slack = linearSystem.createSlackVariable();
        ArrayRow row = linearSystem.createRow();
        row.createRowGreaterThan(variableA, variableB, slack, margin);
        if (withError) {
            float slackValue = row.variables.get(slack);
            linearSystem.addSingleError(row, (int)(-1.0f * slackValue));
        }
        return row;
    }

    public static ArrayRow createRowLowerThan(LinearSystem linearSystem, SolverVariable variableA, SolverVariable variableB, int margin, boolean withError) {
        SolverVariable slack = linearSystem.createSlackVariable();
        ArrayRow row = linearSystem.createRow();
        row.createRowLowerThan(variableA, variableB, slack, margin);
        if (withError) {
            float slackValue = row.variables.get(slack);
            linearSystem.addSingleError(row, (int)(-1.0f * slackValue));
        }
        return row;
    }

    public static ArrayRow createRowCentering(LinearSystem linearSystem, SolverVariable variableA, SolverVariable variableB, int marginA, float bias, SolverVariable variableC, SolverVariable variableD, int marginB, boolean withError) {
        ArrayRow row = linearSystem.createRow();
        row.createRowCentering(variableA, variableB, marginA, bias, variableC, variableD, marginB);
        if (withError) {
            row.addError(linearSystem, 4);
        }
        return row;
    }

    public void addCenterPoint(ConstraintWidget widget, ConstraintWidget target, float angle, int radius) {
        SolverVariable Al = this.createObjectVariable(widget.getAnchor(ConstraintAnchor.Type.LEFT));
        SolverVariable At = this.createObjectVariable(widget.getAnchor(ConstraintAnchor.Type.TOP));
        SolverVariable Ar = this.createObjectVariable(widget.getAnchor(ConstraintAnchor.Type.RIGHT));
        SolverVariable Ab = this.createObjectVariable(widget.getAnchor(ConstraintAnchor.Type.BOTTOM));
        SolverVariable Bl = this.createObjectVariable(target.getAnchor(ConstraintAnchor.Type.LEFT));
        SolverVariable Bt = this.createObjectVariable(target.getAnchor(ConstraintAnchor.Type.TOP));
        SolverVariable Br = this.createObjectVariable(target.getAnchor(ConstraintAnchor.Type.RIGHT));
        SolverVariable Bb = this.createObjectVariable(target.getAnchor(ConstraintAnchor.Type.BOTTOM));
        ArrayRow row = this.createRow();
        float angleComponent = (float)(Math.sin(angle) * (double)radius);
        row.createRowWithAngle(At, Ab, Bt, Bb, angleComponent);
        this.addConstraint(row);
        row = this.createRow();
        angleComponent = (float)(Math.cos(angle) * (double)radius);
        row.createRowWithAngle(Al, Ar, Bl, Br, angleComponent);
        this.addConstraint(row);
    }

    static interface Row {
        public SolverVariable getPivotCandidate(LinearSystem var1, boolean[] var2);

        public void clear();

        public void initFromRow(Row var1);

        public void addError(SolverVariable var1);

        public SolverVariable getKey();

        public boolean isEmpty();
    }
}

