/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.ConstraintWidgetGroup;
import android.support.constraint.solver.widgets.HelperWidget;
import android.support.constraint.solver.widgets.ResolutionAnchor;
import android.support.constraint.solver.widgets.ResolutionNode;
import java.util.ArrayList;
import java.util.List;

public class Analyzer {
    private Analyzer() {
    }

    public static void determineGroups(ConstraintWidgetContainer layoutWidget) {
        if ((layoutWidget.getOptimizationLevel() & 0x20) != 32) {
            Analyzer.singleGroup(layoutWidget);
            return;
        }
        layoutWidget.mSkipSolver = true;
        layoutWidget.mGroupsWrapOptimized = false;
        layoutWidget.mHorizontalWrapOptimized = false;
        layoutWidget.mVerticalWrapOptimized = false;
        ArrayList widgets = layoutWidget.mChildren;
        List<ConstraintWidgetGroup> widgetGroups = layoutWidget.mWidgetGroups;
        boolean horizontalWrapContent = layoutWidget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        boolean verticalWrapContent = layoutWidget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        boolean hasWrapContent = horizontalWrapContent || verticalWrapContent;
        widgetGroups.clear();
        for (ConstraintWidget widget : widgets) {
            widget.mBelongingGroup = null;
            widget.mTop.getResolutionNode().dependents.clear();
            widget.mBottom.getResolutionNode().dependents.clear();
            widget.mLeft.getResolutionNode().dependents.clear();
            widget.mRight.getResolutionNode().dependents.clear();
            widget.mBaseline.getResolutionNode().dependents.clear();
            widget.mCenter.getResolutionNode().dependents.clear();
        }
        for (ConstraintWidget widget : widgets) {
            if (widget.mBelongingGroup != null || Analyzer.determineGroups(widget, widgetGroups, hasWrapContent)) continue;
            Analyzer.singleGroup(layoutWidget);
            layoutWidget.mSkipSolver = false;
            return;
        }
        if (!layoutWidget.mSkipSolver) {
            return;
        }
        int measuredWidth = 0;
        int measuredHeight = 0;
        for (ConstraintWidgetGroup group : widgetGroups) {
            if (horizontalWrapContent || !hasWrapContent) {
                measuredWidth = Math.max(measuredWidth, Analyzer.getMaxDimension(group, 0));
            }
            if (!verticalWrapContent && hasWrapContent) continue;
            measuredHeight = Math.max(measuredHeight, Analyzer.getMaxDimension(group, 1));
        }
        if (horizontalWrapContent) {
            layoutWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
            layoutWidget.setWidth(measuredWidth);
            layoutWidget.mGroupsWrapOptimized = true;
            layoutWidget.mHorizontalWrapOptimized = true;
            layoutWidget.mWrapFixedWidth = measuredWidth;
        }
        if (verticalWrapContent) {
            layoutWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
            layoutWidget.setHeight(measuredHeight);
            layoutWidget.mGroupsWrapOptimized = true;
            layoutWidget.mVerticalWrapOptimized = true;
            layoutWidget.mWrapFixedHeight = measuredHeight;
        }
        if (verticalWrapContent && horizontalWrapContent || !hasWrapContent) {
            layoutWidget.mSkipSolver = true;
            Analyzer.setPosition(widgetGroups, 0, measuredWidth);
            Analyzer.setPosition(widgetGroups, 1, measuredHeight);
        } else {
            layoutWidget.mSkipSolver = false;
        }
    }

    private static boolean determineGroups(ConstraintWidget widget, List<ConstraintWidgetGroup> widgetGroups, boolean hasWrapContent) {
        ConstraintWidgetGroup traverseList = new ConstraintWidgetGroup(new ArrayList<ConstraintWidget>());
        widgetGroups.add(traverseList);
        return Analyzer.traverse(widget, traverseList, widgetGroups, hasWrapContent);
    }

    private static boolean traverse(ConstraintWidget widget, ConstraintWidgetGroup upperGroup, List<ConstraintWidgetGroup> widgetGroups, boolean hasWrapContent) {
        if (widget == null) {
            return true;
        }
        ConstraintWidgetContainer layoutWidget = (ConstraintWidgetContainer)widget.getParent();
        if (widget.mBelongingGroup == null) {
            upperGroup.mConstrainedGroup.add(widget);
            widget.mBelongingGroup = upperGroup;
            if (widget.mLeft.mTarget == null && widget.mRight.mTarget == null && widget.mTop.mTarget == null && widget.mBottom.mTarget == null && widget.mBaseline.mTarget == null && widget.mCenter.mTarget == null) {
                layoutWidget.mSkipSolver = false;
                if (hasWrapContent) {
                    return false;
                }
            }
            if (widget.mTop.mTarget != null && widget.mBottom.mTarget != null) {
                layoutWidget.mSkipSolver = false;
                if (hasWrapContent) {
                    return false;
                }
            }
            if (widget.mLeft.mTarget != null && widget.mRight.mTarget != null) {
                layoutWidget.mSkipSolver = false;
                if (hasWrapContent) {
                    return false;
                }
            }
            if (widget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT ^ widget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mDimensionRatio != 0.0f) {
                int length = 0;
                if (widget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    length = (int)((float)widget.getHeight() / widget.mDimensionRatio);
                    widget.setWidth(length);
                } else if (widget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    length = (int)((float)widget.getWidth() / widget.mDimensionRatio);
                    widget.setHeight(length);
                }
            } else if (widget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || widget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                layoutWidget.mSkipSolver = false;
                if (hasWrapContent) {
                    return false;
                }
            }
            if (widget.mLeft.mTarget == null && widget.mRight.mTarget == null || widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner == widget.mParent || widget.mRight.mTarget != null && widget.mRight.mTarget.mOwner == widget.mParent) {
                upperGroup.mStartHorizontalWidgets.add(widget);
            }
            if (widget.mTop.mTarget == null && widget.mBottom.mTarget == null && widget.mBaseline.mTarget == null || widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner == widget.mParent || widget.mBottom.mTarget != null && widget.mBottom.mTarget.mOwner == widget.mParent) {
                upperGroup.mStartVerticalWidgets.add(widget);
            }
        } else {
            if (widget.mBelongingGroup != upperGroup) {
                upperGroup.mConstrainedGroup.addAll(widget.mBelongingGroup.mConstrainedGroup);
                upperGroup.mStartHorizontalWidgets.addAll(widget.mBelongingGroup.mStartHorizontalWidgets);
                upperGroup.mStartVerticalWidgets.addAll(widget.mBelongingGroup.mStartVerticalWidgets);
                widgetGroups.remove(widget.mBelongingGroup);
                for (ConstraintWidget auxWidget : widget.mBelongingGroup.mConstrainedGroup) {
                    auxWidget.mBelongingGroup = upperGroup;
                }
            }
            return true;
        }
        if (widget instanceof HelperWidget) {
            layoutWidget.mSkipSolver = false;
            if (hasWrapContent) {
                return false;
            }
            HelperWidget hWidget = (HelperWidget)widget;
            for (int widgetsCount = 0; widgetsCount < hWidget.mWidgetsCount; ++widgetsCount) {
                if (Analyzer.traverse(hWidget.mWidgets[widgetsCount], upperGroup, widgetGroups, hasWrapContent)) continue;
                return false;
            }
        }
        for (ConstraintAnchor anchor : widget.mListAnchors) {
            if (anchor.mTarget == null || anchor.mTarget.mOwner == widget.getParent()) continue;
            if (anchor.mType == ConstraintAnchor.Type.CENTER) {
                layoutWidget.mSkipSolver = false;
                if (hasWrapContent) {
                    return false;
                }
            } else {
                Analyzer.setConnection(anchor);
            }
            if (Analyzer.traverse(anchor.mTarget.mOwner, upperGroup, widgetGroups, hasWrapContent)) continue;
            return false;
        }
        return true;
    }

    private static int getMaxDimension(ConstraintWidgetGroup group, int orientation) {
        int dimension = 0;
        for (ConstraintWidget widget : group.getStartWidgets(orientation)) {
            boolean topLeftFlow = widget.mListAnchors[orientation * 2 + 1].mTarget == null;
            dimension = Math.max(dimension, Analyzer.getMaxDimensionTraversal(widget, orientation, topLeftFlow, 0));
        }
        group.mGroupDimensions[orientation] = dimension;
        return dimension;
    }

    private static int getMaxDimensionTraversal(ConstraintWidget widget, int orientation, boolean topLeftFlow, int depth) {
        ResolutionAnchor anchor;
        int flow;
        int endOffset;
        int startOffset;
        int baselinePostDistance;
        int baselinePreDistance;
        boolean hasBaseline;
        int dimension = 0;
        int dimensionPre = 0;
        int dimensionPost = 0;
        boolean bl = hasBaseline = widget.mBaseline.mTarget != null && orientation == 1;
        if (topLeftFlow) {
            baselinePreDistance = widget.getBaselineDistance();
            baselinePostDistance = widget.getHeight() - widget.getBaselineDistance();
            startOffset = orientation * 2;
            endOffset = startOffset + 1;
        } else {
            baselinePreDistance = widget.getHeight() - widget.getBaselineDistance();
            baselinePostDistance = widget.getBaselineDistance();
            endOffset = orientation * 2;
            startOffset = endOffset + 1;
        }
        if (widget.mListAnchors[endOffset].mTarget != null && widget.mListAnchors[startOffset].mTarget == null) {
            flow = -1;
            int aux = startOffset;
            startOffset = endOffset;
            endOffset = aux;
        } else {
            flow = 1;
        }
        if (hasBaseline) {
            depth -= baselinePreDistance;
        }
        dimension = widget.mListAnchors[startOffset].getMargin() * flow;
        int downDepth = dimension + depth;
        int postTemp = (orientation == 0 ? widget.getWidth() : widget.getHeight()) * flow;
        for (Object targetNode : widget.mListAnchors[startOffset].getResolutionNode().dependents) {
            anchor = (ResolutionAnchor)targetNode;
            dimensionPre = Math.max(dimensionPre, Analyzer.getMaxDimensionTraversal(anchor.myAnchor.mOwner, orientation, topLeftFlow, downDepth));
        }
        for (Object targetNode : widget.mListAnchors[endOffset].getResolutionNode().dependents) {
            anchor = (ResolutionAnchor)targetNode;
            dimensionPost = Math.max(dimensionPost, Analyzer.getMaxDimensionTraversal(anchor.myAnchor.mOwner, orientation, topLeftFlow, postTemp + downDepth));
        }
        if (hasBaseline) {
            dimensionPre -= baselinePreDistance;
            dimensionPost += baselinePostDistance;
        } else {
            dimensionPost += (orientation == 0 ? widget.getWidth() : widget.getHeight()) * flow;
        }
        int dimensionBaseline = 0;
        if (orientation == 1) {
            for (ResolutionNode targetNode : widget.mBaseline.getResolutionNode().dependents) {
                ResolutionAnchor anchor2 = (ResolutionAnchor)targetNode;
                if (flow == 1) {
                    dimensionBaseline = Math.max(dimensionBaseline, Analyzer.getMaxDimensionTraversal(anchor2.myAnchor.mOwner, orientation, topLeftFlow, baselinePreDistance + downDepth));
                    continue;
                }
                dimensionBaseline = Math.max(dimensionBaseline, Analyzer.getMaxDimensionTraversal(anchor2.myAnchor.mOwner, orientation, topLeftFlow, baselinePostDistance * flow + downDepth));
            }
            if (widget.mBaseline.getResolutionNode().dependents.size() > 0 && !hasBaseline) {
                dimensionBaseline = flow == 1 ? (dimensionBaseline += baselinePreDistance) : (dimensionBaseline -= baselinePostDistance);
            }
        }
        dimension += Math.max(dimensionPre, Math.max(dimensionPost, dimensionBaseline));
        int leftTop = depth + widget.mListAnchors[startOffset].getMargin() * flow;
        int end = leftTop + postTemp;
        if (flow == -1) {
            int aux = end;
            end = leftTop;
            leftTop = aux;
        }
        if (topLeftFlow) {
            widget.setFrame(leftTop, end, orientation);
        } else if (orientation == 0) {
            widget.mBelongingGroup.mWidgetsToSetHorizontal.add(widget);
            widget.mRelX = leftTop;
        } else if (orientation == 1) {
            widget.mBelongingGroup.mWidgetsToSetVertical.add(widget);
            widget.mRelY = leftTop;
        }
        return dimension;
    }

    private static void setConnection(ConstraintAnchor originAnchor) {
        ResolutionAnchor originNode = originAnchor.getResolutionNode();
        if (originAnchor.mTarget != null && originAnchor.mTarget.mTarget != originAnchor) {
            originAnchor.mTarget.getResolutionNode().addDependent(originNode);
        }
    }

    private static void singleGroup(ConstraintWidgetContainer layoutWidget) {
        layoutWidget.mWidgetGroups.clear();
        layoutWidget.mWidgetGroups.add(0, new ConstraintWidgetGroup(layoutWidget.mChildren));
    }

    public static void setPosition(List<ConstraintWidgetGroup> groups, int orientation, int containerLength) {
        for (ConstraintWidgetGroup group : groups) {
            for (ConstraintWidget startWidget : group.getWidgetsToSet(orientation)) {
                Analyzer.traverseSetPosition(startWidget, orientation, containerLength);
            }
        }
    }

    private static void traverseSetPosition(ConstraintWidget widget, int orientation, int containerLength) {
        if (orientation == 0) {
            int start = containerLength - (widget.mRelX + widget.getWidth());
            int end = start + widget.getWidth();
            widget.setHorizontalDimension(start, end);
        } else if (orientation == 1) {
            int start = containerLength - (widget.mRelY + widget.getHeight());
            int end = start + widget.getHeight();
            widget.setVerticalDimension(start, end);
        }
    }
}

