/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets.analyzer;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.Helper;
import android.support.constraint.solver.widgets.analyzer.Dependency;
import android.support.constraint.solver.widgets.analyzer.DependencyNode;
import android.support.constraint.solver.widgets.analyzer.DimensionDependency;
import android.support.constraint.solver.widgets.analyzer.WidgetRun;

public class HorizontalWidgetRun
extends WidgetRun {
    private static int[] tempDimensions = new int[2];

    public HorizontalWidgetRun(ConstraintWidget widget) {
        super(widget);
        this.start.type = DependencyNode.Type.LEFT;
        this.end.type = DependencyNode.Type.RIGHT;
        this.orientation = 0;
    }

    public String toString() {
        return "HorizontalRun " + this.widget.getDebugName();
    }

    @Override
    void clear() {
        this.runGroup = null;
        this.start.clear();
        this.end.clear();
        this.dimension.clear();
        this.resolved = false;
    }

    @Override
    void reset() {
        this.resolved = false;
        this.start.clear();
        this.start.resolved = false;
        this.end.clear();
        this.end.resolved = false;
        this.dimension.resolved = false;
    }

    @Override
    boolean supportsWrapComputation() {
        if (this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            return this.widget.mMatchConstraintDefaultWidth == 0;
        }
        return true;
    }

    @Override
    void apply() {
        DependencyNode left;
        DependencyNode target;
        DependencyNode startTarget;
        ConstraintWidget parent;
        if (this.widget.measured) {
            this.dimension.resolve(this.widget.getWidth());
        }
        if (!this.dimension.resolved) {
            this.dimensionBehavior = this.widget.getHorizontalDimensionBehaviour();
            if (this.dimensionBehavior != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                if (this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_PARENT && ((parent = this.widget.getParent()) != null && parent.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED || parent.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_PARENT)) {
                    int resolvedDimension = parent.getWidth() - this.widget.mLeft.getMargin() - this.widget.mRight.getMargin();
                    this.addTarget(this.start, parent.horizontalRun.start, this.widget.mLeft.getMargin());
                    this.addTarget(this.end, parent.horizontalRun.end, -this.widget.mRight.getMargin());
                    this.dimension.resolve(resolvedDimension);
                    return;
                }
                if (this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.FIXED) {
                    this.dimension.resolve(this.widget.getWidth());
                }
            }
        } else if (this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_PARENT && ((parent = this.widget.getParent()) != null && parent.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED || parent.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_PARENT)) {
            this.addTarget(this.start, parent.horizontalRun.start, this.widget.mLeft.getMargin());
            this.addTarget(this.end, parent.horizontalRun.end, -this.widget.mRight.getMargin());
            return;
        }
        if (this.dimension.resolved && this.widget.measured) {
            if (this.widget.mListAnchors[0].mTarget != null && this.widget.mListAnchors[1].mTarget != null) {
                if (this.widget.isInHorizontalChain()) {
                    this.start.margin = this.widget.mListAnchors[0].getMargin();
                    this.end.margin = -this.widget.mListAnchors[1].getMargin();
                } else {
                    DependencyNode endTarget;
                    startTarget = this.getTarget(this.widget.mListAnchors[0]);
                    if (startTarget != null) {
                        this.addTarget(this.start, startTarget, this.widget.mListAnchors[0].getMargin());
                    }
                    if ((endTarget = this.getTarget(this.widget.mListAnchors[1])) != null) {
                        this.addTarget(this.end, endTarget, -this.widget.mListAnchors[1].getMargin());
                    }
                    this.start.delegateToWidgetRun = true;
                    this.end.delegateToWidgetRun = true;
                }
            } else if (this.widget.mListAnchors[0].mTarget != null) {
                target = this.getTarget(this.widget.mListAnchors[0]);
                if (target != null) {
                    this.addTarget(this.start, target, this.widget.mListAnchors[0].getMargin());
                    this.addTarget(this.end, this.start, this.dimension.value);
                }
            } else if (this.widget.mListAnchors[1].mTarget != null) {
                target = this.getTarget(this.widget.mListAnchors[1]);
                if (target != null) {
                    this.addTarget(this.end, target, -this.widget.mListAnchors[1].getMargin());
                    this.addTarget(this.start, this.end, -this.dimension.value);
                }
            } else if (!(this.widget instanceof Helper) && this.widget.getParent() != null && this.widget.getAnchor((ConstraintAnchor.Type)ConstraintAnchor.Type.CENTER).mTarget == null) {
                left = this.widget.getParent().horizontalRun.start;
                this.addTarget(this.start, left, this.widget.getX());
                this.addTarget(this.end, this.start, this.dimension.value);
            }
        } else {
            if (this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                switch (this.widget.mMatchConstraintDefaultWidth) {
                    case 3: {
                        if (this.widget.mMatchConstraintDefaultHeight == 3) {
                            this.start.updateDelegate = this;
                            this.end.updateDelegate = this;
                            this.widget.verticalRun.start.updateDelegate = this;
                            this.widget.verticalRun.end.updateDelegate = this;
                            this.dimension.updateDelegate = this;
                            if (this.widget.isInVerticalChain()) {
                                this.dimension.targets.add(this.widget.verticalRun.dimension);
                                this.widget.verticalRun.dimension.dependencies.add(this.dimension);
                                this.widget.verticalRun.dimension.updateDelegate = this;
                                this.dimension.targets.add(this.widget.verticalRun.start);
                                this.dimension.targets.add(this.widget.verticalRun.end);
                                this.widget.verticalRun.start.dependencies.add(this.dimension);
                                this.widget.verticalRun.end.dependencies.add(this.dimension);
                                break;
                            }
                            if (this.widget.isInHorizontalChain()) {
                                this.widget.verticalRun.dimension.targets.add(this.dimension);
                                this.dimension.dependencies.add(this.widget.verticalRun.dimension);
                                break;
                            }
                            this.widget.verticalRun.dimension.targets.add(this.dimension);
                            break;
                        }
                        DimensionDependency targetDimension = this.widget.verticalRun.dimension;
                        this.dimension.targets.add(targetDimension);
                        targetDimension.dependencies.add(this.dimension);
                        this.widget.verticalRun.start.dependencies.add(this.dimension);
                        this.widget.verticalRun.end.dependencies.add(this.dimension);
                        this.dimension.delegateToWidgetRun = true;
                        this.dimension.dependencies.add(this.start);
                        this.dimension.dependencies.add(this.end);
                        this.start.targets.add(this.dimension);
                        this.end.targets.add(this.dimension);
                        break;
                    }
                    case 2: {
                        parent = this.widget.getParent();
                        if (parent == null) break;
                        DimensionDependency targetDimension = parent.verticalRun.dimension;
                        this.dimension.targets.add(targetDimension);
                        targetDimension.dependencies.add(this.dimension);
                        this.dimension.delegateToWidgetRun = true;
                        this.dimension.dependencies.add(this.start);
                        this.dimension.dependencies.add(this.end);
                        break;
                    }
                }
            }
            if (this.widget.mListAnchors[0].mTarget != null && this.widget.mListAnchors[1].mTarget != null) {
                if (this.widget.isInHorizontalChain()) {
                    this.start.margin = this.widget.mListAnchors[0].getMargin();
                    this.end.margin = -this.widget.mListAnchors[1].getMargin();
                } else {
                    startTarget = this.getTarget(this.widget.mListAnchors[0]);
                    DependencyNode endTarget = this.getTarget(this.widget.mListAnchors[1]);
                    startTarget.addDependency(this);
                    endTarget.addDependency(this);
                    this.mRunType = WidgetRun.RunType.CENTER;
                }
            } else if (this.widget.mListAnchors[0].mTarget != null) {
                target = this.getTarget(this.widget.mListAnchors[0]);
                if (target != null) {
                    this.addTarget(this.start, target, this.widget.mListAnchors[0].getMargin());
                    this.addTarget(this.end, this.start, 1, this.dimension);
                }
            } else if (this.widget.mListAnchors[1].mTarget != null) {
                target = this.getTarget(this.widget.mListAnchors[1]);
                if (target != null) {
                    this.addTarget(this.end, target, -this.widget.mListAnchors[1].getMargin());
                    this.addTarget(this.start, this.end, -1, this.dimension);
                }
            } else if (!(this.widget instanceof Helper) && this.widget.getParent() != null) {
                left = this.widget.getParent().horizontalRun.start;
                this.addTarget(this.start, left, this.widget.getX());
                this.addTarget(this.end, this.start, 1, this.dimension);
            }
        }
    }

    private void computeInsetRatio(int[] dimensions, int x1, int x2, int y1, int y2, float ratio, int side) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        switch (side) {
            case -1: {
                int candidateX1 = (int)(0.5f + (float)dy * ratio);
                int candidateY1 = dy;
                int candidateX2 = dx;
                int candidateY2 = (int)(0.5f + (float)dx / ratio);
                if (candidateX1 <= dx && candidateY1 <= dy) {
                    dimensions[0] = candidateX1;
                    dimensions[1] = candidateY1;
                    break;
                }
                if (candidateX2 > dx || candidateY2 > dy) break;
                dimensions[0] = candidateX2;
                dimensions[1] = candidateY2;
                break;
            }
            case 0: {
                int horizontalSide;
                dimensions[0] = horizontalSide = (int)(0.5f + (float)dy * ratio);
                dimensions[1] = dy;
                break;
            }
            case 1: {
                int verticalSide = (int)(0.5f + (float)dx * ratio);
                dimensions[0] = dx;
                dimensions[1] = verticalSide;
            }
        }
    }

    @Override
    public void update(Dependency dependency) {
        int endPos;
        int startPos;
        DependencyNode endTarget;
        DependencyNode startTarget;
        switch (this.mRunType) {
            case START: {
                this.updateRunStart(dependency);
                break;
            }
            case END: {
                this.updateRunEnd(dependency);
                break;
            }
            case CENTER: {
                this.updateRunCenter(dependency, this.widget.mLeft, this.widget.mRight, 0);
                return;
            }
        }
        if (!this.dimension.resolved && this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            switch (this.widget.mMatchConstraintDefaultWidth) {
                case 3: {
                    if (this.widget.mMatchConstraintDefaultHeight == 0 || this.widget.mMatchConstraintDefaultHeight == 3) {
                        float ratio;
                        DependencyNode secondStart = this.widget.verticalRun.start;
                        DependencyNode secondEnd = this.widget.verticalRun.end;
                        boolean s1 = this.widget.mLeft.mTarget != null;
                        boolean s2 = this.widget.mTop.mTarget != null;
                        boolean e1 = this.widget.mRight.mTarget != null;
                        boolean e2 = this.widget.mBottom.mTarget != null;
                        int definedSide = this.widget.getDimensionRatioSide();
                        if (s1 && s2 && e1 && e2) {
                            int y2;
                            int y1;
                            int x2;
                            int x1;
                            ratio = this.widget.getDimensionRatio();
                            if (secondStart.resolved && secondEnd.resolved) {
                                if (!this.start.readyToSolve || !this.end.readyToSolve) {
                                    return;
                                }
                                int x12 = this.start.targets.get((int)0).value + this.start.margin;
                                int x22 = this.end.targets.get((int)0).value - this.end.margin;
                                int y12 = secondStart.value + secondStart.margin;
                                int y22 = secondEnd.value - secondEnd.margin;
                                this.computeInsetRatio(tempDimensions, x12, x22, y12, y22, ratio, definedSide);
                                this.dimension.resolve(tempDimensions[0]);
                                this.widget.verticalRun.dimension.resolve(tempDimensions[1]);
                                return;
                            }
                            if (this.start.resolved && this.end.resolved) {
                                if (!secondStart.readyToSolve || !secondEnd.readyToSolve) {
                                    return;
                                }
                                x1 = this.start.value + this.start.margin;
                                x2 = this.end.value - this.end.margin;
                                y1 = secondStart.targets.get((int)0).value + secondStart.margin;
                                y2 = secondEnd.targets.get((int)0).value - secondEnd.margin;
                                this.computeInsetRatio(tempDimensions, x1, x2, y1, y2, ratio, definedSide);
                                this.dimension.resolve(tempDimensions[0]);
                                this.widget.verticalRun.dimension.resolve(tempDimensions[1]);
                            }
                            if (!(this.start.readyToSolve && this.end.readyToSolve && secondStart.readyToSolve && secondEnd.readyToSolve)) {
                                return;
                            }
                            x1 = this.start.targets.get((int)0).value + this.start.margin;
                            x2 = this.end.targets.get((int)0).value - this.end.margin;
                            y1 = secondStart.targets.get((int)0).value + secondStart.margin;
                            y2 = secondEnd.targets.get((int)0).value - secondEnd.margin;
                            this.computeInsetRatio(tempDimensions, x1, x2, y1, y2, ratio, definedSide);
                            this.dimension.resolve(tempDimensions[0]);
                            this.widget.verticalRun.dimension.resolve(tempDimensions[1]);
                            break;
                        }
                        if (s1 && e1) {
                            if (!this.start.readyToSolve || !this.end.readyToSolve) {
                                return;
                            }
                            ratio = this.widget.getDimensionRatio();
                            int x1 = this.start.targets.get((int)0).value + this.start.margin;
                            int x2 = this.end.targets.get((int)0).value - this.end.margin;
                            switch (definedSide) {
                                case -1: 
                                case 0: {
                                    int dx = x2 - x1;
                                    int ldx = this.getLimitedDimension(dx, 0);
                                    int dy = (int)(0.5f + (float)ldx * ratio);
                                    int ldy = this.getLimitedDimension(dy, 1);
                                    if (dy != ldy) {
                                        ldx = (int)(0.5f + (float)ldy / ratio);
                                    }
                                    this.dimension.resolve(ldx);
                                    this.widget.verticalRun.dimension.resolve(ldy);
                                    break;
                                }
                                case 1: {
                                    int dx = x2 - x1;
                                    int ldx = this.getLimitedDimension(dx, 0);
                                    int dy = (int)(0.5f + (float)ldx / ratio);
                                    int ldy = this.getLimitedDimension(dy, 1);
                                    if (dy != ldy) {
                                        ldx = (int)(0.5f + (float)ldy * ratio);
                                    }
                                    this.dimension.resolve(ldx);
                                    this.widget.verticalRun.dimension.resolve(ldy);
                                }
                            }
                            break;
                        }
                        if (s2 && e2) {
                            if (!secondStart.readyToSolve || !secondEnd.readyToSolve) {
                                return;
                            }
                            ratio = this.widget.getDimensionRatio();
                            int y1 = secondStart.targets.get((int)0).value + secondStart.margin;
                            int y2 = secondEnd.targets.get((int)0).value - secondEnd.margin;
                            switch (definedSide) {
                                case -1: 
                                case 1: {
                                    int dy = y2 - y1;
                                    int ldy = this.getLimitedDimension(dy, 1);
                                    int dx = (int)(0.5f + (float)ldy / ratio);
                                    int ldx = this.getLimitedDimension(dx, 0);
                                    if (dx != ldx) {
                                        ldy = (int)(0.5f + (float)ldx * ratio);
                                    }
                                    this.dimension.resolve(ldx);
                                    this.widget.verticalRun.dimension.resolve(ldy);
                                    break;
                                }
                                case 0: {
                                    int dy = y2 - y1;
                                    int ldy = this.getLimitedDimension(dy, 1);
                                    int dx = (int)(0.5f + (float)ldy * ratio);
                                    int ldx = this.getLimitedDimension(dx, 0);
                                    if (dx != ldx) {
                                        ldy = (int)(0.5f + (float)ldx / ratio);
                                    }
                                    this.dimension.resolve(ldx);
                                    this.widget.verticalRun.dimension.resolve(ldy);
                                }
                            }
                        }
                        break;
                    }
                    int size = 0;
                    int ratioSide = this.widget.getDimensionRatioSide();
                    switch (ratioSide) {
                        case 0: {
                            size = (int)(0.5f + (float)this.widget.verticalRun.dimension.value / this.widget.getDimensionRatio());
                            break;
                        }
                        case 1: {
                            size = (int)(0.5f + (float)this.widget.verticalRun.dimension.value * this.widget.getDimensionRatio());
                            break;
                        }
                        case -1: {
                            size = (int)(0.5f + (float)this.widget.verticalRun.dimension.value * this.widget.getDimensionRatio());
                        }
                    }
                    this.dimension.resolve(size);
                    break;
                }
                case 2: {
                    ConstraintWidget parent = this.widget.getParent();
                    if (parent == null || !parent.horizontalRun.dimension.resolved) break;
                    float percent = this.widget.mMatchConstraintPercentWidth;
                    int targetDimensionValue = parent.horizontalRun.dimension.value;
                    int size = (int)(0.5f + (float)targetDimensionValue * percent);
                    this.dimension.resolve(size);
                }
            }
        }
        if (!this.start.readyToSolve || !this.end.readyToSolve) {
            return;
        }
        if (this.start.resolved && this.end.resolved && this.dimension.resolved) {
            return;
        }
        if (!this.dimension.resolved && this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.widget.mMatchConstraintDefaultWidth == 0 && !this.widget.isInHorizontalChain()) {
            startTarget = this.start.targets.get(0);
            endTarget = this.end.targets.get(0);
            startPos = startTarget.value + this.start.margin;
            endPos = endTarget.value + this.end.margin;
            int distance = endPos - startPos;
            this.start.resolve(startPos);
            this.end.resolve(endPos);
            this.dimension.resolve(distance);
            return;
        }
        if (!this.dimension.resolved && this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.matchConstraintsType == 1 && this.start.targets.size() > 0 && this.end.targets.size() > 0) {
            startTarget = this.start.targets.get(0);
            endTarget = this.end.targets.get(0);
            startPos = startTarget.value + this.start.margin;
            endPos = endTarget.value + this.end.margin;
            int availableSpace = endPos - startPos;
            int value = Math.min(availableSpace, this.dimension.wrapValue);
            int max = this.widget.mMatchConstraintMaxWidth;
            int min = this.widget.mMatchConstraintMinWidth;
            value = Math.max(min, value);
            if (max > 0) {
                value = Math.min(max, value);
            }
            this.dimension.resolve(value);
        }
        if (!this.dimension.resolved) {
            return;
        }
        startTarget = this.start.targets.get(0);
        endTarget = this.end.targets.get(0);
        startPos = startTarget.value + this.start.margin;
        endPos = endTarget.value + this.end.margin;
        float bias = this.widget.getHorizontalBiasPercent();
        if (startTarget == endTarget) {
            startPos = startTarget.value;
            endPos = endTarget.value;
            bias = 0.5f;
        }
        int distance = endPos - startPos - this.dimension.value;
        this.start.resolve((int)(0.5f + (float)startPos + (float)distance * bias));
        this.end.resolve(this.start.value + this.dimension.value);
    }

    @Override
    public void applyToWidget() {
        if (this.start.resolved) {
            this.widget.setX(this.start.value);
        }
    }
}

