/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.constraint.ConstraintAttribute;
import android.support.constraint.R;
import android.support.constraint.motion.Key;
import android.support.constraint.motion.SplineSet;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import java.util.HashMap;
import java.util.HashSet;

public class KeyAttributes
extends Key {
    static final String NAME = "KeyAttribute";
    private static final String TAG = "KeyAttribute";
    private String mTransitionEasing;
    private int mCurveFit = -1;
    private boolean mVisibility = false;
    private float mAlpha = Float.NaN;
    private float mElevation = Float.NaN;
    private float mRotation = Float.NaN;
    private float mRotationX = Float.NaN;
    private float mRotationY = Float.NaN;
    private float mTransitionPathRotate = Float.NaN;
    private float mScaleX = Float.NaN;
    private float mScaleY = Float.NaN;
    private float mTranslationX = Float.NaN;
    private float mTranslationY = Float.NaN;
    private float mTranslationZ = Float.NaN;
    private float mProgress = Float.NaN;
    public static final int KEY_TYPE = 1;

    public KeyAttributes() {
        this.mType = 1;
        this.mCustomConstraints = new HashMap();
    }

    @Override
    public void load(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.KeyAttribute);
        Loader.read(this, a);
    }

    int getCurveFit() {
        return this.mCurveFit;
    }

    @Override
    public void getAttributeNames(HashSet<String> attributes) {
        if (!Float.isNaN(this.mAlpha)) {
            attributes.add("alpha");
        }
        if (!Float.isNaN(this.mElevation)) {
            attributes.add("elevation");
        }
        if (!Float.isNaN(this.mRotation)) {
            attributes.add("rotation");
        }
        if (!Float.isNaN(this.mRotationX)) {
            attributes.add("rotationX");
        }
        if (!Float.isNaN(this.mRotationY)) {
            attributes.add("rotationY");
        }
        if (!Float.isNaN(this.mTranslationX)) {
            attributes.add("translationX");
        }
        if (!Float.isNaN(this.mTranslationY)) {
            attributes.add("translationY");
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            attributes.add("translationZ");
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            attributes.add("transitionPathRotate");
        }
        if (!Float.isNaN(this.mScaleX)) {
            attributes.add("scaleX");
        }
        if (!Float.isNaN(this.mScaleX)) {
            attributes.add("scaleY");
        }
        if (!Float.isNaN(this.mProgress)) {
            attributes.add("progress");
        }
        if (this.mCustomConstraints.size() > 0) {
            for (String s : this.mCustomConstraints.keySet()) {
                attributes.add("CUSTOM," + s);
            }
        }
    }

    @Override
    public void setInterpolation(HashMap<String, Integer> interpolation) {
        if (this.mCurveFit == -1) {
            return;
        }
        if (!Float.isNaN(this.mAlpha)) {
            interpolation.put("alpha", this.mCurveFit);
        }
        if (!Float.isNaN(this.mElevation)) {
            interpolation.put("elevation", this.mCurveFit);
        }
        if (!Float.isNaN(this.mRotation)) {
            interpolation.put("rotation", this.mCurveFit);
        }
        if (!Float.isNaN(this.mRotationX)) {
            interpolation.put("rotationX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mRotationY)) {
            interpolation.put("rotationY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTranslationX)) {
            interpolation.put("translationX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTranslationY)) {
            interpolation.put("translationY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            interpolation.put("translationZ", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            interpolation.put("transitionPathRotate", this.mCurveFit);
        }
        if (!Float.isNaN(this.mScaleX)) {
            interpolation.put("scaleX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mScaleY)) {
            interpolation.put("scaleY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mProgress)) {
            interpolation.put("progress", this.mCurveFit);
        }
        if (this.mCustomConstraints.size() > 0) {
            for (String s : this.mCustomConstraints.keySet()) {
                interpolation.put("CUSTOM," + s, this.mCurveFit);
            }
        }
    }

    @Override
    public void addValues(HashMap<String, SplineSet> splines) {
        block28: for (String s : splines.keySet()) {
            SplineSet splineSet = splines.get(s);
            if (s.startsWith("CUSTOM")) {
                String ckey = s.substring("CUSTOM".length() + 1);
                ConstraintAttribute cvalue = (ConstraintAttribute)this.mCustomConstraints.get(ckey);
                if (cvalue == null) continue;
                ((SplineSet.CustomSet)splineSet).setPoint(this.mFramePosition, cvalue);
                continue;
            }
            switch (s) {
                case "alpha": {
                    if (Float.isNaN(this.mAlpha)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mAlpha);
                    continue block28;
                }
                case "elevation": {
                    if (Float.isNaN(this.mElevation)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mElevation);
                    continue block28;
                }
                case "rotation": {
                    if (Float.isNaN(this.mRotation)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mRotation);
                    continue block28;
                }
                case "rotationX": {
                    if (Float.isNaN(this.mRotationX)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mRotationX);
                    continue block28;
                }
                case "rotationY": {
                    if (Float.isNaN(this.mRotationY)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mRotationY);
                    continue block28;
                }
                case "transitionPathRotate": {
                    if (Float.isNaN(this.mTransitionPathRotate)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mTransitionPathRotate);
                    continue block28;
                }
                case "scaleX": {
                    if (Float.isNaN(this.mScaleX)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mScaleX);
                    continue block28;
                }
                case "scaleY": {
                    if (Float.isNaN(this.mScaleY)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mScaleY);
                    continue block28;
                }
                case "translationX": {
                    if (Float.isNaN(this.mTranslationX)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mTranslationX);
                    continue block28;
                }
                case "translationY": {
                    if (Float.isNaN(this.mTranslationY)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mTranslationY);
                    continue block28;
                }
                case "translationZ": {
                    if (Float.isNaN(this.mTranslationZ)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mTranslationZ);
                    continue block28;
                }
                case "progress": {
                    if (Float.isNaN(this.mProgress)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mProgress);
                    continue block28;
                }
            }
            Log.v((String)"KeyAttributes", (String)("UNKNOWN addValues \"" + s + "\""));
        }
    }

    @Override
    public void setValue(String tag, Object value) {
        switch (tag) {
            case "alpha": {
                this.mAlpha = this.toFloat(value);
                break;
            }
            case "curveFit": {
                this.mCurveFit = this.toInt(value);
                break;
            }
            case "elevation": {
                this.mElevation = this.toFloat(value);
                break;
            }
            case "progress": {
                this.mProgress = this.toFloat(value);
                break;
            }
            case "rotation": {
                this.mRotation = this.toFloat(value);
                break;
            }
            case "rotationX": {
                this.mRotationX = this.toFloat(value);
                break;
            }
            case "rotationY": {
                this.mRotationY = this.toFloat(value);
                break;
            }
            case "scaleX": {
                this.mScaleX = this.toFloat(value);
                break;
            }
            case "scaleY": {
                this.mScaleY = this.toFloat(value);
                break;
            }
            case "transitionEasing": {
                this.mTransitionEasing = value.toString();
                break;
            }
            case "visibility": {
                this.mVisibility = this.toBoolean(value);
                break;
            }
            case "transitionPathRotate": {
                this.mTransitionPathRotate = this.toFloat(value);
                break;
            }
            case "translationX": {
                this.mTranslationX = this.toFloat(value);
                break;
            }
            case "translationY": {
                this.mTranslationY = this.toFloat(value);
                break;
            }
            case "mTranslationZ": {
                this.mTranslationZ = this.toFloat(value);
            }
        }
    }

    private static class Loader {
        private static final int ANDROID_ALPHA = 1;
        private static final int ANDROID_ELEVATION = 2;
        private static final int ANDROID_ROTATION = 4;
        private static final int ANDROID_ROTATION_X = 5;
        private static final int ANDROID_ROTATION_Y = 6;
        private static final int TRANSITION_PATH_ROTATE = 8;
        private static final int ANDROID_SCALE_X = 7;
        private static final int TRANSITION_EASING = 9;
        private static final int TARGET_ID = 10;
        private static final int FRAME_POSITION = 12;
        private static final int CURVE_FIT = 13;
        private static final int ANDROID_VISIBILITY = 14;
        private static final int ANDROID_SCALE_Y = 15;
        private static final int ANDROID_TRANSLATION_X = 16;
        private static final int ANDROID_TRANSLATION_Y = 17;
        private static final int ANDROID_TRANSLATION_Z = 18;
        private static final int PROGRESS = 19;
        private static SparseIntArray mAttrMap = new SparseIntArray();

        private Loader() {
        }

        public static void read(KeyAttributes c, TypedArray a) {
            int N = a.getIndexCount();
            block19: for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                switch (mAttrMap.get(attr)) {
                    case 10: {
                        c.mTargetId = a.getResourceId(attr, c.mTargetId);
                        continue block19;
                    }
                    case 12: {
                        c.mFramePosition = a.getInt(attr, c.mFramePosition);
                        continue block19;
                    }
                    case 1: {
                        c.mAlpha = a.getFloat(attr, c.mAlpha);
                        continue block19;
                    }
                    case 2: {
                        c.mElevation = a.getDimension(attr, c.mElevation);
                        continue block19;
                    }
                    case 4: {
                        c.mRotation = a.getFloat(attr, c.mRotation);
                        continue block19;
                    }
                    case 13: {
                        c.mCurveFit = a.getInteger(attr, c.mCurveFit);
                        continue block19;
                    }
                    case 7: {
                        c.mScaleX = a.getFloat(attr, c.mScaleX);
                        continue block19;
                    }
                    case 5: {
                        c.mRotationX = a.getFloat(attr, c.mRotationX);
                        continue block19;
                    }
                    case 6: {
                        c.mRotationY = a.getFloat(attr, c.mRotationY);
                        continue block19;
                    }
                    case 9: {
                        c.mTransitionEasing = a.getString(attr);
                        continue block19;
                    }
                    case 14: {
                        c.mVisibility = a.getBoolean(attr, c.mVisibility);
                        continue block19;
                    }
                    case 15: {
                        c.mScaleY = a.getFloat(attr, c.mScaleY);
                        continue block19;
                    }
                    case 8: {
                        c.mTransitionPathRotate = a.getFloat(attr, c.mTransitionPathRotate);
                        continue block19;
                    }
                    case 16: {
                        c.mTranslationX = a.getDimension(attr, c.mTranslationX);
                        continue block19;
                    }
                    case 17: {
                        c.mTranslationY = a.getDimension(attr, c.mTranslationY);
                        continue block19;
                    }
                    case 18: {
                        c.mTranslationZ = a.getDimension(attr, c.mTranslationZ);
                        continue block19;
                    }
                    case 19: {
                        c.mProgress = a.getFloat(attr, c.mProgress);
                        continue block19;
                    }
                    default: {
                        Log.e((String)"KeyAttribute", (String)("unused attribute 0x" + Integer.toHexString(attr) + "   " + mAttrMap.get(attr)));
                    }
                }
            }
        }

        static {
            mAttrMap.append(R.styleable.KeyAttribute_android_alpha, 1);
            mAttrMap.append(R.styleable.KeyAttribute_android_elevation, 2);
            mAttrMap.append(R.styleable.KeyAttribute_android_rotation, 4);
            mAttrMap.append(R.styleable.KeyAttribute_android_rotationX, 5);
            mAttrMap.append(R.styleable.KeyAttribute_android_rotationY, 6);
            mAttrMap.append(R.styleable.KeyAttribute_android_scaleX, 7);
            mAttrMap.append(R.styleable.KeyAttribute_transitionPathRotate, 8);
            mAttrMap.append(R.styleable.KeyAttribute_transitionEasing, 9);
            mAttrMap.append(R.styleable.KeyAttribute_target, 10);
            mAttrMap.append(R.styleable.KeyAttribute_framePosition, 12);
            mAttrMap.append(R.styleable.KeyAttribute_curveFit, 13);
            mAttrMap.append(R.styleable.KeyAttribute_android_visibility, 14);
            mAttrMap.append(R.styleable.KeyAttribute_android_scaleY, 15);
            mAttrMap.append(R.styleable.KeyAttribute_android_translationX, 16);
            mAttrMap.append(R.styleable.KeyAttribute_android_translationY, 17);
            mAttrMap.append(R.styleable.KeyAttribute_android_translationZ, 18);
            mAttrMap.append(R.styleable.KeyAttribute_progress, 19);
        }
    }
}

