/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.constraint.R;
import android.support.constraint.motion.Debug;
import android.support.constraint.motion.Key;
import android.support.constraint.motion.SplineSet;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.View;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;

public class KeyTrigger
extends Key {
    static final String NAME = "KeyTrigger";
    private static final String TAG = "KeyTrigger";
    private int mCurveFit = -1;
    private String mCross = null;
    private String mNegativeCross = null;
    private String mPositiveCross = null;
    private int mTriggerId = -1;
    float mTriggerSlack = 0.1f;
    private boolean mFireCrossReset = true;
    private boolean mFireNegativeReset = true;
    private boolean mFirePositiveReset = true;
    private float mFireThreshold = Float.NaN;
    private Method mFireCross;
    private Method mFireNegativeCross;
    private Method mFirePositiveCross;
    private float mFireLastPos;
    public static final int KEY_TYPE = 5;

    public KeyTrigger() {
        this.mType = 5;
        this.mCustomConstraints = new HashMap();
    }

    @Override
    public void load(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.KeyTrigger);
        Loader.read(this, a, context);
    }

    int getCurveFit() {
        return this.mCurveFit;
    }

    @Override
    public void getAttributeNames(HashSet<String> attributes) {
    }

    @Override
    public void addValues(HashMap<String, SplineSet> splines) {
    }

    @Override
    public void setValue(String tag, Object value) {
    }

    public void conditionallyFire(float pos, View child) {
        float lastOffset;
        float offset;
        if (this.mCross != null && this.mFireCrossReset) {
            offset = pos - this.mFireThreshold;
            lastOffset = this.mFireLastPos - this.mFireThreshold;
            if (offset * lastOffset < 0.0f) {
                if (this.mFireCross == null) {
                    try {
                        this.mFireCross = child.getClass().getMethod(this.mCross, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        Log.e((String)"KeyTrigger", (String)("Could not find method \"" + this.mCross + "\"on class " + child.getClass().getSimpleName() + " " + Debug.getName(child)));
                    }
                }
                try {
                    this.mFireCross.invoke((Object)child, new Object[0]);
                }
                catch (Exception e) {
                    Log.e((String)"KeyTrigger", (String)("Exception in call \"" + this.mCross + "\"on class " + child.getClass().getSimpleName() + " " + Debug.getName(child)));
                }
                this.mFireCrossReset = false;
            }
        } else if (Math.abs(pos - this.mFireThreshold) > this.mTriggerSlack) {
            this.mFireCrossReset = true;
        }
        if (this.mNegativeCross != null && this.mFireNegativeReset) {
            offset = pos - this.mFireThreshold;
            lastOffset = this.mFireLastPos - this.mFireThreshold;
            if (offset * lastOffset < 0.0f && offset < 0.0f) {
                if (this.mFireNegativeCross == null) {
                    try {
                        this.mFireNegativeCross = child.getClass().getMethod(this.mNegativeCross, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        Log.e((String)"KeyTrigger", (String)("Could not find method \"" + this.mNegativeCross + "\"on class " + child.getClass().getSimpleName() + " " + Debug.getName(child)));
                    }
                }
                try {
                    this.mFireNegativeCross.invoke((Object)child, new Object[0]);
                }
                catch (Exception e) {
                    Log.e((String)"KeyTrigger", (String)("Exception in call \"" + this.mNegativeCross + "\"on class " + child.getClass().getSimpleName() + " " + Debug.getName(child)));
                }
                this.mFireNegativeReset = false;
            }
        } else if (Math.abs(pos - this.mFireThreshold) > this.mTriggerSlack) {
            this.mFireNegativeReset = true;
        }
        if (this.mPositiveCross != null && this.mFirePositiveReset) {
            offset = pos - this.mFireThreshold;
            lastOffset = this.mFireLastPos - this.mFireThreshold;
            if (offset * lastOffset < 0.0f && offset > 0.0f) {
                if (this.mFirePositiveCross == null) {
                    try {
                        this.mFirePositiveCross = child.getClass().getMethod(this.mPositiveCross, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        Log.e((String)"KeyTrigger", (String)("Could not find method \"" + this.mPositiveCross + "\"on class " + child.getClass().getSimpleName() + " " + Debug.getName(child)));
                    }
                }
                try {
                    this.mFirePositiveCross.invoke((Object)child, new Object[0]);
                }
                catch (Exception e) {
                    Log.e((String)"KeyTrigger", (String)("Exception in call \"" + this.mPositiveCross + "\"on class " + child.getClass().getSimpleName() + " " + Debug.getName(child)));
                }
                this.mFirePositiveReset = false;
            }
        } else if (Math.abs(pos - this.mFireThreshold) > this.mTriggerSlack) {
            this.mFirePositiveReset = true;
        }
        this.mFireLastPos = pos;
    }

    private static class Loader {
        private static final int NEGATIVE_CROSS = 1;
        private static final int POSITIVE_CROSS = 2;
        private static final int CROSS = 4;
        private static final int TRIGGER_SLACK = 5;
        private static final int TRIGGER_ID = 6;
        private static final int TARGET_ID = 7;
        private static final int FRAME_POS = 8;
        private static SparseIntArray mAttrMap = new SparseIntArray();

        private Loader() {
        }

        public static void read(KeyTrigger c, TypedArray a, Context context) {
            int N = a.getIndexCount();
            block9: for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                switch (mAttrMap.get(attr)) {
                    case 8: {
                        c.mFramePosition = a.getInteger(attr, c.mFramePosition);
                        c.mFireThreshold = ((float)c.mFramePosition + 0.5f) / 100.0f;
                        continue block9;
                    }
                    case 7: {
                        c.mTargetId = a.getResourceId(attr, c.mTargetId);
                        continue block9;
                    }
                    case 1: {
                        c.mNegativeCross = a.getString(attr);
                        continue block9;
                    }
                    case 2: {
                        c.mPositiveCross = a.getString(attr);
                        continue block9;
                    }
                    case 4: {
                        c.mCross = a.getString(attr);
                        continue block9;
                    }
                    case 5: {
                        c.mTriggerSlack = a.getFloat(attr, c.mTriggerSlack);
                        continue block9;
                    }
                    case 6: {
                        c.mTriggerId = a.getResourceId(attr, c.mTriggerId);
                        continue block9;
                    }
                    default: {
                        Log.e((String)"KeyTrigger", (String)("unused attribute 0x" + Integer.toHexString(attr) + "   " + mAttrMap.get(attr)));
                    }
                }
            }
        }

        static {
            mAttrMap.append(R.styleable.KeyTrigger_framePosition, 8);
            mAttrMap.append(R.styleable.KeyTrigger_onCross, 4);
            mAttrMap.append(R.styleable.KeyTrigger_onNegativeCross, 1);
            mAttrMap.append(R.styleable.KeyTrigger_onPositiveCross, 2);
            mAttrMap.append(R.styleable.KeyTrigger_target, 7);
            mAttrMap.append(R.styleable.KeyTrigger_triggerId, 6);
            mAttrMap.append(R.styleable.KeyTrigger_triggerSlack, 5);
        }
    }
}

