/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Build;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.ConstraintSet;
import android.support.constraint.R;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.Helper;
import android.support.constraint.solver.widgets.HelperWidget;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;

public abstract class ConstraintHelper
extends View {
    protected int[] mIds = new int[32];
    protected int mCount;
    protected Context myContext;
    protected Helper mHelperWidget;
    protected boolean mUseViewMeasure = false;
    protected String mReferenceIds;
    private View[] mViews = null;
    private HashMap<Integer, String> mMap = new HashMap();

    public ConstraintHelper(Context context) {
        super(context);
        this.myContext = context;
        this.init(null);
    }

    public ConstraintHelper(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.myContext = context;
        this.init(attrs);
    }

    public ConstraintHelper(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.myContext = context;
        this.init(attrs);
    }

    protected void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ConstraintLayout_Layout);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr != R.styleable.ConstraintLayout_Layout_constraint_referenced_ids) continue;
                this.mReferenceIds = a.getString(attr);
                this.setIds(this.mReferenceIds);
            }
            a.recycle();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mReferenceIds != null) {
            this.setIds(this.mReferenceIds);
        }
    }

    public void addView(View view) {
        if (view == this) {
            return;
        }
        if (view.getId() == -1) {
            Log.e((String)"ConstraintHelper", (String)"Views added to a ConstraintHelper need to have an id");
            return;
        }
        if (view.getParent() == null) {
            Log.e((String)"ConstraintHelper", (String)"Views added to a ConstraintHelper need to have a parent");
            return;
        }
        this.mReferenceIds = null;
        this.addRscID(view.getId());
        this.requestLayout();
    }

    public void removeView(View view) {
        int id2 = view.getId();
        if (id2 == -1) {
            return;
        }
        this.mReferenceIds = null;
        for (int i = 0; i < this.mCount; ++i) {
            if (this.mIds[i] != id2) continue;
            for (int j = i; j < this.mCount - 1; ++j) {
                this.mIds[j] = this.mIds[j + 1];
            }
            this.mIds[this.mCount - 1] = 0;
            --this.mCount;
            break;
        }
        this.requestLayout();
    }

    public int[] getReferencedIds() {
        return Arrays.copyOf(this.mIds, this.mCount);
    }

    public void setReferencedIds(int[] ids) {
        this.mReferenceIds = null;
        this.mCount = 0;
        for (int i = 0; i < ids.length; ++i) {
            this.addRscID(ids[i]);
        }
    }

    private void addRscID(int id2) {
        if (id2 == this.getId()) {
            return;
        }
        if (this.mCount + 1 > this.mIds.length) {
            this.mIds = Arrays.copyOf(this.mIds, this.mIds.length * 2);
        }
        this.mIds[this.mCount] = id2;
        ++this.mCount;
    }

    public void onDraw(Canvas canvas) {
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mUseViewMeasure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.setMeasuredDimension(0, 0);
        }
    }

    public void validateParams() {
        if (this.mHelperWidget == null) {
            return;
        }
        ViewGroup.LayoutParams params = this.getLayoutParams();
        if (params instanceof ConstraintLayout.LayoutParams) {
            ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)params;
            layoutParams.widget = (ConstraintWidget)this.mHelperWidget;
        }
    }

    private void addID(String idString) {
        int rscId;
        if (idString == null || idString.length() == 0) {
            return;
        }
        if (this.myContext == null) {
            return;
        }
        idString = idString.trim();
        ConstraintLayout parent = null;
        if (this.getParent() instanceof ConstraintLayout) {
            parent = (ConstraintLayout)this.getParent();
        }
        if ((rscId = this.findId(idString)) != 0) {
            this.mMap.put(rscId, idString);
            this.addRscID(rscId);
        } else {
            Log.w((String)"ConstraintHelper", (String)("Could not find id of \"" + idString + "\""));
        }
    }

    private int findId(String referenceId) {
        Object value;
        ConstraintLayout parent = null;
        if (this.getParent() instanceof ConstraintLayout) {
            parent = (ConstraintLayout)this.getParent();
        }
        int rscId = 0;
        if (this.isInEditMode() && parent != null && (value = parent.getDesignInformation(0, referenceId)) instanceof Integer) {
            rscId = (Integer)value;
        }
        if (rscId == 0 && parent != null) {
            rscId = this.findId(parent, referenceId);
        }
        if (rscId == 0) {
            try {
                Class<R.id> res = R.id.class;
                Field field = res.getField(referenceId);
                rscId = field.getInt(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rscId == 0) {
            rscId = this.myContext.getResources().getIdentifier(referenceId, "id", this.myContext.getPackageName());
        }
        return rscId;
    }

    private int findId(ConstraintLayout container, String idString) {
        if (idString == null || container == null) {
            return 0;
        }
        Resources resources = this.myContext.getResources();
        if (resources == null) {
            return 0;
        }
        int count = container.getChildCount();
        for (int j = 0; j < count; ++j) {
            View child = container.getChildAt(j);
            if (child.getId() == -1) continue;
            String res = null;
            try {
                res = resources.getResourceEntryName(child.getId());
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
            if (!idString.equals(res)) continue;
            return child.getId();
        }
        return 0;
    }

    protected void setIds(String idList) {
        this.mReferenceIds = idList;
        if (idList == null) {
            return;
        }
        int begin = 0;
        this.mCount = 0;
        while (true) {
            int end;
            if ((end = idList.indexOf(44, begin)) == -1) break;
            this.addID(idList.substring(begin, end));
            begin = end + 1;
        }
        this.addID(idList.substring(begin));
    }

    protected void applyLayoutFeatures(ConstraintLayout container) {
        int visibility = this.getVisibility();
        float elevation = 0.0f;
        if (Build.VERSION.SDK_INT >= 21) {
            elevation = this.getElevation();
        }
        for (int i = 0; i < this.mCount; ++i) {
            int id2 = this.mIds[i];
            View view = container.getViewById(id2);
            if (view == null) continue;
            view.setVisibility(visibility);
            if (!(elevation > 0.0f) || Build.VERSION.SDK_INT < 21) continue;
            view.setTranslationZ(view.getTranslationZ() + elevation);
        }
    }

    protected void applyLayoutFeatures() {
        ViewParent parent = this.getParent();
        if (parent != null && parent instanceof ConstraintLayout) {
            this.applyLayoutFeatures((ConstraintLayout)parent);
        }
    }

    public void updatePreLayout(ConstraintLayout container) {
        if (this.isInEditMode()) {
            this.setIds(this.mReferenceIds);
        }
        if (this.mHelperWidget == null) {
            return;
        }
        this.mHelperWidget.removeAllIds();
        for (int i = 0; i < this.mCount; ++i) {
            String candidate;
            int foundId;
            int id2 = this.mIds[i];
            View view = container.getViewById(id2);
            if (view == null && (foundId = this.findId(container, candidate = this.mMap.get(id2))) != 0) {
                this.mIds[i] = foundId;
                this.mMap.put(foundId, candidate);
                view = container.getViewById(foundId);
            }
            if (view == null) continue;
            this.mHelperWidget.add(container.getViewWidget(view));
        }
        this.mHelperWidget.updateConstraints(container.mLayoutWidget);
    }

    public void updatePreLayout(ConstraintWidgetContainer container, Helper helper, SparseArray<ConstraintWidget> map) {
        helper.removeAllIds();
        for (int i = 0; i < this.mCount; ++i) {
            int id2 = this.mIds[i];
            helper.add((ConstraintWidget)map.get(id2));
        }
    }

    protected View[] getViews(ConstraintLayout layout) {
        if (this.mViews == null || this.mViews.length != this.mCount) {
            this.mViews = new View[this.mCount];
        }
        for (int i = 0; i < this.mCount; ++i) {
            int id2 = this.mIds[i];
            this.mViews[i] = layout.getViewById(id2);
        }
        return this.mViews;
    }

    public void updatePostLayout(ConstraintLayout container) {
    }

    public void updatePostMeasure(ConstraintLayout container) {
    }

    public void updatePostConstraints(ConstraintLayout constainer) {
    }

    public void updatePreDraw(ConstraintLayout container) {
    }

    public void loadParameters(ConstraintSet.Constraint constraint, HelperWidget child, ConstraintLayout.LayoutParams layoutParams, SparseArray<ConstraintWidget> mapIdToWidget) {
        if (constraint.layout.mReferenceIds != null) {
            this.setReferencedIds(constraint.layout.mReferenceIds);
        } else if (constraint.layout.mReferenceIdString != null && constraint.layout.mReferenceIdString.length() > 0) {
            constraint.layout.mReferenceIds = this.convertReferenceString(this, constraint.layout.mReferenceIdString);
        }
        child.removeAllIds();
        if (constraint.layout.mReferenceIds != null) {
            for (int i = 0; i < constraint.layout.mReferenceIds.length; ++i) {
                int id2 = constraint.layout.mReferenceIds[i];
                ConstraintWidget widget = (ConstraintWidget)mapIdToWidget.get(id2);
                if (widget == null) continue;
                child.add(widget);
            }
        }
    }

    private int[] convertReferenceString(View view, String referenceIdString) {
        String[] split = referenceIdString.split(",");
        Context context = view.getContext();
        int[] rscIds = new int[split.length];
        int count = 0;
        for (int i = 0; i < split.length; ++i) {
            String idString = split[i];
            int id2 = this.findId(idString = idString.trim());
            if (id2 == 0) continue;
            rscIds[count++] = id2;
        }
        if (count != split.length) {
            rscIds = Arrays.copyOf(rscIds, count);
        }
        return rscIds;
    }

    public void resolveRtl(ConstraintWidget widget, boolean isRtl) {
    }
}

