/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.bottomappbar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.MenuRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.bottomappbar.BottomAppBarTopEdgeTreatment;
import android.support.design.bottomappbar.R;
import android.support.design.internal.ThemeEnforcement;
import android.support.design.resources.MaterialResources;
import android.support.design.shape.EdgeTreatment;
import android.support.design.shape.MaterialShapeDrawable;
import android.support.design.shape.ShapePathModel;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.AbsSavedState;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.ActionMenuView;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.view.View;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

@CoordinatorLayout.DefaultBehavior(value=Behavior.class)
public class BottomAppBar
extends Toolbar {
    private static final long ANIMATION_DURATION = 300L;
    public static final int FAB_ALIGNMENT_MODE_CENTER = 0;
    public static final int FAB_ALIGNMENT_MODE_END = 1;
    private final int fabOffsetEndMode;
    private final MaterialShapeDrawable materialShapeDrawable;
    private final BottomAppBarTopEdgeTreatment topEdgeTreatment;
    @Nullable
    private Animator attachAnimator;
    @Nullable
    private Animator modeAnimator;
    @Nullable
    private Animator menuAnimator;
    private int fabAlignmentMode;
    private boolean fabAttached;

    public BottomAppBar(Context context) {
        this(context, null, 0);
    }

    public BottomAppBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.bottomAppBarStyle);
    }

    public BottomAppBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = ThemeEnforcement.obtainStyledAttributes((Context)context, (AttributeSet)attrs, (int[])R.styleable.BottomAppBar, (int)defStyleAttr, (int)R.style.Widget_MaterialComponents_BottomAppBar);
        ColorStateList backgroundTint = MaterialResources.getColorStateList((Context)context, (TypedArray)a, (int)R.styleable.BottomAppBar_backgroundTint);
        float fabCradleDiameter = a.getDimensionPixelOffset(R.styleable.BottomAppBar_fabCradleDiameter, 0);
        float fabCornerRadius = a.getDimensionPixelOffset(R.styleable.BottomAppBar_fabCradleRoundedCornerRadius, 0);
        float fabVerticalOffset = a.getDimensionPixelOffset(R.styleable.BottomAppBar_fabCradleVerticalOffset, 0);
        this.fabAttached = a.getBoolean(R.styleable.BottomAppBar_fabAttached, true);
        this.fabAlignmentMode = a.getInt(R.styleable.BottomAppBar_fabAlignmentMode, 0);
        a.recycle();
        this.fabOffsetEndMode = this.getResources().getDimensionPixelOffset(R.dimen.mtrl_bottomappbar_fabOffsetEndMode);
        this.topEdgeTreatment = new BottomAppBarTopEdgeTreatment(fabCradleDiameter, fabCornerRadius, fabVerticalOffset);
        ShapePathModel appBarModel = new ShapePathModel();
        appBarModel.setTopEdge((EdgeTreatment)this.topEdgeTreatment);
        this.materialShapeDrawable = new MaterialShapeDrawable(appBarModel);
        this.materialShapeDrawable.setStrokeWidth(1.0f);
        this.materialShapeDrawable.setShadowEnabled(true);
        this.materialShapeDrawable.setPaintStyle(Paint.Style.FILL);
        DrawableCompat.setTintList((Drawable)this.materialShapeDrawable, (ColorStateList)backgroundTint);
        ViewCompat.setBackground((View)this, (Drawable)this.materialShapeDrawable);
    }

    public int getFabAlignmentMode() {
        return this.fabAlignmentMode;
    }

    public void setFabAlignmentMode(int fabAlignmentMode) {
        this.maybeAnimateModeChange(fabAlignmentMode);
        this.maybeAnimateMenuView(fabAlignmentMode, this.fabAttached);
        this.fabAlignmentMode = fabAlignmentMode;
    }

    public boolean isFabAttached() {
        return this.fabAttached;
    }

    public void setFabAttached(boolean attached) {
        this.maybeAnimateAttachChange(attached);
        this.maybeAnimateMenuView(this.fabAlignmentMode, attached);
        this.fabAttached = attached;
    }

    public float getCradleVerticalOffset() {
        return this.topEdgeTreatment.getCradleVerticalOffset();
    }

    public void setCradleVerticalOffset(int verticalOffset) {
        if ((float)verticalOffset != this.getCradleVerticalOffset()) {
            this.topEdgeTreatment.setCradleVerticalOffset(verticalOffset);
            this.materialShapeDrawable.invalidateSelf();
        }
    }

    public void replaceMenu(@MenuRes int newMenu) {
        this.getMenu().clear();
        this.inflateMenu(newMenu);
    }

    private void maybeAnimateModeChange(int targetMode) {
        if (this.fabAlignmentMode == targetMode || !ViewCompat.isLaidOut((View)this)) {
            return;
        }
        if (this.modeAnimator != null) {
            this.modeAnimator.cancel();
        }
        ArrayList<Animator> animators = new ArrayList<Animator>();
        this.createCradleTranslationAnimation(targetMode, animators);
        this.createFabTranslationXAnimation(targetMode, animators);
        AnimatorSet set = new AnimatorSet();
        set.playTogether(animators);
        this.modeAnimator = set;
        this.modeAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                BottomAppBar.this.modeAnimator = null;
            }
        });
        this.modeAnimator.start();
    }

    private void createCradleTranslationAnimation(int targetMode, List<Animator> animators) {
        if (!this.fabAttached) {
            return;
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{this.topEdgeTreatment.getHorizontalOffset(), this.getFabTranslationX(targetMode)});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BottomAppBar.this.topEdgeTreatment.setHorizontalOffset(((Float)animation.getAnimatedValue()).floatValue());
                BottomAppBar.this.materialShapeDrawable.invalidateSelf();
            }
        });
        animator.setDuration(300L);
        animators.add((Animator)animator);
    }

    @Nullable
    private FloatingActionButton findDependentFab() {
        List dependents = ((CoordinatorLayout)this.getParent()).getDependents((View)this);
        for (View v : dependents) {
            if (!(v instanceof FloatingActionButton) || v.getVisibility() != 0) continue;
            return (FloatingActionButton)v;
        }
        return null;
    }

    private void createFabTranslationXAnimation(int targetMode, List<Animator> animators) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)this.findDependentFab(), (String)"translationX", (float[])new float[]{this.getFabTranslationX(targetMode)});
        animator.setDuration(300L);
        animators.add((Animator)animator);
    }

    private void maybeAnimateMenuView(int targetMode, boolean newFabAttached) {
        if (!ViewCompat.isLaidOut((View)this)) {
            return;
        }
        if (this.menuAnimator != null) {
            this.menuAnimator.cancel();
        }
        ArrayList<Animator> animators = new ArrayList<Animator>();
        this.createMenuViewTranslationAnimation(targetMode, newFabAttached, animators);
        AnimatorSet set = new AnimatorSet();
        set.playTogether(animators);
        this.menuAnimator = set;
        this.menuAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                BottomAppBar.this.menuAnimator = null;
            }
        });
        this.menuAnimator.start();
    }

    private void createMenuViewTranslationAnimation(final int targetMode, final boolean targetAttached, List<Animator> animators) {
        final ActionMenuView actionMenuView = this.getActionMenuView();
        if (actionMenuView == null) {
            return;
        }
        ObjectAnimator fadeIn = ObjectAnimator.ofFloat((Object)actionMenuView, (String)"alpha", (float[])new float[]{1.0f});
        if ((this.fabAttached || targetAttached) && (this.fabAlignmentMode == 1 || targetMode == 1)) {
            ObjectAnimator fadeOut = ObjectAnimator.ofFloat((Object)actionMenuView, (String)"alpha", (float[])new float[]{0.0f});
            fadeOut.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    BottomAppBar.this.translateActionMenuView(actionMenuView, targetMode, targetAttached);
                }
            });
            AnimatorSet set = new AnimatorSet();
            set.setDuration(150L);
            set.playSequentially(new Animator[]{fadeOut, fadeIn});
            animators.add((Animator)set);
        } else if (actionMenuView.getAlpha() < 1.0f) {
            animators.add((Animator)fadeIn);
        }
    }

    private void maybeAnimateAttachChange(boolean targetAttached) {
        if (this.fabAttached == targetAttached || !ViewCompat.isLaidOut((View)this)) {
            return;
        }
        if (this.attachAnimator != null) {
            this.attachAnimator.cancel();
        }
        ArrayList<Animator> animators = new ArrayList<Animator>();
        this.createCradleShapeAnimation(targetAttached, animators);
        this.createFabTranslationYAnimation(targetAttached, animators);
        AnimatorSet set = new AnimatorSet();
        set.playTogether(animators);
        this.attachAnimator = set;
        this.attachAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                BottomAppBar.this.attachAnimator = null;
            }
        });
        this.attachAnimator.start();
    }

    private void createCradleShapeAnimation(boolean targetAttached, List<Animator> animators) {
        if (targetAttached) {
            this.topEdgeTreatment.setHorizontalOffset(this.getFabTranslationX());
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{this.materialShapeDrawable.getInterpolation(), targetAttached ? 1.0f : 0.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BottomAppBar.this.materialShapeDrawable.setInterpolation(((Float)animation.getAnimatedValue()).floatValue());
            }
        });
        animator.setDuration(300L);
        animators.add((Animator)animator);
    }

    private void createFabTranslationYAnimation(boolean targetAttached, List<Animator> animators) {
        FloatingActionButton fab = this.findDependentFab();
        if (fab == null) {
            return;
        }
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)fab, (String)"translationY", (float[])new float[]{targetAttached ? 0.0f : (float)(-fab.getHeight()) + this.getCradleVerticalOffset()});
        animator.setDuration(300L);
        animators.add((Animator)animator);
    }

    private int getFabTranslationX(int fabAlignmentMode) {
        boolean isRtl;
        boolean bl = isRtl = ViewCompat.getLayoutDirection((View)this) == 1;
        return fabAlignmentMode == 1 ? (this.getMeasuredWidth() / 2 - this.fabOffsetEndMode) * (isRtl ? -1 : 1) : 0;
    }

    private float getFabTranslationX() {
        return this.getFabTranslationX(this.fabAlignmentMode);
    }

    @Nullable
    private ActionMenuView getActionMenuView() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof ActionMenuView)) continue;
            return (ActionMenuView)view;
        }
        return null;
    }

    private void translateActionMenuView(ActionMenuView actionMenuView, int fabAlignmentMode, boolean fabAttached) {
        int toolbarLeftContentEnd = 0;
        boolean isRtl = ViewCompat.getLayoutDirection((View)this) == 1;
        for (int i = 0; i < this.getChildCount(); ++i) {
            boolean isAlignedToStart;
            View view = this.getChildAt(i);
            boolean bl = isAlignedToStart = view.getLayoutParams() instanceof Toolbar.LayoutParams && (((Toolbar.LayoutParams)view.getLayoutParams()).gravity & 0x800007) == 0x800003;
            if (!isAlignedToStart) continue;
            toolbarLeftContentEnd = Math.max(toolbarLeftContentEnd, isRtl ? view.getLeft() : view.getRight());
        }
        int end = isRtl ? actionMenuView.getRight() : actionMenuView.getLeft();
        int offset = toolbarLeftContentEnd - end;
        actionMenuView.setTranslationX(fabAlignmentMode == 1 && fabAttached ? (float)offset : 0.0f);
    }

    private void cancelAnimations() {
        if (this.attachAnimator != null) {
            this.attachAnimator.cancel();
        }
        if (this.menuAnimator != null) {
            this.menuAnimator.cancel();
        }
        if (this.modeAnimator != null) {
            this.modeAnimator.cancel();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        FloatingActionButton fab;
        super.onLayout(changed, l, t, r, b);
        this.cancelAnimations();
        this.topEdgeTreatment.setHorizontalOffset(this.getFabTranslationX());
        this.materialShapeDrawable.setInterpolation(this.fabAttached ? 1.0f : 0.0f);
        ActionMenuView actionMenuView = this.getActionMenuView();
        if (actionMenuView != null) {
            actionMenuView.setAlpha(1.0f);
            this.translateActionMenuView(actionMenuView, this.fabAlignmentMode, this.fabAttached);
        }
        if ((fab = this.findDependentFab()) != null) {
            fab.setTranslationY(this.isFabAttached() ? 0.0f : (float)(-fab.getMeasuredHeight()) + this.getCradleVerticalOffset());
            fab.setTranslationX(this.getFabTranslationX());
        }
    }

    public void setTitle(CharSequence title) {
    }

    public void setSubtitle(CharSequence subtitle) {
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.fabAlignmentMode = this.fabAlignmentMode;
        savedState.fabAttached = this.fabAttached;
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.fabAlignmentMode = savedState.fabAlignmentMode;
        this.fabAttached = savedState.fabAttached;
    }

    static class SavedState
    extends AbsSavedState {
        int fabAlignmentMode;
        boolean fabAttached;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public SavedState(Parcel in, ClassLoader loader) {
            super(in, loader);
            this.fabAlignmentMode = in.readInt();
            this.fabAttached = in.readInt() != 0;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.fabAlignmentMode);
            out.writeInt(this.fabAttached ? 1 : 0);
        }
    }

    public static class Behavior
    extends CoordinatorLayout.Behavior<BottomAppBar> {
        private boolean updateFabPositionAndVisibility(FloatingActionButton fab, BottomAppBar child) {
            CoordinatorLayout.LayoutParams fabLayoutParams = (CoordinatorLayout.LayoutParams)fab.getLayoutParams();
            fabLayoutParams.anchorGravity = 17;
            Rect rect = new Rect();
            fab.getBackground().getPadding(rect);
            int drawablePadding = rect.bottom;
            fabLayoutParams.bottomMargin = (int)((float)(child.getMeasuredHeight() / 2) + child.getCradleVerticalOffset()) - drawablePadding;
            return true;
        }

        public boolean onLayoutChild(CoordinatorLayout parent, BottomAppBar child, int layoutDirection) {
            View dependent;
            List dependents = parent.getDependents((View)child);
            int count = dependents.size();
            for (int i = 0; !(i >= count || (dependent = (View)dependents.get(i)) instanceof FloatingActionButton && this.updateFabPositionAndVisibility((FloatingActionButton)dependent, child)); ++i) {
            }
            parent.onLayoutChild((View)child, layoutDirection);
            return true;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FabAlignmentMode {
    }
}

