/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.chip;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.BoolRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.chip.Chip;
import android.support.design.chip.R;
import android.support.design.internal.FlexboxLayout;
import android.support.design.internal.ThemeEnforcement;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;

public class ChipGroup
extends FlexboxLayout {
    private final SpacingDrawable spacingDrawable = new SpacingDrawable();
    @Dimension
    private int chipSpacingHorizontal;
    @Dimension
    private int chipSpacingVertical;
    private boolean singleLine;
    private boolean singleSelection;
    @Nullable
    private OnCheckedChangeListener onCheckedChangeListener;
    private final CheckedStateTracker checkedStateTracker = new CheckedStateTracker();
    private PassThroughHierarchyChangeListener passThroughListener = new PassThroughHierarchyChangeListener();
    @IdRes
    private int checkedId = -1;
    private boolean protectFromCheckedChange = false;

    public ChipGroup(Context context) {
        this(context, null);
    }

    public ChipGroup(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.chipGroupStyle);
    }

    public ChipGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = ThemeEnforcement.obtainStyledAttributes((Context)context, (AttributeSet)attrs, (int[])R.styleable.ChipGroup, (int)defStyleAttr, (int)R.style.Widget_MaterialComponents_ChipGroup);
        int chipSpacing = a.getDimensionPixelOffset(R.styleable.ChipGroup_chipSpacing, 0);
        this.setChipSpacingHorizontal(a.getDimensionPixelOffset(R.styleable.ChipGroup_chipSpacingHorizontal, chipSpacing));
        this.setChipSpacingVertical(a.getDimensionPixelOffset(R.styleable.ChipGroup_chipSpacingVertical, chipSpacing));
        this.setSingleLine(a.getBoolean(R.styleable.ChipGroup_singleLine, false));
        this.setSingleSelection(a.getBoolean(R.styleable.ChipGroup_singleSelection, false));
        int checkedChip = a.getResourceId(R.styleable.ChipGroup_checkedChip, -1);
        if (checkedChip != -1) {
            this.checkedId = checkedChip;
        }
        a.recycle();
        this.setDividerDrawable(this.spacingDrawable);
        this.setShowDivider(2);
        this.setWillNotDraw(true);
        super.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)this.passThroughListener);
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener listener) {
        this.passThroughListener.onHierarchyChangeListener = listener;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.checkedId != -1) {
            this.setCheckedStateForView(this.checkedId, true);
            this.setCheckedId(this.checkedId);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        Chip chip;
        if (child instanceof Chip && (chip = (Chip)child).isChecked()) {
            if (this.checkedId != -1 && this.singleSelection) {
                this.setCheckedStateForView(this.checkedId, false);
            }
            this.setCheckedId(chip.getId());
        }
        super.addView(child, index, params);
    }

    public void setDividerDrawableHorizontal(Drawable divider) {
        if (divider != this.spacingDrawable) {
            throw new UnsupportedOperationException("Changing divider drawables not allowed. ChipGroup uses divider drawables as spacing.");
        }
        super.setDividerDrawableHorizontal(divider);
    }

    public void setDividerDrawableVertical(@Nullable Drawable divider) {
        if (divider != this.spacingDrawable) {
            throw new UnsupportedOperationException("Changing divider drawables not allowed. ChipGroup uses divider drawables as spacing.");
        }
        super.setDividerDrawableVertical(divider);
    }

    public void setShowDividerHorizontal(int dividerMode) {
        if (dividerMode != 2) {
            throw new UnsupportedOperationException("Changing divider modes not allowed. ChipGroup uses divider drawables as spacing.");
        }
        super.setShowDividerHorizontal(dividerMode);
    }

    public void setShowDividerVertical(int dividerMode) {
        if (dividerMode != 2) {
            throw new UnsupportedOperationException("Changing divider modes not allowed. ChipGroup uses divider drawables as spacing.");
        }
        super.setShowDividerVertical(dividerMode);
    }

    public void setFlexWrap(int flexWrap) {
        throw new UnsupportedOperationException("Changing flex wrap not allowed. ChipGroup exposes a singleLine attribute instead.");
    }

    public void check(@IdRes int id) {
        if (id == this.checkedId) {
            return;
        }
        if (this.checkedId != -1 && this.singleSelection) {
            this.setCheckedStateForView(this.checkedId, false);
        }
        if (id != -1) {
            this.setCheckedStateForView(id, true);
        }
        this.setCheckedId(id);
    }

    @IdRes
    public int getCheckedChipId() {
        return this.singleSelection ? this.checkedId : -1;
    }

    public void clearCheck() {
        this.protectFromCheckedChange = true;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof Chip)) continue;
            ((Chip)child).setChecked(false);
        }
        this.protectFromCheckedChange = false;
        this.setCheckedId(-1);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.onCheckedChangeListener = listener;
    }

    private void setCheckedId(int checkedId) {
        this.checkedId = checkedId;
        if (this.onCheckedChangeListener != null && this.singleSelection) {
            this.onCheckedChangeListener.onCheckedChanged(this, checkedId);
        }
    }

    private void setCheckedStateForView(@IdRes int viewId, boolean checked) {
        View checkedView = this.findViewById(viewId);
        if (checkedView instanceof Chip) {
            this.protectFromCheckedChange = true;
            ((Chip)checkedView).setChecked(checked);
            this.protectFromCheckedChange = false;
        }
    }

    public void setChipSpacing(@Dimension int chipSpacing) {
        this.setChipSpacingHorizontal(chipSpacing);
        this.setChipSpacingVertical(chipSpacing);
    }

    public void setChipSpacingResource(@DimenRes int id) {
        this.setChipSpacing(this.getResources().getDimensionPixelOffset(id));
    }

    @Dimension
    public int getChipSpacingHorizontal() {
        return this.chipSpacingHorizontal;
    }

    public void setChipSpacingHorizontal(@Dimension int chipSpacingHorizontal) {
        if (this.chipSpacingHorizontal != chipSpacingHorizontal) {
            this.chipSpacingHorizontal = chipSpacingHorizontal;
            this.requestLayout();
        }
    }

    public void setChipSpacingHorizontalResource(@DimenRes int id) {
        this.setChipSpacingHorizontal(this.getResources().getDimensionPixelOffset(id));
    }

    @Dimension
    public int getChipSpacingVertical() {
        return this.chipSpacingVertical;
    }

    public void setChipSpacingVertical(@Dimension int chipSpacingVertical) {
        if (this.chipSpacingVertical != chipSpacingVertical) {
            this.chipSpacingVertical = chipSpacingVertical;
            this.requestLayout();
        }
    }

    public void setChipSpacingVerticalResource(@DimenRes int id) {
        this.setChipSpacingVertical(this.getResources().getDimensionPixelOffset(id));
    }

    public boolean isSingleLine() {
        return this.singleLine;
    }

    public void setSingleLine(boolean singleLine) {
        this.singleLine = singleLine;
        super.setFlexWrap(singleLine ? 0 : 1);
    }

    public void setSingleLine(@BoolRes int id) {
        this.setSingleLine(this.getResources().getBoolean(id));
    }

    public boolean isSingleSelection() {
        return this.singleSelection;
    }

    public void setSingleSelection(boolean singleSelection) {
        if (this.singleSelection != singleSelection) {
            this.singleSelection = singleSelection;
            this.clearCheck();
        }
    }

    public void setSingleSelection(@BoolRes int id) {
        this.setSingleSelection(this.getResources().getBoolean(id));
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener;

        private PassThroughHierarchyChangeListener() {
        }

        public void onChildViewAdded(View parent, View child) {
            if (parent == ChipGroup.this && child instanceof Chip) {
                int id = child.getId();
                if (id == -1) {
                    id = Build.VERSION.SDK_INT >= 17 ? View.generateViewId() : child.hashCode();
                    child.setId(id);
                }
                ((Chip)child).setOnCheckedChangeListenerInternal(ChipGroup.this.checkedStateTracker);
            }
            if (this.onHierarchyChangeListener != null) {
                this.onHierarchyChangeListener.onChildViewAdded(parent, child);
            }
        }

        public void onChildViewRemoved(View parent, View child) {
            if (parent == ChipGroup.this && child instanceof Chip) {
                ((Chip)child).setOnCheckedChangeListenerInternal(null);
            }
            if (this.onHierarchyChangeListener != null) {
                this.onHierarchyChangeListener.onChildViewRemoved(parent, child);
            }
        }
    }

    private class CheckedStateTracker
    implements CompoundButton.OnCheckedChangeListener {
        private CheckedStateTracker() {
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (ChipGroup.this.protectFromCheckedChange) {
                return;
            }
            int id = buttonView.getId();
            if (isChecked) {
                if (ChipGroup.this.checkedId != -1 && ChipGroup.this.checkedId != id && ChipGroup.this.singleSelection) {
                    ChipGroup.this.setCheckedStateForView(ChipGroup.this.checkedId, false);
                }
                ChipGroup.this.setCheckedId(id);
            } else if (ChipGroup.this.checkedId == id) {
                ChipGroup.this.setCheckedId(-1);
            }
        }
    }

    private class SpacingDrawable
    extends Drawable {
        private SpacingDrawable() {
        }

        public int getIntrinsicWidth() {
            return ChipGroup.this.chipSpacingHorizontal;
        }

        public int getIntrinsicHeight() {
            return ChipGroup.this.chipSpacingVertical;
        }

        public void draw(@NonNull Canvas canvas) {
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(@Nullable ColorFilter colorFilter) {
        }

        public int getOpacity() {
            return -2;
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(ChipGroup var1, @IdRes int var2);
    }
}

