/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.ripple;

import android.annotation.TargetApi;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.graphics.ColorUtils;
import android.util.StateSet;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class RippleUtils {
    public static final boolean USE_FRAMEWORK_RIPPLE = Build.VERSION.SDK_INT >= 21;
    private static final int[] PRESSED_STATE_SET = new int[]{16842919};
    private static final int[] HOVERED_FOCUSED_STATE_SET = new int[]{16843623, 16842908};
    private static final int[] FOCUSED_STATE_SET = new int[]{16842908};
    private static final int[] HOVERED_STATE_SET = new int[]{16843623};
    private static final int[] SELECTED_PRESSED_STATE_SET = new int[]{0x10100A1, 16842919};
    private static final int[] SELECTED_HOVERED_FOCUSED_STATE_SET = new int[]{0x10100A1, 16843623, 16842908};
    private static final int[] SELECTED_FOCUSED_STATE_SET = new int[]{0x10100A1, 16842908};
    private static final int[] SELECTED_HOVERED_STATE_SET = new int[]{0x10100A1, 16843623};
    private static final int[] SELECTED_STATE_SET = new int[]{0x10100A1};

    private RippleUtils() {
    }

    @NonNull
    public static ColorStateList convertToRippleDrawableColor(@Nullable ColorStateList rippleColor) {
        if (USE_FRAMEWORK_RIPPLE) {
            int size = 2;
            int[][] states = new int[size][];
            int[] colors = new int[size];
            int i = 0;
            states[i] = SELECTED_STATE_SET;
            colors[i] = RippleUtils.getColorForState(rippleColor, SELECTED_PRESSED_STATE_SET);
            states[++i] = StateSet.NOTHING;
            colors[i] = RippleUtils.getColorForState(rippleColor, PRESSED_STATE_SET);
            ++i;
            return new ColorStateList((int[][])states, colors);
        }
        int size = 10;
        int[][] states = new int[size][];
        int[] colors = new int[size];
        int i = 0;
        states[i] = SELECTED_PRESSED_STATE_SET;
        colors[i] = RippleUtils.getColorForState(rippleColor, SELECTED_PRESSED_STATE_SET);
        states[++i] = SELECTED_HOVERED_FOCUSED_STATE_SET;
        colors[i] = RippleUtils.getColorForState(rippleColor, SELECTED_HOVERED_FOCUSED_STATE_SET);
        states[++i] = SELECTED_FOCUSED_STATE_SET;
        colors[i] = RippleUtils.getColorForState(rippleColor, SELECTED_FOCUSED_STATE_SET);
        states[++i] = SELECTED_HOVERED_STATE_SET;
        colors[i] = RippleUtils.getColorForState(rippleColor, SELECTED_HOVERED_STATE_SET);
        states[++i] = SELECTED_STATE_SET;
        colors[i] = 0;
        states[++i] = PRESSED_STATE_SET;
        colors[i] = RippleUtils.getColorForState(rippleColor, PRESSED_STATE_SET);
        states[++i] = HOVERED_FOCUSED_STATE_SET;
        colors[i] = RippleUtils.getColorForState(rippleColor, HOVERED_FOCUSED_STATE_SET);
        states[++i] = FOCUSED_STATE_SET;
        colors[i] = RippleUtils.getColorForState(rippleColor, FOCUSED_STATE_SET);
        states[++i] = HOVERED_STATE_SET;
        colors[i] = RippleUtils.getColorForState(rippleColor, HOVERED_STATE_SET);
        states[++i] = StateSet.NOTHING;
        colors[i] = 0;
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    @ColorInt
    private static int getColorForState(@Nullable ColorStateList rippleColor, int[] state) {
        int color = rippleColor != null ? rippleColor.getColorForState(state, rippleColor.getDefaultColor()) : 0;
        return USE_FRAMEWORK_RIPPLE ? RippleUtils.doubleAlpha(color) : color;
    }

    @ColorInt
    @TargetApi(value=21)
    private static int doubleAlpha(@ColorInt int color) {
        int alpha = Math.min(2 * Color.alpha((int)color), 255);
        return ColorUtils.setAlphaComponent((int)color, (int)alpha);
    }
}

