/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.transformation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.design.animation.AnimatorSetCompat;
import android.support.design.animation.MotionTiming;
import android.support.design.transformation.ExpandableTransformationBehavior;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.FloatingActionButton;
import android.util.AttributeSet;
import android.util.Property;
import android.view.MotionEvent;
import android.view.View;
import java.util.ArrayList;
import java.util.List;

public class FabTransformationScrimBehavior
extends ExpandableTransformationBehavior {
    public static final long EXPAND_DELAY = 75L;
    public static final long EXPAND_DURATION = 150L;
    public static final long COLLAPSE_DELAY = 0L;
    public static final long COLLAPSE_DURATION = 150L;
    private final MotionTiming expandTiming = new MotionTiming(75L, 150L);
    private final MotionTiming collapseTiming = new MotionTiming(0L, 150L);

    public FabTransformationScrimBehavior() {
    }

    public FabTransformationScrimBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public boolean layoutDependsOn(CoordinatorLayout parent, View child, View dependency) {
        return dependency instanceof FloatingActionButton;
    }

    public boolean onTouchEvent(CoordinatorLayout parent, View child, MotionEvent ev) {
        return super.onTouchEvent(parent, child, ev);
    }

    @Override
    @NonNull
    protected AnimatorSet onCreateExpandedStateChangeAnimation(View dependency, final View child, final boolean expanded, boolean isAnimating) {
        ArrayList<Animator> animations = new ArrayList<Animator>();
        ArrayList<Animator.AnimatorListener> listeners = new ArrayList<Animator.AnimatorListener>();
        this.createScrimAnimation(child, expanded, isAnimating, animations, listeners);
        AnimatorSet set = new AnimatorSet();
        AnimatorSetCompat.playTogether((AnimatorSet)set, animations);
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (expanded) {
                    child.setVisibility(0);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (!expanded) {
                    child.setVisibility(4);
                }
            }
        });
        return set;
    }

    private void createScrimAnimation(View child, boolean expanded, boolean currentlyAnimating, List<Animator> animations, List<Animator.AnimatorListener> unusedListeners) {
        ObjectAnimator animator;
        MotionTiming timing;
        MotionTiming motionTiming = timing = expanded ? this.expandTiming : this.collapseTiming;
        if (expanded) {
            if (!currentlyAnimating) {
                child.setAlpha(0.0f);
            }
            animator = ObjectAnimator.ofFloat((Object)child, (Property)View.ALPHA, (float[])new float[]{1.0f});
        } else {
            animator = ObjectAnimator.ofFloat((Object)child, (Property)View.ALPHA, (float[])new float[]{0.0f});
        }
        timing.apply((Animator)animator);
        animations.add((Animator)animator);
    }
}

