/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.util.Log;
import java.lang.reflect.Method;

class DrawableUtils {
    private static final String LOG_TAG = "DrawableUtils";
    private static Method sSetConstantStateMethod;
    private static boolean sSetConstantStateMethodFetched;

    private DrawableUtils() {
    }

    static boolean setContainerConstantState(DrawableContainer drawable2, Drawable.ConstantState constantState) {
        return DrawableUtils.setContainerConstantStateV9(drawable2, constantState);
    }

    private static boolean setContainerConstantStateV9(DrawableContainer drawable2, Drawable.ConstantState constantState) {
        if (!sSetConstantStateMethodFetched) {
            try {
                sSetConstantStateMethod = DrawableContainer.class.getDeclaredMethod("setConstantState", DrawableContainer.DrawableContainerState.class);
                sSetConstantStateMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Log.e((String)LOG_TAG, (String)"Could not fetch setConstantState(). Oh well.");
            }
            sSetConstantStateMethodFetched = true;
        }
        if (sSetConstantStateMethod != null) {
            try {
                sSetConstantStateMethod.invoke((Object)drawable2, constantState);
                return true;
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)"Could not invoke setConstantState(). Oh well.");
            }
        }
        return false;
    }
}

