/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.internal;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.StyleRes;
import android.support.design.R;
import android.support.design.internal.NavigationMenuItemView;
import android.support.design.internal.NavigationMenuView;
import android.support.design.internal.ParcelableSparseArray;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.view.menu.MenuItemImpl;
import android.support.v7.view.menu.MenuPresenter;
import android.support.v7.view.menu.MenuView;
import android.support.v7.view.menu.SubMenuBuilder;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class NavigationMenuPresenter
implements MenuPresenter {
    private static final String STATE_HIERARCHY = "android:menu:list";
    private static final String STATE_ADAPTER = "android:menu:adapter";
    private static final String STATE_HEADER = "android:menu:header";
    private NavigationMenuView mMenuView;
    LinearLayout mHeaderLayout;
    private MenuPresenter.Callback mCallback;
    MenuBuilder mMenu;
    private int mId;
    NavigationMenuAdapter mAdapter;
    LayoutInflater mLayoutInflater;
    int mTextAppearance;
    boolean mTextAppearanceSet;
    ColorStateList mTextColor;
    ColorStateList mIconTintList;
    Drawable mItemBackground;
    private int mPaddingTopDefault;
    int mPaddingSeparator;
    final View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            NavigationMenuItemView itemView = (NavigationMenuItemView)v;
            NavigationMenuPresenter.this.setUpdateSuspended(true);
            MenuItemImpl item = itemView.getItemData();
            boolean result = NavigationMenuPresenter.this.mMenu.performItemAction((MenuItem)item, (MenuPresenter)NavigationMenuPresenter.this, 0);
            if (item != null && item.isCheckable() && result) {
                NavigationMenuPresenter.this.mAdapter.setCheckedItem(item);
            }
            NavigationMenuPresenter.this.setUpdateSuspended(false);
            NavigationMenuPresenter.this.updateMenuView(false);
        }
    };

    public void initForMenu(Context context, MenuBuilder menu) {
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        this.mMenu = menu;
        Resources res = context.getResources();
        this.mPaddingSeparator = res.getDimensionPixelOffset(R.dimen.design_navigation_separator_vertical_padding);
    }

    public MenuView getMenuView(ViewGroup root) {
        if (this.mMenuView == null) {
            this.mMenuView = (NavigationMenuView)this.mLayoutInflater.inflate(R.layout.design_navigation_menu, root, false);
            if (this.mAdapter == null) {
                this.mAdapter = new NavigationMenuAdapter();
            }
            this.mHeaderLayout = (LinearLayout)this.mLayoutInflater.inflate(R.layout.design_navigation_item_header, (ViewGroup)this.mMenuView, false);
            this.mMenuView.setAdapter(this.mAdapter);
        }
        return this.mMenuView;
    }

    public void updateMenuView(boolean cleared) {
        if (this.mAdapter != null) {
            this.mAdapter.update();
        }
    }

    public void setCallback(MenuPresenter.Callback cb) {
        this.mCallback = cb;
    }

    public boolean onSubMenuSelected(SubMenuBuilder subMenu) {
        return false;
    }

    public void onCloseMenu(MenuBuilder menu, boolean allMenusAreClosing) {
        if (this.mCallback != null) {
            this.mCallback.onCloseMenu(menu, allMenusAreClosing);
        }
    }

    public boolean flagActionItems() {
        return false;
    }

    public boolean expandItemActionView(MenuBuilder menu, MenuItemImpl item) {
        return false;
    }

    public boolean collapseItemActionView(MenuBuilder menu, MenuItemImpl item) {
        return false;
    }

    public int getId() {
        return this.mId;
    }

    public void setId(int id2) {
        this.mId = id2;
    }

    public Parcelable onSaveInstanceState() {
        if (Build.VERSION.SDK_INT >= 11) {
            Bundle state = new Bundle();
            if (this.mMenuView != null) {
                SparseArray hierarchy = new SparseArray();
                this.mMenuView.saveHierarchyState(hierarchy);
                state.putSparseParcelableArray(STATE_HIERARCHY, hierarchy);
            }
            if (this.mAdapter != null) {
                state.putBundle(STATE_ADAPTER, this.mAdapter.createInstanceState());
            }
            if (this.mHeaderLayout != null) {
                SparseArray header = new SparseArray();
                this.mHeaderLayout.saveHierarchyState(header);
                state.putSparseParcelableArray(STATE_HEADER, header);
            }
            return state;
        }
        return null;
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable instanceof Bundle) {
            SparseArray header;
            Bundle adapterState;
            Bundle state = (Bundle)parcelable;
            SparseArray hierarchy = state.getSparseParcelableArray(STATE_HIERARCHY);
            if (hierarchy != null) {
                this.mMenuView.restoreHierarchyState(hierarchy);
            }
            if ((adapterState = state.getBundle(STATE_ADAPTER)) != null) {
                this.mAdapter.restoreInstanceState(adapterState);
            }
            if ((header = state.getSparseParcelableArray(STATE_HEADER)) != null) {
                this.mHeaderLayout.restoreHierarchyState(header);
            }
        }
    }

    public void setCheckedItem(MenuItemImpl item) {
        this.mAdapter.setCheckedItem(item);
    }

    public View inflateHeaderView(@LayoutRes int res) {
        View view = this.mLayoutInflater.inflate(res, (ViewGroup)this.mHeaderLayout, false);
        this.addHeaderView(view);
        return view;
    }

    public void addHeaderView(@NonNull View view) {
        this.mHeaderLayout.addView(view);
        this.mMenuView.setPadding(0, 0, 0, this.mMenuView.getPaddingBottom());
    }

    public void removeHeaderView(@NonNull View view) {
        this.mHeaderLayout.removeView(view);
        if (this.mHeaderLayout.getChildCount() == 0) {
            this.mMenuView.setPadding(0, this.mPaddingTopDefault, 0, this.mMenuView.getPaddingBottom());
        }
    }

    public int getHeaderCount() {
        return this.mHeaderLayout.getChildCount();
    }

    public View getHeaderView(int index) {
        return this.mHeaderLayout.getChildAt(index);
    }

    @Nullable
    public ColorStateList getItemTintList() {
        return this.mIconTintList;
    }

    public void setItemIconTintList(@Nullable ColorStateList tint) {
        this.mIconTintList = tint;
        this.updateMenuView(false);
    }

    @Nullable
    public ColorStateList getItemTextColor() {
        return this.mTextColor;
    }

    public void setItemTextColor(@Nullable ColorStateList textColor) {
        this.mTextColor = textColor;
        this.updateMenuView(false);
    }

    public void setItemTextAppearance(@StyleRes int resId) {
        this.mTextAppearance = resId;
        this.mTextAppearanceSet = true;
        this.updateMenuView(false);
    }

    @Nullable
    public Drawable getItemBackground() {
        return this.mItemBackground;
    }

    public void setItemBackground(@Nullable Drawable itemBackground) {
        this.mItemBackground = itemBackground;
        this.updateMenuView(false);
    }

    public void setUpdateSuspended(boolean updateSuspended) {
        if (this.mAdapter != null) {
            this.mAdapter.setUpdateSuspended(updateSuspended);
        }
    }

    public void dispatchApplyWindowInsets(WindowInsetsCompat insets) {
        int top = insets.getSystemWindowInsetTop();
        if (this.mPaddingTopDefault != top) {
            this.mPaddingTopDefault = top;
            if (this.mHeaderLayout.getChildCount() == 0) {
                this.mMenuView.setPadding(0, this.mPaddingTopDefault, 0, this.mMenuView.getPaddingBottom());
            }
        }
        ViewCompat.dispatchApplyWindowInsets((View)this.mHeaderLayout, (WindowInsetsCompat)insets);
    }

    private static class NavigationMenuHeaderItem
    implements NavigationMenuItem {
        NavigationMenuHeaderItem() {
        }
    }

    private static class NavigationMenuSeparatorItem
    implements NavigationMenuItem {
        private final int mPaddingTop;
        private final int mPaddingBottom;

        public NavigationMenuSeparatorItem(int paddingTop, int paddingBottom) {
            this.mPaddingTop = paddingTop;
            this.mPaddingBottom = paddingBottom;
        }

        public int getPaddingTop() {
            return this.mPaddingTop;
        }

        public int getPaddingBottom() {
            return this.mPaddingBottom;
        }
    }

    private static class NavigationMenuTextItem
    implements NavigationMenuItem {
        private final MenuItemImpl mMenuItem;
        boolean needsEmptyIcon;

        NavigationMenuTextItem(MenuItemImpl item) {
            this.mMenuItem = item;
        }

        public MenuItemImpl getMenuItem() {
            return this.mMenuItem;
        }
    }

    private static interface NavigationMenuItem {
    }

    private class NavigationMenuAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        private static final String STATE_CHECKED_ITEM = "android:menu:checked";
        private static final String STATE_ACTION_VIEWS = "android:menu:action_views";
        private static final int VIEW_TYPE_NORMAL = 0;
        private static final int VIEW_TYPE_SUBHEADER = 1;
        private static final int VIEW_TYPE_SEPARATOR = 2;
        private static final int VIEW_TYPE_HEADER = 3;
        private final ArrayList<NavigationMenuItem> mItems = new ArrayList();
        private MenuItemImpl mCheckedItem;
        private boolean mUpdateSuspended;

        NavigationMenuAdapter() {
            this.prepareMenuItems();
        }

        public long getItemId(int position) {
            return position;
        }

        public int getItemCount() {
            return this.mItems.size();
        }

        public int getItemViewType(int position) {
            NavigationMenuItem item = this.mItems.get(position);
            if (item instanceof NavigationMenuSeparatorItem) {
                return 2;
            }
            if (item instanceof NavigationMenuHeaderItem) {
                return 3;
            }
            if (item instanceof NavigationMenuTextItem) {
                NavigationMenuTextItem textItem = (NavigationMenuTextItem)item;
                if (textItem.getMenuItem().hasSubMenu()) {
                    return 1;
                }
                return 0;
            }
            throw new RuntimeException("Unknown item type.");
        }

        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            switch (viewType) {
                case 0: {
                    return new NormalViewHolder(NavigationMenuPresenter.this.mLayoutInflater, parent, NavigationMenuPresenter.this.mOnClickListener);
                }
                case 1: {
                    return new SubheaderViewHolder(NavigationMenuPresenter.this.mLayoutInflater, parent);
                }
                case 2: {
                    return new SeparatorViewHolder(NavigationMenuPresenter.this.mLayoutInflater, parent);
                }
                case 3: {
                    return new HeaderViewHolder((View)NavigationMenuPresenter.this.mHeaderLayout);
                }
            }
            return null;
        }

        public void onBindViewHolder(ViewHolder holder, int position) {
            switch (this.getItemViewType(position)) {
                case 0: {
                    NavigationMenuItemView itemView = (NavigationMenuItemView)holder.itemView;
                    itemView.setIconTintList(NavigationMenuPresenter.this.mIconTintList);
                    if (NavigationMenuPresenter.this.mTextAppearanceSet) {
                        itemView.setTextAppearance(NavigationMenuPresenter.this.mTextAppearance);
                    }
                    if (NavigationMenuPresenter.this.mTextColor != null) {
                        itemView.setTextColor(NavigationMenuPresenter.this.mTextColor);
                    }
                    ViewCompat.setBackground((View)itemView, NavigationMenuPresenter.this.mItemBackground != null ? NavigationMenuPresenter.this.mItemBackground.getConstantState().newDrawable() : null);
                    NavigationMenuTextItem item = (NavigationMenuTextItem)this.mItems.get(position);
                    itemView.setNeedsEmptyIcon(item.needsEmptyIcon);
                    itemView.initialize(item.getMenuItem(), 0);
                    break;
                }
                case 1: {
                    TextView subHeader = (TextView)holder.itemView;
                    NavigationMenuTextItem item = (NavigationMenuTextItem)this.mItems.get(position);
                    subHeader.setText(item.getMenuItem().getTitle());
                    break;
                }
                case 2: {
                    NavigationMenuSeparatorItem item = (NavigationMenuSeparatorItem)this.mItems.get(position);
                    holder.itemView.setPadding(0, item.getPaddingTop(), 0, item.getPaddingBottom());
                    break;
                }
            }
        }

        public void onViewRecycled(ViewHolder holder) {
            if (holder instanceof NormalViewHolder) {
                ((NavigationMenuItemView)holder.itemView).recycle();
            }
        }

        public void update() {
            this.prepareMenuItems();
            this.notifyDataSetChanged();
        }

        private void prepareMenuItems() {
            if (this.mUpdateSuspended) {
                return;
            }
            this.mUpdateSuspended = true;
            this.mItems.clear();
            this.mItems.add(new NavigationMenuHeaderItem());
            int currentGroupId = -1;
            int currentGroupStart = 0;
            boolean currentGroupHasIcon = false;
            int totalSize = NavigationMenuPresenter.this.mMenu.getVisibleItems().size();
            for (int i = 0; i < totalSize; ++i) {
                MenuItemImpl item = (MenuItemImpl)NavigationMenuPresenter.this.mMenu.getVisibleItems().get(i);
                if (item.isChecked()) {
                    this.setCheckedItem(item);
                }
                if (item.isCheckable()) {
                    item.setExclusiveCheckable(false);
                }
                if (item.hasSubMenu()) {
                    SubMenu subMenu = item.getSubMenu();
                    if (!subMenu.hasVisibleItems()) continue;
                    if (i != 0) {
                        this.mItems.add(new NavigationMenuSeparatorItem(NavigationMenuPresenter.this.mPaddingSeparator, 0));
                    }
                    this.mItems.add(new NavigationMenuTextItem(item));
                    boolean subMenuHasIcon = false;
                    int subMenuStart = this.mItems.size();
                    int size = subMenu.size();
                    for (int j = 0; j < size; ++j) {
                        MenuItemImpl subMenuItem = (MenuItemImpl)subMenu.getItem(j);
                        if (!subMenuItem.isVisible()) continue;
                        if (!subMenuHasIcon && subMenuItem.getIcon() != null) {
                            subMenuHasIcon = true;
                        }
                        if (subMenuItem.isCheckable()) {
                            subMenuItem.setExclusiveCheckable(false);
                        }
                        if (item.isChecked()) {
                            this.setCheckedItem(item);
                        }
                        this.mItems.add(new NavigationMenuTextItem(subMenuItem));
                    }
                    if (!subMenuHasIcon) continue;
                    this.appendTransparentIconIfMissing(subMenuStart, this.mItems.size());
                    continue;
                }
                int groupId = item.getGroupId();
                if (groupId != currentGroupId) {
                    currentGroupStart = this.mItems.size();
                    boolean bl = currentGroupHasIcon = item.getIcon() != null;
                    if (i != 0) {
                        ++currentGroupStart;
                        this.mItems.add(new NavigationMenuSeparatorItem(NavigationMenuPresenter.this.mPaddingSeparator, NavigationMenuPresenter.this.mPaddingSeparator));
                    }
                } else if (!currentGroupHasIcon && item.getIcon() != null) {
                    currentGroupHasIcon = true;
                    this.appendTransparentIconIfMissing(currentGroupStart, this.mItems.size());
                }
                NavigationMenuTextItem textItem = new NavigationMenuTextItem(item);
                textItem.needsEmptyIcon = currentGroupHasIcon;
                this.mItems.add(textItem);
                currentGroupId = groupId;
            }
            this.mUpdateSuspended = false;
        }

        private void appendTransparentIconIfMissing(int startIndex, int endIndex) {
            for (int i = startIndex; i < endIndex; ++i) {
                NavigationMenuTextItem textItem = (NavigationMenuTextItem)this.mItems.get(i);
                textItem.needsEmptyIcon = true;
            }
        }

        public void setCheckedItem(MenuItemImpl checkedItem) {
            if (this.mCheckedItem == checkedItem || !checkedItem.isCheckable()) {
                return;
            }
            if (this.mCheckedItem != null) {
                this.mCheckedItem.setChecked(false);
            }
            this.mCheckedItem = checkedItem;
            checkedItem.setChecked(true);
        }

        public Bundle createInstanceState() {
            Bundle state = new Bundle();
            if (this.mCheckedItem != null) {
                state.putInt(STATE_CHECKED_ITEM, this.mCheckedItem.getItemId());
            }
            SparseArray actionViewStates = new SparseArray();
            for (NavigationMenuItem navigationMenuItem : this.mItems) {
                MenuItemImpl item;
                View actionView;
                if (!(navigationMenuItem instanceof NavigationMenuTextItem) || (actionView = (item = ((NavigationMenuTextItem)navigationMenuItem).getMenuItem()) != null ? item.getActionView() : null) == null) continue;
                ParcelableSparseArray container = new ParcelableSparseArray();
                actionView.saveHierarchyState((SparseArray)container);
                actionViewStates.put(item.getItemId(), (Object)container);
            }
            state.putSparseParcelableArray(STATE_ACTION_VIEWS, actionViewStates);
            return state;
        }

        public void restoreInstanceState(Bundle state) {
            int checkedItem = state.getInt(STATE_CHECKED_ITEM, 0);
            if (checkedItem != 0) {
                this.mUpdateSuspended = true;
                for (NavigationMenuItem item : this.mItems) {
                    MenuItemImpl menuItem;
                    if (!(item instanceof NavigationMenuTextItem) || (menuItem = ((NavigationMenuTextItem)item).getMenuItem()) == null || menuItem.getItemId() != checkedItem) continue;
                    this.setCheckedItem(menuItem);
                    break;
                }
                this.mUpdateSuspended = false;
                this.prepareMenuItems();
            }
            SparseArray actionViewStates = state.getSparseParcelableArray(STATE_ACTION_VIEWS);
            for (NavigationMenuItem navigationMenuItem : this.mItems) {
                MenuItemImpl item;
                View actionView;
                if (!(navigationMenuItem instanceof NavigationMenuTextItem) || (actionView = (item = ((NavigationMenuTextItem)navigationMenuItem).getMenuItem()) != null ? item.getActionView() : null) == null) continue;
                actionView.restoreHierarchyState((SparseArray)actionViewStates.get(item.getItemId()));
            }
        }

        public void setUpdateSuspended(boolean updateSuspended) {
            this.mUpdateSuspended = updateSuspended;
        }
    }

    private static class HeaderViewHolder
    extends ViewHolder {
        public HeaderViewHolder(View itemView) {
            super(itemView);
        }
    }

    private static class SeparatorViewHolder
    extends ViewHolder {
        public SeparatorViewHolder(LayoutInflater inflater, ViewGroup parent) {
            super(inflater.inflate(R.layout.design_navigation_item_separator, parent, false));
        }
    }

    private static class SubheaderViewHolder
    extends ViewHolder {
        public SubheaderViewHolder(LayoutInflater inflater, ViewGroup parent) {
            super(inflater.inflate(R.layout.design_navigation_item_subheader, parent, false));
        }
    }

    private static class NormalViewHolder
    extends ViewHolder {
        public NormalViewHolder(LayoutInflater inflater, ViewGroup parent, View.OnClickListener listener) {
            super(inflater.inflate(R.layout.design_navigation_item, parent, false));
            this.itemView.setOnClickListener(listener);
        }
    }

    private static abstract class ViewHolder
    extends RecyclerView.ViewHolder {
        public ViewHolder(View itemView) {
            super(itemView);
        }
    }
}

