/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.chip;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.AnimatorRes;
import android.support.annotation.BoolRes;
import android.support.annotation.CallSuper;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.support.design.R;
import android.support.design.animation.MotionSpec;
import android.support.design.chip.ChipDrawable;
import android.support.design.internal.ViewUtils;
import android.support.design.resources.TextAppearance;
import android.support.design.ripple.RippleUtils;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.widget.ExploreByTouchHelper;
import android.support.v7.widget.AppCompatCheckBox;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.view.ViewParent;
import android.widget.CompoundButton;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class Chip
extends AppCompatCheckBox
implements ChipDrawable.Delegate {
    private static final String TAG = "Chip";
    private static final int CLOSE_ICON_VIRTUAL_ID = 0;
    private static final Rect EMPTY_BOUNDS = new Rect();
    private static final int[] SELECTED_STATE = new int[]{0x10100A1};
    private static final String NAMESPACE_ANDROID = "http://schemas.android.com/apk/res/android";
    @Nullable
    private ChipDrawable chipDrawable;
    @Nullable
    private RippleDrawable ripple;
    @Nullable
    private View.OnClickListener onCloseIconClickListener;
    @Nullable
    private CompoundButton.OnCheckedChangeListener onCheckedChangeListenerInternal;
    private boolean deferredCheckedValue;
    private int focusedVirtualView = Integer.MIN_VALUE;
    private boolean closeIconPressed;
    private boolean closeIconHovered;
    private boolean closeIconFocused;
    private final ChipTouchHelper touchHelper;
    private final Rect rect = new Rect();
    private final RectF rectF = new RectF();

    public Chip(Context context) {
        this(context, null);
    }

    public Chip(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.chipStyle);
    }

    public Chip(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.validateAttributes(attrs);
        ChipDrawable drawable2 = ChipDrawable.createFromAttributes(context, attrs, defStyleAttr, R.style.Widget_MaterialComponents_Chip_Action);
        this.setChipDrawable(drawable2);
        this.setText(null);
        this.touchHelper = new ChipTouchHelper(this);
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)this.touchHelper);
        ViewCompat.setImportantForAccessibility((View)this, (int)1);
        this.initOutlineProvider();
        this.setChecked(this.deferredCheckedValue);
    }

    private void validateAttributes(@Nullable AttributeSet attributeSet) {
        if (attributeSet == null) {
            return;
        }
        if (attributeSet.getAttributeValue(NAMESPACE_ANDROID, "background") != null) {
            throw new UnsupportedOperationException("Do not set the background; Chip manages its own background drawable.");
        }
        if (attributeSet.getAttributeValue(NAMESPACE_ANDROID, "drawableLeft") != null) {
            throw new UnsupportedOperationException("Please set left drawable using R.attr#chipIcon.");
        }
        if (attributeSet.getAttributeValue(NAMESPACE_ANDROID, "drawableStart") != null) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (attributeSet.getAttributeValue(NAMESPACE_ANDROID, "drawableEnd") != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        if (attributeSet.getAttributeValue(NAMESPACE_ANDROID, "drawableRight") != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        if (!attributeSet.getAttributeBooleanValue(NAMESPACE_ANDROID, "singleLine", true) || attributeSet.getAttributeIntValue(NAMESPACE_ANDROID, "lines", 1) != 1 || attributeSet.getAttributeIntValue(NAMESPACE_ANDROID, "minLines", 1) != 1 || attributeSet.getAttributeIntValue(NAMESPACE_ANDROID, "maxLines", 1) != 1) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
    }

    private void initOutlineProvider() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setOutlineProvider(new ViewOutlineProvider(){

                @TargetApi(value=21)
                public void getOutline(View view, Outline outline) {
                    if (Chip.this.chipDrawable != null) {
                        Chip.this.chipDrawable.getOutline(outline);
                    } else {
                        outline.setAlpha(0.0f);
                    }
                }
            });
        }
    }

    public Drawable getChipDrawable() {
        return this.chipDrawable;
    }

    public void setChipDrawable(@NonNull ChipDrawable drawable2) {
        if (this.chipDrawable != drawable2) {
            this.unapplyChipDrawable(this.chipDrawable);
            this.chipDrawable = drawable2;
            this.applyChipDrawable(this.chipDrawable);
            if (RippleUtils.USE_FRAMEWORK_RIPPLE) {
                this.ripple = new RippleDrawable(RippleUtils.convertToRippleDrawableColor(this.chipDrawable.getRippleColor()), (Drawable)this.chipDrawable, null);
                this.chipDrawable.setUseCompatRipple(false);
                ViewCompat.setBackground((View)this, (Drawable)this.ripple);
            } else {
                this.chipDrawable.setUseCompatRipple(true);
                ViewCompat.setBackground((View)this, (Drawable)this.chipDrawable);
            }
        }
    }

    private void unapplyChipDrawable(@Nullable ChipDrawable chipDrawable) {
        if (chipDrawable != null) {
            chipDrawable.setDelegate(null);
        }
    }

    private void applyChipDrawable(@NonNull ChipDrawable chipDrawable) {
        chipDrawable.setDelegate(this);
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] state = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            Chip.mergeDrawableStates((int[])state, (int[])SELECTED_STATE);
        }
        return state;
    }

    public void setBackgroundTintList(@Nullable ColorStateList tint) {
        throw new UnsupportedOperationException("Do not set the background tint list; Chip manages its own background drawable.");
    }

    public void setBackgroundTintMode(@Nullable PorterDuff.Mode tintMode) {
        throw new UnsupportedOperationException("Do not set the background tint mode; Chip manages its own background drawable.");
    }

    public void setBackgroundColor(int color2) {
        throw new UnsupportedOperationException("Do not set the background color; Chip manages its own background drawable.");
    }

    public void setBackgroundResource(int resid) {
        throw new UnsupportedOperationException("Do not set the background resource; Chip manages its own background drawable.");
    }

    public void setBackground(Drawable background) {
        if (background != this.chipDrawable && background != this.ripple) {
            throw new UnsupportedOperationException("Do not set the background; Chip manages its own background drawable.");
        }
        super.setBackground(background);
    }

    public void setBackgroundDrawable(Drawable background) {
        if (background != this.chipDrawable && background != this.ripple) {
            throw new UnsupportedOperationException("Do not set the background drawable; Chip manages its own background drawable.");
        }
        super.setBackgroundDrawable(background);
    }

    public void setCompoundDrawables(@Nullable Drawable left, @Nullable Drawable top, @Nullable Drawable right, @Nullable Drawable bottom) {
        if (left != null) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (right != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawables(left, top, right, bottom);
    }

    public void setCompoundDrawablesWithIntrinsicBounds(int left, int top, int right, int bottom) {
        if (left != 0) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (right != 0) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
    }

    public void setCompoundDrawablesWithIntrinsicBounds(@Nullable Drawable left, @Nullable Drawable top, @Nullable Drawable right, @Nullable Drawable bottom) {
        if (left != null) {
            throw new UnsupportedOperationException("Please set left drawable using R.attr#chipIcon.");
        }
        if (right != null) {
            throw new UnsupportedOperationException("Please set right drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
    }

    public void setCompoundDrawablesRelative(@Nullable Drawable start, @Nullable Drawable top, @Nullable Drawable end, @Nullable Drawable bottom) {
        if (start != null) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (end != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesRelative(start, top, end, bottom);
    }

    public void setCompoundDrawablesRelativeWithIntrinsicBounds(int start, int top, int end, int bottom) {
        if (start != 0) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (end != 0) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesRelativeWithIntrinsicBounds(start, top, end, bottom);
    }

    public void setCompoundDrawablesRelativeWithIntrinsicBounds(@Nullable Drawable start, @Nullable Drawable top, @Nullable Drawable end, @Nullable Drawable bottom) {
        if (start != null) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (end != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesRelativeWithIntrinsicBounds(start, top, end, bottom);
    }

    public TextUtils.TruncateAt getEllipsize() {
        return this.chipDrawable != null ? this.chipDrawable.getEllipsize() : null;
    }

    public void setEllipsize(TextUtils.TruncateAt where) {
        if (where == TextUtils.TruncateAt.MARQUEE) {
            throw new UnsupportedOperationException("Text within a chip are not allowed to scroll.");
        }
        if (this.chipDrawable != null) {
            this.chipDrawable.setEllipsize(where);
        }
    }

    public void setSingleLine(boolean singleLine) {
        if (!singleLine) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        super.setSingleLine(singleLine);
    }

    public void setLines(int lines) {
        if (lines > 1) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        super.setLines(lines);
    }

    public void setMinLines(int minLines) {
        if (minLines > 1) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        super.setMinLines(minLines);
    }

    public void setMaxLines(int maxLines) {
        if (maxLines > 1) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        super.setMaxLines(maxLines);
    }

    @Override
    public void onChipDrawableSizeChange() {
        this.requestLayout();
        if (Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    public void setChecked(boolean checked) {
        if (this.chipDrawable == null) {
            this.deferredCheckedValue = checked;
        } else if (this.chipDrawable.isCheckable()) {
            boolean wasChecked = this.isChecked();
            super.setChecked(checked);
            if (wasChecked != checked && this.onCheckedChangeListenerInternal != null) {
                this.onCheckedChangeListenerInternal.onCheckedChanged((CompoundButton)this, checked);
            }
        }
    }

    void setOnCheckedChangeListenerInternal(CompoundButton.OnCheckedChangeListener listener) {
        this.onCheckedChangeListenerInternal = listener;
    }

    public void setOnCloseIconClickListener(View.OnClickListener listener) {
        this.onCloseIconClickListener = listener;
    }

    @CallSuper
    public boolean performCloseIconClick() {
        boolean result;
        this.playSoundEffect(0);
        if (this.onCloseIconClickListener != null) {
            this.onCloseIconClickListener.onClick((View)this);
            result = true;
        } else {
            result = false;
        }
        this.touchHelper.sendEventForVirtualView(0, 1);
        return result;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean handled = false;
        int action = event.getActionMasked();
        boolean eventInCloseIcon = this.getCloseIconTouchBounds().contains(event.getX(), event.getY());
        switch (action) {
            case 0: {
                if (!eventInCloseIcon) break;
                this.setCloseIconPressed(true);
                handled = true;
                break;
            }
            case 2: {
                if (!this.closeIconPressed) break;
                if (!eventInCloseIcon) {
                    this.setCloseIconPressed(false);
                }
                handled = true;
                break;
            }
            case 1: {
                if (this.closeIconPressed) {
                    this.performCloseIconClick();
                    handled = true;
                }
            }
            case 3: {
                this.setCloseIconPressed(false);
                break;
            }
        }
        return handled || super.onTouchEvent(event);
    }

    public boolean onHoverEvent(MotionEvent event) {
        int action = event.getActionMasked();
        switch (action) {
            case 7: {
                this.setCloseIconHovered(this.getCloseIconTouchBounds().contains(event.getX(), event.getY()));
                break;
            }
            case 10: {
                this.setCloseIconHovered(false);
                break;
            }
        }
        return super.onHoverEvent(event);
    }

    @SuppressLint(value={"PrivateApi"})
    private boolean handleAccessibilityExit(MotionEvent event) {
        if (event.getAction() == 10) {
            try {
                Field f = ExploreByTouchHelper.class.getDeclaredField("mHoveredVirtualViewId");
                f.setAccessible(true);
                int mHoveredVirtualViewId = (Integer)f.get((Object)this.touchHelper);
                if (mHoveredVirtualViewId != Integer.MIN_VALUE) {
                    Method m = ExploreByTouchHelper.class.getDeclaredMethod("updateHoveredVirtualView", Integer.TYPE);
                    m.setAccessible(true);
                    m.invoke((Object)this.touchHelper, Integer.MIN_VALUE);
                    return true;
                }
            }
            catch (NoSuchMethodException e) {
                Log.e((String)TAG, (String)"Unable to send Accessibility Exit event", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)"Unable to send Accessibility Exit event", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.e((String)TAG, (String)"Unable to send Accessibility Exit event", (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                Log.e((String)TAG, (String)"Unable to send Accessibility Exit event", (Throwable)e);
            }
        }
        return false;
    }

    protected boolean dispatchHoverEvent(MotionEvent event) {
        return this.handleAccessibilityExit(event) || this.touchHelper.dispatchHoverEvent(event) || super.dispatchHoverEvent(event);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return this.touchHelper.dispatchKeyEvent(event) || super.dispatchKeyEvent(event);
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        if (focused) {
            this.setFocusedVirtualView(-1);
        } else {
            this.setFocusedVirtualView(Integer.MIN_VALUE);
        }
        this.invalidate();
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        this.touchHelper.onFocusChanged(focused, direction, previouslyFocusedRect);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean focusChanged = false;
        switch (event.getKeyCode()) {
            case 21: {
                if (!event.hasNoModifiers()) break;
                focusChanged = this.moveFocus(ViewUtils.isLayoutRtl((View)this));
                break;
            }
            case 22: {
                if (!event.hasNoModifiers()) break;
                focusChanged = this.moveFocus(!ViewUtils.isLayoutRtl((View)this));
                break;
            }
            case 23: 
            case 66: {
                switch (this.focusedVirtualView) {
                    case -1: {
                        this.performClick();
                        return true;
                    }
                    case 0: {
                        this.performCloseIconClick();
                        return true;
                    }
                }
                break;
            }
            case 61: {
                int focusChangeDirection = 0;
                if (event.hasNoModifiers()) {
                    focusChangeDirection = 2;
                } else if (event.hasModifiers(1)) {
                    focusChangeDirection = 1;
                }
                if (focusChangeDirection == 0) break;
                ViewParent parent = this.getParent();
                Chip nextFocus = this;
                while ((nextFocus = nextFocus.focusSearch(focusChangeDirection)) != null && nextFocus != this && nextFocus.getParent() == parent) {
                }
                if (nextFocus == null) break;
                nextFocus.requestFocus();
                return true;
            }
        }
        if (focusChanged) {
            this.invalidate();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private boolean moveFocus(boolean positive) {
        this.ensureFocus();
        boolean focusChanged = false;
        if (positive) {
            if (this.focusedVirtualView == -1) {
                this.setFocusedVirtualView(0);
                focusChanged = true;
            }
        } else if (this.focusedVirtualView == 0) {
            this.setFocusedVirtualView(-1);
            focusChanged = true;
        }
        return focusChanged;
    }

    private void ensureFocus() {
        if (this.focusedVirtualView == Integer.MIN_VALUE) {
            this.setFocusedVirtualView(-1);
        }
    }

    public void getFocusedRect(Rect r) {
        if (this.focusedVirtualView == 0) {
            r.set(this.getCloseIconTouchBoundsInt());
        } else {
            super.getFocusedRect(r);
        }
    }

    private void setFocusedVirtualView(int virtualView) {
        if (this.focusedVirtualView != virtualView) {
            if (this.focusedVirtualView == 0) {
                this.setCloseIconFocused(false);
            }
            this.focusedVirtualView = virtualView;
            if (virtualView == 0) {
                this.setCloseIconFocused(true);
            }
        }
    }

    private void setCloseIconPressed(boolean pressed) {
        if (this.closeIconPressed != pressed) {
            this.closeIconPressed = pressed;
            this.refreshDrawableState();
        }
    }

    private void setCloseIconHovered(boolean hovered) {
        if (this.closeIconHovered != hovered) {
            this.closeIconHovered = hovered;
            this.refreshDrawableState();
        }
    }

    private void setCloseIconFocused(boolean focused) {
        if (this.closeIconFocused != focused) {
            this.closeIconFocused = focused;
            this.refreshDrawableState();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        boolean changed = false;
        if (this.chipDrawable != null && this.chipDrawable.isCloseIconStateful()) {
            changed = this.chipDrawable.setCloseIconState(this.createCloseIconDrawableState());
        }
        if (changed) {
            this.invalidate();
        }
    }

    private int[] createCloseIconDrawableState() {
        int count = 0;
        if (this.isEnabled()) {
            ++count;
        }
        if (this.closeIconFocused) {
            ++count;
        }
        if (this.closeIconHovered) {
            ++count;
        }
        if (this.closeIconPressed) {
            ++count;
        }
        if (this.isChecked()) {
            ++count;
        }
        int[] stateSet = new int[count];
        int i = 0;
        if (this.isEnabled()) {
            stateSet[i] = 16842910;
            ++i;
        }
        if (this.closeIconFocused) {
            stateSet[i] = 16842908;
            ++i;
        }
        if (this.closeIconHovered) {
            stateSet[i] = 16843623;
            ++i;
        }
        if (this.closeIconPressed) {
            stateSet[i] = 16842919;
            ++i;
        }
        if (this.isChecked()) {
            stateSet[i] = 0x10100A1;
            ++i;
        }
        return stateSet;
    }

    private boolean hasCloseIcon() {
        return this.chipDrawable != null && this.chipDrawable.getCloseIcon() != null;
    }

    private RectF getCloseIconTouchBounds() {
        this.rectF.setEmpty();
        if (this.hasCloseIcon()) {
            this.chipDrawable.getCloseIconTouchBounds(this.rectF);
        }
        return this.rectF;
    }

    private Rect getCloseIconTouchBoundsInt() {
        RectF bounds = this.getCloseIconTouchBounds();
        this.rect.set((int)bounds.left, (int)bounds.top, (int)bounds.right, (int)bounds.bottom);
        return this.rect;
    }

    @TargetApi(value=24)
    public PointerIcon onResolvePointerIcon(MotionEvent event, int pointerIndex) {
        if (this.getCloseIconTouchBounds().contains(event.getX(), event.getY()) && this.isEnabled()) {
            return PointerIcon.getSystemIcon((Context)this.getContext(), (int)1002);
        }
        return null;
    }

    @Nullable
    public ColorStateList getChipBackgroundColor() {
        return this.chipDrawable != null ? this.chipDrawable.getChipBackgroundColor() : null;
    }

    public void setChipBackgroundColorResource(@ColorRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipBackgroundColorResource(id2);
        }
    }

    public void setChipBackgroundColor(@Nullable ColorStateList chipBackgroundColor) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipBackgroundColor(chipBackgroundColor);
        }
    }

    public float getChipMinHeight() {
        return this.chipDrawable != null ? this.chipDrawable.getChipMinHeight() : 0.0f;
    }

    public void setChipMinHeightResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipMinHeightResource(id2);
        }
    }

    public void setChipMinHeight(float minHeight) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipMinHeight(minHeight);
        }
    }

    public float getChipCornerRadius() {
        return this.chipDrawable != null ? this.chipDrawable.getChipCornerRadius() : 0.0f;
    }

    public void setChipCornerRadiusResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipCornerRadiusResource(id2);
        }
    }

    public void setChipCornerRadius(float chipCornerRadius) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipCornerRadius(chipCornerRadius);
        }
    }

    @Nullable
    public ColorStateList getChipStrokeColor() {
        return this.chipDrawable != null ? this.chipDrawable.getChipStrokeColor() : null;
    }

    public void setChipStrokeColorResource(@ColorRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipStrokeColorResource(id2);
        }
    }

    public void setChipStrokeColor(@Nullable ColorStateList chipStrokeColor) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipStrokeColor(chipStrokeColor);
        }
    }

    public float getChipStrokeWidth() {
        return this.chipDrawable != null ? this.chipDrawable.getChipStrokeWidth() : 0.0f;
    }

    public void setChipStrokeWidthResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipStrokeWidthResource(id2);
        }
    }

    public void setChipStrokeWidth(float chipStrokeWidth) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipStrokeWidth(chipStrokeWidth);
        }
    }

    @Nullable
    public ColorStateList getRippleColor() {
        return this.chipDrawable != null ? this.chipDrawable.getRippleColor() : null;
    }

    public void setRippleColorResource(@ColorRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setRippleColorResource(id2);
        }
    }

    public void setRippleColor(@Nullable ColorStateList rippleColor) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setRippleColor(rippleColor);
        }
    }

    @Nullable
    public CharSequence getChipText() {
        return this.chipDrawable != null ? this.chipDrawable.getText() : null;
    }

    public void setChipTextResource(@StringRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setTextResource(id2);
        }
    }

    public void setChipText(@Nullable CharSequence chipText) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setText(chipText);
        }
    }

    @Nullable
    public TextAppearance getTextAppearance() {
        return this.chipDrawable != null ? this.chipDrawable.getTextAppearance() : null;
    }

    public void setTextAppearanceResource(@StyleRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setTextAppearanceResource(id2);
        }
    }

    public void setTextAppearance(@Nullable TextAppearance textAppearance) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setTextAppearance(textAppearance);
        }
    }

    public boolean isChipIconEnabled() {
        return this.chipDrawable != null && this.chipDrawable.isChipIconEnabled();
    }

    public void setChipIconEnabledResource(@BoolRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipIconEnabledResource(id2);
        }
    }

    public void setChipIconEnabled(boolean chipIconEnabled) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipIconEnabled(chipIconEnabled);
        }
    }

    @Nullable
    public Drawable getChipIcon() {
        return this.chipDrawable != null ? this.chipDrawable.getChipIcon() : null;
    }

    public void setChipIconResource(@DrawableRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipIconResource(id2);
        }
    }

    public void setChipIcon(@Nullable Drawable chipIcon) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipIcon(chipIcon);
        }
    }

    public float getChipIconSize() {
        return this.chipDrawable != null ? this.chipDrawable.getChipIconSize() : 0.0f;
    }

    public void setChipIconSizeResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipIconSizeResource(id2);
        }
    }

    public void setChipIconSize(float chipIconSize) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipIconSize(chipIconSize);
        }
    }

    public boolean isCloseIconEnabled() {
        return this.chipDrawable != null && this.chipDrawable.isCloseIconEnabled();
    }

    public void setCloseIconEnabledResource(@BoolRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconEnabledResource(id2);
        }
    }

    public void setCloseIconEnabled(boolean closeIconEnabled) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconEnabled(closeIconEnabled);
        }
    }

    @Nullable
    public Drawable getCloseIcon() {
        return this.chipDrawable != null ? this.chipDrawable.getCloseIcon() : null;
    }

    public void setCloseIconResource(@DrawableRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconResource(id2);
        }
    }

    public void setCloseIcon(@Nullable Drawable closeIcon) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIcon(closeIcon);
        }
    }

    @Nullable
    public ColorStateList getCloseIconTint() {
        return this.chipDrawable != null ? this.chipDrawable.getCloseIconTint() : null;
    }

    public void setCloseIconTintResource(@ColorRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconTintResource(id2);
        }
    }

    public void setCloseIconTint(@Nullable ColorStateList closeIconTint) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconTint(closeIconTint);
        }
    }

    public float getCloseIconSize() {
        return this.chipDrawable != null ? this.chipDrawable.getCloseIconSize() : 0.0f;
    }

    public void setCloseIconSizeResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconSizeResource(id2);
        }
    }

    public void setCloseIconSize(float closeIconSize) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconSize(closeIconSize);
        }
    }

    public void setCloseIconContentDescription(@Nullable CharSequence closeIconContentDescription) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconContentDescription(closeIconContentDescription);
        }
    }

    @Nullable
    public CharSequence getCloseIconContentDescription() {
        return this.chipDrawable != null ? this.chipDrawable.getCloseIconContentDescription() : null;
    }

    public boolean isCheckable() {
        return this.chipDrawable != null && this.chipDrawable.isCheckable();
    }

    public void setCheckableResource(@BoolRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCheckableResource(id2);
        }
    }

    public void setCheckable(boolean checkable) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCheckable(checkable);
        }
    }

    public boolean isCheckedIconEnabled() {
        return this.chipDrawable != null && this.chipDrawable.isCheckedIconEnabled();
    }

    public void setCheckedIconEnabledResource(@BoolRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCheckedIconEnabledResource(id2);
        }
    }

    public void setCheckedIconEnabled(boolean checkedIconEnabled) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCheckedIconEnabled(checkedIconEnabled);
        }
    }

    @Nullable
    public Drawable getCheckedIcon() {
        return this.chipDrawable != null ? this.chipDrawable.getCheckedIcon() : null;
    }

    public void setCheckedIconResource(@DrawableRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCheckedIconResource(id2);
        }
    }

    public void setCheckedIcon(@Nullable Drawable checkedIcon) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCheckedIcon(checkedIcon);
        }
    }

    @Nullable
    public MotionSpec getShowMotionSpec() {
        return this.chipDrawable != null ? this.chipDrawable.getShowMotionSpec() : null;
    }

    public void setShowMotionSpecResource(@AnimatorRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setShowMotionSpecResource(id2);
        }
    }

    public void setShowMotionSpec(@Nullable MotionSpec showMotionSpec) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setShowMotionSpec(showMotionSpec);
        }
    }

    @Nullable
    public MotionSpec getHideMotionSpec() {
        return this.chipDrawable != null ? this.chipDrawable.getHideMotionSpec() : null;
    }

    public void setHideMotionSpecResource(@AnimatorRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setHideMotionSpecResource(id2);
        }
    }

    public void setHideMotionSpec(@Nullable MotionSpec hideMotionSpec) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setHideMotionSpec(hideMotionSpec);
        }
    }

    public float getChipStartPadding() {
        return this.chipDrawable != null ? this.chipDrawable.getChipStartPadding() : 0.0f;
    }

    public void setChipStartPaddingResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipStartPaddingResource(id2);
        }
    }

    public void setChipStartPadding(float chipStartPadding) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipStartPadding(chipStartPadding);
        }
    }

    public float getIconStartPadding() {
        return this.chipDrawable != null ? this.chipDrawable.getIconStartPadding() : 0.0f;
    }

    public void setIconStartPaddingResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setIconStartPaddingResource(id2);
        }
    }

    public void setIconStartPadding(float iconStartPadding) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setIconStartPadding(iconStartPadding);
        }
    }

    public float getIconEndPadding() {
        return this.chipDrawable != null ? this.chipDrawable.getIconEndPadding() : 0.0f;
    }

    public void setIconEndPaddingResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setIconEndPaddingResource(id2);
        }
    }

    public void setIconEndPadding(float iconEndPadding) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setIconEndPadding(iconEndPadding);
        }
    }

    public float getTextStartPadding() {
        return this.chipDrawable != null ? this.chipDrawable.getTextStartPadding() : 0.0f;
    }

    public void setTextStartPaddingResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setTextStartPaddingResource(id2);
        }
    }

    public void setTextStartPadding(float textStartPadding) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setTextStartPadding(textStartPadding);
        }
    }

    public float getTextEndPadding() {
        return this.chipDrawable != null ? this.chipDrawable.getTextEndPadding() : 0.0f;
    }

    public void setTextEndPaddingResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setTextEndPaddingResource(id2);
        }
    }

    public void setTextEndPadding(float textEndPadding) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setTextEndPadding(textEndPadding);
        }
    }

    public float getCloseIconStartPadding() {
        return this.chipDrawable != null ? this.chipDrawable.getCloseIconStartPadding() : 0.0f;
    }

    public void setCloseIconStartPaddingResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconStartPaddingResource(id2);
        }
    }

    public void setCloseIconStartPadding(float closeIconStartPadding) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconStartPadding(closeIconStartPadding);
        }
    }

    public float getCloseIconEndPadding() {
        return this.chipDrawable != null ? this.chipDrawable.getCloseIconEndPadding() : 0.0f;
    }

    public void setCloseIconEndPaddingResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconEndPaddingResource(id2);
        }
    }

    public void setCloseIconEndPadding(float closeIconEndPadding) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setCloseIconEndPadding(closeIconEndPadding);
        }
    }

    public float getChipEndPadding() {
        return this.chipDrawable != null ? this.chipDrawable.getChipEndPadding() : 0.0f;
    }

    public void setChipEndPaddingResource(@DimenRes int id2) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipEndPaddingResource(id2);
        }
    }

    public void setChipEndPadding(float chipEndPadding) {
        if (this.chipDrawable != null) {
            this.chipDrawable.setChipEndPadding(chipEndPadding);
        }
    }

    private class ChipTouchHelper
    extends ExploreByTouchHelper {
        ChipTouchHelper(Chip view) {
            super((View)view);
        }

        protected int getVirtualViewAt(float x, float y) {
            return Chip.this.hasCloseIcon() && Chip.this.getCloseIconTouchBounds().contains(x, y) ? 0 : -1;
        }

        protected void getVisibleVirtualViews(List<Integer> virtualViewIds) {
            if (Chip.this.hasCloseIcon()) {
                virtualViewIds.add(0);
            }
        }

        protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfoCompat node) {
            if (Chip.this.hasCloseIcon()) {
                CharSequence closeIconContentDescription = Chip.this.getCloseIconContentDescription();
                if (closeIconContentDescription != null) {
                    node.setContentDescription(closeIconContentDescription);
                } else {
                    CharSequence chipText = Chip.this.getChipText();
                    node.setContentDescription((CharSequence)Chip.this.getContext().getString(R.string.mtrl_chip_close_icon_content_description, new Object[]{!TextUtils.isEmpty((CharSequence)chipText) ? chipText : ""}).trim());
                }
                node.setBoundsInParent(Chip.this.getCloseIconTouchBoundsInt());
                node.addAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK);
                node.setEnabled(Chip.this.isEnabled());
            } else {
                node.setContentDescription((CharSequence)"");
                node.setBoundsInParent(EMPTY_BOUNDS);
            }
        }

        protected void onPopulateNodeForHost(AccessibilityNodeInfoCompat node) {
            String chipText;
            node.setCheckable(Chip.this.chipDrawable != null && Chip.this.chipDrawable.isCheckable());
            node.setClassName((CharSequence)Chip.class.getName());
            CharSequence charSequence = chipText = Chip.this.chipDrawable != null ? Chip.this.chipDrawable.getText() : "";
            if (Build.VERSION.SDK_INT >= 23) {
                node.setText((CharSequence)chipText);
            } else {
                node.setContentDescription((CharSequence)chipText);
            }
        }

        protected boolean onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
            if (action == 16 && virtualViewId == 0) {
                return Chip.this.performCloseIconClick();
            }
            return false;
        }
    }
}

