/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.app.PendingIntent;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.MediaRouteDialogHelper;
import android.support.v7.app.MediaRouteExpandCollapseButton;
import android.support.v7.app.MediaRouteVolumeSlider;
import android.support.v7.app.MediaRouterThemeHelper;
import android.support.v7.app.OverlayListView;
import android.support.v7.graphics.Palette;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.support.v7.mediarouter.R;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.view.animation.TranslateAnimation;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class MediaRouteControllerDialog
extends AlertDialog {
    static final String TAG = "MediaRouteCtrlDialog";
    static final boolean DEBUG = Log.isLoggable((String)"MediaRouteCtrlDialog", (int)3);
    static final int VOLUME_UPDATE_DELAY_MILLIS = 500;
    static final int CONNECTION_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(30L);
    private static final int BUTTON_NEUTRAL_RES_ID = 16908315;
    static final int BUTTON_DISCONNECT_RES_ID = 16908314;
    static final int BUTTON_STOP_RES_ID = 16908313;
    final MediaRouter mRouter;
    private final MediaRouterCallback mCallback;
    final MediaRouter.RouteInfo mRoute;
    Context mContext;
    private boolean mCreated;
    private boolean mAttachedToWindow;
    private int mDialogContentWidth;
    private View mCustomControlView;
    private Button mDisconnectButton;
    private Button mStopCastingButton;
    private ImageButton mPlayPauseButton;
    private ImageButton mCloseButton;
    private MediaRouteExpandCollapseButton mGroupExpandCollapseButton;
    private FrameLayout mExpandableAreaLayout;
    private LinearLayout mDialogAreaLayout;
    FrameLayout mDefaultControlLayout;
    private FrameLayout mCustomControlLayout;
    private ImageView mArtView;
    private TextView mTitleView;
    private TextView mSubtitleView;
    private TextView mRouteNameTextView;
    private boolean mVolumeControlEnabled = true;
    private LinearLayout mMediaMainControlLayout;
    private RelativeLayout mPlaybackControlLayout;
    private LinearLayout mVolumeControlLayout;
    private View mDividerView;
    OverlayListView mVolumeGroupList;
    VolumeGroupAdapter mVolumeGroupAdapter;
    private List<MediaRouter.RouteInfo> mGroupMemberRoutes;
    Set<MediaRouter.RouteInfo> mGroupMemberRoutesAdded;
    private Set<MediaRouter.RouteInfo> mGroupMemberRoutesRemoved;
    Set<MediaRouter.RouteInfo> mGroupMemberRoutesAnimatingWithBitmap;
    SeekBar mVolumeSlider;
    VolumeChangeListener mVolumeChangeListener;
    MediaRouter.RouteInfo mRouteInVolumeSliderTouched;
    private int mVolumeGroupListItemIconSize;
    private int mVolumeGroupListItemHeight;
    private int mVolumeGroupListMaxHeight;
    private final int mVolumeGroupListPaddingTop;
    Map<MediaRouter.RouteInfo, SeekBar> mVolumeSliderMap;
    MediaControllerCompat mMediaController;
    MediaControllerCallback mControllerCallback;
    PlaybackStateCompat mState;
    MediaDescriptionCompat mDescription;
    FetchArtTask mFetchArtTask;
    Bitmap mArtIconBitmap;
    Uri mArtIconUri;
    boolean mArtIconIsLoaded;
    Bitmap mArtIconLoadedBitmap;
    int mArtIconBackgroundColor;
    boolean mHasPendingUpdate;
    boolean mPendingUpdateAnimationNeeded;
    boolean mIsGroupExpanded;
    boolean mIsGroupListAnimating;
    boolean mIsGroupListAnimationPending;
    int mGroupListAnimationDurationMs;
    private int mGroupListFadeInDurationMs;
    private int mGroupListFadeOutDurationMs;
    private Interpolator mInterpolator;
    private Interpolator mLinearOutSlowInInterpolator;
    private Interpolator mFastOutSlowInInterpolator;
    private Interpolator mAccelerateDecelerateInterpolator;
    final AccessibilityManager mAccessibilityManager;
    Runnable mGroupListFadeInAnimation = new Runnable(){

        @Override
        public void run() {
            MediaRouteControllerDialog.this.startGroupListFadeInAnimation();
        }
    };

    public MediaRouteControllerDialog(Context context) {
        this(context, 0);
    }

    public MediaRouteControllerDialog(Context context, int theme) {
        super(MediaRouterThemeHelper.createThemedContext(context, MediaRouterThemeHelper.getAlertDialogResolvedTheme(context, theme)), theme);
        this.mContext = this.getContext();
        this.mControllerCallback = new MediaControllerCallback();
        this.mRouter = MediaRouter.getInstance(this.mContext);
        this.mCallback = new MediaRouterCallback();
        this.mRoute = this.mRouter.getSelectedRoute();
        this.setMediaSession(this.mRouter.getMediaSessionToken());
        this.mVolumeGroupListPaddingTop = this.mContext.getResources().getDimensionPixelSize(R.dimen.mr_controller_volume_group_list_padding_top);
        this.mAccessibilityManager = (AccessibilityManager)this.mContext.getSystemService("accessibility");
        if (Build.VERSION.SDK_INT >= 21) {
            this.mLinearOutSlowInInterpolator = AnimationUtils.loadInterpolator((Context)context, (int)R.interpolator.mr_linear_out_slow_in);
            this.mFastOutSlowInInterpolator = AnimationUtils.loadInterpolator((Context)context, (int)R.interpolator.mr_fast_out_slow_in);
        }
        this.mAccelerateDecelerateInterpolator = new AccelerateDecelerateInterpolator();
    }

    public MediaRouter.RouteInfo getRoute() {
        return this.mRoute;
    }

    private MediaRouter.RouteGroup getGroup() {
        if (this.mRoute instanceof MediaRouter.RouteGroup) {
            return (MediaRouter.RouteGroup)this.mRoute;
        }
        return null;
    }

    public View onCreateMediaControlView(Bundle savedInstanceState) {
        return null;
    }

    public View getMediaControlView() {
        return this.mCustomControlView;
    }

    public void setVolumeControlEnabled(boolean enable) {
        if (this.mVolumeControlEnabled != enable) {
            this.mVolumeControlEnabled = enable;
            if (this.mCreated) {
                this.update(false);
            }
        }
    }

    public boolean isVolumeControlEnabled() {
        return this.mVolumeControlEnabled;
    }

    private void setMediaSession(MediaSessionCompat.Token sessionToken) {
        if (this.mMediaController != null) {
            this.mMediaController.unregisterCallback((MediaControllerCompat.Callback)this.mControllerCallback);
            this.mMediaController = null;
        }
        if (sessionToken == null) {
            return;
        }
        if (!this.mAttachedToWindow) {
            return;
        }
        try {
            this.mMediaController = new MediaControllerCompat(this.mContext, sessionToken);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error creating media controller in setMediaSession.", (Throwable)e);
        }
        if (this.mMediaController != null) {
            this.mMediaController.registerCallback((MediaControllerCompat.Callback)this.mControllerCallback);
        }
        MediaMetadataCompat metadata = this.mMediaController == null ? null : this.mMediaController.getMetadata();
        this.mDescription = metadata == null ? null : metadata.getDescription();
        this.mState = this.mMediaController == null ? null : this.mMediaController.getPlaybackState();
        this.updateArtIconIfNeeded();
        this.update(false);
    }

    public MediaSessionCompat.Token getMediaSession() {
        return this.mMediaController == null ? null : this.mMediaController.getSessionToken();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().setBackgroundDrawableResource(17170445);
        this.setContentView(R.layout.mr_controller_material_dialog_b);
        this.findViewById(16908315).setVisibility(8);
        ClickListener listener = new ClickListener();
        this.mExpandableAreaLayout = (FrameLayout)this.findViewById(R.id.mr_expandable_area);
        this.mExpandableAreaLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MediaRouteControllerDialog.this.dismiss();
            }
        });
        this.mDialogAreaLayout = (LinearLayout)this.findViewById(R.id.mr_dialog_area);
        this.mDialogAreaLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        int color2 = MediaRouterThemeHelper.getButtonTextColor(this.mContext);
        this.mDisconnectButton = (Button)this.findViewById(16908314);
        this.mDisconnectButton.setText(R.string.mr_controller_disconnect);
        this.mDisconnectButton.setTextColor(color2);
        this.mDisconnectButton.setOnClickListener((View.OnClickListener)listener);
        this.mStopCastingButton = (Button)this.findViewById(16908313);
        this.mStopCastingButton.setText(R.string.mr_controller_stop);
        this.mStopCastingButton.setTextColor(color2);
        this.mStopCastingButton.setOnClickListener((View.OnClickListener)listener);
        this.mRouteNameTextView = (TextView)this.findViewById(R.id.mr_name);
        this.mCloseButton = (ImageButton)this.findViewById(R.id.mr_close);
        this.mCloseButton.setOnClickListener((View.OnClickListener)listener);
        this.mCustomControlLayout = (FrameLayout)this.findViewById(R.id.mr_custom_control);
        this.mDefaultControlLayout = (FrameLayout)this.findViewById(R.id.mr_default_control);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                PendingIntent pi;
                if (MediaRouteControllerDialog.this.mMediaController != null && (pi = MediaRouteControllerDialog.this.mMediaController.getSessionActivity()) != null) {
                    try {
                        pi.send();
                        MediaRouteControllerDialog.this.dismiss();
                    }
                    catch (PendingIntent.CanceledException e) {
                        Log.e((String)MediaRouteControllerDialog.TAG, (String)(pi + " was not sent, it had been canceled."));
                    }
                }
            }
        };
        this.mArtView = (ImageView)this.findViewById(R.id.mr_art);
        this.mArtView.setOnClickListener(onClickListener);
        this.findViewById(R.id.mr_control_title_container).setOnClickListener(onClickListener);
        this.mMediaMainControlLayout = (LinearLayout)this.findViewById(R.id.mr_media_main_control);
        this.mDividerView = this.findViewById(R.id.mr_control_divider);
        this.mPlaybackControlLayout = (RelativeLayout)this.findViewById(R.id.mr_playback_control);
        this.mTitleView = (TextView)this.findViewById(R.id.mr_control_title);
        this.mSubtitleView = (TextView)this.findViewById(R.id.mr_control_subtitle);
        this.mPlayPauseButton = (ImageButton)this.findViewById(R.id.mr_control_play_pause);
        this.mPlayPauseButton.setOnClickListener((View.OnClickListener)listener);
        this.mVolumeControlLayout = (LinearLayout)this.findViewById(R.id.mr_volume_control);
        this.mVolumeControlLayout.setVisibility(8);
        this.mVolumeSlider = (SeekBar)this.findViewById(R.id.mr_volume_slider);
        this.mVolumeSlider.setTag((Object)this.mRoute);
        this.mVolumeChangeListener = new VolumeChangeListener();
        this.mVolumeSlider.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this.mVolumeChangeListener);
        this.mVolumeGroupList = (OverlayListView)this.findViewById(R.id.mr_volume_group_list);
        this.mGroupMemberRoutes = new ArrayList<MediaRouter.RouteInfo>();
        this.mVolumeGroupAdapter = new VolumeGroupAdapter(this.mVolumeGroupList.getContext(), this.mGroupMemberRoutes);
        this.mVolumeGroupList.setAdapter((ListAdapter)this.mVolumeGroupAdapter);
        this.mGroupMemberRoutesAnimatingWithBitmap = new HashSet<MediaRouter.RouteInfo>();
        MediaRouterThemeHelper.setMediaControlsBackgroundColor(this.mContext, (View)this.mMediaMainControlLayout, (View)this.mVolumeGroupList, this.getGroup() != null);
        MediaRouterThemeHelper.setVolumeSliderColor(this.mContext, (MediaRouteVolumeSlider)this.mVolumeSlider, (View)this.mMediaMainControlLayout);
        this.mVolumeSliderMap = new HashMap<MediaRouter.RouteInfo, SeekBar>();
        this.mVolumeSliderMap.put(this.mRoute, this.mVolumeSlider);
        this.mGroupExpandCollapseButton = (MediaRouteExpandCollapseButton)this.findViewById(R.id.mr_group_expand_collapse);
        this.mGroupExpandCollapseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                boolean bl = MediaRouteControllerDialog.this.mIsGroupExpanded = !MediaRouteControllerDialog.this.mIsGroupExpanded;
                if (MediaRouteControllerDialog.this.mIsGroupExpanded) {
                    MediaRouteControllerDialog.this.mVolumeGroupList.setVisibility(0);
                }
                MediaRouteControllerDialog.this.loadInterpolator();
                MediaRouteControllerDialog.this.updateLayoutHeight(true);
            }
        });
        this.loadInterpolator();
        this.mGroupListAnimationDurationMs = this.mContext.getResources().getInteger(R.integer.mr_controller_volume_group_list_animation_duration_ms);
        this.mGroupListFadeInDurationMs = this.mContext.getResources().getInteger(R.integer.mr_controller_volume_group_list_fade_in_duration_ms);
        this.mGroupListFadeOutDurationMs = this.mContext.getResources().getInteger(R.integer.mr_controller_volume_group_list_fade_out_duration_ms);
        this.mCustomControlView = this.onCreateMediaControlView(savedInstanceState);
        if (this.mCustomControlView != null) {
            this.mCustomControlLayout.addView(this.mCustomControlView);
            this.mCustomControlLayout.setVisibility(0);
        }
        this.mCreated = true;
        this.updateLayout();
    }

    void updateLayout() {
        int width = MediaRouteDialogHelper.getDialogWidth(this.mContext);
        this.getWindow().setLayout(width, -2);
        View decorView = this.getWindow().getDecorView();
        this.mDialogContentWidth = width - decorView.getPaddingLeft() - decorView.getPaddingRight();
        Resources res = this.mContext.getResources();
        this.mVolumeGroupListItemIconSize = res.getDimensionPixelSize(R.dimen.mr_controller_volume_group_list_item_icon_size);
        this.mVolumeGroupListItemHeight = res.getDimensionPixelSize(R.dimen.mr_controller_volume_group_list_item_height);
        this.mVolumeGroupListMaxHeight = res.getDimensionPixelSize(R.dimen.mr_controller_volume_group_list_max_height);
        this.mArtIconBitmap = null;
        this.mArtIconUri = null;
        this.updateArtIconIfNeeded();
        this.update(false);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
        this.mRouter.addCallback(MediaRouteSelector.EMPTY, this.mCallback, 2);
        this.setMediaSession(this.mRouter.getMediaSessionToken());
    }

    public void onDetachedFromWindow() {
        this.mRouter.removeCallback(this.mCallback);
        this.setMediaSession(null);
        this.mAttachedToWindow = false;
        super.onDetachedFromWindow();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 25 || keyCode == 24) {
            this.mRoute.requestUpdateVolume(keyCode == 25 ? -1 : 1);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 25 || keyCode == 24) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    void update(boolean animate) {
        if (this.mRouteInVolumeSliderTouched != null) {
            this.mHasPendingUpdate = true;
            this.mPendingUpdateAnimationNeeded |= animate;
            return;
        }
        this.mHasPendingUpdate = false;
        this.mPendingUpdateAnimationNeeded = false;
        if (!this.mRoute.isSelected() || this.mRoute.isDefaultOrBluetooth()) {
            this.dismiss();
            return;
        }
        if (!this.mCreated) {
            return;
        }
        this.mRouteNameTextView.setText((CharSequence)this.mRoute.getName());
        this.mDisconnectButton.setVisibility(this.mRoute.canDisconnect() ? 0 : 8);
        if (this.mCustomControlView == null && this.mArtIconIsLoaded) {
            if (this.isBitmapRecycled(this.mArtIconLoadedBitmap)) {
                Log.w((String)TAG, (String)("Can't set artwork image with recycled bitmap: " + this.mArtIconLoadedBitmap));
            } else {
                this.mArtView.setImageBitmap(this.mArtIconLoadedBitmap);
                this.mArtView.setBackgroundColor(this.mArtIconBackgroundColor);
            }
            this.clearLoadedBitmap();
        }
        this.updateVolumeControlLayout();
        this.updatePlaybackControlLayout();
        this.updateLayoutHeight(animate);
    }

    private boolean isBitmapRecycled(Bitmap bitmap) {
        return bitmap != null && bitmap.isRecycled();
    }

    private boolean canShowPlaybackControlLayout() {
        return this.mCustomControlView == null && (this.mDescription != null || this.mState != null);
    }

    private int getMainControllerHeight(boolean showPlaybackControl) {
        int height = 0;
        if (showPlaybackControl || this.mVolumeControlLayout.getVisibility() == 0) {
            height += this.mMediaMainControlLayout.getPaddingTop() + this.mMediaMainControlLayout.getPaddingBottom();
            if (showPlaybackControl) {
                height += this.mPlaybackControlLayout.getMeasuredHeight();
            }
            if (this.mVolumeControlLayout.getVisibility() == 0) {
                height += this.mVolumeControlLayout.getMeasuredHeight();
            }
            if (showPlaybackControl && this.mVolumeControlLayout.getVisibility() == 0) {
                height += this.mDividerView.getMeasuredHeight();
            }
        }
        return height;
    }

    private void updateMediaControlVisibility(boolean canShowPlaybackControlLayout) {
        this.mDividerView.setVisibility(this.mVolumeControlLayout.getVisibility() == 0 && canShowPlaybackControlLayout ? 0 : 8);
        this.mMediaMainControlLayout.setVisibility(this.mVolumeControlLayout.getVisibility() == 8 && !canShowPlaybackControlLayout ? 8 : 0);
    }

    void updateLayoutHeight(final boolean animate) {
        this.mDefaultControlLayout.requestLayout();
        ViewTreeObserver observer = this.mDefaultControlLayout.getViewTreeObserver();
        observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                MediaRouteControllerDialog.this.mDefaultControlLayout.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                if (MediaRouteControllerDialog.this.mIsGroupListAnimating) {
                    MediaRouteControllerDialog.this.mIsGroupListAnimationPending = true;
                } else {
                    MediaRouteControllerDialog.this.updateLayoutHeightInternal(animate);
                }
            }
        });
    }

    void updateLayoutHeightInternal(boolean animate) {
        int expandedGroupListHeight;
        Bitmap art;
        int oldHeight = MediaRouteControllerDialog.getLayoutHeight((View)this.mMediaMainControlLayout);
        MediaRouteControllerDialog.setLayoutHeight((View)this.mMediaMainControlLayout, -1);
        this.updateMediaControlVisibility(this.canShowPlaybackControlLayout());
        View decorView = this.getWindow().getDecorView();
        decorView.measure(View.MeasureSpec.makeMeasureSpec((int)this.getWindow().getAttributes().width, (int)0x40000000), 0);
        MediaRouteControllerDialog.setLayoutHeight((View)this.mMediaMainControlLayout, oldHeight);
        int artViewHeight = 0;
        if (this.mCustomControlView == null && this.mArtView.getDrawable() instanceof BitmapDrawable && (art = ((BitmapDrawable)this.mArtView.getDrawable()).getBitmap()) != null) {
            artViewHeight = this.getDesiredArtHeight(art.getWidth(), art.getHeight());
            this.mArtView.setScaleType(art.getWidth() >= art.getHeight() ? ImageView.ScaleType.FIT_XY : ImageView.ScaleType.FIT_CENTER);
        }
        int mainControllerHeight = this.getMainControllerHeight(this.canShowPlaybackControlLayout());
        int volumeGroupListCount = this.mGroupMemberRoutes.size();
        int n = expandedGroupListHeight = this.getGroup() == null ? 0 : this.mVolumeGroupListItemHeight * this.getGroup().getRoutes().size();
        if (volumeGroupListCount > 0) {
            expandedGroupListHeight += this.mVolumeGroupListPaddingTop;
        }
        expandedGroupListHeight = Math.min(expandedGroupListHeight, this.mVolumeGroupListMaxHeight);
        int visibleGroupListHeight = this.mIsGroupExpanded ? expandedGroupListHeight : 0;
        int desiredControlLayoutHeight = Math.max(artViewHeight, visibleGroupListHeight) + mainControllerHeight;
        Rect visibleRect = new Rect();
        decorView.getWindowVisibleDisplayFrame(visibleRect);
        int nonControlViewHeight = this.mDialogAreaLayout.getMeasuredHeight() - this.mDefaultControlLayout.getMeasuredHeight();
        int maximumControlViewHeight = visibleRect.height() - nonControlViewHeight;
        if (this.mCustomControlView == null && artViewHeight > 0 && desiredControlLayoutHeight <= maximumControlViewHeight) {
            this.mArtView.setVisibility(0);
            MediaRouteControllerDialog.setLayoutHeight((View)this.mArtView, artViewHeight);
        } else {
            if (MediaRouteControllerDialog.getLayoutHeight((View)this.mVolumeGroupList) + this.mMediaMainControlLayout.getMeasuredHeight() >= this.mDefaultControlLayout.getMeasuredHeight()) {
                this.mArtView.setVisibility(8);
            }
            artViewHeight = 0;
            desiredControlLayoutHeight = visibleGroupListHeight + mainControllerHeight;
        }
        if (this.canShowPlaybackControlLayout() && desiredControlLayoutHeight <= maximumControlViewHeight) {
            this.mPlaybackControlLayout.setVisibility(0);
        } else {
            this.mPlaybackControlLayout.setVisibility(8);
        }
        this.updateMediaControlVisibility(this.mPlaybackControlLayout.getVisibility() == 0);
        mainControllerHeight = this.getMainControllerHeight(this.mPlaybackControlLayout.getVisibility() == 0);
        desiredControlLayoutHeight = Math.max(artViewHeight, visibleGroupListHeight) + mainControllerHeight;
        if (desiredControlLayoutHeight > maximumControlViewHeight) {
            visibleGroupListHeight -= desiredControlLayoutHeight - maximumControlViewHeight;
            desiredControlLayoutHeight = maximumControlViewHeight;
        }
        this.mMediaMainControlLayout.clearAnimation();
        this.mVolumeGroupList.clearAnimation();
        this.mDefaultControlLayout.clearAnimation();
        if (animate) {
            this.animateLayoutHeight((View)this.mMediaMainControlLayout, mainControllerHeight);
            this.animateLayoutHeight((View)this.mVolumeGroupList, visibleGroupListHeight);
            this.animateLayoutHeight((View)this.mDefaultControlLayout, desiredControlLayoutHeight);
        } else {
            MediaRouteControllerDialog.setLayoutHeight((View)this.mMediaMainControlLayout, mainControllerHeight);
            MediaRouteControllerDialog.setLayoutHeight((View)this.mVolumeGroupList, visibleGroupListHeight);
            MediaRouteControllerDialog.setLayoutHeight((View)this.mDefaultControlLayout, desiredControlLayoutHeight);
        }
        MediaRouteControllerDialog.setLayoutHeight((View)this.mExpandableAreaLayout, visibleRect.height());
        this.rebuildVolumeGroupList(animate);
    }

    void updateVolumeGroupItemHeight(View item) {
        LinearLayout container = (LinearLayout)item.findViewById(R.id.volume_item_container);
        MediaRouteControllerDialog.setLayoutHeight((View)container, this.mVolumeGroupListItemHeight);
        View icon = item.findViewById(R.id.mr_volume_item_icon);
        ViewGroup.LayoutParams lp = icon.getLayoutParams();
        lp.width = this.mVolumeGroupListItemIconSize;
        lp.height = this.mVolumeGroupListItemIconSize;
        icon.setLayoutParams(lp);
    }

    private void animateLayoutHeight(final View view, int targetHeight) {
        final int startValue = MediaRouteControllerDialog.getLayoutHeight(view);
        final int endValue = targetHeight;
        Animation anim = new Animation(){

            protected void applyTransformation(float interpolatedTime, Transformation t) {
                int height = startValue - (int)((float)(startValue - endValue) * interpolatedTime);
                MediaRouteControllerDialog.setLayoutHeight(view, height);
            }
        };
        anim.setDuration((long)this.mGroupListAnimationDurationMs);
        if (Build.VERSION.SDK_INT >= 21) {
            anim.setInterpolator(this.mInterpolator);
        }
        view.startAnimation(anim);
    }

    void loadInterpolator() {
        this.mInterpolator = Build.VERSION.SDK_INT >= 21 ? (this.mIsGroupExpanded ? this.mLinearOutSlowInInterpolator : this.mFastOutSlowInInterpolator) : this.mAccelerateDecelerateInterpolator;
    }

    private void updateVolumeControlLayout() {
        if (this.isVolumeControlAvailable(this.mRoute)) {
            if (this.mVolumeControlLayout.getVisibility() == 8) {
                this.mVolumeControlLayout.setVisibility(0);
                this.mVolumeSlider.setMax(this.mRoute.getVolumeMax());
                this.mVolumeSlider.setProgress(this.mRoute.getVolume());
                this.mGroupExpandCollapseButton.setVisibility(this.getGroup() == null ? 8 : 0);
            }
        } else {
            this.mVolumeControlLayout.setVisibility(8);
        }
    }

    private void rebuildVolumeGroupList(boolean animate) {
        List<MediaRouter.RouteInfo> routes;
        List<MediaRouter.RouteInfo> list = routes = this.getGroup() == null ? null : this.getGroup().getRoutes();
        if (routes == null) {
            this.mGroupMemberRoutes.clear();
            this.mVolumeGroupAdapter.notifyDataSetChanged();
        } else if (MediaRouteDialogHelper.listUnorderedEquals(this.mGroupMemberRoutes, routes)) {
            this.mVolumeGroupAdapter.notifyDataSetChanged();
        } else {
            HashMap<MediaRouter.RouteInfo, Rect> previousRouteBoundMap = animate ? MediaRouteDialogHelper.getItemBoundMap(this.mVolumeGroupList, this.mVolumeGroupAdapter) : null;
            HashMap<MediaRouter.RouteInfo, BitmapDrawable> previousRouteBitmapMap = animate ? MediaRouteDialogHelper.getItemBitmapMap(this.mContext, this.mVolumeGroupList, this.mVolumeGroupAdapter) : null;
            this.mGroupMemberRoutesAdded = MediaRouteDialogHelper.getItemsAdded(this.mGroupMemberRoutes, routes);
            this.mGroupMemberRoutesRemoved = MediaRouteDialogHelper.getItemsRemoved(this.mGroupMemberRoutes, routes);
            this.mGroupMemberRoutes.addAll(0, this.mGroupMemberRoutesAdded);
            this.mGroupMemberRoutes.removeAll(this.mGroupMemberRoutesRemoved);
            this.mVolumeGroupAdapter.notifyDataSetChanged();
            if (animate && this.mIsGroupExpanded && this.mGroupMemberRoutesAdded.size() + this.mGroupMemberRoutesRemoved.size() > 0) {
                this.animateGroupListItems(previousRouteBoundMap, previousRouteBitmapMap);
            } else {
                this.mGroupMemberRoutesAdded = null;
                this.mGroupMemberRoutesRemoved = null;
            }
        }
    }

    private void animateGroupListItems(final Map<MediaRouter.RouteInfo, Rect> previousRouteBoundMap, final Map<MediaRouter.RouteInfo, BitmapDrawable> previousRouteBitmapMap) {
        this.mVolumeGroupList.setEnabled(false);
        this.mVolumeGroupList.requestLayout();
        this.mIsGroupListAnimating = true;
        ViewTreeObserver observer = this.mVolumeGroupList.getViewTreeObserver();
        observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                MediaRouteControllerDialog.this.mVolumeGroupList.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                MediaRouteControllerDialog.this.animateGroupListItemsInternal(previousRouteBoundMap, previousRouteBitmapMap);
            }
        });
    }

    void animateGroupListItemsInternal(Map<MediaRouter.RouteInfo, Rect> previousRouteBoundMap, Map<MediaRouter.RouteInfo, BitmapDrawable> previousRouteBitmapMap) {
        if (this.mGroupMemberRoutesAdded == null || this.mGroupMemberRoutesRemoved == null) {
            return;
        }
        int groupSizeDelta = this.mGroupMemberRoutesAdded.size() - this.mGroupMemberRoutesRemoved.size();
        boolean listenerRegistered = false;
        Animation.AnimationListener listener = new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                MediaRouteControllerDialog.this.mVolumeGroupList.startAnimationAll();
                MediaRouteControllerDialog.this.mVolumeGroupList.postDelayed(MediaRouteControllerDialog.this.mGroupListFadeInAnimation, MediaRouteControllerDialog.this.mGroupListAnimationDurationMs);
            }

            public void onAnimationEnd(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        };
        int first = this.mVolumeGroupList.getFirstVisiblePosition();
        for (int i = 0; i < this.mVolumeGroupList.getChildCount(); ++i) {
            View view = this.mVolumeGroupList.getChildAt(i);
            int position = first + i;
            MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)this.mVolumeGroupAdapter.getItem(position);
            Rect previousBounds = previousRouteBoundMap.get(route);
            int currentTop = view.getTop();
            int previousTop = previousBounds != null ? previousBounds.top : currentTop + this.mVolumeGroupListItemHeight * groupSizeDelta;
            AnimationSet animSet = new AnimationSet(true);
            if (this.mGroupMemberRoutesAdded != null && this.mGroupMemberRoutesAdded.contains(route)) {
                previousTop = currentTop;
                AlphaAnimation alphaAnim = new AlphaAnimation(0.0f, 0.0f);
                alphaAnim.setDuration((long)this.mGroupListFadeInDurationMs);
                animSet.addAnimation((Animation)alphaAnim);
            }
            TranslateAnimation translationAnim = new TranslateAnimation(0.0f, 0.0f, (float)(previousTop - currentTop), 0.0f);
            translationAnim.setDuration((long)this.mGroupListAnimationDurationMs);
            animSet.addAnimation((Animation)translationAnim);
            animSet.setFillAfter(true);
            animSet.setFillEnabled(true);
            animSet.setInterpolator(this.mInterpolator);
            if (!listenerRegistered) {
                listenerRegistered = true;
                animSet.setAnimationListener(listener);
            }
            view.clearAnimation();
            view.startAnimation((Animation)animSet);
            previousRouteBoundMap.remove(route);
            previousRouteBitmapMap.remove(route);
        }
        for (Map.Entry<MediaRouter.RouteInfo, BitmapDrawable> item : previousRouteBitmapMap.entrySet()) {
            final MediaRouter.RouteInfo route = item.getKey();
            BitmapDrawable bitmap = item.getValue();
            Rect bounds = previousRouteBoundMap.get(route);
            OverlayListView.OverlayObject object = null;
            if (this.mGroupMemberRoutesRemoved.contains(route)) {
                object = new OverlayListView.OverlayObject(bitmap, bounds).setAlphaAnimation(1.0f, 0.0f).setDuration(this.mGroupListFadeOutDurationMs).setInterpolator(this.mInterpolator);
            } else {
                int deltaY = groupSizeDelta * this.mVolumeGroupListItemHeight;
                object = new OverlayListView.OverlayObject(bitmap, bounds).setTranslateYAnimation(deltaY).setDuration(this.mGroupListAnimationDurationMs).setInterpolator(this.mInterpolator).setAnimationEndListener(new OverlayListView.OverlayObject.OnAnimationEndListener(){

                    @Override
                    public void onAnimationEnd() {
                        MediaRouteControllerDialog.this.mGroupMemberRoutesAnimatingWithBitmap.remove(route);
                        MediaRouteControllerDialog.this.mVolumeGroupAdapter.notifyDataSetChanged();
                    }
                });
                this.mGroupMemberRoutesAnimatingWithBitmap.add(route);
            }
            this.mVolumeGroupList.addOverlayObject(object);
        }
    }

    void startGroupListFadeInAnimation() {
        this.clearGroupListAnimation(true);
        this.mVolumeGroupList.requestLayout();
        ViewTreeObserver observer = this.mVolumeGroupList.getViewTreeObserver();
        observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                MediaRouteControllerDialog.this.mVolumeGroupList.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                MediaRouteControllerDialog.this.startGroupListFadeInAnimationInternal();
            }
        });
    }

    void startGroupListFadeInAnimationInternal() {
        if (this.mGroupMemberRoutesAdded != null && this.mGroupMemberRoutesAdded.size() != 0) {
            this.fadeInAddedRoutes();
        } else {
            this.finishAnimation(true);
        }
    }

    void finishAnimation(boolean animate) {
        this.mGroupMemberRoutesAdded = null;
        this.mGroupMemberRoutesRemoved = null;
        this.mIsGroupListAnimating = false;
        if (this.mIsGroupListAnimationPending) {
            this.mIsGroupListAnimationPending = false;
            this.updateLayoutHeight(animate);
        }
        this.mVolumeGroupList.setEnabled(true);
    }

    private void fadeInAddedRoutes() {
        Animation.AnimationListener listener = new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                MediaRouteControllerDialog.this.finishAnimation(true);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        };
        boolean listenerRegistered = false;
        int first = this.mVolumeGroupList.getFirstVisiblePosition();
        for (int i = 0; i < this.mVolumeGroupList.getChildCount(); ++i) {
            View view = this.mVolumeGroupList.getChildAt(i);
            int position = first + i;
            MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)this.mVolumeGroupAdapter.getItem(position);
            if (!this.mGroupMemberRoutesAdded.contains(route)) continue;
            AlphaAnimation alphaAnim = new AlphaAnimation(0.0f, 1.0f);
            alphaAnim.setDuration((long)this.mGroupListFadeInDurationMs);
            alphaAnim.setFillEnabled(true);
            alphaAnim.setFillAfter(true);
            if (!listenerRegistered) {
                listenerRegistered = true;
                alphaAnim.setAnimationListener(listener);
            }
            view.clearAnimation();
            view.startAnimation((Animation)alphaAnim);
        }
    }

    void clearGroupListAnimation(boolean exceptAddedRoutes) {
        int first = this.mVolumeGroupList.getFirstVisiblePosition();
        for (int i = 0; i < this.mVolumeGroupList.getChildCount(); ++i) {
            View view = this.mVolumeGroupList.getChildAt(i);
            int position = first + i;
            MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)this.mVolumeGroupAdapter.getItem(position);
            if (exceptAddedRoutes && this.mGroupMemberRoutesAdded != null && this.mGroupMemberRoutesAdded.contains(route)) continue;
            LinearLayout container = (LinearLayout)view.findViewById(R.id.volume_item_container);
            container.setVisibility(0);
            AnimationSet animSet = new AnimationSet(true);
            AlphaAnimation alphaAnim = new AlphaAnimation(1.0f, 1.0f);
            alphaAnim.setDuration(0L);
            animSet.addAnimation((Animation)alphaAnim);
            TranslateAnimation translationAnim = new TranslateAnimation(0.0f, 0.0f, 0.0f, 0.0f);
            translationAnim.setDuration(0L);
            animSet.setFillAfter(true);
            animSet.setFillEnabled(true);
            view.clearAnimation();
            view.startAnimation((Animation)animSet);
        }
        this.mVolumeGroupList.stopAnimationAll();
        if (!exceptAddedRoutes) {
            this.finishAnimation(false);
        }
    }

    private void updatePlaybackControlLayout() {
        if (this.canShowPlaybackControlLayout()) {
            CharSequence title = this.mDescription == null ? null : this.mDescription.getTitle();
            boolean hasTitle = !TextUtils.isEmpty((CharSequence)title);
            CharSequence subtitle = this.mDescription == null ? null : this.mDescription.getSubtitle();
            boolean hasSubtitle = !TextUtils.isEmpty((CharSequence)subtitle);
            boolean showTitle = false;
            boolean showSubtitle = false;
            if (this.mRoute.getPresentationDisplayId() != -1) {
                this.mTitleView.setText(R.string.mr_controller_casting_screen);
                showTitle = true;
            } else if (this.mState == null || this.mState.getState() == 0) {
                this.mTitleView.setText(R.string.mr_controller_no_media_selected);
                showTitle = true;
            } else if (!hasTitle && !hasSubtitle) {
                this.mTitleView.setText(R.string.mr_controller_no_info_available);
                showTitle = true;
            } else {
                if (hasTitle) {
                    this.mTitleView.setText(title);
                    showTitle = true;
                }
                if (hasSubtitle) {
                    this.mSubtitleView.setText(subtitle);
                    showSubtitle = true;
                }
            }
            this.mTitleView.setVisibility(showTitle ? 0 : 8);
            this.mSubtitleView.setVisibility(showSubtitle ? 0 : 8);
            if (this.mState != null) {
                boolean isPlaying = this.mState.getState() == 6 || this.mState.getState() == 3;
                boolean supportsPlay = (this.mState.getActions() & 0x204L) != 0L;
                boolean supportsPause = (this.mState.getActions() & 0x202L) != 0L;
                Context playPauseButtonContext = this.mPlayPauseButton.getContext();
                if (isPlaying && supportsPause) {
                    this.mPlayPauseButton.setVisibility(0);
                    this.mPlayPauseButton.setImageResource(MediaRouterThemeHelper.getThemeResource(playPauseButtonContext, R.attr.mediaRoutePauseDrawable));
                    this.mPlayPauseButton.setContentDescription(playPauseButtonContext.getResources().getText(R.string.mr_controller_pause));
                } else if (!isPlaying && supportsPlay) {
                    this.mPlayPauseButton.setVisibility(0);
                    this.mPlayPauseButton.setImageResource(MediaRouterThemeHelper.getThemeResource(playPauseButtonContext, R.attr.mediaRoutePlayDrawable));
                    this.mPlayPauseButton.setContentDescription(playPauseButtonContext.getResources().getText(R.string.mr_controller_play));
                } else {
                    this.mPlayPauseButton.setVisibility(8);
                }
            }
        }
    }

    boolean isVolumeControlAvailable(MediaRouter.RouteInfo route) {
        return this.mVolumeControlEnabled && route.getVolumeHandling() == 1;
    }

    private static int getLayoutHeight(View view) {
        return view.getLayoutParams().height;
    }

    static void setLayoutHeight(View view, int height) {
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        lp.height = height;
        view.setLayoutParams(lp);
    }

    private static boolean uriEquals(Uri uri1, Uri uri2) {
        if (uri1 != null && uri1.equals((Object)uri2)) {
            return true;
        }
        return uri1 == null && uri2 == null;
    }

    int getDesiredArtHeight(int originalWidth, int originalHeight) {
        if (originalWidth >= originalHeight) {
            return (int)((float)this.mDialogContentWidth * (float)originalHeight / (float)originalWidth + 0.5f);
        }
        return (int)((float)this.mDialogContentWidth * 9.0f / 16.0f + 0.5f);
    }

    void updateArtIconIfNeeded() {
        if (this.mCustomControlView != null || !this.isIconChanged()) {
            return;
        }
        if (this.mFetchArtTask != null) {
            this.mFetchArtTask.cancel(true);
        }
        this.mFetchArtTask = new FetchArtTask();
        this.mFetchArtTask.execute(new Void[0]);
    }

    void clearLoadedBitmap() {
        this.mArtIconIsLoaded = false;
        this.mArtIconLoadedBitmap = null;
        this.mArtIconBackgroundColor = 0;
    }

    private boolean isIconChanged() {
        Uri oldUri;
        Bitmap newBitmap = this.mDescription == null ? null : this.mDescription.getIconBitmap();
        Uri newUri = this.mDescription == null ? null : this.mDescription.getIconUri();
        Bitmap oldBitmap = this.mFetchArtTask == null ? this.mArtIconBitmap : this.mFetchArtTask.getIconBitmap();
        Uri uri = oldUri = this.mFetchArtTask == null ? this.mArtIconUri : this.mFetchArtTask.getIconUri();
        if (oldBitmap != newBitmap) {
            return true;
        }
        return oldBitmap == null && !MediaRouteControllerDialog.uriEquals(oldUri, newUri);
    }

    private class FetchArtTask
    extends AsyncTask<Void, Void, Bitmap> {
        private static final long SHOW_ANIM_TIME_THRESHOLD_MILLIS = 120L;
        private final Bitmap mIconBitmap;
        private final Uri mIconUri;
        private int mBackgroundColor;
        private long mStartTimeMillis;

        FetchArtTask() {
            Bitmap bitmap;
            Bitmap bitmap2 = bitmap = MediaRouteControllerDialog.this.mDescription == null ? null : MediaRouteControllerDialog.this.mDescription.getIconBitmap();
            if (MediaRouteControllerDialog.this.isBitmapRecycled(bitmap)) {
                Log.w((String)MediaRouteControllerDialog.TAG, (String)"Can't fetch the given art bitmap because it's already recycled.");
                bitmap = null;
            }
            this.mIconBitmap = bitmap;
            this.mIconUri = MediaRouteControllerDialog.this.mDescription == null ? null : MediaRouteControllerDialog.this.mDescription.getIconUri();
        }

        public Bitmap getIconBitmap() {
            return this.mIconBitmap;
        }

        public Uri getIconUri() {
            return this.mIconUri;
        }

        protected void onPreExecute() {
            this.mStartTimeMillis = SystemClock.uptimeMillis();
            MediaRouteControllerDialog.this.clearLoadedBitmap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Bitmap doInBackground(Void ... arg) {
            Bitmap art = null;
            if (this.mIconBitmap != null) {
                art = this.mIconBitmap;
            } else if (this.mIconUri != null) {
                InputStream stream = null;
                try {
                    BitmapFactory.Options options;
                    block33: {
                        stream = this.openInputStreamByScheme(this.mIconUri);
                        if (stream == null) {
                            Log.w((String)MediaRouteControllerDialog.TAG, (String)("Unable to open: " + this.mIconUri));
                            Bitmap bitmap = null;
                            return bitmap;
                        }
                        options = new BitmapFactory.Options();
                        options.inJustDecodeBounds = true;
                        BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
                        if (options.outWidth == 0 || options.outHeight == 0) {
                            Bitmap bitmap = null;
                            return bitmap;
                        }
                        try {
                            stream.reset();
                        }
                        catch (IOException e) {
                            stream.close();
                            stream = this.openInputStreamByScheme(this.mIconUri);
                            if (stream != null) break block33;
                            Log.w((String)MediaRouteControllerDialog.TAG, (String)("Unable to open: " + this.mIconUri));
                            Bitmap bitmap = null;
                            if (stream == null) return bitmap;
                            try {
                                stream.close();
                                return bitmap;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return bitmap;
                        }
                    }
                    options.inJustDecodeBounds = false;
                    int reqHeight = MediaRouteControllerDialog.this.getDesiredArtHeight(options.outWidth, options.outHeight);
                    int ratio = options.outHeight / reqHeight;
                    options.inSampleSize = Math.max(1, Integer.highestOneBit(ratio));
                    if (this.isCancelled()) {
                        Bitmap bitmap = null;
                        return bitmap;
                    }
                    art = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
                }
                catch (IOException e) {
                    Log.w((String)MediaRouteControllerDialog.TAG, (String)("Unable to open: " + this.mIconUri), (Throwable)e);
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (MediaRouteControllerDialog.this.isBitmapRecycled(art)) {
                Log.w((String)MediaRouteControllerDialog.TAG, (String)("Can't use recycled bitmap: " + art));
                return null;
            }
            if (art == null) return art;
            if (art.getWidth() >= art.getHeight()) return art;
            Palette palette = new Palette.Builder(art).maximumColorCount(1).generate();
            this.mBackgroundColor = palette.getSwatches().isEmpty() ? 0 : ((Palette.Swatch)palette.getSwatches().get(0)).getRgb();
            return art;
        }

        protected void onPostExecute(Bitmap art) {
            MediaRouteControllerDialog.this.mFetchArtTask = null;
            if (MediaRouteControllerDialog.this.mArtIconBitmap != this.mIconBitmap || MediaRouteControllerDialog.this.mArtIconUri != this.mIconUri) {
                MediaRouteControllerDialog.this.mArtIconBitmap = this.mIconBitmap;
                MediaRouteControllerDialog.this.mArtIconLoadedBitmap = art;
                MediaRouteControllerDialog.this.mArtIconUri = this.mIconUri;
                MediaRouteControllerDialog.this.mArtIconBackgroundColor = this.mBackgroundColor;
                MediaRouteControllerDialog.this.mArtIconIsLoaded = true;
                long elapsedTimeMillis = SystemClock.uptimeMillis() - this.mStartTimeMillis;
                MediaRouteControllerDialog.this.update(elapsedTimeMillis > 120L);
            }
        }

        private InputStream openInputStreamByScheme(Uri uri) throws IOException {
            String scheme = uri.getScheme().toLowerCase();
            InputStream stream = null;
            if ("android.resource".equals(scheme) || "content".equals(scheme) || "file".equals(scheme)) {
                stream = MediaRouteControllerDialog.this.mContext.getContentResolver().openInputStream(uri);
            } else {
                URL url = new URL(uri.toString());
                URLConnection conn = url.openConnection();
                conn.setConnectTimeout(CONNECTION_TIMEOUT_MILLIS);
                conn.setReadTimeout(CONNECTION_TIMEOUT_MILLIS);
                stream = conn.getInputStream();
            }
            return stream == null ? null : new BufferedInputStream(stream);
        }
    }

    private class VolumeGroupAdapter
    extends ArrayAdapter<MediaRouter.RouteInfo> {
        final float mDisabledAlpha;

        public VolumeGroupAdapter(Context context, List<MediaRouter.RouteInfo> objects) {
            super(context, 0, objects);
            this.mDisabledAlpha = MediaRouterThemeHelper.getDisabledAlpha(context);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View v = convertView;
            if (v == null) {
                v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.mr_controller_volume_item, parent, false);
            } else {
                MediaRouteControllerDialog.this.updateVolumeGroupItemHeight(v);
            }
            MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)this.getItem(position);
            if (route != null) {
                boolean isEnabled = route.isEnabled();
                TextView routeName = (TextView)v.findViewById(R.id.mr_name);
                routeName.setEnabled(isEnabled);
                routeName.setText((CharSequence)route.getName());
                MediaRouteVolumeSlider volumeSlider = (MediaRouteVolumeSlider)v.findViewById(R.id.mr_volume_slider);
                MediaRouterThemeHelper.setVolumeSliderColor(parent.getContext(), volumeSlider, (View)MediaRouteControllerDialog.this.mVolumeGroupList);
                volumeSlider.setTag(route);
                MediaRouteControllerDialog.this.mVolumeSliderMap.put(route, (SeekBar)volumeSlider);
                volumeSlider.setHideThumb(!isEnabled);
                volumeSlider.setEnabled(isEnabled);
                if (isEnabled) {
                    if (MediaRouteControllerDialog.this.isVolumeControlAvailable(route)) {
                        volumeSlider.setMax(route.getVolumeMax());
                        volumeSlider.setProgress(route.getVolume());
                        volumeSlider.setOnSeekBarChangeListener(MediaRouteControllerDialog.this.mVolumeChangeListener);
                    } else {
                        volumeSlider.setMax(100);
                        volumeSlider.setProgress(100);
                        volumeSlider.setEnabled(false);
                    }
                }
                ImageView volumeItemIcon = (ImageView)v.findViewById(R.id.mr_volume_item_icon);
                volumeItemIcon.setAlpha(isEnabled ? 255 : (int)(255.0f * this.mDisabledAlpha));
                LinearLayout container = (LinearLayout)v.findViewById(R.id.volume_item_container);
                container.setVisibility(MediaRouteControllerDialog.this.mGroupMemberRoutesAnimatingWithBitmap.contains(route) ? 4 : 0);
                if (MediaRouteControllerDialog.this.mGroupMemberRoutesAdded != null && MediaRouteControllerDialog.this.mGroupMemberRoutesAdded.contains(route)) {
                    AlphaAnimation alphaAnim = new AlphaAnimation(0.0f, 0.0f);
                    alphaAnim.setDuration(0L);
                    alphaAnim.setFillEnabled(true);
                    alphaAnim.setFillAfter(true);
                    v.clearAnimation();
                    v.startAnimation((Animation)alphaAnim);
                }
            }
            return v;
        }
    }

    private class VolumeChangeListener
    implements SeekBar.OnSeekBarChangeListener {
        private final Runnable mStopTrackingTouch = new Runnable(){

            @Override
            public void run() {
                if (MediaRouteControllerDialog.this.mRouteInVolumeSliderTouched != null) {
                    MediaRouteControllerDialog.this.mRouteInVolumeSliderTouched = null;
                    if (MediaRouteControllerDialog.this.mHasPendingUpdate) {
                        MediaRouteControllerDialog.this.update(MediaRouteControllerDialog.this.mPendingUpdateAnimationNeeded);
                    }
                }
            }
        };

        VolumeChangeListener() {
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
            if (MediaRouteControllerDialog.this.mRouteInVolumeSliderTouched != null) {
                MediaRouteControllerDialog.this.mVolumeSlider.removeCallbacks(this.mStopTrackingTouch);
            }
            MediaRouteControllerDialog.this.mRouteInVolumeSliderTouched = (MediaRouter.RouteInfo)seekBar.getTag();
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            MediaRouteControllerDialog.this.mVolumeSlider.postDelayed(this.mStopTrackingTouch, 500L);
        }

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            if (fromUser) {
                MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)seekBar.getTag();
                if (DEBUG) {
                    Log.d((String)MediaRouteControllerDialog.TAG, (String)("onProgressChanged(): calling MediaRouter.RouteInfo.requestSetVolume(" + progress + ")"));
                }
                route.requestSetVolume(progress);
            }
        }
    }

    private final class ClickListener
    implements View.OnClickListener {
        ClickListener() {
        }

        public void onClick(View v) {
            int id2 = v.getId();
            if (id2 == 16908313 || id2 == 16908314) {
                if (MediaRouteControllerDialog.this.mRoute.isSelected()) {
                    MediaRouteControllerDialog.this.mRouter.unselect(id2 == 16908313 ? 2 : 1);
                }
                MediaRouteControllerDialog.this.dismiss();
            } else if (id2 == R.id.mr_control_play_pause) {
                if (MediaRouteControllerDialog.this.mMediaController != null && MediaRouteControllerDialog.this.mState != null) {
                    boolean isPlaying;
                    boolean bl = isPlaying = MediaRouteControllerDialog.this.mState.getState() == 3;
                    if (isPlaying) {
                        MediaRouteControllerDialog.this.mMediaController.getTransportControls().pause();
                    } else {
                        MediaRouteControllerDialog.this.mMediaController.getTransportControls().play();
                    }
                    if (MediaRouteControllerDialog.this.mAccessibilityManager != null && MediaRouteControllerDialog.this.mAccessibilityManager.isEnabled()) {
                        AccessibilityEvent event = AccessibilityEvent.obtain((int)16384);
                        event.setPackageName((CharSequence)MediaRouteControllerDialog.this.mContext.getPackageName());
                        event.setClassName((CharSequence)this.getClass().getName());
                        int resId = isPlaying ? R.string.mr_controller_pause : R.string.mr_controller_play;
                        event.getText().add(MediaRouteControllerDialog.this.mContext.getString(resId));
                        MediaRouteControllerDialog.this.mAccessibilityManager.sendAccessibilityEvent(event);
                    }
                }
            } else if (id2 == R.id.mr_close) {
                MediaRouteControllerDialog.this.dismiss();
            }
        }
    }

    private final class MediaControllerCallback
    extends MediaControllerCompat.Callback {
        MediaControllerCallback() {
        }

        public void onSessionDestroyed() {
            if (MediaRouteControllerDialog.this.mMediaController != null) {
                MediaRouteControllerDialog.this.mMediaController.unregisterCallback((MediaControllerCompat.Callback)MediaRouteControllerDialog.this.mControllerCallback);
                MediaRouteControllerDialog.this.mMediaController = null;
            }
        }

        public void onPlaybackStateChanged(PlaybackStateCompat state) {
            MediaRouteControllerDialog.this.mState = state;
            MediaRouteControllerDialog.this.update(false);
        }

        public void onMetadataChanged(MediaMetadataCompat metadata) {
            MediaRouteControllerDialog.this.mDescription = metadata == null ? null : metadata.getDescription();
            MediaRouteControllerDialog.this.updateArtIconIfNeeded();
            MediaRouteControllerDialog.this.update(false);
        }
    }

    private final class MediaRouterCallback
    extends MediaRouter.Callback {
        MediaRouterCallback() {
        }

        @Override
        public void onRouteUnselected(MediaRouter router, MediaRouter.RouteInfo route) {
            MediaRouteControllerDialog.this.update(false);
        }

        @Override
        public void onRouteChanged(MediaRouter router, MediaRouter.RouteInfo route) {
            MediaRouteControllerDialog.this.update(true);
        }

        @Override
        public void onRouteVolumeChanged(MediaRouter router, MediaRouter.RouteInfo route) {
            SeekBar volumeSlider = MediaRouteControllerDialog.this.mVolumeSliderMap.get(route);
            int volume = route.getVolume();
            if (DEBUG) {
                Log.d((String)MediaRouteControllerDialog.TAG, (String)("onRouteVolumeChanged(), route.getVolume:" + volume));
            }
            if (volumeSlider != null && MediaRouteControllerDialog.this.mRouteInVolumeSliderTouched != route) {
                volumeSlider.setProgress(volume);
            }
        }
    }
}

