/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.support.v4.graphics.ColorUtils;
import android.support.v7.app.MediaRouteVolumeSlider;
import android.support.v7.appcompat.R;
import android.support.v7.mediarouter.R;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.View;

final class MediaRouterThemeHelper {
    private static final float MIN_CONTRAST = 3.0f;
    static final int COLOR_DARK_ON_LIGHT_BACKGROUND = -570425344;
    static final int COLOR_WHITE_ON_DARK_BACKGROUND = -1;

    private MediaRouterThemeHelper() {
    }

    public static Context createThemedContext(Context context, int style2) {
        int theme = MediaRouterThemeHelper.isLightTheme(context) ? (MediaRouterThemeHelper.getControllerColor(context, style2) == -570425344 ? R.style.Theme_MediaRouter_Light : R.style.Theme_MediaRouter_Light_DarkControlPanel) : (MediaRouterThemeHelper.getControllerColor(context, style2) == -570425344 ? R.style.Theme_MediaRouter_LightControlPanel : R.style.Theme_MediaRouter);
        int mediaRouteThemeResId = MediaRouterThemeHelper.getThemeResource(context, R.attr.mediaRouteTheme);
        ContextThemeWrapper themedContext = new ContextThemeWrapper(context, theme);
        if (mediaRouteThemeResId != 0) {
            themedContext = new ContextThemeWrapper((Context)themedContext, mediaRouteThemeResId);
        }
        return themedContext;
    }

    public static int getThemeResource(Context context, int attr2) {
        TypedValue value = new TypedValue();
        return context.getTheme().resolveAttribute(attr2, value, true) ? value.resourceId : 0;
    }

    public static float getDisabledAlpha(Context context) {
        TypedValue value = new TypedValue();
        return context.getTheme().resolveAttribute(0x1010033, value, true) ? value.getFloat() : 0.5f;
    }

    public static int getControllerColor(Context context, int style2) {
        int primaryColor = MediaRouterThemeHelper.getThemeColor(context, style2, R.attr.colorPrimary);
        if (ColorUtils.calculateContrast((int)-1, (int)primaryColor) >= 3.0) {
            return -1;
        }
        return -570425344;
    }

    public static int getButtonTextColor(Context context) {
        int backgroundColor;
        int primaryColor = MediaRouterThemeHelper.getThemeColor(context, 0, R.attr.colorPrimary);
        if (ColorUtils.calculateContrast((int)primaryColor, (int)(backgroundColor = MediaRouterThemeHelper.getThemeColor(context, 0, 0x1010031))) < 3.0) {
            return MediaRouterThemeHelper.getThemeColor(context, 0, R.attr.colorAccent);
        }
        return primaryColor;
    }

    public static void setMediaControlsBackgroundColor(Context context, View mainControls, View groupControls, boolean hasGroup) {
        int primaryColor = MediaRouterThemeHelper.getThemeColor(context, 0, R.attr.colorPrimary);
        int primaryDarkColor = MediaRouterThemeHelper.getThemeColor(context, 0, R.attr.colorPrimaryDark);
        if (hasGroup && MediaRouterThemeHelper.getControllerColor(context, 0) == -570425344) {
            primaryDarkColor = primaryColor;
            primaryColor = -1;
        }
        mainControls.setBackgroundColor(primaryColor);
        groupControls.setBackgroundColor(primaryDarkColor);
        mainControls.setTag((Object)primaryColor);
        groupControls.setTag((Object)primaryDarkColor);
    }

    public static void setVolumeSliderColor(Context context, MediaRouteVolumeSlider volumeSlider, View backgroundView) {
        int controllerColor = MediaRouterThemeHelper.getControllerColor(context, 0);
        if (Color.alpha((int)controllerColor) != 255) {
            int backgroundColor = (Integer)backgroundView.getTag();
            controllerColor = ColorUtils.compositeColors((int)controllerColor, (int)backgroundColor);
        }
        volumeSlider.setColor(controllerColor);
    }

    public static int getAlertDialogResolvedTheme(Context context, int themeResId) {
        if (themeResId >= 0x1000000) {
            return themeResId;
        }
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.alertDialogTheme, outValue, true);
        return outValue.resourceId;
    }

    private static boolean isLightTheme(Context context) {
        TypedValue value = new TypedValue();
        return context.getTheme().resolveAttribute(R.attr.isLightTheme, value, true) && value.data != 0;
    }

    private static int getThemeColor(Context context, int style2, int attr2) {
        if (style2 != 0) {
            int[] attrs = new int[]{attr2};
            TypedArray ta = context.obtainStyledAttributes(style2, attrs);
            int color = ta.getColor(0, 0);
            ta.recycle();
            if (color != 0) {
                return color;
            }
        }
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(attr2, value, true);
        if (value.resourceId != 0) {
            return context.getResources().getColor(value.resourceId);
        }
        return value.data;
    }
}

