/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.media;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.util.ObjectsCompat;
import android.support.v7.media.MediaItemStatus;
import android.support.v7.media.MediaRouter;
import android.support.v7.media.MediaSessionStatus;
import android.util.Log;

public class RemotePlaybackClient {
    static final String TAG = "RemotePlaybackClient";
    static final boolean DEBUG = Log.isLoggable((String)"RemotePlaybackClient", (int)3);
    private final Context mContext;
    private final MediaRouter.RouteInfo mRoute;
    private final ActionReceiver mActionReceiver;
    private final PendingIntent mItemStatusPendingIntent;
    private final PendingIntent mSessionStatusPendingIntent;
    private final PendingIntent mMessagePendingIntent;
    private boolean mRouteSupportsRemotePlayback;
    private boolean mRouteSupportsQueuing;
    private boolean mRouteSupportsSessionManagement;
    private boolean mRouteSupportsMessaging;
    String mSessionId;
    StatusCallback mStatusCallback;
    OnMessageReceivedListener mOnMessageReceivedListener;

    public RemotePlaybackClient(Context context, MediaRouter.RouteInfo route) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (route == null) {
            throw new IllegalArgumentException("route must not be null");
        }
        this.mContext = context;
        this.mRoute = route;
        IntentFilter actionFilter = new IntentFilter();
        actionFilter.addAction("android.support.v7.media.actions.ACTION_ITEM_STATUS_CHANGED");
        actionFilter.addAction("android.support.v7.media.actions.ACTION_SESSION_STATUS_CHANGED");
        actionFilter.addAction("android.support.v7.media.actions.ACTION_MESSAGE_RECEIVED");
        this.mActionReceiver = new ActionReceiver();
        context.registerReceiver((BroadcastReceiver)this.mActionReceiver, actionFilter);
        Intent itemStatusIntent = new Intent("android.support.v7.media.actions.ACTION_ITEM_STATUS_CHANGED");
        itemStatusIntent.setPackage(context.getPackageName());
        this.mItemStatusPendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)itemStatusIntent, (int)0);
        Intent sessionStatusIntent = new Intent("android.support.v7.media.actions.ACTION_SESSION_STATUS_CHANGED");
        sessionStatusIntent.setPackage(context.getPackageName());
        this.mSessionStatusPendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)sessionStatusIntent, (int)0);
        Intent messageIntent = new Intent("android.support.v7.media.actions.ACTION_MESSAGE_RECEIVED");
        messageIntent.setPackage(context.getPackageName());
        this.mMessagePendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)messageIntent, (int)0);
        this.detectFeatures();
    }

    public void release() {
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mActionReceiver);
    }

    public boolean isRemotePlaybackSupported() {
        return this.mRouteSupportsRemotePlayback;
    }

    public boolean isQueuingSupported() {
        return this.mRouteSupportsQueuing;
    }

    public boolean isSessionManagementSupported() {
        return this.mRouteSupportsSessionManagement;
    }

    public boolean isMessagingSupported() {
        return this.mRouteSupportsMessaging;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    public void setSessionId(String sessionId) {
        if (!ObjectsCompat.equals((Object)this.mSessionId, (Object)sessionId)) {
            if (DEBUG) {
                Log.d((String)TAG, (String)("Session id is now: " + sessionId));
            }
            this.mSessionId = sessionId;
            if (this.mStatusCallback != null) {
                this.mStatusCallback.onSessionChanged(sessionId);
            }
        }
    }

    public boolean hasSession() {
        return this.mSessionId != null;
    }

    public void setStatusCallback(StatusCallback callback) {
        this.mStatusCallback = callback;
    }

    public void setOnMessageReceivedListener(OnMessageReceivedListener listener) {
        this.mOnMessageReceivedListener = listener;
    }

    public void play(Uri contentUri, String mimeType, Bundle metadata, long positionMillis, Bundle extras, ItemActionCallback callback) {
        this.playOrEnqueue(contentUri, mimeType, metadata, positionMillis, extras, callback, "android.media.intent.action.PLAY");
    }

    public void enqueue(Uri contentUri, String mimeType, Bundle metadata, long positionMillis, Bundle extras, ItemActionCallback callback) {
        this.playOrEnqueue(contentUri, mimeType, metadata, positionMillis, extras, callback, "android.media.intent.action.ENQUEUE");
    }

    private void playOrEnqueue(Uri contentUri, String mimeType, Bundle metadata, long positionMillis, Bundle extras, ItemActionCallback callback, String action) {
        if (contentUri == null) {
            throw new IllegalArgumentException("contentUri must not be null");
        }
        this.throwIfRemotePlaybackNotSupported();
        if (action.equals("android.media.intent.action.ENQUEUE")) {
            this.throwIfQueuingNotSupported();
        }
        Intent intent = new Intent(action);
        intent.setDataAndType(contentUri, mimeType);
        intent.putExtra("android.media.intent.extra.ITEM_STATUS_UPDATE_RECEIVER", (Parcelable)this.mItemStatusPendingIntent);
        if (metadata != null) {
            intent.putExtra("android.media.intent.extra.ITEM_METADATA", metadata);
        }
        if (positionMillis != 0L) {
            intent.putExtra("android.media.intent.extra.ITEM_POSITION", positionMillis);
        }
        this.performItemAction(intent, this.mSessionId, null, extras, callback);
    }

    public void seek(String itemId, long positionMillis, Bundle extras, ItemActionCallback callback) {
        if (itemId == null) {
            throw new IllegalArgumentException("itemId must not be null");
        }
        this.throwIfNoCurrentSession();
        Intent intent = new Intent("android.media.intent.action.SEEK");
        intent.putExtra("android.media.intent.extra.ITEM_POSITION", positionMillis);
        this.performItemAction(intent, this.mSessionId, itemId, extras, callback);
    }

    public void getStatus(String itemId, Bundle extras, ItemActionCallback callback) {
        if (itemId == null) {
            throw new IllegalArgumentException("itemId must not be null");
        }
        this.throwIfNoCurrentSession();
        Intent intent = new Intent("android.media.intent.action.GET_STATUS");
        this.performItemAction(intent, this.mSessionId, itemId, extras, callback);
    }

    public void remove(String itemId, Bundle extras, ItemActionCallback callback) {
        if (itemId == null) {
            throw new IllegalArgumentException("itemId must not be null");
        }
        this.throwIfQueuingNotSupported();
        this.throwIfNoCurrentSession();
        Intent intent = new Intent("android.media.intent.action.REMOVE");
        this.performItemAction(intent, this.mSessionId, itemId, extras, callback);
    }

    public void pause(Bundle extras, SessionActionCallback callback) {
        this.throwIfNoCurrentSession();
        Intent intent = new Intent("android.media.intent.action.PAUSE");
        this.performSessionAction(intent, this.mSessionId, extras, callback);
    }

    public void resume(Bundle extras, SessionActionCallback callback) {
        this.throwIfNoCurrentSession();
        Intent intent = new Intent("android.media.intent.action.RESUME");
        this.performSessionAction(intent, this.mSessionId, extras, callback);
    }

    public void stop(Bundle extras, SessionActionCallback callback) {
        this.throwIfNoCurrentSession();
        Intent intent = new Intent("android.media.intent.action.STOP");
        this.performSessionAction(intent, this.mSessionId, extras, callback);
    }

    public void startSession(Bundle extras, SessionActionCallback callback) {
        this.throwIfSessionManagementNotSupported();
        Intent intent = new Intent("android.media.intent.action.START_SESSION");
        intent.putExtra("android.media.intent.extra.SESSION_STATUS_UPDATE_RECEIVER", (Parcelable)this.mSessionStatusPendingIntent);
        if (this.mRouteSupportsMessaging) {
            intent.putExtra("android.media.intent.extra.MESSAGE_RECEIVER", (Parcelable)this.mMessagePendingIntent);
        }
        this.performSessionAction(intent, null, extras, callback);
    }

    public void sendMessage(Bundle message, SessionActionCallback callback) {
        this.throwIfNoCurrentSession();
        this.throwIfMessageNotSupported();
        Intent intent = new Intent("android.media.intent.action.SEND_MESSAGE");
        this.performSessionAction(intent, this.mSessionId, message, callback);
    }

    public void getSessionStatus(Bundle extras, SessionActionCallback callback) {
        this.throwIfSessionManagementNotSupported();
        this.throwIfNoCurrentSession();
        Intent intent = new Intent("android.media.intent.action.GET_SESSION_STATUS");
        this.performSessionAction(intent, this.mSessionId, extras, callback);
    }

    public void endSession(Bundle extras, SessionActionCallback callback) {
        this.throwIfSessionManagementNotSupported();
        this.throwIfNoCurrentSession();
        Intent intent = new Intent("android.media.intent.action.END_SESSION");
        this.performSessionAction(intent, this.mSessionId, extras, callback);
    }

    private void performItemAction(final Intent intent, final String sessionId, final String itemId, Bundle extras, final ItemActionCallback callback) {
        intent.addCategory("android.media.intent.category.REMOTE_PLAYBACK");
        if (sessionId != null) {
            intent.putExtra("android.media.intent.extra.SESSION_ID", sessionId);
        }
        if (itemId != null) {
            intent.putExtra("android.media.intent.extra.ITEM_ID", itemId);
        }
        if (extras != null) {
            intent.putExtras(extras);
        }
        RemotePlaybackClient.logRequest(intent);
        this.mRoute.sendControlRequest(intent, new MediaRouter.ControlRequestCallback(){

            @Override
            public void onResult(Bundle data) {
                if (data != null) {
                    String sessionIdResult = RemotePlaybackClient.inferMissingResult(sessionId, data.getString("android.media.intent.extra.SESSION_ID"));
                    MediaSessionStatus sessionStatus = MediaSessionStatus.fromBundle(data.getBundle("android.media.intent.extra.SESSION_STATUS"));
                    String itemIdResult = RemotePlaybackClient.inferMissingResult(itemId, data.getString("android.media.intent.extra.ITEM_ID"));
                    MediaItemStatus itemStatus = MediaItemStatus.fromBundle(data.getBundle("android.media.intent.extra.ITEM_STATUS"));
                    RemotePlaybackClient.this.adoptSession(sessionIdResult);
                    if (sessionIdResult != null && itemIdResult != null && itemStatus != null) {
                        if (DEBUG) {
                            Log.d((String)RemotePlaybackClient.TAG, (String)("Received result from " + intent.getAction() + ": data=" + RemotePlaybackClient.bundleToString(data) + ", sessionId=" + sessionIdResult + ", sessionStatus=" + sessionStatus + ", itemId=" + itemIdResult + ", itemStatus=" + itemStatus));
                        }
                        callback.onResult(data, sessionIdResult, sessionStatus, itemIdResult, itemStatus);
                        return;
                    }
                }
                RemotePlaybackClient.this.handleInvalidResult(intent, callback, data);
            }

            @Override
            public void onError(String error, Bundle data) {
                RemotePlaybackClient.this.handleError(intent, callback, error, data);
            }
        });
    }

    private void performSessionAction(final Intent intent, final String sessionId, Bundle extras, final SessionActionCallback callback) {
        intent.addCategory("android.media.intent.category.REMOTE_PLAYBACK");
        if (sessionId != null) {
            intent.putExtra("android.media.intent.extra.SESSION_ID", sessionId);
        }
        if (extras != null) {
            intent.putExtras(extras);
        }
        RemotePlaybackClient.logRequest(intent);
        this.mRoute.sendControlRequest(intent, new MediaRouter.ControlRequestCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(Bundle data) {
                if (data != null) {
                    String sessionIdResult = RemotePlaybackClient.inferMissingResult(sessionId, data.getString("android.media.intent.extra.SESSION_ID"));
                    MediaSessionStatus sessionStatus = MediaSessionStatus.fromBundle(data.getBundle("android.media.intent.extra.SESSION_STATUS"));
                    RemotePlaybackClient.this.adoptSession(sessionIdResult);
                    if (sessionIdResult != null) {
                        if (DEBUG) {
                            Log.d((String)RemotePlaybackClient.TAG, (String)("Received result from " + intent.getAction() + ": data=" + RemotePlaybackClient.bundleToString(data) + ", sessionId=" + sessionIdResult + ", sessionStatus=" + sessionStatus));
                        }
                        try {
                            callback.onResult(data, sessionIdResult, sessionStatus);
                        }
                        finally {
                            if (intent.getAction().equals("android.media.intent.action.END_SESSION") && sessionIdResult.equals(RemotePlaybackClient.this.mSessionId)) {
                                RemotePlaybackClient.this.setSessionId(null);
                            }
                        }
                        return;
                    }
                }
                RemotePlaybackClient.this.handleInvalidResult(intent, callback, data);
            }

            @Override
            public void onError(String error, Bundle data) {
                RemotePlaybackClient.this.handleError(intent, callback, error, data);
            }
        });
    }

    void adoptSession(String sessionId) {
        if (sessionId != null) {
            this.setSessionId(sessionId);
        }
    }

    void handleInvalidResult(Intent intent, ActionCallback callback, Bundle data) {
        Log.w((String)TAG, (String)("Received invalid result data from " + intent.getAction() + ": data=" + RemotePlaybackClient.bundleToString(data)));
        callback.onError(null, 0, data);
    }

    void handleError(Intent intent, ActionCallback callback, String error, Bundle data) {
        int code = data != null ? data.getInt("android.media.intent.extra.ERROR_CODE", 0) : 0;
        if (DEBUG) {
            Log.w((String)TAG, (String)("Received error from " + intent.getAction() + ": error=" + error + ", code=" + code + ", data=" + RemotePlaybackClient.bundleToString(data)));
        }
        callback.onError(error, code, data);
    }

    private void detectFeatures() {
        this.mRouteSupportsRemotePlayback = this.routeSupportsAction("android.media.intent.action.PLAY") && this.routeSupportsAction("android.media.intent.action.SEEK") && this.routeSupportsAction("android.media.intent.action.GET_STATUS") && this.routeSupportsAction("android.media.intent.action.PAUSE") && this.routeSupportsAction("android.media.intent.action.RESUME") && this.routeSupportsAction("android.media.intent.action.STOP");
        this.mRouteSupportsQueuing = this.mRouteSupportsRemotePlayback && this.routeSupportsAction("android.media.intent.action.ENQUEUE") && this.routeSupportsAction("android.media.intent.action.REMOVE");
        this.mRouteSupportsSessionManagement = this.mRouteSupportsRemotePlayback && this.routeSupportsAction("android.media.intent.action.START_SESSION") && this.routeSupportsAction("android.media.intent.action.GET_SESSION_STATUS") && this.routeSupportsAction("android.media.intent.action.END_SESSION");
        this.mRouteSupportsMessaging = this.doesRouteSupportMessaging();
    }

    private boolean routeSupportsAction(String action) {
        return this.mRoute.supportsControlAction("android.media.intent.category.REMOTE_PLAYBACK", action);
    }

    private boolean doesRouteSupportMessaging() {
        for (IntentFilter filter : this.mRoute.getControlFilters()) {
            if (!filter.hasAction("android.media.intent.action.SEND_MESSAGE")) continue;
            return true;
        }
        return false;
    }

    private void throwIfRemotePlaybackNotSupported() {
        if (!this.mRouteSupportsRemotePlayback) {
            throw new UnsupportedOperationException("The route does not support remote playback.");
        }
    }

    private void throwIfQueuingNotSupported() {
        if (!this.mRouteSupportsQueuing) {
            throw new UnsupportedOperationException("The route does not support queuing.");
        }
    }

    private void throwIfSessionManagementNotSupported() {
        if (!this.mRouteSupportsSessionManagement) {
            throw new UnsupportedOperationException("The route does not support session management.");
        }
    }

    private void throwIfMessageNotSupported() {
        if (!this.mRouteSupportsMessaging) {
            throw new UnsupportedOperationException("The route does not support message.");
        }
    }

    private void throwIfNoCurrentSession() {
        if (this.mSessionId == null) {
            throw new IllegalStateException("There is no current session.");
        }
    }

    static String inferMissingResult(String request, String result) {
        if (result == null) {
            return request;
        }
        if (request == null || request.equals(result)) {
            return result;
        }
        return null;
    }

    private static void logRequest(Intent intent) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("Sending request: " + intent));
        }
    }

    static String bundleToString(Bundle bundle) {
        if (bundle != null) {
            bundle.size();
            return bundle.toString();
        }
        return "null";
    }

    public static interface OnMessageReceivedListener {
        public void onMessageReceived(String var1, Bundle var2);
    }

    public static abstract class SessionActionCallback
    extends ActionCallback {
        public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus) {
        }
    }

    public static abstract class ItemActionCallback
    extends ActionCallback {
        public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus, String itemId, MediaItemStatus itemStatus) {
        }
    }

    public static abstract class ActionCallback {
        public void onError(String error, int code, Bundle data) {
        }
    }

    public static abstract class StatusCallback {
        public void onItemStatusChanged(Bundle data, String sessionId, MediaSessionStatus sessionStatus, String itemId, MediaItemStatus itemStatus) {
        }

        public void onSessionStatusChanged(Bundle data, String sessionId, MediaSessionStatus sessionStatus) {
        }

        public void onSessionChanged(String sessionId) {
        }
    }

    private final class ActionReceiver
    extends BroadcastReceiver {
        public static final String ACTION_ITEM_STATUS_CHANGED = "android.support.v7.media.actions.ACTION_ITEM_STATUS_CHANGED";
        public static final String ACTION_SESSION_STATUS_CHANGED = "android.support.v7.media.actions.ACTION_SESSION_STATUS_CHANGED";
        public static final String ACTION_MESSAGE_RECEIVED = "android.support.v7.media.actions.ACTION_MESSAGE_RECEIVED";

        ActionReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String sessionId = intent.getStringExtra("android.media.intent.extra.SESSION_ID");
            if (sessionId == null || !sessionId.equals(RemotePlaybackClient.this.mSessionId)) {
                Log.w((String)RemotePlaybackClient.TAG, (String)("Discarding spurious status callback with missing or invalid session id: sessionId=" + sessionId));
                return;
            }
            MediaSessionStatus sessionStatus = MediaSessionStatus.fromBundle(intent.getBundleExtra("android.media.intent.extra.SESSION_STATUS"));
            String action = intent.getAction();
            if (action.equals(ACTION_ITEM_STATUS_CHANGED)) {
                String itemId = intent.getStringExtra("android.media.intent.extra.ITEM_ID");
                if (itemId == null) {
                    Log.w((String)RemotePlaybackClient.TAG, (String)"Discarding spurious status callback with missing item id.");
                    return;
                }
                MediaItemStatus itemStatus = MediaItemStatus.fromBundle(intent.getBundleExtra("android.media.intent.extra.ITEM_STATUS"));
                if (itemStatus == null) {
                    Log.w((String)RemotePlaybackClient.TAG, (String)"Discarding spurious status callback with missing item status.");
                    return;
                }
                if (DEBUG) {
                    Log.d((String)RemotePlaybackClient.TAG, (String)("Received item status callback: sessionId=" + sessionId + ", sessionStatus=" + sessionStatus + ", itemId=" + itemId + ", itemStatus=" + itemStatus));
                }
                if (RemotePlaybackClient.this.mStatusCallback != null) {
                    RemotePlaybackClient.this.mStatusCallback.onItemStatusChanged(intent.getExtras(), sessionId, sessionStatus, itemId, itemStatus);
                }
            } else if (action.equals(ACTION_SESSION_STATUS_CHANGED)) {
                if (sessionStatus == null) {
                    Log.w((String)RemotePlaybackClient.TAG, (String)"Discarding spurious media status callback with missing session status.");
                    return;
                }
                if (DEBUG) {
                    Log.d((String)RemotePlaybackClient.TAG, (String)("Received session status callback: sessionId=" + sessionId + ", sessionStatus=" + sessionStatus));
                }
                if (RemotePlaybackClient.this.mStatusCallback != null) {
                    RemotePlaybackClient.this.mStatusCallback.onSessionStatusChanged(intent.getExtras(), sessionId, sessionStatus);
                }
            } else if (action.equals(ACTION_MESSAGE_RECEIVED)) {
                if (DEBUG) {
                    Log.d((String)RemotePlaybackClient.TAG, (String)("Received message callback: sessionId=" + sessionId));
                }
                if (RemotePlaybackClient.this.mOnMessageReceivedListener != null) {
                    RemotePlaybackClient.this.mOnMessageReceivedListener.onMessageReceived(sessionId, intent.getBundleExtra("android.media.intent.extra.MESSAGE"));
                }
            }
        }
    }
}

