/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.preference;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v7.preference.Preference;
import android.support.v7.preference.PreferenceGroup;
import android.support.v7.preference.PreferenceGroupAdapter;
import android.support.v7.preference.PreferenceViewHolder;
import android.support.v7.preference.R;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

final class CollapsiblePreferenceGroupController
implements PreferenceGroup.PreferenceInstanceStateCallback {
    private final PreferenceGroupAdapter mPreferenceGroupAdapter;
    private int mMaxPreferenceToShow;
    private final Context mContext;

    CollapsiblePreferenceGroupController(PreferenceGroup preferenceGroup, PreferenceGroupAdapter preferenceGroupAdapter) {
        this.mPreferenceGroupAdapter = preferenceGroupAdapter;
        this.mMaxPreferenceToShow = preferenceGroup.getInitialExpandedChildrenCount();
        this.mContext = preferenceGroup.getContext();
        preferenceGroup.setPreferenceInstanceStateCallback(this);
    }

    public List<Preference> createVisiblePreferencesList(List<Preference> flattenedPreferenceList) {
        int visiblePreferenceCount = 0;
        ArrayList<Preference> visiblePreferenceList = new ArrayList<Preference>(flattenedPreferenceList.size());
        for (Preference preference : flattenedPreferenceList) {
            if (!preference.isVisible()) continue;
            if (visiblePreferenceCount < this.mMaxPreferenceToShow) {
                visiblePreferenceList.add(preference);
            }
            if (preference instanceof PreferenceGroup) continue;
            ++visiblePreferenceCount;
        }
        if (this.showLimitedChildren() && visiblePreferenceCount > this.mMaxPreferenceToShow) {
            ExpandButton expandButton = this.createExpandButton(visiblePreferenceList, flattenedPreferenceList);
            visiblePreferenceList.add(expandButton);
        }
        return visiblePreferenceList;
    }

    public boolean onPreferenceVisibilityChange(Preference preference) {
        if (this.showLimitedChildren()) {
            this.mPreferenceGroupAdapter.onPreferenceHierarchyChange(preference);
            return true;
        }
        return false;
    }

    @Override
    public Parcelable saveInstanceState(Parcelable state) {
        SavedState myState = new SavedState(state);
        myState.mMaxPreferenceToShow = this.mMaxPreferenceToShow;
        return myState;
    }

    @Override
    public Parcelable restoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            return state;
        }
        SavedState myState = (SavedState)state;
        int restoredMaxToShow = myState.mMaxPreferenceToShow;
        if (this.mMaxPreferenceToShow != restoredMaxToShow) {
            this.mMaxPreferenceToShow = restoredMaxToShow;
            this.mPreferenceGroupAdapter.onPreferenceHierarchyChange(null);
        }
        return myState.getSuperState();
    }

    private ExpandButton createExpandButton(List<Preference> visiblePreferenceList, List<Preference> flattenedPreferenceList) {
        ExpandButton preference = new ExpandButton(this.mContext, visiblePreferenceList, flattenedPreferenceList);
        preference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

            @Override
            public boolean onPreferenceClick(Preference preference) {
                CollapsiblePreferenceGroupController.this.mMaxPreferenceToShow = Integer.MAX_VALUE;
                CollapsiblePreferenceGroupController.this.mPreferenceGroupAdapter.onPreferenceHierarchyChange(preference);
                return true;
            }
        });
        return preference;
    }

    private boolean showLimitedChildren() {
        return this.mMaxPreferenceToShow != Integer.MAX_VALUE;
    }

    static class SavedState
    extends Preference.BaseSavedState {
        int mMaxPreferenceToShow;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcel source) {
            super(source);
            this.mMaxPreferenceToShow = source.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mMaxPreferenceToShow);
        }

        SavedState(Parcelable superState) {
            super(superState);
        }
    }

    static class ExpandButton
    extends Preference {
        ExpandButton(Context context, List<Preference> visiblePreferenceList, List<Preference> flattenedPreferenceList) {
            super(context);
            this.initLayout();
            this.setSummary(visiblePreferenceList, flattenedPreferenceList);
        }

        private void initLayout() {
            this.setLayoutResource(R.layout.expand_button);
            this.setIcon(R.drawable.ic_arrow_down_24dp);
            this.setTitle(R.string.expand_button_title);
            this.setOrder(999);
        }

        private void setSummary(List<Preference> visiblePreferenceList, List<Preference> flattenedPreferenceList) {
            Preference lastVisiblePreference = visiblePreferenceList.get(visiblePreferenceList.size() - 1);
            int collapsedIndex = flattenedPreferenceList.indexOf(lastVisiblePreference) + 1;
            CharSequence summary = null;
            for (int i = collapsedIndex; i < flattenedPreferenceList.size(); ++i) {
                CharSequence title;
                Preference preference = flattenedPreferenceList.get(i);
                if (preference instanceof PreferenceGroup || !preference.isVisible() || TextUtils.isEmpty((CharSequence)(title = preference.getTitle()))) continue;
                summary = summary == null ? title : this.getContext().getString(R.string.summary_collapsed_preference_list, new Object[]{summary, title});
            }
            this.setSummary(summary);
        }

        @Override
        public void onBindViewHolder(PreferenceViewHolder holder) {
            super.onBindViewHolder(holder);
            holder.setDividerAllowedAbove(false);
        }
    }
}

