/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget.helper;

import android.graphics.Canvas;
import android.support.v4.view.ViewCompat;
import android.support.v7.recyclerview.R;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchUIUtil;
import android.view.View;

class ItemTouchUIUtilImpl {
    ItemTouchUIUtilImpl() {
    }

    static class Gingerbread
    implements ItemTouchUIUtil {
        Gingerbread() {
        }

        private void draw(Canvas c, RecyclerView parent, View view, float dX, float dY) {
            c.save();
            c.translate(dX, dY);
            parent.drawChild(c, view, 0L);
            c.restore();
        }

        @Override
        public void clearView(View view) {
            view.setVisibility(0);
        }

        @Override
        public void onSelected(View view) {
            view.setVisibility(4);
        }

        @Override
        public void onDraw(Canvas c, RecyclerView recyclerView, View view, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            if (actionState != 2) {
                this.draw(c, recyclerView, view, dX, dY);
            }
        }

        @Override
        public void onDrawOver(Canvas c, RecyclerView recyclerView, View view, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            if (actionState == 2) {
                this.draw(c, recyclerView, view, dX, dY);
            }
        }
    }

    static class Honeycomb
    implements ItemTouchUIUtil {
        Honeycomb() {
        }

        @Override
        public void clearView(View view) {
            view.setTranslationX(0.0f);
            view.setTranslationY(0.0f);
        }

        @Override
        public void onSelected(View view) {
        }

        @Override
        public void onDraw(Canvas c, RecyclerView recyclerView, View view, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            view.setTranslationX(dX);
            view.setTranslationY(dY);
        }

        @Override
        public void onDrawOver(Canvas c, RecyclerView recyclerView, View view, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        }
    }

    static class Lollipop
    extends Honeycomb {
        Lollipop() {
        }

        @Override
        public void onDraw(Canvas c, RecyclerView recyclerView, View view, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            Object originalElevation;
            if (isCurrentlyActive && (originalElevation = view.getTag(R.id.item_touch_helper_previous_elevation)) == null) {
                originalElevation = Float.valueOf(ViewCompat.getElevation((View)view));
                float newElevation = 1.0f + this.findMaxElevation(recyclerView, view);
                ViewCompat.setElevation((View)view, (float)newElevation);
                view.setTag(R.id.item_touch_helper_previous_elevation, originalElevation);
            }
            super.onDraw(c, recyclerView, view, dX, dY, actionState, isCurrentlyActive);
        }

        private float findMaxElevation(RecyclerView recyclerView, View itemView) {
            int childCount = recyclerView.getChildCount();
            float max = 0.0f;
            for (int i = 0; i < childCount; ++i) {
                float elevation;
                View child = recyclerView.getChildAt(i);
                if (child == itemView || !((elevation = ViewCompat.getElevation((View)child)) > max)) continue;
                max = elevation;
            }
            return max;
        }

        @Override
        public void clearView(View view) {
            Object tag = view.getTag(R.id.item_touch_helper_previous_elevation);
            if (tag != null && tag instanceof Float) {
                ViewCompat.setElevation((View)view, (float)((Float)tag).floatValue());
            }
            view.setTag(R.id.item_touch_helper_previous_elevation, null);
            super.clearView(view);
        }
    }
}

