/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.text;

import android.annotation.TargetApi;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.text.ICUCompatApi21;
import android.support.v4.text.ICUCompatIcs;
import java.util.Locale;

public final class ICUCompat {
    private static final ICUCompatBaseImpl IMPL;

    @Nullable
    public static String maximizeAndGetScript(Locale locale) {
        return IMPL.maximizeAndGetScript(locale);
    }

    private ICUCompat() {
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 21 ? new ICUCompatApi21Impl() : new ICUCompatBaseImpl();
    }

    @TargetApi(value=23)
    static class ICUCompatApi21Impl
    extends ICUCompatBaseImpl {
        ICUCompatApi21Impl() {
        }

        @Override
        public String maximizeAndGetScript(Locale locale) {
            return ICUCompatApi21.maximizeAndGetScript(locale);
        }
    }

    static class ICUCompatBaseImpl {
        ICUCompatBaseImpl() {
        }

        public String maximizeAndGetScript(Locale locale) {
            return ICUCompatIcs.maximizeAndGetScript(locale);
        }
    }
}

