/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.net.Uri;
import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.content.res.FontResourcesParserCompat;
import android.support.v4.graphics.TypefaceCompatBaseImpl;
import android.support.v4.graphics.fonts.FontResult;
import android.support.v4.provider.FontsContractCompat;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TypefaceCompat {
    @GuardedBy(value="sLock")
    private static TypefaceCompatImpl sTypefaceCompatImpl;
    private static final Object sLock;

    public static TypefaceHolder createTypeface(Context context, @NonNull List<FontResult> resultList) {
        TypefaceCompat.maybeInitImpl(context);
        return sTypefaceCompatImpl.createTypeface(resultList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=26)
    private static void maybeInitImpl(Context context) {
        if (sTypefaceCompatImpl == null) {
            Object object = sLock;
            synchronized (object) {
                if (sTypefaceCompatImpl == null) {
                    sTypefaceCompatImpl = new TypefaceCompatBaseImpl(context);
                }
            }
        }
    }

    private TypefaceCompat() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypefaceHolder findFromCache(Resources resources, int id, int style) {
        Object object = sLock;
        synchronized (object) {
            if (sTypefaceCompatImpl == null) {
                return null;
            }
        }
        return sTypefaceCompatImpl.findFromCache(resources, id, style);
    }

    public static TypefaceHolder createFromResourcesFamilyXml(Context context, FontResourcesParserCompat.FamilyResourceEntry entry, Resources resources, int id, int style) {
        TypefaceCompat.maybeInitImpl(context);
        return sTypefaceCompatImpl.createFromResourcesFamilyXml(entry, resources, id, style);
    }

    @Nullable
    public static TypefaceHolder createFromResourcesFontFile(Context context, Resources resources, int id, int style) {
        TypefaceCompat.maybeInitImpl(context);
        return sTypefaceCompatImpl.createFromResourcesFontFile(resources, id, style);
    }

    public static TypefaceHolder createTypeface(Context context, @NonNull FontsContractCompat.FontInfo[] fonts, Map<Uri, ByteBuffer> uriBuffer) {
        TypefaceCompat.maybeInitImpl(context);
        return sTypefaceCompatImpl.createTypeface(fonts, uriBuffer);
    }

    static {
        sLock = new Object();
    }

    public static abstract class FontRequestCallback {
        public static final int FAIL_REASON_PROVIDER_NOT_FOUND = -1;
        public static final int FAIL_REASON_WRONG_CERTIFICATES = -2;
        public static final int FAIL_REASON_FONT_LOAD_ERROR = -3;
        public static final int FAIL_REASON_FONT_NOT_FOUND = 1;
        public static final int FAIL_REASON_FONT_UNAVAILABLE = 2;
        public static final int FAIL_REASON_MALFORMED_QUERY = 3;

        public abstract void onTypefaceRetrieved(Typeface var1);

        public abstract void onTypefaceRequestFailed(int var1);
    }

    static interface TypefaceCompatImpl {
        public TypefaceHolder createFromResourcesFontFile(Resources var1, int var2, int var3);

        public TypefaceHolder createFromResourcesFamilyXml(FontResourcesParserCompat.FamilyResourceEntry var1, Resources var2, int var3, int var4);

        public TypefaceHolder findFromCache(Resources var1, int var2, int var3);

        public TypefaceHolder createTypeface(@NonNull List<FontResult> var1);

        public TypefaceHolder createTypeface(@NonNull FontsContractCompat.FontInfo[] var1, Map<Uri, ByteBuffer> var2);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class TypefaceHolder {
        private final Typeface mTypeface;
        private final int mWeight;
        private final boolean mItalic;

        public TypefaceHolder(Typeface typeface, int weight, boolean italic) {
            this.mTypeface = typeface;
            this.mWeight = weight;
            this.mItalic = italic;
        }

        public Typeface getTypeface() {
            return this.mTypeface;
        }

        public int getWeight() {
            return this.mWeight;
        }

        public boolean isItalic() {
            return this.mItalic;
        }
    }
}

