/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics.drawable;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.util.Preconditions;
import android.text.TextUtils;
import android.util.Log;
import androidx.versionedparcelable.CustomVersionedParcelable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;

public class IconCompat
extends CustomVersionedParcelable {
    private static final String TAG = "IconCompat";
    public static final int TYPE_UNKNOWN = -1;
    private static final float ADAPTIVE_ICON_INSET_FACTOR = 0.25f;
    private static final float DEFAULT_VIEW_PORT_SCALE = 0.6666667f;
    private static final float ICON_DIAMETER_FACTOR = 0.9166667f;
    private static final float BLUR_FACTOR = 0.010416667f;
    private static final float KEY_SHADOW_OFFSET_FACTOR = 0.020833334f;
    private static final int KEY_SHADOW_ALPHA = 61;
    private static final int AMBIENT_SHADOW_ALPHA = 30;
    private static final String EXTRA_TYPE = "type";
    private static final String EXTRA_OBJ = "obj";
    private static final String EXTRA_INT1 = "int1";
    private static final String EXTRA_INT2 = "int2";
    private static final String EXTRA_TINT_LIST = "tint_list";
    private static final String EXTRA_TINT_MODE = "tint_mode";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int mType;
    Object mObj1;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public byte[] mData;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Parcelable mParcelable;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int mInt1;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int mInt2;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ColorStateList mTintList = null;
    static final PorterDuff.Mode DEFAULT_TINT_MODE = PorterDuff.Mode.SRC_IN;
    PorterDuff.Mode mTintMode = DEFAULT_TINT_MODE;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String mTintModeStr;

    public static IconCompat createWithResource(Context context, @DrawableRes int resId) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null.");
        }
        return IconCompat.createWithResource(context.getResources(), context.getPackageName(), resId);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static IconCompat createWithResource(Resources r, String pkg, @DrawableRes int resId) {
        if (pkg == null) {
            throw new IllegalArgumentException("Package must not be null.");
        }
        IconCompat rep = new IconCompat(2);
        rep.mInt1 = resId;
        rep.mObj1 = r != null ? r.getResourceName(resId) : pkg;
        return rep;
    }

    public static IconCompat createWithBitmap(Bitmap bits) {
        if (bits == null) {
            throw new IllegalArgumentException("Bitmap must not be null.");
        }
        IconCompat rep = new IconCompat(1);
        rep.mObj1 = bits;
        return rep;
    }

    public static IconCompat createWithAdaptiveBitmap(Bitmap bits) {
        if (bits == null) {
            throw new IllegalArgumentException("Bitmap must not be null.");
        }
        IconCompat rep = new IconCompat(5);
        rep.mObj1 = bits;
        return rep;
    }

    public static IconCompat createWithData(byte[] data, int offset, int length) {
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null.");
        }
        IconCompat rep = new IconCompat(3);
        rep.mObj1 = data;
        rep.mInt1 = offset;
        rep.mInt2 = length;
        return rep;
    }

    public static IconCompat createWithContentUri(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Uri must not be null.");
        }
        IconCompat rep = new IconCompat(4);
        rep.mObj1 = uri;
        return rep;
    }

    public static IconCompat createWithContentUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Uri must not be null.");
        }
        return IconCompat.createWithContentUri(uri.toString());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public IconCompat() {
    }

    private IconCompat(int mType) {
        this.mType = mType;
    }

    public int getType() {
        if (this.mType == -1 && Build.VERSION.SDK_INT >= 23) {
            return IconCompat.getType((Icon)this.mObj1);
        }
        return this.mType;
    }

    @NonNull
    public String getResPackage() {
        if (this.mType == -1 && Build.VERSION.SDK_INT >= 23) {
            return IconCompat.getResPackage((Icon)this.mObj1);
        }
        if (this.mType != 2) {
            throw new IllegalStateException("called getResPackage() on " + (Object)((Object)this));
        }
        return ((String)this.mObj1).split(":", -1)[0];
    }

    @IdRes
    public int getResId() {
        if (this.mType == -1 && Build.VERSION.SDK_INT >= 23) {
            return IconCompat.getResId((Icon)this.mObj1);
        }
        if (this.mType != 2) {
            throw new IllegalStateException("called getResId() on " + (Object)((Object)this));
        }
        return this.mInt1;
    }

    @NonNull
    public Uri getUri() {
        if (this.mType == -1 && Build.VERSION.SDK_INT >= 23) {
            return IconCompat.getUri((Icon)this.mObj1);
        }
        return Uri.parse((String)((String)this.mObj1));
    }

    public IconCompat setTint(@ColorInt int tint) {
        return this.setTintList(ColorStateList.valueOf((int)tint));
    }

    public IconCompat setTintList(ColorStateList tintList) {
        this.mTintList = tintList;
        return this;
    }

    public IconCompat setTintMode(PorterDuff.Mode mode) {
        this.mTintMode = mode;
        return this;
    }

    @RequiresApi(value=23)
    public Icon toIcon() {
        Icon icon;
        switch (this.mType) {
            case -1: {
                return (Icon)this.mObj1;
            }
            case 1: {
                icon = Icon.createWithBitmap((Bitmap)((Bitmap)this.mObj1));
                break;
            }
            case 5: {
                if (Build.VERSION.SDK_INT >= 26) {
                    icon = Icon.createWithAdaptiveBitmap((Bitmap)((Bitmap)this.mObj1));
                    break;
                }
                icon = Icon.createWithBitmap((Bitmap)IconCompat.createLegacyIconFromAdaptiveIcon((Bitmap)this.mObj1, false));
                break;
            }
            case 2: {
                icon = Icon.createWithResource((String)this.getResPackage(), (int)this.mInt1);
                break;
            }
            case 3: {
                icon = Icon.createWithData((byte[])((byte[])this.mObj1), (int)this.mInt1, (int)this.mInt2);
                break;
            }
            case 4: {
                icon = Icon.createWithContentUri((String)((String)this.mObj1));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type");
            }
        }
        if (this.mTintList != null) {
            icon.setTintList(this.mTintList);
        }
        if (this.mTintMode != DEFAULT_TINT_MODE) {
            icon.setTintMode(this.mTintMode);
        }
        return icon;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void checkResource(Context context) {
        if (this.mType == 2) {
            String resPackage = (String)this.mObj1;
            if (!resPackage.contains(":")) {
                return;
            }
            String resName = resPackage.split(":", -1)[1];
            String resType = resName.split("/", -1)[0];
            resName = resName.split("/", -1)[1];
            Resources res = IconCompat.getResources(context, resPackage = resPackage.split(":", -1)[0]);
            int id2 = res.getIdentifier(resName, resType, resPackage);
            if (this.mInt1 != id2) {
                Log.i((String)TAG, (String)("Id has changed for " + resPackage + "/" + resName));
                this.mInt1 = id2;
            }
        }
    }

    public Drawable loadDrawable(Context context) {
        this.checkResource(context);
        if (Build.VERSION.SDK_INT >= 23) {
            return this.toIcon().loadDrawable(context);
        }
        Drawable result = this.loadDrawableInner(context);
        if (result != null && (this.mTintList != null || this.mTintMode != DEFAULT_TINT_MODE)) {
            result.mutate();
            DrawableCompat.setTintList(result, this.mTintList);
            DrawableCompat.setTintMode(result, this.mTintMode);
        }
        return result;
    }

    private Drawable loadDrawableInner(Context context) {
        switch (this.mType) {
            case 1: {
                return new BitmapDrawable(context.getResources(), (Bitmap)this.mObj1);
            }
            case 5: {
                return new BitmapDrawable(context.getResources(), IconCompat.createLegacyIconFromAdaptiveIcon((Bitmap)this.mObj1, false));
            }
            case 2: {
                String resPackage = this.getResPackage();
                if (TextUtils.isEmpty((CharSequence)resPackage)) {
                    resPackage = context.getPackageName();
                }
                Resources res = IconCompat.getResources(context, resPackage);
                try {
                    return ResourcesCompat.getDrawable(res, this.mInt1, context.getTheme());
                }
                catch (RuntimeException e) {
                    Log.e((String)TAG, (String)String.format("Unable to load resource 0x%08x from pkg=%s", this.mInt1, this.mObj1), (Throwable)e);
                    break;
                }
            }
            case 3: {
                return new BitmapDrawable(context.getResources(), BitmapFactory.decodeByteArray((byte[])((byte[])this.mObj1), (int)this.mInt1, (int)this.mInt2));
            }
            case 4: {
                Uri uri = Uri.parse((String)((String)this.mObj1));
                String scheme = uri.getScheme();
                InputStream is = null;
                if ("content".equals(scheme) || "file".equals(scheme)) {
                    try {
                        is = context.getContentResolver().openInputStream(uri);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (String)("Unable to load image from URI: " + uri), (Throwable)e);
                    }
                } else {
                    try {
                        is = new FileInputStream(new File((String)this.mObj1));
                    }
                    catch (FileNotFoundException e) {
                        Log.w((String)TAG, (String)("Unable to load image from path: " + uri), (Throwable)e);
                    }
                }
                if (is == null) break;
                return new BitmapDrawable(context.getResources(), BitmapFactory.decodeStream((InputStream)is));
            }
        }
        return null;
    }

    private static Resources getResources(Context context, String resPackage) {
        if ("android".equals(resPackage)) {
            return Resources.getSystem();
        }
        PackageManager pm = context.getPackageManager();
        try {
            ApplicationInfo ai = pm.getApplicationInfo(resPackage, 8192);
            if (ai != null) {
                return pm.getResourcesForApplication(ai);
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)String.format("Unable to find pkg=%s for icon", resPackage), (Throwable)e);
            return null;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void addToShortcutIntent(@NonNull Intent outIntent, @Nullable Drawable badge, @NonNull Context c) {
        Bitmap icon;
        this.checkResource(c);
        switch (this.mType) {
            case 1: {
                icon = (Bitmap)this.mObj1;
                if (badge == null) break;
                icon = icon.copy(icon.getConfig(), true);
                break;
            }
            case 5: {
                icon = IconCompat.createLegacyIconFromAdaptiveIcon((Bitmap)this.mObj1, true);
                break;
            }
            case 2: {
                try {
                    Context context = c.createPackageContext(this.getResPackage(), 0);
                    if (badge == null) {
                        outIntent.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)Intent.ShortcutIconResource.fromContext((Context)context, (int)this.mInt1));
                        return;
                    }
                    Drawable dr = ContextCompat.getDrawable(context, this.mInt1);
                    if (dr.getIntrinsicWidth() <= 0 || dr.getIntrinsicHeight() <= 0) {
                        int size = ((ActivityManager)context.getSystemService("activity")).getLauncherLargeIconSize();
                        icon = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    } else {
                        icon = Bitmap.createBitmap((int)dr.getIntrinsicWidth(), (int)dr.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    }
                    dr.setBounds(0, 0, icon.getWidth(), icon.getHeight());
                    dr.draw(new Canvas(icon));
                    break;
                }
                catch (PackageManager.NameNotFoundException e) {
                    throw new IllegalArgumentException("Can't find package " + this.mObj1, e);
                }
            }
            default: {
                throw new IllegalArgumentException("Icon type not supported for intent shortcuts");
            }
        }
        if (badge != null) {
            int w = icon.getWidth();
            int h = icon.getHeight();
            badge.setBounds(w / 2, h / 2, w, h);
            badge.draw(new Canvas(icon));
        }
        outIntent.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)icon);
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        switch (this.mType) {
            case 1: 
            case 5: {
                bundle.putParcelable(EXTRA_OBJ, (Parcelable)((Bitmap)this.mObj1));
                break;
            }
            case -1: {
                bundle.putParcelable(EXTRA_OBJ, (Parcelable)this.mObj1);
                break;
            }
            case 2: 
            case 4: {
                bundle.putString(EXTRA_OBJ, (String)this.mObj1);
                break;
            }
            case 3: {
                bundle.putByteArray(EXTRA_OBJ, (byte[])this.mObj1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid icon");
            }
        }
        bundle.putInt(EXTRA_TYPE, this.mType);
        bundle.putInt(EXTRA_INT1, this.mInt1);
        bundle.putInt(EXTRA_INT2, this.mInt2);
        if (this.mTintList != null) {
            bundle.putParcelable(EXTRA_TINT_LIST, (Parcelable)this.mTintList);
        }
        if (this.mTintMode != DEFAULT_TINT_MODE) {
            bundle.putString(EXTRA_TINT_MODE, this.mTintMode.name());
        }
        return bundle;
    }

    public String toString() {
        if (this.mType == -1) {
            return String.valueOf(this.mObj1);
        }
        StringBuilder sb = new StringBuilder("Icon(typ=").append(IconCompat.typeToString(this.mType));
        switch (this.mType) {
            case 1: 
            case 5: {
                sb.append(" size=").append(((Bitmap)this.mObj1).getWidth()).append("x").append(((Bitmap)this.mObj1).getHeight());
                break;
            }
            case 2: {
                sb.append(" pkg=").append(this.getResPackage()).append(" id=").append(String.format("0x%08x", this.getResId()));
                break;
            }
            case 3: {
                sb.append(" len=").append(this.mInt1);
                if (this.mInt2 == 0) break;
                sb.append(" off=").append(this.mInt2);
                break;
            }
            case 4: {
                sb.append(" uri=").append(this.mObj1);
            }
        }
        if (this.mTintList != null) {
            sb.append(" tint=");
            sb.append(this.mTintList);
        }
        if (this.mTintMode != DEFAULT_TINT_MODE) {
            sb.append(" mode=").append(this.mTintMode);
        }
        sb.append(")");
        return sb.toString();
    }

    public void onPreParceling(boolean isStream) {
        this.mTintModeStr = this.mTintMode.name();
        switch (this.mType) {
            case -1: {
                if (isStream) {
                    throw new IllegalArgumentException("Can't serialize Icon created with IconCompat#createFromIcon");
                }
                this.mParcelable = (Parcelable)this.mObj1;
                break;
            }
            case 1: 
            case 5: {
                if (isStream) {
                    Bitmap bitmap = (Bitmap)this.mObj1;
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)data);
                    this.mData = data.toByteArray();
                    break;
                }
                this.mParcelable = (Parcelable)this.mObj1;
                break;
            }
            case 4: {
                this.mData = this.mObj1.toString().getBytes(Charset.forName("UTF-16"));
                break;
            }
            case 2: {
                this.mData = ((String)this.mObj1).getBytes(Charset.forName("UTF-16"));
                break;
            }
            case 3: {
                this.mData = (byte[])this.mObj1;
            }
        }
    }

    public void onPostParceling() {
        this.mTintMode = PorterDuff.Mode.valueOf((String)this.mTintModeStr);
        switch (this.mType) {
            case -1: {
                if (this.mParcelable != null) {
                    this.mObj1 = this.mParcelable;
                    break;
                }
                throw new IllegalArgumentException("Invalid icon");
            }
            case 1: 
            case 5: {
                if (this.mParcelable != null) {
                    this.mObj1 = this.mParcelable;
                    break;
                }
                this.mObj1 = this.mData;
                this.mType = 3;
                this.mInt1 = 0;
                this.mInt2 = this.mData.length;
                break;
            }
            case 2: 
            case 4: {
                this.mObj1 = new String(this.mData, Charset.forName("UTF-16"));
                break;
            }
            case 3: {
                this.mObj1 = this.mData;
            }
        }
    }

    private static String typeToString(int x) {
        switch (x) {
            case 1: {
                return "BITMAP";
            }
            case 5: {
                return "BITMAP_MASKABLE";
            }
            case 3: {
                return "DATA";
            }
            case 2: {
                return "RESOURCE";
            }
            case 4: {
                return "URI";
            }
        }
        return "UNKNOWN";
    }

    @Nullable
    public static IconCompat createFromBundle(@NonNull Bundle bundle) {
        int type = bundle.getInt(EXTRA_TYPE);
        IconCompat icon = new IconCompat(type);
        icon.mInt1 = bundle.getInt(EXTRA_INT1);
        icon.mInt2 = bundle.getInt(EXTRA_INT2);
        if (bundle.containsKey(EXTRA_TINT_LIST)) {
            icon.mTintList = (ColorStateList)bundle.getParcelable(EXTRA_TINT_LIST);
        }
        if (bundle.containsKey(EXTRA_TINT_MODE)) {
            icon.mTintMode = PorterDuff.Mode.valueOf((String)bundle.getString(EXTRA_TINT_MODE));
        }
        switch (type) {
            case -1: 
            case 1: 
            case 5: {
                icon.mObj1 = bundle.getParcelable(EXTRA_OBJ);
                break;
            }
            case 2: 
            case 4: {
                icon.mObj1 = bundle.getString(EXTRA_OBJ);
                break;
            }
            case 3: {
                icon.mObj1 = bundle.getByteArray(EXTRA_OBJ);
                break;
            }
            default: {
                Log.w((String)TAG, (String)("Unknown type " + type));
                return null;
            }
        }
        return icon;
    }

    @RequiresApi(value=23)
    @Nullable
    public static IconCompat createFromIcon(@NonNull Context context, @NonNull Icon icon) {
        Preconditions.checkNotNull(icon);
        switch (IconCompat.getType(icon)) {
            case 2: {
                String resPackage = IconCompat.getResPackage(icon);
                return IconCompat.createWithResource(IconCompat.getResources(context, resPackage), resPackage, IconCompat.getResId(icon));
            }
            case 4: {
                return IconCompat.createWithContentUri(IconCompat.getUri(icon));
            }
        }
        IconCompat iconCompat = new IconCompat(-1);
        iconCompat.mObj1 = icon;
        return iconCompat;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=23)
    @Nullable
    public static IconCompat createFromIcon(@NonNull Icon icon) {
        Preconditions.checkNotNull(icon);
        switch (IconCompat.getType(icon)) {
            case 2: {
                return IconCompat.createWithResource(null, IconCompat.getResPackage(icon), IconCompat.getResId(icon));
            }
            case 4: {
                return IconCompat.createWithContentUri(IconCompat.getUri(icon));
            }
        }
        IconCompat iconCompat = new IconCompat(-1);
        iconCompat.mObj1 = icon;
        return iconCompat;
    }

    @RequiresApi(value=23)
    private static int getType(@NonNull Icon icon) {
        if (Build.VERSION.SDK_INT >= 28) {
            return icon.getType();
        }
        try {
            return (Integer)icon.getClass().getMethod("getType", new Class[0]).invoke((Object)icon, new Object[0]);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)("Unable to get icon type " + icon), (Throwable)e);
            return -1;
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)("Unable to get icon type " + icon), (Throwable)e);
            return -1;
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)("Unable to get icon type " + icon), (Throwable)e);
            return -1;
        }
    }

    @Nullable
    @RequiresApi(value=23)
    private static String getResPackage(@NonNull Icon icon) {
        if (Build.VERSION.SDK_INT >= 28) {
            return icon.getResPackage();
        }
        try {
            return (String)icon.getClass().getMethod("getResPackage", new Class[0]).invoke((Object)icon, new Object[0]);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)"Unable to get icon package", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)"Unable to get icon package", (Throwable)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"Unable to get icon package", (Throwable)e);
            return null;
        }
    }

    @IdRes
    @RequiresApi(value=23)
    @DrawableRes
    private static int getResId(@NonNull Icon icon) {
        if (Build.VERSION.SDK_INT >= 28) {
            return icon.getResId();
        }
        try {
            return (Integer)icon.getClass().getMethod("getResId", new Class[0]).invoke((Object)icon, new Object[0]);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)"Unable to get icon resource", (Throwable)e);
            return 0;
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)"Unable to get icon resource", (Throwable)e);
            return 0;
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"Unable to get icon resource", (Throwable)e);
            return 0;
        }
    }

    @Nullable
    @RequiresApi(value=23)
    private static Uri getUri(@NonNull Icon icon) {
        if (Build.VERSION.SDK_INT >= 28) {
            return icon.getUri();
        }
        try {
            return (Uri)icon.getClass().getMethod("getUri", new Class[0]).invoke((Object)icon, new Object[0]);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)"Unable to get icon uri", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)"Unable to get icon uri", (Throwable)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"Unable to get icon uri", (Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    static Bitmap createLegacyIconFromAdaptiveIcon(Bitmap adaptiveIconBitmap, boolean addShadow) {
        int size = (int)(0.6666667f * (float)Math.min(adaptiveIconBitmap.getWidth(), adaptiveIconBitmap.getHeight()));
        Bitmap icon = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(icon);
        Paint paint = new Paint(3);
        float center = (float)size * 0.5f;
        float radius = center * 0.9166667f;
        if (addShadow) {
            float blur = 0.010416667f * (float)size;
            paint.setColor(0);
            paint.setShadowLayer(blur, 0.0f, 0.020833334f * (float)size, 0x3D000000);
            canvas.drawCircle(center, center, radius, paint);
            paint.setShadowLayer(blur, 0.0f, 0.0f, 0x1E000000);
            canvas.drawCircle(center, center, radius, paint);
            paint.clearShadowLayer();
        }
        paint.setColor(-16777216);
        BitmapShader shader = new BitmapShader(adaptiveIconBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Matrix shift = new Matrix();
        shift.setTranslate((float)(-(adaptiveIconBitmap.getWidth() - size) / 2), (float)(-(adaptiveIconBitmap.getHeight() - size) / 2));
        shader.setLocalMatrix(shift);
        paint.setShader((Shader)shader);
        canvas.drawCircle(center, center, radius, paint);
        canvas.setBitmap(null);
        return icon;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface IconType {
    }
}

