/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.support.annotation.GuardedBy;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.media.AudioAttributesCompat;
import android.support.v4.media.BaseMediaPlayer;
import android.support.v4.media.MediaSession2;
import android.support.v4.util.ObjectsCompat;
import android.util.Log;

@VisibleForTesting(otherwise=3)
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class AudioFocusHandler {
    private static final String TAG = "AudioFocusHandler";
    private static final boolean DEBUG = false;
    private final AudioFocusHandlerImpl mImpl;

    AudioFocusHandler(Context context, MediaSession2 session) {
        this.mImpl = new AudioFocusHandlerImplBase(context, session);
    }

    public boolean onPlayRequested() {
        return this.mImpl.onPlayRequested();
    }

    public boolean onPauseRequested() {
        return this.mImpl.onPauseRequested();
    }

    public void onPlayerStateChanged(int playerState) {
        this.mImpl.onPlayerStateChanged(playerState);
    }

    public void close() {
        this.mImpl.close();
    }

    public void sendIntent(Intent intent) {
        this.mImpl.sendIntent(intent);
    }

    private static class AudioFocusHandlerImplBase
    implements AudioFocusHandlerImpl {
        private static final float VOLUME_DUCK_FACTOR = 0.2f;
        private final BroadcastReceiver mBecomingNoisyIntentReceiver = new NoisyIntentReceiver();
        private final IntentFilter mIntentFilter = new IntentFilter("android.media.AUDIO_BECOMING_NOISY");
        private final AudioManager.OnAudioFocusChangeListener mAudioFocusListener = new AudioFocusListener();
        private final Object mLock = new Object();
        private final Context mContext;
        private final MediaSession2 mSession;
        private final AudioManager mAudioManager;
        @GuardedBy(value="mLock")
        private AudioAttributesCompat mAudioAttributes;
        @GuardedBy(value="mLock")
        private boolean mHasAudioFocus;
        @GuardedBy(value="mLock")
        private boolean mResumeWhenAudioFocusGain;
        @GuardedBy(value="mLock")
        private boolean mHasRegisteredReceiver;

        AudioFocusHandlerImplBase(Context context, MediaSession2 session) {
            this.mContext = context;
            this.mSession = session;
            this.mAudioManager = (AudioManager)context.getSystemService("audio");
        }

        private AudioAttributesCompat getAudioAttributesNotLocked() {
            if (this.mSession.getVolumeProvider() != null) {
                return null;
            }
            BaseMediaPlayer player = this.mSession.getPlayer();
            return player == null ? null : player.getAudioAttributes();
        }

        @GuardedBy(value="mLock")
        private void updateAudioAttributesIfNeededLocked(AudioAttributesCompat attributes) {
            if (ObjectsCompat.equals((Object)attributes, (Object)this.mAudioAttributes)) {
                return;
            }
            this.mAudioAttributes = attributes;
            if (this.mHasAudioFocus) {
                this.mHasAudioFocus = this.requestAudioFocusLocked();
                if (!this.mHasAudioFocus) {
                    Log.w((String)AudioFocusHandler.TAG, (String)"Failed to regain audio focus.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onPlayRequested() {
            AudioAttributesCompat attr = this.getAudioAttributesNotLocked();
            Object object = this.mLock;
            synchronized (object) {
                this.updateAudioAttributesIfNeededLocked(attr);
                if (!this.requestAudioFocusLocked()) {
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onPauseRequested() {
            Object object = this.mLock;
            synchronized (object) {
                this.mResumeWhenAudioFocusGain = false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPlayerStateChanged(int playerState) {
            switch (playerState) {
                case 0: {
                    Object object = this.mLock;
                    synchronized (object) {
                        this.abandonAudioFocusLocked();
                        break;
                    }
                }
                case 1: {
                    AudioAttributesCompat attr = this.getAudioAttributesNotLocked();
                    Object object = this.mLock;
                    synchronized (object) {
                        this.updateAudioAttributesIfNeededLocked(attr);
                        this.unregisterReceiverLocked();
                        break;
                    }
                }
                case 2: {
                    AudioAttributesCompat attr = this.getAudioAttributesNotLocked();
                    Object object = this.mLock;
                    synchronized (object) {
                        this.updateAudioAttributesIfNeededLocked(attr);
                        this.registerReceiverLocked();
                        break;
                    }
                }
                case 3: {
                    this.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.mLock;
            synchronized (object) {
                this.unregisterReceiverLocked();
                this.abandonAudioFocusLocked();
            }
        }

        @Override
        public void sendIntent(Intent intent) {
            this.mBecomingNoisyIntentReceiver.onReceive(this.mContext, intent);
        }

        @GuardedBy(value="mLock")
        private boolean requestAudioFocusLocked() {
            int focusGain = this.convertAudioAttributesToFocusGainLocked();
            if (focusGain == 0) {
                return true;
            }
            int audioFocusRequestResult = this.mAudioManager.requestAudioFocus(this.mAudioFocusListener, this.mAudioAttributes.getVolumeControlStream(), focusGain);
            if (audioFocusRequestResult == 1) {
                this.mHasAudioFocus = true;
            } else {
                Log.w((String)AudioFocusHandler.TAG, (String)("requestAudioFocus(" + focusGain + ") failed (return=" + audioFocusRequestResult + ") playback wouldn't start."));
                this.mHasAudioFocus = false;
            }
            this.mResumeWhenAudioFocusGain = false;
            return this.mHasAudioFocus;
        }

        @GuardedBy(value="mLock")
        private void abandonAudioFocusLocked() {
            if (!this.mHasAudioFocus) {
                return;
            }
            this.mAudioManager.abandonAudioFocus(this.mAudioFocusListener);
            this.mHasAudioFocus = false;
            this.mResumeWhenAudioFocusGain = false;
        }

        @GuardedBy(value="mLock")
        private void registerReceiverLocked() {
            if (this.mHasRegisteredReceiver) {
                return;
            }
            this.mContext.registerReceiver(this.mBecomingNoisyIntentReceiver, this.mIntentFilter);
            this.mHasRegisteredReceiver = true;
        }

        @GuardedBy(value="mLock")
        private void unregisterReceiverLocked() {
            if (!this.mHasRegisteredReceiver) {
                return;
            }
            this.mContext.unregisterReceiver(this.mBecomingNoisyIntentReceiver);
            this.mHasRegisteredReceiver = false;
        }

        @GuardedBy(value="mLock")
        private int convertAudioAttributesToFocusGainLocked() {
            AudioAttributesCompat audioAttributesCompat = this.mAudioAttributes;
            if (audioAttributesCompat == null) {
                return 0;
            }
            switch (audioAttributesCompat.getUsage()) {
                case 1: 
                case 14: {
                    return 1;
                }
                case 2: 
                case 3: 
                case 4: {
                    return 2;
                }
                case 0: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: {
                    return 3;
                }
            }
            return 0;
        }

        private class AudioFocusListener
        implements AudioManager.OnAudioFocusChangeListener {
            private float mPlayerVolumeBeforeDucking;
            private float mPlayerDuckingVolume;

            private AudioFocusListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onAudioFocusChange(int focusGain) {
                switch (focusGain) {
                    case 1: {
                        float volumeBeforeDucking;
                        if (AudioFocusHandlerImplBase.this.mSession.getPlayerState() == 1) {
                            Object object = AudioFocusHandlerImplBase.this.mLock;
                            synchronized (object) {
                                if (!AudioFocusHandlerImplBase.this.mResumeWhenAudioFocusGain) {
                                    break;
                                }
                            }
                            AudioFocusHandlerImplBase.this.mSession.play();
                            break;
                        }
                        BaseMediaPlayer player = AudioFocusHandlerImplBase.this.mSession.getPlayer();
                        if (player == null) break;
                        float currentVolume = player.getPlayerVolume();
                        Object object = AudioFocusHandlerImplBase.this.mLock;
                        synchronized (object) {
                            if (currentVolume != this.mPlayerDuckingVolume) {
                                break;
                            }
                            volumeBeforeDucking = this.mPlayerVolumeBeforeDucking;
                        }
                        player.setPlayerVolume(volumeBeforeDucking);
                        break;
                    }
                    case -1: {
                        AudioFocusHandlerImplBase.this.mSession.pause();
                        Object player = AudioFocusHandlerImplBase.this.mLock;
                        synchronized (player) {
                            AudioFocusHandlerImplBase.this.mResumeWhenAudioFocusGain = false;
                            break;
                        }
                    }
                    case -3: {
                        boolean pause;
                        Object currentVolume = AudioFocusHandlerImplBase.this.mLock;
                        synchronized (currentVolume) {
                            if (AudioFocusHandlerImplBase.this.mAudioAttributes == null) {
                                break;
                            }
                            pause = AudioFocusHandlerImplBase.this.mAudioAttributes.getContentType() == 1;
                        }
                        if (pause) {
                            AudioFocusHandlerImplBase.this.mSession.pause();
                            break;
                        }
                        BaseMediaPlayer player = AudioFocusHandlerImplBase.this.mSession.getPlayer();
                        if (player == null) break;
                        float currentVolume2 = player.getPlayerVolume();
                        float duckingVolume = currentVolume2 * 0.2f;
                        Object object = AudioFocusHandlerImplBase.this.mLock;
                        synchronized (object) {
                            this.mPlayerVolumeBeforeDucking = currentVolume2;
                            this.mPlayerDuckingVolume = duckingVolume;
                        }
                        player.setPlayerVolume(duckingVolume);
                        break;
                    }
                    case -2: {
                        AudioFocusHandlerImplBase.this.mSession.pause();
                        Object object = AudioFocusHandlerImplBase.this.mLock;
                        synchronized (object) {
                            AudioFocusHandlerImplBase.this.mResumeWhenAudioFocusGain = true;
                            break;
                        }
                    }
                }
            }
        }

        private class NoisyIntentReceiver
        extends BroadcastReceiver {
            private NoisyIntentReceiver() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                Object object = AudioFocusHandlerImplBase.this.mLock;
                synchronized (object) {
                    if (!AudioFocusHandlerImplBase.this.mHasRegisteredReceiver) {
                        return;
                    }
                }
                if ("android.media.AUDIO_BECOMING_NOISY".equals(intent.getAction())) {
                    int usage;
                    Object object2 = AudioFocusHandlerImplBase.this.mLock;
                    synchronized (object2) {
                        if (AudioFocusHandlerImplBase.this.mAudioAttributes == null) {
                            return;
                        }
                        usage = AudioFocusHandlerImplBase.this.mAudioAttributes.getUsage();
                    }
                    switch (usage) {
                        case 1: {
                            AudioFocusHandlerImplBase.this.mSession.pause();
                            break;
                        }
                        case 14: {
                            BaseMediaPlayer player = AudioFocusHandlerImplBase.this.mSession.getPlayer();
                            if (player == null) break;
                            player.setPlayerVolume(player.getPlayerVolume() * 0.2f);
                            break;
                        }
                    }
                }
            }
        }
    }

    static interface AudioFocusHandlerImpl {
        public boolean onPlayRequested();

        public boolean onPauseRequested();

        public void onPlayerStateChanged(int var1);

        public void close();

        public void sendIntent(Intent var1);
    }
}

