/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.media.Media2DataSource;
import android.support.v4.util.Preconditions;
import java.io.FileDescriptor;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataSourceDesc {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_CALLBACK = 1;
    public static final int TYPE_FD = 2;
    public static final int TYPE_URI = 3;
    private static final long LONG_MAX = 0x7FFFFFFFFFFFFFFL;
    public static final long POSITION_UNKNOWN = 0x7FFFFFFFFFFFFFFL;
    public static final long FD_LENGTH_UNKNOWN = 0x7FFFFFFFFFFFFFFL;
    private int mType = 0;
    private Media2DataSource mMedia2DataSource;
    private FileDescriptor mFD;
    private long mFDOffset = 0L;
    private long mFDLength = 0x7FFFFFFFFFFFFFFL;
    private Uri mUri;
    private Map<String, String> mUriHeader;
    private List<HttpCookie> mUriCookies;
    private Context mUriContext;
    private String mMediaId;
    private long mStartPositionMs = 0L;
    private long mEndPositionMs = 0x7FFFFFFFFFFFFFFL;

    private DataSourceDesc() {
    }

    @Nullable
    public String getMediaId() {
        return this.mMediaId;
    }

    public long getStartPosition() {
        return this.mStartPositionMs;
    }

    public long getEndPosition() {
        return this.mEndPositionMs;
    }

    public int getType() {
        return this.mType;
    }

    @Nullable
    public Media2DataSource getMedia2DataSource() {
        return this.mMedia2DataSource;
    }

    @Nullable
    public FileDescriptor getFileDescriptor() {
        return this.mFD;
    }

    public long getFileDescriptorOffset() {
        return this.mFDOffset;
    }

    public long getFileDescriptorLength() {
        return this.mFDLength;
    }

    @Nullable
    public Uri getUri() {
        return this.mUri;
    }

    @Nullable
    public Map<String, String> getUriHeaders() {
        if (this.mUriHeader == null) {
            return null;
        }
        return new HashMap<String, String>(this.mUriHeader);
    }

    @Nullable
    public List<HttpCookie> getUriCookies() {
        if (this.mUriCookies == null) {
            return null;
        }
        return new ArrayList<HttpCookie>(this.mUriCookies);
    }

    @Nullable
    public Context getUriContext() {
        return this.mUriContext;
    }

    public static class Builder {
        private int mType = 0;
        private Media2DataSource mMedia2DataSource;
        private FileDescriptor mFD;
        private long mFDOffset = 0L;
        private long mFDLength = 0x7FFFFFFFFFFFFFFL;
        private Uri mUri;
        private Map<String, String> mUriHeader;
        private List<HttpCookie> mUriCookies;
        private Context mUriContext;
        private String mMediaId;
        private long mStartPositionMs = 0L;
        private long mEndPositionMs = 0x7FFFFFFFFFFFFFFL;

        public Builder() {
        }

        public Builder(@NonNull DataSourceDesc dsd) {
            this.mType = dsd.mType;
            this.mMedia2DataSource = dsd.mMedia2DataSource;
            this.mFD = dsd.mFD;
            this.mFDOffset = dsd.mFDOffset;
            this.mFDLength = dsd.mFDLength;
            this.mUri = dsd.mUri;
            this.mUriHeader = dsd.mUriHeader;
            this.mUriCookies = dsd.mUriCookies;
            this.mUriContext = dsd.mUriContext;
            this.mMediaId = dsd.mMediaId;
            this.mStartPositionMs = dsd.mStartPositionMs;
            this.mEndPositionMs = dsd.mEndPositionMs;
        }

        @NonNull
        public DataSourceDesc build() {
            if (this.mType != 1 && this.mType != 2 && this.mType != 3) {
                throw new IllegalStateException("Illegal type: " + this.mType);
            }
            if (this.mStartPositionMs > this.mEndPositionMs) {
                throw new IllegalStateException("Illegal start/end position: " + this.mStartPositionMs + " : " + this.mEndPositionMs);
            }
            DataSourceDesc dsd = new DataSourceDesc();
            dsd.mType = this.mType;
            dsd.mMedia2DataSource = this.mMedia2DataSource;
            dsd.mFD = this.mFD;
            dsd.mFDOffset = this.mFDOffset;
            dsd.mFDLength = this.mFDLength;
            dsd.mUri = this.mUri;
            dsd.mUriHeader = this.mUriHeader;
            dsd.mUriCookies = this.mUriCookies;
            dsd.mUriContext = this.mUriContext;
            dsd.mMediaId = this.mMediaId;
            dsd.mStartPositionMs = this.mStartPositionMs;
            dsd.mEndPositionMs = this.mEndPositionMs;
            return dsd;
        }

        @NonNull
        public Builder setMediaId(String mediaId) {
            this.mMediaId = mediaId;
            return this;
        }

        @NonNull
        public Builder setStartPosition(long position) {
            if (position < 0L) {
                position = 0L;
            }
            this.mStartPositionMs = position;
            return this;
        }

        @NonNull
        public Builder setEndPosition(long position) {
            if (position < 0L) {
                position = 0x7FFFFFFFFFFFFFFL;
            }
            this.mEndPositionMs = position;
            return this;
        }

        @NonNull
        public Builder setDataSource(@NonNull Media2DataSource m2ds) {
            Preconditions.checkNotNull((Object)m2ds);
            this.resetDataSource();
            this.mType = 1;
            this.mMedia2DataSource = m2ds;
            return this;
        }

        @NonNull
        public Builder setDataSource(@NonNull FileDescriptor fd) {
            Preconditions.checkNotNull((Object)fd);
            this.resetDataSource();
            this.mType = 2;
            this.mFD = fd;
            return this;
        }

        @NonNull
        public Builder setDataSource(@NonNull FileDescriptor fd, long offset, long length) {
            Preconditions.checkNotNull((Object)fd);
            if (offset < 0L) {
                offset = 0L;
            }
            if (length < 0L) {
                length = 0x7FFFFFFFFFFFFFFL;
            }
            this.resetDataSource();
            this.mType = 2;
            this.mFD = fd;
            this.mFDOffset = offset;
            this.mFDLength = length;
            return this;
        }

        @NonNull
        public Builder setDataSource(@NonNull Context context, @NonNull Uri uri) {
            Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
            Preconditions.checkNotNull((Object)uri, (Object)"uri cannot be null");
            this.resetDataSource();
            this.mType = 3;
            this.mUri = uri;
            this.mUriContext = context;
            return this;
        }

        @NonNull
        public Builder setDataSource(@NonNull Context context, @NonNull Uri uri, @Nullable Map<String, String> headers, @Nullable List<HttpCookie> cookies) {
            CookieHandler cookieHandler;
            Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
            Preconditions.checkNotNull((Object)uri);
            if (cookies != null && (cookieHandler = CookieHandler.getDefault()) != null && !(cookieHandler instanceof CookieManager)) {
                throw new IllegalArgumentException("The cookie handler has to be of CookieManager type when cookies are provided.");
            }
            this.resetDataSource();
            this.mType = 3;
            this.mUri = uri;
            if (headers != null) {
                this.mUriHeader = new HashMap<String, String>(headers);
            }
            if (cookies != null) {
                this.mUriCookies = new ArrayList<HttpCookie>(cookies);
            }
            this.mUriContext = context;
            return this;
        }

        private void resetDataSource() {
            this.mType = 0;
            this.mMedia2DataSource = null;
            this.mFD = null;
            this.mFDOffset = 0L;
            this.mFDLength = 0x7FFFFFFFFFFFFFFL;
            this.mUri = null;
            this.mUriHeader = null;
            this.mUriCookies = null;
            this.mUriContext = null;
        }
    }
}

