/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.content.Context;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.media.MediaBrowser2;
import android.support.v4.media.MediaBrowserCompat;
import android.support.v4.media.MediaController2ImplLegacy;
import android.support.v4.media.MediaItem2;
import android.support.v4.media.MediaUtils2;
import android.support.v4.media.SessionToken2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;

class MediaBrowser2ImplLegacy
extends MediaController2ImplLegacy
implements MediaBrowser2.SupportLibraryImpl {
    public static final String EXTRA_ITEM_COUNT = "android.media.browse.extra.ITEM_COUNT";
    @GuardedBy(value="mLock")
    private final HashMap<Bundle, MediaBrowserCompat> mBrowserCompats = new HashMap();
    @GuardedBy(value="mLock")
    private final HashMap<String, List<SubscribeCallback>> mSubscribeCallbacks = new HashMap();

    MediaBrowser2ImplLegacy(@NonNull Context context, MediaBrowser2 instance, @NonNull SessionToken2 token, @NonNull Executor executor, @NonNull MediaBrowser2.BrowserCallback callback) {
        super(context, instance, token, executor, callback);
    }

    @Override
    public MediaBrowser2 getInstance() {
        return (MediaBrowser2)super.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            for (MediaBrowserCompat browser : this.mBrowserCompats.values()) {
                browser.disconnect();
            }
            this.mBrowserCompats.clear();
            super.close();
        }
    }

    @Override
    public void getLibraryRoot(final @Nullable Bundle extras) {
        final MediaBrowserCompat browser = this.getBrowserCompat(extras);
        if (browser != null) {
            this.getCallbackExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    MediaBrowser2ImplLegacy.this.getCallback().onGetLibraryRootDone(MediaBrowser2ImplLegacy.this.getInstance(), extras, browser.getRoot(), browser.getExtras());
                }
            });
        } else {
            this.getCallbackExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MediaBrowserCompat newBrowser = new MediaBrowserCompat(MediaBrowser2ImplLegacy.this.getContext(), MediaBrowser2ImplLegacy.this.getSessionToken().getComponentName(), new GetLibraryRootCallback(extras), extras);
                    Object object = MediaBrowser2ImplLegacy.this.mLock;
                    synchronized (object) {
                        MediaBrowser2ImplLegacy.this.mBrowserCompats.put(extras, newBrowser);
                    }
                    newBrowser.connect();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(@NonNull String parentId, @Nullable Bundle extras) {
        if (parentId == null) {
            throw new IllegalArgumentException("parentId shouldn't be null");
        }
        MediaBrowserCompat browser = this.getBrowserCompat();
        if (browser == null) {
            return;
        }
        SubscribeCallback callback = new SubscribeCallback();
        Object object = this.mLock;
        synchronized (object) {
            List<SubscribeCallback> list = this.mSubscribeCallbacks.get(parentId);
            if (list == null) {
                list = new ArrayList<SubscribeCallback>();
                this.mSubscribeCallbacks.put(parentId, list);
            }
            list.add(callback);
        }
        Bundle options = new Bundle();
        options.putBundle("android.support.v4.media.argument.EXTRAS", extras);
        browser.subscribe(parentId, options, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(@NonNull String parentId) {
        if (parentId == null) {
            throw new IllegalArgumentException("parentId shouldn't be null");
        }
        MediaBrowserCompat browser = this.getBrowserCompat();
        if (browser == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            List<SubscribeCallback> list = this.mSubscribeCallbacks.get(parentId);
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                browser.unsubscribe(parentId, list.get(i));
            }
        }
    }

    @Override
    public void getChildren(@NonNull String parentId, int page, int pageSize, @Nullable Bundle extras) {
        if (parentId == null) {
            throw new IllegalArgumentException("parentId shouldn't be null");
        }
        if (page < 1 || pageSize < 1) {
            throw new IllegalArgumentException("Neither page nor pageSize should be less than 1");
        }
        MediaBrowserCompat browser = this.getBrowserCompat();
        if (browser == null) {
            return;
        }
        Bundle options = MediaUtils2.createBundle(extras);
        options.putInt("android.media.browse.extra.PAGE", page);
        options.putInt("android.media.browse.extra.PAGE_SIZE", pageSize);
        browser.subscribe(parentId, options, new GetChildrenCallback(parentId, page, pageSize));
    }

    @Override
    public void getItem(final @NonNull String mediaId) {
        MediaBrowserCompat browser = this.getBrowserCompat();
        if (browser == null) {
            return;
        }
        browser.getItem(mediaId, new MediaBrowserCompat.ItemCallback(){

            @Override
            public void onItemLoaded(final MediaBrowserCompat.MediaItem item) {
                MediaBrowser2ImplLegacy.this.getCallbackExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        MediaBrowser2ImplLegacy.this.getCallback().onGetItemDone(MediaBrowser2ImplLegacy.this.getInstance(), mediaId, MediaUtils2.convertToMediaItem2(item));
                    }
                });
            }

            @Override
            public void onError(String itemId) {
                MediaBrowser2ImplLegacy.this.getCallbackExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        MediaBrowser2ImplLegacy.this.getCallback().onGetItemDone(MediaBrowser2ImplLegacy.this.getInstance(), mediaId, null);
                    }
                });
            }
        });
    }

    @Override
    public void search(@NonNull String query, @Nullable Bundle extras) {
        MediaBrowserCompat browser = this.getBrowserCompat();
        if (browser == null) {
            return;
        }
        browser.search(query, extras, new MediaBrowserCompat.SearchCallback(){

            @Override
            public void onSearchResult(final String query, final Bundle extras, final List<MediaBrowserCompat.MediaItem> items) {
                MediaBrowser2ImplLegacy.this.getCallbackExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        MediaBrowser2ImplLegacy.this.getCallback().onSearchResultChanged(MediaBrowser2ImplLegacy.this.getInstance(), query, items.size(), extras);
                    }
                });
            }

            @Override
            public void onError(String query, Bundle extras) {
            }
        });
    }

    @Override
    public void getSearchResult(@NonNull String query, final int page, final int pageSize, final @Nullable Bundle extras) {
        MediaBrowserCompat browser = this.getBrowserCompat();
        if (browser == null) {
            return;
        }
        Bundle options = MediaUtils2.createBundle(extras);
        options.putInt("android.media.browse.extra.PAGE", page);
        options.putInt("android.media.browse.extra.PAGE_SIZE", pageSize);
        browser.search(query, options, new MediaBrowserCompat.SearchCallback(){

            @Override
            public void onSearchResult(final String query, Bundle extrasSent, final List<MediaBrowserCompat.MediaItem> items) {
                MediaBrowser2ImplLegacy.this.getCallbackExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        List<MediaItem2> item2List = MediaUtils2.convertMediaItemListToMediaItem2List(items);
                        MediaBrowser2ImplLegacy.this.getCallback().onGetSearchResultDone(MediaBrowser2ImplLegacy.this.getInstance(), query, page, pageSize, item2List, extras);
                    }
                });
            }

            @Override
            public void onError(final String query, Bundle extrasSent) {
                MediaBrowser2ImplLegacy.this.getCallbackExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        MediaBrowser2ImplLegacy.this.getCallback().onGetSearchResultDone(MediaBrowser2ImplLegacy.this.getInstance(), query, page, pageSize, null, extras);
                    }
                });
            }
        });
    }

    @Override
    public MediaBrowser2.BrowserCallback getCallback() {
        return (MediaBrowser2.BrowserCallback)super.getCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaBrowserCompat getBrowserCompat(Bundle extras) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mBrowserCompats.get(extras);
        }
    }

    private Bundle getExtrasWithoutPagination(Bundle extras) {
        if (extras == null) {
            return null;
        }
        extras.setClassLoader(this.getContext().getClassLoader());
        try {
            extras.remove("android.media.browse.extra.PAGE");
            extras.remove("android.media.browse.extra.PAGE_SIZE");
        }
        catch (BadParcelableException badParcelableException) {
            // empty catch block
        }
        return extras;
    }

    private class GetChildrenCallback
    extends MediaBrowserCompat.SubscriptionCallback {
        private final String mParentId;
        private final int mPage;
        private final int mPageSize;

        GetChildrenCallback(String parentId, int page, int pageSize) {
            this.mParentId = parentId;
            this.mPage = page;
            this.mPageSize = pageSize;
        }

        @Override
        public void onError(String parentId) {
            this.onChildrenLoaded(parentId, null, null);
        }

        @Override
        public void onError(String parentId, Bundle options) {
            this.onChildrenLoaded(parentId, null, options);
        }

        @Override
        public void onChildrenLoaded(String parentId, List<MediaBrowserCompat.MediaItem> children) {
            this.onChildrenLoaded(parentId, children, null);
        }

        @Override
        public void onChildrenLoaded(final String parentId, List<MediaBrowserCompat.MediaItem> children, Bundle options) {
            ArrayList<MediaItem2> items;
            if (children == null) {
                items = null;
            } else {
                items = new ArrayList<MediaItem2>();
                for (int i = 0; i < children.size(); ++i) {
                    items.add(MediaUtils2.convertToMediaItem2(children.get(i)));
                }
            }
            final Bundle extras = MediaBrowser2ImplLegacy.this.getExtrasWithoutPagination(options);
            MediaBrowser2ImplLegacy.this.getCallbackExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    MediaBrowserCompat browser = MediaBrowser2ImplLegacy.this.getBrowserCompat();
                    if (browser == null) {
                        return;
                    }
                    MediaBrowser2ImplLegacy.this.getCallback().onGetChildrenDone(MediaBrowser2ImplLegacy.this.getInstance(), parentId, GetChildrenCallback.this.mPage, GetChildrenCallback.this.mPageSize, items, extras);
                    browser.unsubscribe(GetChildrenCallback.this.mParentId, GetChildrenCallback.this);
                }
            });
        }
    }

    private class SubscribeCallback
    extends MediaBrowserCompat.SubscriptionCallback {
        private SubscribeCallback() {
        }

        @Override
        public void onError(String parentId) {
            this.onChildrenLoaded(parentId, null, null);
        }

        @Override
        public void onError(String parentId, Bundle options) {
            this.onChildrenLoaded(parentId, null, options);
        }

        @Override
        public void onChildrenLoaded(String parentId, List<MediaBrowserCompat.MediaItem> children) {
            this.onChildrenLoaded(parentId, children, null);
        }

        @Override
        public void onChildrenLoaded(final String parentId, List<MediaBrowserCompat.MediaItem> children, Bundle options) {
            int itemCount;
            if (options != null && options.containsKey(MediaBrowser2ImplLegacy.EXTRA_ITEM_COUNT)) {
                itemCount = options.getInt(MediaBrowser2ImplLegacy.EXTRA_ITEM_COUNT);
            } else if (children != null) {
                itemCount = children.size();
            } else {
                return;
            }
            final Bundle notifyChildrenChangedOptions = MediaBrowser2ImplLegacy.this.getBrowserCompat().getNotifyChildrenChangedOptions();
            MediaBrowser2ImplLegacy.this.getCallbackExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    MediaBrowser2ImplLegacy.this.getCallback().onChildrenChanged(MediaBrowser2ImplLegacy.this.getInstance(), parentId, itemCount, notifyChildrenChangedOptions);
                }
            });
        }
    }

    private class GetLibraryRootCallback
    extends MediaBrowserCompat.ConnectionCallback {
        private final Bundle mExtras;

        GetLibraryRootCallback(Bundle extras) {
            this.mExtras = extras;
        }

        @Override
        public void onConnected() {
            MediaBrowser2ImplLegacy.this.getCallbackExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MediaBrowserCompat browser;
                    Object object = MediaBrowser2ImplLegacy.this.mLock;
                    synchronized (object) {
                        browser = (MediaBrowserCompat)MediaBrowser2ImplLegacy.this.mBrowserCompats.get(GetLibraryRootCallback.this.mExtras);
                    }
                    if (browser == null) {
                        return;
                    }
                    MediaBrowser2ImplLegacy.this.getCallback().onGetLibraryRootDone(MediaBrowser2ImplLegacy.this.getInstance(), GetLibraryRootCallback.this.mExtras, browser.getRoot(), browser.getExtras());
                }
            });
        }

        @Override
        public void onConnectionSuspended() {
            MediaBrowser2ImplLegacy.this.close();
        }

        @Override
        public void onConnectionFailed() {
            MediaBrowser2ImplLegacy.this.close();
        }
    }
}

