/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.content.Context;
import android.media.browse.MediaBrowser;
import android.os.Bundle;
import android.os.Parcel;
import android.service.media.MediaBrowserService;
import android.support.annotation.RequiresApi;
import android.support.v4.media.MediaBrowserServiceCompatApi23;
import android.util.Log;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(value=26)
class MediaBrowserServiceCompatApi26 {
    private static final String TAG = "MBSCompatApi26";
    private static Field sResultFlags;

    public static Object createService(Context context, ServiceCompatProxy serviceProxy) {
        return new MediaBrowserServiceAdaptor(context, serviceProxy);
    }

    public static void notifyChildrenChanged(Object serviceObj, String parentId, Bundle options) {
        ((MediaBrowserService)serviceObj).notifyChildrenChanged(parentId, options);
    }

    public static Bundle getBrowserRootHints(Object serviceObj) {
        return ((MediaBrowserService)serviceObj).getBrowserRootHints();
    }

    private MediaBrowserServiceCompatApi26() {
    }

    static {
        try {
            sResultFlags = MediaBrowserService.Result.class.getDeclaredField("mFlags");
            sResultFlags.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    static class MediaBrowserServiceAdaptor
    extends MediaBrowserServiceCompatApi23.MediaBrowserServiceAdaptor {
        MediaBrowserServiceAdaptor(Context context, ServiceCompatProxy serviceWrapper) {
            super(context, serviceWrapper);
        }

        public void onLoadChildren(String parentId, MediaBrowserService.Result<List<MediaBrowser.MediaItem>> result, Bundle options) {
            ((ServiceCompatProxy)this.mServiceProxy).onLoadChildren(parentId, new ResultWrapper(result), options);
        }
    }

    static class ResultWrapper {
        MediaBrowserService.Result mResultObj;

        ResultWrapper(MediaBrowserService.Result result) {
            this.mResultObj = result;
        }

        public void sendResult(List<Parcel> result, int flags) {
            try {
                sResultFlags.setInt(this.mResultObj, flags);
            }
            catch (IllegalAccessException e) {
                Log.w((String)MediaBrowserServiceCompatApi26.TAG, (Throwable)e);
            }
            this.mResultObj.sendResult(this.parcelListToItemList(result));
        }

        public void detach() {
            this.mResultObj.detach();
        }

        List<MediaBrowser.MediaItem> parcelListToItemList(List<Parcel> parcelList) {
            if (parcelList == null) {
                return null;
            }
            ArrayList<MediaBrowser.MediaItem> items = new ArrayList<MediaBrowser.MediaItem>();
            for (Parcel parcel : parcelList) {
                parcel.setDataPosition(0);
                items.add((MediaBrowser.MediaItem)MediaBrowser.MediaItem.CREATOR.createFromParcel(parcel));
                parcel.recycle();
            }
            return items;
        }
    }

    public static interface ServiceCompatProxy
    extends MediaBrowserServiceCompatApi23.ServiceCompatProxy {
        public void onLoadChildren(String var1, ResultWrapper var2, Bundle var3);
    }
}

