/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.mediacompat.Rating2;
import android.support.v4.media.IMediaSession2;
import android.support.v4.media.MediaBrowserCompat;
import android.support.v4.media.MediaController2;
import android.support.v4.media.MediaController2Stub;
import android.support.v4.media.MediaItem2;
import android.support.v4.media.MediaMetadata2;
import android.support.v4.media.MediaSession2;
import android.support.v4.media.MediaUtils2;
import android.support.v4.media.SessionCommand2;
import android.support.v4.media.SessionCommandGroup2;
import android.support.v4.media.SessionToken2;
import android.util.Log;
import java.util.List;
import java.util.concurrent.Executor;

class MediaController2ImplBase
implements MediaController2.SupportLibraryImpl {
    static final String TAG = "MC2ImplBase";
    static final boolean DEBUG = Log.isLoggable((String)"MC2ImplBase", (int)3);
    private final MediaController2 mInstance;
    private final Context mContext;
    private final Object mLock = new Object();
    private final SessionToken2 mToken;
    private final MediaController2.ControllerCallback mCallback;
    private final Executor mCallbackExecutor;
    private final IBinder.DeathRecipient mDeathRecipient;
    final MediaController2Stub mControllerStub;
    @GuardedBy(value="mLock")
    private SessionServiceConnection mServiceConnection;
    @GuardedBy(value="mLock")
    private boolean mIsReleased;
    @GuardedBy(value="mLock")
    private List<MediaItem2> mPlaylist;
    @GuardedBy(value="mLock")
    private MediaMetadata2 mPlaylistMetadata;
    @GuardedBy(value="mLock")
    private int mRepeatMode;
    @GuardedBy(value="mLock")
    private int mShuffleMode;
    @GuardedBy(value="mLock")
    private int mPlayerState;
    @GuardedBy(value="mLock")
    private long mPositionEventTimeMs;
    @GuardedBy(value="mLock")
    private long mPositionMs;
    @GuardedBy(value="mLock")
    private float mPlaybackSpeed;
    @GuardedBy(value="mLock")
    private MediaItem2 mCurrentMediaItem;
    @GuardedBy(value="mLock")
    private int mBufferingState;
    @GuardedBy(value="mLock")
    private long mBufferedPositionMs;
    @GuardedBy(value="mLock")
    private MediaController2.PlaybackInfo mPlaybackInfo;
    @GuardedBy(value="mLock")
    private PendingIntent mSessionActivity;
    @GuardedBy(value="mLock")
    private SessionCommandGroup2 mAllowedCommands;
    @GuardedBy(value="mLock")
    private volatile IMediaSession2 mISession2;

    MediaController2ImplBase(Context context, MediaController2 instance, SessionToken2 token, Executor executor, MediaController2.ControllerCallback callback) {
        this.mInstance = instance;
        if (context == null) {
            throw new IllegalArgumentException("context shouldn't be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("token shouldn't be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback shouldn't be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor shouldn't be null");
        }
        this.mContext = context;
        this.mControllerStub = new MediaController2Stub(this);
        this.mToken = token;
        this.mCallback = callback;
        this.mCallbackExecutor = executor;
        this.mDeathRecipient = new IBinder.DeathRecipient(){

            public void binderDied() {
                MediaController2ImplBase.this.mInstance.close();
            }
        };
        IMediaSession2 iSession2 = IMediaSession2.Stub.asInterface((IBinder)this.mToken.getBinder());
        if (this.mToken.getType() == 0) {
            this.mServiceConnection = null;
            this.connectToSession(iSession2);
        } else {
            this.mServiceConnection = new SessionServiceConnection();
            this.connectToService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        IMediaSession2 iSession2;
        if (DEBUG) {
            Log.d((String)TAG, (String)("release from " + this.mToken));
        }
        Object object = this.mLock;
        synchronized (object) {
            iSession2 = this.mISession2;
            if (this.mIsReleased) {
                return;
            }
            this.mIsReleased = true;
            if (this.mServiceConnection != null) {
                this.mContext.unbindService((ServiceConnection)this.mServiceConnection);
                this.mServiceConnection = null;
            }
            this.mISession2 = null;
            this.mControllerStub.destroy();
        }
        if (iSession2 != null) {
            try {
                iSession2.asBinder().unlinkToDeath(this.mDeathRecipient, 0);
                iSession2.release(this.mControllerStub);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                MediaController2ImplBase.this.mCallback.onDisconnected(MediaController2ImplBase.this.mInstance);
            }
        });
    }

    @Override
    public SessionToken2 getSessionToken() {
        return this.mToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mISession2 != null;
        }
    }

    @Override
    public void play() {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(1);
        if (iSession2 != null) {
            try {
                iSession2.play(this.mControllerStub);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void pause() {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(2);
        if (iSession2 != null) {
            try {
                iSession2.pause(this.mControllerStub);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void reset() {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(3);
        if (iSession2 != null) {
            try {
                iSession2.reset(this.mControllerStub);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void prepare() {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(6);
        if (iSession2 != null) {
            try {
                iSession2.prepare(this.mControllerStub);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void fastForward() {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(7);
        if (iSession2 != null) {
            try {
                iSession2.fastForward(this.mControllerStub);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void rewind() {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(8);
        if (iSession2 != null) {
            try {
                iSession2.rewind(this.mControllerStub);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void seekTo(long pos) {
        if (pos < 0L) {
            throw new IllegalArgumentException("position shouldn't be negative");
        }
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(9);
        if (iSession2 != null) {
            try {
                iSession2.seekTo(this.mControllerStub, pos);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void skipForward() {
    }

    @Override
    public void skipBackward() {
    }

    @Override
    public void playFromMediaId(@NonNull String mediaId, @Nullable Bundle extras) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(22);
        if (iSession2 != null) {
            try {
                iSession2.playFromMediaId(this.mControllerStub, mediaId, extras);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void playFromSearch(@NonNull String query, @Nullable Bundle extras) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(24);
        if (iSession2 != null) {
            try {
                iSession2.playFromSearch(this.mControllerStub, query, extras);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void playFromUri(Uri uri, Bundle extras) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(23);
        if (iSession2 != null) {
            try {
                iSession2.playFromUri(this.mControllerStub, uri, extras);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void prepareFromMediaId(@NonNull String mediaId, @Nullable Bundle extras) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(25);
        if (iSession2 != null) {
            try {
                iSession2.prepareFromMediaId(this.mControllerStub, mediaId, extras);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void prepareFromSearch(@NonNull String query, @Nullable Bundle extras) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(27);
        if (iSession2 != null) {
            try {
                iSession2.prepareFromSearch(this.mControllerStub, query, extras);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void prepareFromUri(@NonNull Uri uri, @Nullable Bundle extras) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(26);
        if (iSession2 != null) {
            try {
                iSession2.prepareFromUri(this.mControllerStub, uri, extras);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void setVolumeTo(int value, int flags) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(10);
        if (iSession2 != null) {
            try {
                iSession2.setVolumeTo(this.mControllerStub, value, flags);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void adjustVolume(int direction, int flags) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(11);
        if (iSession2 != null) {
            try {
                iSession2.adjustVolume(this.mControllerStub, direction, flags);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PendingIntent getSessionActivity() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSessionActivity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPlayerState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPlayerState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDuration() {
        Object object = this.mLock;
        synchronized (object) {
            MediaMetadata2 metadata = this.mCurrentMediaItem.getMetadata();
            if (metadata != null && metadata.containsKey("android.media.metadata.DURATION")) {
                return metadata.getLong("android.media.metadata.DURATION");
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCurrentPosition() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mISession2 == null) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return -1L;
            }
            long timeDiff = this.mInstance.mTimeDiff != null ? this.mInstance.mTimeDiff : SystemClock.elapsedRealtime() - this.mPositionEventTimeMs;
            long expectedPosition = this.mPositionMs + (long)(this.mPlaybackSpeed * (float)timeDiff);
            return Math.max(0L, expectedPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getPlaybackSpeed() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mISession2 == null) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return 0.0f;
            }
            return this.mPlaybackSpeed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlaybackSpeed(float speed) {
        Object object = this.mLock;
        synchronized (object) {
            IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(39);
            if (iSession2 != null) {
                try {
                    iSession2.setPlaybackSpeed(this.mControllerStub, speed);
                }
                catch (RemoteException e) {
                    Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBufferingState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mISession2 == null) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return 0;
            }
            return this.mBufferingState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBufferedPosition() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mISession2 == null) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return -1L;
            }
            return this.mBufferedPositionMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaController2.PlaybackInfo getPlaybackInfo() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPlaybackInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRating(@NonNull String mediaId, @NonNull Rating2 rating) {
        IMediaSession2 iSession2;
        Object object = this.mLock;
        synchronized (object) {
            iSession2 = this.mISession2;
        }
        if (iSession2 != null) {
            try {
                iSession2.setRating(this.mControllerStub, mediaId, rating.toBundle());
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void sendCustomCommand(@NonNull SessionCommand2 command, Bundle args, @Nullable ResultReceiver cb) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(command);
        if (iSession2 != null) {
            try {
                iSession2.sendCustomCommand(this.mControllerStub, command.toBundle(), args, cb);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MediaItem2> getPlaylist() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPlaylist;
        }
    }

    @Override
    public void setPlaylist(@NonNull List<MediaItem2> list, @Nullable MediaMetadata2 metadata) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(19);
        if (iSession2 != null) {
            try {
                iSession2.setPlaylist(this.mControllerStub, MediaUtils2.convertMediaItem2ListToBundleList(list), metadata == null ? null : metadata.toBundle());
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void updatePlaylistMetadata(@Nullable MediaMetadata2 metadata) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(21);
        if (iSession2 != null) {
            try {
                iSession2.updatePlaylistMetadata(this.mControllerStub, metadata == null ? null : metadata.toBundle());
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaMetadata2 getPlaylistMetadata() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPlaylistMetadata;
        }
    }

    @Override
    public void addPlaylistItem(int index, @NonNull MediaItem2 item) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(15);
        if (iSession2 != null) {
            try {
                iSession2.addPlaylistItem(this.mControllerStub, index, item.toBundle());
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void removePlaylistItem(@NonNull MediaItem2 item) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(16);
        if (iSession2 != null) {
            try {
                iSession2.removePlaylistItem(this.mControllerStub, item.toBundle());
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void replacePlaylistItem(int index, @NonNull MediaItem2 item) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(17);
        if (iSession2 != null) {
            try {
                iSession2.replacePlaylistItem(this.mControllerStub, index, item.toBundle());
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaItem2 getCurrentMediaItem() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrentMediaItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skipToPreviousItem() {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(5);
        Object object = this.mLock;
        synchronized (object) {
            if (iSession2 != null) {
                try {
                    iSession2.skipToPreviousItem(this.mControllerStub);
                }
                catch (RemoteException e) {
                    Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skipToNextItem() {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(4);
        Object object = this.mLock;
        synchronized (object) {
            if (iSession2 != null) {
                try {
                    this.mISession2.skipToNextItem(this.mControllerStub);
                }
                catch (RemoteException e) {
                    Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skipToPlaylistItem(@NonNull MediaItem2 item) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(12);
        Object object = this.mLock;
        synchronized (object) {
            if (iSession2 != null) {
                try {
                    this.mISession2.skipToPlaylistItem(this.mControllerStub, item.toBundle());
                }
                catch (RemoteException e) {
                    Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRepeatMode() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRepeatMode;
        }
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(14);
        if (iSession2 != null) {
            try {
                iSession2.setRepeatMode(this.mControllerStub, repeatMode);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getShuffleMode() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mShuffleMode;
        }
    }

    @Override
    public void setShuffleMode(int shuffleMode) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(13);
        if (iSession2 != null) {
            try {
                iSession2.setShuffleMode(this.mControllerStub, shuffleMode);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void subscribeRoutesInfo() {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(36);
        if (iSession2 != null) {
            try {
                iSession2.subscribeRoutesInfo(this.mControllerStub);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void unsubscribeRoutesInfo() {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(37);
        if (iSession2 != null) {
            try {
                iSession2.unsubscribeRoutesInfo(this.mControllerStub);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    public void selectRoute(@NonNull Bundle route) {
        IMediaSession2 iSession2 = this.getSessionInterfaceIfAble(38);
        if (iSession2 != null) {
            try {
                iSession2.selectRoute(this.mControllerStub, route);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Cannot connect to the service or the session is gone", (Throwable)e);
            }
        }
    }

    @Override
    @NonNull
    public Context getContext() {
        return this.mContext;
    }

    @Override
    @NonNull
    public MediaController2.ControllerCallback getCallback() {
        return this.mCallback;
    }

    @Override
    @NonNull
    public Executor getCallbackExecutor() {
        return this.mCallbackExecutor;
    }

    @Override
    @Nullable
    public MediaBrowserCompat getBrowserCompat() {
        return null;
    }

    @Override
    @NonNull
    public MediaController2 getInstance() {
        return this.mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToService() {
        Intent intent = new Intent("android.media.MediaSessionService2");
        intent.setClassName(this.mToken.getPackageName(), this.mToken.getServiceName());
        Object object = this.mLock;
        synchronized (object) {
            boolean result = this.mContext.bindService(intent, (ServiceConnection)this.mServiceConnection, 1);
            if (!result) {
                Log.w((String)TAG, (String)("bind to " + this.mToken + " failed"));
            } else if (DEBUG) {
                Log.d((String)TAG, (String)("bind to " + this.mToken + " success"));
            }
        }
    }

    private void connectToSession(IMediaSession2 sessionBinder) {
        try {
            sessionBinder.connect(this.mControllerStub, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)"Failed to call connection request. Framework will retry automatically");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IMediaSession2 getSessionInterfaceIfAble(int commandCode) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAllowedCommands.hasCommand(commandCode)) {
                Log.w((String)TAG, (String)("Controller isn't allowed to call command, commandCode=" + commandCode));
                return null;
            }
            return this.mISession2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IMediaSession2 getSessionInterfaceIfAble(SessionCommand2 command) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAllowedCommands.hasCommand(command)) {
                Log.w((String)TAG, (String)("Controller isn't allowed to call command, command=" + command));
                return null;
            }
            return this.mISession2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCurrentMediaItemChanged(final MediaItem2 item) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentMediaItem = item;
        }
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!MediaController2ImplBase.this.mInstance.isConnected()) {
                    return;
                }
                MediaController2ImplBase.this.mCallback.onCurrentMediaItemChanged(MediaController2ImplBase.this.mInstance, item);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPlayerStateChanges(long eventTimeMs, long positionMs, final int state) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPositionEventTimeMs = eventTimeMs;
            this.mPositionMs = positionMs;
            this.mPlayerState = state;
        }
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!MediaController2ImplBase.this.mInstance.isConnected()) {
                    return;
                }
                MediaController2ImplBase.this.mCallback.onPlayerStateChanged(MediaController2ImplBase.this.mInstance, state);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPlaybackSpeedChanges(long eventTimeMs, long positionMs, final float speed) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPositionEventTimeMs = eventTimeMs;
            this.mPositionMs = positionMs;
            this.mPlaybackSpeed = speed;
        }
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!MediaController2ImplBase.this.mInstance.isConnected()) {
                    return;
                }
                MediaController2ImplBase.this.mCallback.onPlaybackSpeedChanged(MediaController2ImplBase.this.mInstance, speed);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyBufferingStateChanged(final MediaItem2 item, final int state, long bufferedPositionMs) {
        Object object = this.mLock;
        synchronized (object) {
            this.mBufferingState = state;
            this.mBufferedPositionMs = bufferedPositionMs;
        }
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!MediaController2ImplBase.this.mInstance.isConnected()) {
                    return;
                }
                MediaController2ImplBase.this.mCallback.onBufferingStateChanged(MediaController2ImplBase.this.mInstance, item, state);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPlaylistChanges(final List<MediaItem2> playlist, final MediaMetadata2 metadata) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPlaylist = playlist;
            this.mPlaylistMetadata = metadata;
        }
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!MediaController2ImplBase.this.mInstance.isConnected()) {
                    return;
                }
                MediaController2ImplBase.this.mCallback.onPlaylistChanged(MediaController2ImplBase.this.mInstance, playlist, metadata);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPlaylistMetadataChanges(final MediaMetadata2 metadata) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPlaylistMetadata = metadata;
        }
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!MediaController2ImplBase.this.mInstance.isConnected()) {
                    return;
                }
                MediaController2ImplBase.this.mCallback.onPlaylistMetadataChanged(MediaController2ImplBase.this.mInstance, metadata);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPlaybackInfoChanges(final MediaController2.PlaybackInfo info) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPlaybackInfo = info;
        }
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!MediaController2ImplBase.this.mInstance.isConnected()) {
                    return;
                }
                MediaController2ImplBase.this.mCallback.onPlaybackInfoChanged(MediaController2ImplBase.this.mInstance, info);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyRepeatModeChanges(final int repeatMode) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRepeatMode = repeatMode;
        }
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!MediaController2ImplBase.this.mInstance.isConnected()) {
                    return;
                }
                MediaController2ImplBase.this.mCallback.onRepeatModeChanged(MediaController2ImplBase.this.mInstance, repeatMode);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyShuffleModeChanges(final int shuffleMode) {
        Object object = this.mLock;
        synchronized (object) {
            this.mShuffleMode = shuffleMode;
        }
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!MediaController2ImplBase.this.mInstance.isConnected()) {
                    return;
                }
                MediaController2ImplBase.this.mCallback.onShuffleModeChanged(MediaController2ImplBase.this.mInstance, shuffleMode);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifySeekCompleted(long eventTimeMs, long positionMs, final long seekPositionMs) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPositionEventTimeMs = eventTimeMs;
            this.mPositionMs = positionMs;
        }
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!MediaController2ImplBase.this.mInstance.isConnected()) {
                    return;
                }
                MediaController2ImplBase.this.mCallback.onSeekCompleted(MediaController2ImplBase.this.mInstance, seekPositionMs);
            }
        });
    }

    void notifyError(final int errorCode, final Bundle extras) {
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!MediaController2ImplBase.this.mInstance.isConnected()) {
                    return;
                }
                MediaController2ImplBase.this.mCallback.onError(MediaController2ImplBase.this.mInstance, errorCode, extras);
            }
        });
    }

    void notifyRoutesInfoChanged(final List<Bundle> routes) {
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!MediaController2ImplBase.this.mInstance.isConnected()) {
                    return;
                }
                MediaController2ImplBase.this.mCallback.onRoutesInfoChanged(MediaController2ImplBase.this.mInstance, routes);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void onConnectedNotLocked(IMediaSession2 sessionBinder, final SessionCommandGroup2 allowedCommands, int playerState, MediaItem2 currentMediaItem, long positionEventTimeMs, long positionMs, float playbackSpeed, long bufferedPositionMs, MediaController2.PlaybackInfo info, int repeatMode, int shuffleMode, List<MediaItem2> playlist, PendingIntent sessionActivity) {
        boolean close;
        block17: {
            if (DEBUG) {
                Log.d((String)TAG, (String)("onConnectedNotLocked sessionBinder=" + sessionBinder + ", allowedCommands=" + allowedCommands));
            }
            close = false;
            if (sessionBinder == null || allowedCommands == null) {
                close = true;
                if (!close) return;
                this.mInstance.close();
                return;
            }
            Object object = this.mLock;
            // MONITORENTER : object
            if (this.mIsReleased) {
                // MONITOREXIT : object
                if (!close) return;
                this.mInstance.close();
                return;
            }
            if (this.mISession2 == null) break block17;
            Log.e((String)TAG, (String)"Cannot be notified about the connection result many times. Probably a bug or malicious app.");
            close = true;
            // MONITOREXIT : object
            if (!close) return;
            this.mInstance.close();
            return;
        }
        this.mAllowedCommands = allowedCommands;
        this.mPlayerState = playerState;
        this.mCurrentMediaItem = currentMediaItem;
        this.mPositionEventTimeMs = positionEventTimeMs;
        this.mPositionMs = positionMs;
        this.mPlaybackSpeed = playbackSpeed;
        this.mBufferedPositionMs = bufferedPositionMs;
        this.mPlaybackInfo = info;
        this.mRepeatMode = repeatMode;
        this.mShuffleMode = shuffleMode;
        this.mPlaylist = playlist;
        this.mSessionActivity = sessionActivity;
        this.mISession2 = sessionBinder;
        try {
            this.mISession2.asBinder().linkToDeath(this.mDeathRecipient, 0);
        }
        catch (RemoteException e) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"Session died too early.", (Throwable)e);
            }
            close = true;
            // MONITOREXIT : object
            if (!close) return;
            this.mInstance.close();
            return;
        }
        try {
            // MONITOREXIT : object
            this.mCallbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    MediaController2ImplBase.this.mCallback.onConnected(MediaController2ImplBase.this.mInstance, allowedCommands);
                }
            });
            return;
        }
        finally {
            if (close) {
                this.mInstance.close();
            }
        }
    }

    void onCustomCommand(final SessionCommand2 command, final Bundle args, final ResultReceiver receiver) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onCustomCommand cmd=" + command));
        }
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                MediaController2ImplBase.this.mCallback.onCustomCommand(MediaController2ImplBase.this.mInstance, command, args, receiver);
            }
        });
    }

    void onAllowedCommandsChanged(final SessionCommandGroup2 commands) {
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                MediaController2ImplBase.this.mCallback.onAllowedCommandsChanged(MediaController2ImplBase.this.mInstance, commands);
            }
        });
    }

    void onCustomLayoutChanged(final List<MediaSession2.CommandButton> layout) {
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                MediaController2ImplBase.this.mCallback.onCustomLayoutChanged(MediaController2ImplBase.this.mInstance, layout);
            }
        });
    }

    private class SessionServiceConnection
    implements ServiceConnection {
        private SessionServiceConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            if (DEBUG) {
                Log.d((String)MediaController2ImplBase.TAG, (String)("onServiceConnected " + name + " " + this));
            }
            if (!MediaController2ImplBase.this.mToken.getPackageName().equals(name.getPackageName())) {
                Log.wtf((String)MediaController2ImplBase.TAG, (String)(name + " was connected, but expected pkg=" + MediaController2ImplBase.this.mToken.getPackageName() + " with id=" + MediaController2ImplBase.this.mToken.getId()));
                return;
            }
            MediaController2ImplBase.this.connectToSession(IMediaSession2.Stub.asInterface(service));
        }

        public void onServiceDisconnected(ComponentName name) {
            if (DEBUG) {
                Log.w((String)MediaController2ImplBase.TAG, (String)("Session service " + name + " is disconnected."));
            }
        }

        public void onBindingDied(ComponentName name) {
            MediaController2ImplBase.this.close();
        }
    }
}

