/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.mediacompat.Rating2;
import android.support.v4.app.BundleCompat;
import android.support.v4.media.MediaBrowserCompat;
import android.support.v4.media.MediaController2;
import android.support.v4.media.MediaItem2;
import android.support.v4.media.MediaMetadata2;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.MediaSession2;
import android.support.v4.media.MediaUtils2;
import android.support.v4.media.SessionCommand2;
import android.support.v4.media.SessionCommandGroup2;
import android.support.v4.media.SessionToken2;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.util.Log;
import java.util.List;
import java.util.concurrent.Executor;

@TargetApi(value=16)
class MediaController2ImplLegacy
implements MediaController2.SupportLibraryImpl {
    private static final String TAG = "MC2ImplLegacy";
    private static final boolean DEBUG = Log.isLoggable((String)"MC2ImplLegacy", (int)3);
    static final Bundle sDefaultRootExtras = new Bundle();
    private final Context mContext;
    private final SessionToken2 mToken;
    private final MediaController2.ControllerCallback mCallback;
    private final Executor mCallbackExecutor;
    private final HandlerThread mHandlerThread;
    private final Handler mHandler;
    final Object mLock = new Object();
    private MediaController2 mInstance;
    @GuardedBy(value="mLock")
    private MediaBrowserCompat mBrowserCompat;
    @GuardedBy(value="mLock")
    private boolean mIsReleased;
    @GuardedBy(value="mLock")
    private List<MediaItem2> mPlaylist;
    @GuardedBy(value="mLock")
    private MediaMetadata2 mPlaylistMetadata;
    @GuardedBy(value="mLock")
    private int mRepeatMode;
    @GuardedBy(value="mLock")
    private int mShuffleMode;
    @GuardedBy(value="mLock")
    private int mPlayerState;
    @GuardedBy(value="mLock")
    private MediaItem2 mCurrentMediaItem;
    @GuardedBy(value="mLock")
    private int mBufferingState;
    @GuardedBy(value="mLock")
    private MediaController2.PlaybackInfo mPlaybackInfo;
    @GuardedBy(value="mLock")
    private SessionCommandGroup2 mAllowedCommands;
    @GuardedBy(value="mLock")
    private MediaControllerCompat mControllerCompat;
    @GuardedBy(value="mLock")
    private ControllerCompatCallback mControllerCompatCallback;
    @GuardedBy(value="mLock")
    private PlaybackStateCompat mPlaybackStateCompat;
    @GuardedBy(value="mLock")
    private MediaMetadataCompat mMediaMetadataCompat;
    @GuardedBy(value="mLock")
    private volatile boolean mConnected;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaController2ImplLegacy(@NonNull Context context, @NonNull MediaController2 instance, @NonNull SessionToken2 token, @NonNull Executor executor, @NonNull MediaController2.ControllerCallback callback) {
        this.mContext = context;
        this.mInstance = instance;
        this.mHandlerThread = new HandlerThread("MediaController2_Thread");
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.mToken = token;
        this.mCallback = callback;
        this.mCallbackExecutor = executor;
        if (this.mToken.getType() == 0) {
            Object object = this.mLock;
            synchronized (object) {
                this.mBrowserCompat = null;
            }
            this.connectToSession((MediaSessionCompat.Token)this.mToken.getBinder());
        } else {
            this.connectToService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (DEBUG) {
            Log.d((String)TAG, (String)("release from " + this.mToken));
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsReleased) {
                return;
            }
            this.mHandler.removeCallbacksAndMessages(null);
            if (Build.VERSION.SDK_INT >= 18) {
                this.mHandlerThread.quitSafely();
            } else {
                this.mHandlerThread.quit();
            }
            this.mIsReleased = true;
            this.sendCommand("android.support.v4.media.controller.command.DISCONNECT");
            if (this.mControllerCompat != null) {
                this.mControllerCompat.unregisterCallback(this.mControllerCompatCallback);
            }
            if (this.mBrowserCompat != null) {
                this.mBrowserCompat.disconnect();
                this.mBrowserCompat = null;
            }
            if (this.mControllerCompat != null) {
                this.mControllerCompat.unregisterCallback(this.mControllerCompatCallback);
                this.mControllerCompat = null;
            }
            this.mConnected = false;
        }
        this.mCallbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                MediaController2ImplLegacy.this.mCallback.onDisconnected(MediaController2ImplLegacy.this.mInstance);
            }
        });
    }

    @Override
    @NonNull
    public SessionToken2 getSessionToken() {
        return this.mToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConnected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            this.sendCommand(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            this.sendCommand(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            this.sendCommand(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            this.sendCommand(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fastForward() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            this.sendCommand(7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rewind() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            this.sendCommand(8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seekTo(long pos) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            Bundle args = new Bundle();
            args.putLong("android.support.v4.media.argument.SEEK_POSITION", pos);
            this.sendCommand(9, args);
        }
    }

    @Override
    public void skipForward() {
    }

    @Override
    public void skipBackward() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playFromMediaId(@NonNull String mediaId, @Nullable Bundle extras) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            Bundle args = new Bundle();
            args.putString("android.support.v4.media.argument.MEDIA_ID", mediaId);
            args.putBundle("android.support.v4.media.argument.EXTRAS", extras);
            this.sendCommand(22, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playFromSearch(@NonNull String query, @Nullable Bundle extras) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            Bundle args = new Bundle();
            args.putString("android.support.v4.media.argument.QUERY", query);
            args.putBundle("android.support.v4.media.argument.EXTRAS", extras);
            this.sendCommand(24, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playFromUri(@NonNull Uri uri, @Nullable Bundle extras) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            Bundle args = new Bundle();
            args.putParcelable("android.support.v4.media.argument.URI", (Parcelable)uri);
            args.putBundle("android.support.v4.media.argument.EXTRAS", extras);
            this.sendCommand(23, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareFromMediaId(@NonNull String mediaId, @Nullable Bundle extras) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            Bundle args = new Bundle();
            args.putString("android.support.v4.media.argument.MEDIA_ID", mediaId);
            args.putBundle("android.support.v4.media.argument.EXTRAS", extras);
            this.sendCommand(25, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareFromSearch(@NonNull String query, @Nullable Bundle extras) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            Bundle args = new Bundle();
            args.putString("android.support.v4.media.argument.QUERY", query);
            args.putBundle("android.support.v4.media.argument.EXTRAS", extras);
            this.sendCommand(27, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareFromUri(@NonNull Uri uri, @Nullable Bundle extras) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            Bundle args = new Bundle();
            args.putParcelable("android.support.v4.media.argument.URI", (Parcelable)uri);
            args.putBundle("android.support.v4.media.argument.EXTRAS", extras);
            this.sendCommand(26, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVolumeTo(int value, int flags) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            Bundle args = new Bundle();
            args.putInt("android.support.v4.media.argument.VOLUME", value);
            args.putInt("android.support.v4.media.argument.VOLUME_FLAGS", flags);
            this.sendCommand(10, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustVolume(int direction, int flags) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            Bundle args = new Bundle();
            args.putInt("android.support.v4.media.argument.VOLUME_DIRECTION", direction);
            args.putInt("android.support.v4.media.argument.VOLUME_FLAGS", flags);
            this.sendCommand(11, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PendingIntent getSessionActivity() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return null;
            }
            return this.mControllerCompat.getSessionActivity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPlayerState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPlayerState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDuration() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mMediaMetadataCompat != null && this.mMediaMetadataCompat.containsKey("android.media.metadata.DURATION")) {
                return this.mMediaMetadataCompat.getLong("android.media.metadata.DURATION");
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCurrentPosition() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return -1L;
            }
            if (this.mPlaybackStateCompat != null) {
                long timeDiff = this.mInstance.mTimeDiff != null ? this.mInstance.mTimeDiff : SystemClock.elapsedRealtime() - this.mPlaybackStateCompat.getLastPositionUpdateTime();
                long expectedPosition = this.mPlaybackStateCompat.getPosition() + (long)(this.mPlaybackStateCompat.getPlaybackSpeed() * (float)timeDiff);
                return Math.max(0L, expectedPosition);
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getPlaybackSpeed() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return 0.0f;
            }
            return this.mPlaybackStateCompat == null ? 0.0f : this.mPlaybackStateCompat.getPlaybackSpeed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlaybackSpeed(float speed) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            Bundle args = new Bundle();
            args.putFloat("android.support.v4.media.argument.PLAYBACK_SPEED", speed);
            this.sendCommand(39, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBufferingState() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return 0;
            }
            return this.mBufferingState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBufferedPosition() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return -1L;
            }
            return this.mPlaybackStateCompat == null ? -1L : this.mPlaybackStateCompat.getBufferedPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public MediaController2.PlaybackInfo getPlaybackInfo() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPlaybackInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRating(@NonNull String mediaId, @NonNull Rating2 rating) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            Bundle args = new Bundle();
            args.putString("android.support.v4.media.argument.MEDIA_ID", mediaId);
            args.putBundle("android.support.v4.media.argument.RATING", rating.toBundle());
            this.sendCommand(28, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendCustomCommand(@NonNull SessionCommand2 command, @Nullable Bundle args, @Nullable ResultReceiver cb) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mConnected) {
                Log.w((String)TAG, (String)"Session isn't active", (Throwable)new IllegalStateException());
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putBundle("android.support.v4.media.argument.CUSTOM_COMMAND", command.toBundle());
            bundle.putBundle("android.support.v4.media.argument.ARGUMENTS", args);
            this.sendCommand("android.support.v4.media.controller.command.BY_CUSTOM_COMMAND", bundle, cb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public List<MediaItem2> getPlaylist() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPlaylist;
        }
    }

    @Override
    public void setPlaylist(@NonNull List<MediaItem2> list, @Nullable MediaMetadata2 metadata) {
        Bundle args = new Bundle();
        args.putParcelableArray("android.support.v4.media.argument.PLAYLIST", MediaUtils2.convertMediaItem2ListToParcelableArray(list));
        args.putBundle("android.support.v4.media.argument.PLAYLIST_METADATA", metadata == null ? null : metadata.toBundle());
        this.sendCommand(19, args);
    }

    @Override
    public void updatePlaylistMetadata(@Nullable MediaMetadata2 metadata) {
        Bundle args = new Bundle();
        args.putBundle("android.support.v4.media.argument.PLAYLIST_METADATA", metadata == null ? null : metadata.toBundle());
        this.sendCommand(21, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public MediaMetadata2 getPlaylistMetadata() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPlaylistMetadata;
        }
    }

    @Override
    public void addPlaylistItem(int index, @NonNull MediaItem2 item) {
        Bundle args = new Bundle();
        args.putInt("android.support.v4.media.argument.PLAYLIST_INDEX", index);
        args.putBundle("android.support.v4.media.argument.MEDIA_ITEM", item.toBundle());
        this.sendCommand(15, args);
    }

    @Override
    public void removePlaylistItem(@NonNull MediaItem2 item) {
        Bundle args = new Bundle();
        args.putBundle("android.support.v4.media.argument.MEDIA_ITEM", item.toBundle());
        this.sendCommand(16, args);
    }

    @Override
    public void replacePlaylistItem(int index, @NonNull MediaItem2 item) {
        Bundle args = new Bundle();
        args.putInt("android.support.v4.media.argument.PLAYLIST_INDEX", index);
        args.putBundle("android.support.v4.media.argument.MEDIA_ITEM", item.toBundle());
        this.sendCommand(17, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaItem2 getCurrentMediaItem() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrentMediaItem;
        }
    }

    @Override
    public void skipToPreviousItem() {
        this.sendCommand(5);
    }

    @Override
    public void skipToNextItem() {
        this.sendCommand(4);
    }

    @Override
    public void skipToPlaylistItem(@NonNull MediaItem2 item) {
        Bundle args = new Bundle();
        args.putBundle("android.support.v4.media.argument.MEDIA_ITEM", item.toBundle());
        this.sendCommand(12, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRepeatMode() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRepeatMode;
        }
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        Bundle args = new Bundle();
        args.putInt("android.support.v4.media.argument.REPEAT_MODE", repeatMode);
        this.sendCommand(14, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getShuffleMode() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mShuffleMode;
        }
    }

    @Override
    public void setShuffleMode(int shuffleMode) {
        Bundle args = new Bundle();
        args.putInt("android.support.v4.media.argument.SHUFFLE_MODE", shuffleMode);
        this.sendCommand(13, args);
    }

    @Override
    public void subscribeRoutesInfo() {
        this.sendCommand(36);
    }

    @Override
    public void unsubscribeRoutesInfo() {
        this.sendCommand(37);
    }

    @Override
    public void selectRoute(@NonNull Bundle route) {
        Bundle args = new Bundle();
        args.putBundle("android.support.v4.media.argument.ROUTE_BUNDLE", route);
        this.sendCommand(38, args);
    }

    @Override
    @NonNull
    public Context getContext() {
        return this.mContext;
    }

    @Override
    @NonNull
    public MediaController2.ControllerCallback getCallback() {
        return this.mCallback;
    }

    @Override
    @NonNull
    public Executor getCallbackExecutor() {
        return this.mCallbackExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public MediaBrowserCompat getBrowserCompat() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mBrowserCompat;
        }
    }

    @Override
    @NonNull
    public MediaController2 getInstance() {
        return this.mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void onConnectedNotLocked(Bundle data) {
        boolean close;
        MediaMetadata2 metadata;
        MediaController2.PlaybackInfo playbackInfo;
        List<MediaItem2> playlist;
        int shuffleMode;
        int repeatMode;
        PlaybackStateCompat playbackStateCompat;
        int bufferingState;
        MediaItem2 currentMediaItem;
        int playerState;
        SessionCommandGroup2 allowedCommands;
        block11: {
            data.setClassLoader(MediaSession2.class.getClassLoader());
            allowedCommands = SessionCommandGroup2.fromBundle(data.getBundle("android.support.v4.media.argument.ALLOWED_COMMANDS"));
            playerState = data.getInt("android.support.v4.media.argument.PLAYER_STATE");
            currentMediaItem = MediaItem2.fromBundle(data.getBundle("android.support.v4.media.argument.MEDIA_ITEM"));
            bufferingState = data.getInt("android.support.v4.media.argument.BUFFERING_STATE");
            playbackStateCompat = (PlaybackStateCompat)data.getParcelable("android.support.v4.media.argument.PLAYBACK_STATE_COMPAT");
            repeatMode = data.getInt("android.support.v4.media.argument.REPEAT_MODE");
            shuffleMode = data.getInt("android.support.v4.media.argument.SHUFFLE_MODE");
            playlist = MediaUtils2.convertToMediaItem2List(data.getParcelableArray("android.support.v4.media.argument.PLAYLIST"));
            playbackInfo = MediaController2.PlaybackInfo.fromBundle(data.getBundle("android.support.v4.media.argument.PLAYBACK_INFO"));
            metadata = MediaMetadata2.fromBundle(data.getBundle("android.support.v4.media.argument.PLAYLIST_METADATA"));
            if (DEBUG) {
                Log.d((String)TAG, (String)("onConnectedNotLocked token=" + this.mToken + ", allowedCommands=" + allowedCommands));
            }
            close = false;
            Object object = this.mLock;
            // MONITORENTER : object
            if (this.mIsReleased) {
                // MONITOREXIT : object
                if (!close) return;
                this.close();
                return;
            }
            if (!this.mConnected) break block11;
            Log.e((String)TAG, (String)"Cannot be notified about the connection result many times. Probably a bug or malicious app.");
            close = true;
            // MONITOREXIT : object
            if (!close) return;
            this.close();
            return;
        }
        try {
            this.mAllowedCommands = allowedCommands;
            this.mPlayerState = playerState;
            this.mCurrentMediaItem = currentMediaItem;
            this.mBufferingState = bufferingState;
            this.mPlaybackStateCompat = playbackStateCompat;
            this.mRepeatMode = repeatMode;
            this.mShuffleMode = shuffleMode;
            this.mPlaylist = playlist;
            this.mPlaylistMetadata = metadata;
            this.mConnected = true;
            this.mPlaybackInfo = playbackInfo;
            // MONITOREXIT : object
            this.mCallbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    MediaController2ImplLegacy.this.mCallback.onConnected(MediaController2ImplLegacy.this.mInstance, allowedCommands);
                }
            });
            return;
        }
        finally {
            if (close) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToSession(MediaSessionCompat.Token sessionCompatToken) {
        MediaControllerCompat controllerCompat = null;
        try {
            controllerCompat = new MediaControllerCompat(this.mContext, sessionCompatToken);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mControllerCompat = controllerCompat;
            this.mControllerCompatCallback = new ControllerCompatCallback();
            this.mControllerCompat.registerCallback(this.mControllerCompatCallback, this.mHandler);
        }
    }

    private void connectToService() {
        this.mCallbackExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = MediaController2ImplLegacy.this.mLock;
                synchronized (object) {
                    MediaController2ImplLegacy.this.mBrowserCompat = new MediaBrowserCompat(MediaController2ImplLegacy.this.mContext, MediaController2ImplLegacy.this.mToken.getComponentName(), new ConnectionCallback(), sDefaultRootExtras);
                    MediaController2ImplLegacy.this.mBrowserCompat.connect();
                }
            }
        });
    }

    private void sendCommand(int commandCode) {
        this.sendCommand(commandCode, null);
    }

    private void sendCommand(int commandCode, Bundle args) {
        if (args == null) {
            args = new Bundle();
        }
        args.putInt("android.support.v4.media.argument.COMMAND_CODE", commandCode);
        this.sendCommand("android.support.v4.media.controller.command.BY_COMMAND_CODE", args, null);
    }

    private void sendCommand(String command) {
        this.sendCommand(command, null, null);
    }

    private void sendCommand(String command, ResultReceiver receiver) {
        this.sendCommand(command, null, receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(String command, Bundle args, ResultReceiver receiver) {
        ControllerCompatCallback callback;
        MediaControllerCompat controller;
        if (args == null) {
            args = new Bundle();
        }
        Object object = this.mLock;
        synchronized (object) {
            controller = this.mControllerCompat;
            callback = this.mControllerCompatCallback;
        }
        BundleCompat.putBinder((Bundle)args, (String)"android.support.v4.media.argument.ICONTROLLER_CALLBACK", (IBinder)callback.getIControllerCallback().asBinder());
        args.putString("android.support.v4.media.argument.PACKAGE_NAME", this.mContext.getPackageName());
        args.putInt("android.support.v4.media.argument.UID", Process.myUid());
        args.putInt("android.support.v4.media.argument.PID", Process.myPid());
        controller.sendCommand(command, args, receiver);
    }

    static {
        sDefaultRootExtras.putBoolean("android.support.v4.media.root_default_root", true);
    }

    private final class ControllerCompatCallback
    extends MediaControllerCompat.Callback {
        private ControllerCompatCallback() {
        }

        @Override
        public void onSessionReady() {
            MediaController2ImplLegacy.this.sendCommand("android.support.v4.media.controller.command.CONNECT", new ResultReceiver(MediaController2ImplLegacy.this.mHandler){

                protected void onReceiveResult(int resultCode, Bundle resultData) {
                    if (!MediaController2ImplLegacy.this.mHandlerThread.isAlive()) {
                        return;
                    }
                    switch (resultCode) {
                        case 0: {
                            MediaController2ImplLegacy.this.onConnectedNotLocked(resultData);
                            break;
                        }
                        case -1: {
                            MediaController2ImplLegacy.this.mCallbackExecutor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    MediaController2ImplLegacy.this.mCallback.onDisconnected(MediaController2ImplLegacy.this.mInstance);
                                }
                            });
                            MediaController2ImplLegacy.this.close();
                        }
                    }
                }
            });
        }

        @Override
        public void onSessionDestroyed() {
            MediaController2ImplLegacy.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPlaybackStateChanged(PlaybackStateCompat state) {
            Object object = MediaController2ImplLegacy.this.mLock;
            synchronized (object) {
                MediaController2ImplLegacy.this.mPlaybackStateCompat = state;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMetadataChanged(MediaMetadataCompat metadata) {
            Object object = MediaController2ImplLegacy.this.mLock;
            synchronized (object) {
                MediaController2ImplLegacy.this.mMediaMetadataCompat = metadata;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionEvent(String event, Bundle extras) {
            if (extras != null) {
                extras.setClassLoader(MediaSession2.class.getClassLoader());
            }
            switch (event) {
                case "android.support.v4.media.session.event.ON_ALLOWED_COMMANDS_CHANGED": {
                    final SessionCommandGroup2 allowedCommands = SessionCommandGroup2.fromBundle(extras.getBundle("android.support.v4.media.argument.ALLOWED_COMMANDS"));
                    Object object = MediaController2ImplLegacy.this.mLock;
                    synchronized (object) {
                        MediaController2ImplLegacy.this.mAllowedCommands = allowedCommands;
                    }
                    MediaController2ImplLegacy.this.mCallbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MediaController2ImplLegacy.this.mCallback.onAllowedCommandsChanged(MediaController2ImplLegacy.this.mInstance, allowedCommands);
                        }
                    });
                    break;
                }
                case "android.support.v4.media.session.event.ON_PLAYER_STATE_CHANGED": {
                    final int playerState = extras.getInt("android.support.v4.media.argument.PLAYER_STATE");
                    PlaybackStateCompat state = (PlaybackStateCompat)extras.getParcelable("android.support.v4.media.argument.PLAYBACK_STATE_COMPAT");
                    if (state == null) {
                        return;
                    }
                    Object object = MediaController2ImplLegacy.this.mLock;
                    synchronized (object) {
                        MediaController2ImplLegacy.this.mPlayerState = playerState;
                        MediaController2ImplLegacy.this.mPlaybackStateCompat = state;
                    }
                    MediaController2ImplLegacy.this.mCallbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MediaController2ImplLegacy.this.mCallback.onPlayerStateChanged(MediaController2ImplLegacy.this.mInstance, playerState);
                        }
                    });
                    break;
                }
                case "android.support.v4.media.session.event.ON_CURRENT_MEDIA_ITEM_CHANGED": {
                    final MediaItem2 item = MediaItem2.fromBundle(extras.getBundle("android.support.v4.media.argument.MEDIA_ITEM"));
                    Object state = MediaController2ImplLegacy.this.mLock;
                    synchronized (state) {
                        MediaController2ImplLegacy.this.mCurrentMediaItem = item;
                    }
                    MediaController2ImplLegacy.this.mCallbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MediaController2ImplLegacy.this.mCallback.onCurrentMediaItemChanged(MediaController2ImplLegacy.this.mInstance, item);
                        }
                    });
                    break;
                }
                case "android.support.v4.media.session.event.ON_ERROR": {
                    final int errorCode = extras.getInt("android.support.v4.media.argument.ERROR_CODE");
                    final Bundle errorExtras = extras.getBundle("android.support.v4.media.argument.EXTRAS");
                    MediaController2ImplLegacy.this.mCallbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MediaController2ImplLegacy.this.mCallback.onError(MediaController2ImplLegacy.this.mInstance, errorCode, errorExtras);
                        }
                    });
                    break;
                }
                case "android.support.v4.media.session.event.ON_ROUTES_INFO_CHANGED": {
                    final List<Bundle> routes = MediaUtils2.convertToBundleList(extras.getParcelableArray("android.support.v4.media.argument.ROUTE_BUNDLE"));
                    MediaController2ImplLegacy.this.mCallbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MediaController2ImplLegacy.this.mCallback.onRoutesInfoChanged(MediaController2ImplLegacy.this.mInstance, routes);
                        }
                    });
                    break;
                }
                case "android.support.v4.media.session.event.ON_PLAYLIST_CHANGED": {
                    final MediaMetadata2 playlistMetadata = MediaMetadata2.fromBundle(extras.getBundle("android.support.v4.media.argument.PLAYLIST_METADATA"));
                    final List<MediaItem2> playlist = MediaUtils2.convertToMediaItem2List(extras.getParcelableArray("android.support.v4.media.argument.PLAYLIST"));
                    Object object = MediaController2ImplLegacy.this.mLock;
                    synchronized (object) {
                        MediaController2ImplLegacy.this.mPlaylist = playlist;
                        MediaController2ImplLegacy.this.mPlaylistMetadata = playlistMetadata;
                    }
                    MediaController2ImplLegacy.this.mCallbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MediaController2ImplLegacy.this.mCallback.onPlaylistChanged(MediaController2ImplLegacy.this.mInstance, playlist, playlistMetadata);
                        }
                    });
                    break;
                }
                case "android.support.v4.media.session.event.ON_PLAYLIST_METADATA_CHANGED": {
                    final MediaMetadata2 playlistMetadata = MediaMetadata2.fromBundle(extras.getBundle("android.support.v4.media.argument.PLAYLIST_METADATA"));
                    Object playlist = MediaController2ImplLegacy.this.mLock;
                    synchronized (playlist) {
                        MediaController2ImplLegacy.this.mPlaylistMetadata = playlistMetadata;
                    }
                    MediaController2ImplLegacy.this.mCallbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MediaController2ImplLegacy.this.mCallback.onPlaylistMetadataChanged(MediaController2ImplLegacy.this.mInstance, playlistMetadata);
                        }
                    });
                    break;
                }
                case "android.support.v4.media.session.event.ON_REPEAT_MODE_CHANGED": {
                    final int repeatMode = extras.getInt("android.support.v4.media.argument.REPEAT_MODE");
                    Object playlist = MediaController2ImplLegacy.this.mLock;
                    synchronized (playlist) {
                        MediaController2ImplLegacy.this.mRepeatMode = repeatMode;
                    }
                    MediaController2ImplLegacy.this.mCallbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MediaController2ImplLegacy.this.mCallback.onRepeatModeChanged(MediaController2ImplLegacy.this.mInstance, repeatMode);
                        }
                    });
                    break;
                }
                case "android.support.v4.media.session.event.ON_SHUFFLE_MODE_CHANGED": {
                    final int shuffleMode = extras.getInt("android.support.v4.media.argument.SHUFFLE_MODE");
                    Object playlist = MediaController2ImplLegacy.this.mLock;
                    synchronized (playlist) {
                        MediaController2ImplLegacy.this.mShuffleMode = shuffleMode;
                    }
                    MediaController2ImplLegacy.this.mCallbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MediaController2ImplLegacy.this.mCallback.onShuffleModeChanged(MediaController2ImplLegacy.this.mInstance, shuffleMode);
                        }
                    });
                    break;
                }
                case "android.support.v4.media.session.event.SEND_CUSTOM_COMMAND": {
                    Bundle commandBundle = extras.getBundle("android.support.v4.media.argument.CUSTOM_COMMAND");
                    if (commandBundle == null) {
                        return;
                    }
                    final SessionCommand2 command = SessionCommand2.fromBundle(commandBundle);
                    final Bundle args = extras.getBundle("android.support.v4.media.argument.ARGUMENTS");
                    final ResultReceiver receiver = (ResultReceiver)extras.getParcelable("android.support.v4.media.argument.RESULT_RECEIVER");
                    MediaController2ImplLegacy.this.mCallbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MediaController2ImplLegacy.this.mCallback.onCustomCommand(MediaController2ImplLegacy.this.mInstance, command, args, receiver);
                        }
                    });
                    break;
                }
                case "android.support.v4.media.session.event.SET_CUSTOM_LAYOUT": {
                    final List<MediaSession2.CommandButton> layout = MediaUtils2.convertToCommandButtonList(extras.getParcelableArray("android.support.v4.media.argument.COMMAND_BUTTONS"));
                    if (layout == null) {
                        return;
                    }
                    MediaController2ImplLegacy.this.mCallbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MediaController2ImplLegacy.this.mCallback.onCustomLayoutChanged(MediaController2ImplLegacy.this.mInstance, layout);
                        }
                    });
                    break;
                }
                case "android.support.v4.media.session.event.ON_PLAYBACK_INFO_CHANGED": {
                    final MediaController2.PlaybackInfo info = MediaController2.PlaybackInfo.fromBundle(extras.getBundle("android.support.v4.media.argument.PLAYBACK_INFO"));
                    if (info == null) {
                        return;
                    }
                    Object command = MediaController2ImplLegacy.this.mLock;
                    synchronized (command) {
                        MediaController2ImplLegacy.this.mPlaybackInfo = info;
                    }
                    MediaController2ImplLegacy.this.mCallbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MediaController2ImplLegacy.this.mCallback.onPlaybackInfoChanged(MediaController2ImplLegacy.this.mInstance, info);
                        }
                    });
                    break;
                }
                case "android.support.v4.media.session.event.ON_PLAYBACK_SPEED_CHANGED": {
                    final PlaybackStateCompat state = (PlaybackStateCompat)extras.getParcelable("android.support.v4.media.argument.PLAYBACK_STATE_COMPAT");
                    if (state == null) {
                        return;
                    }
                    Object command = MediaController2ImplLegacy.this.mLock;
                    synchronized (command) {
                        MediaController2ImplLegacy.this.mPlaybackStateCompat = state;
                    }
                    MediaController2ImplLegacy.this.mCallbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MediaController2ImplLegacy.this.mCallback.onPlaybackSpeedChanged(MediaController2ImplLegacy.this.mInstance, state.getPlaybackSpeed());
                        }
                    });
                    break;
                }
                case "android.support.v4.media.session.event.ON_BUFFERING_STATE_CHANGED": {
                    final MediaItem2 item = MediaItem2.fromBundle(extras.getBundle("android.support.v4.media.argument.MEDIA_ITEM"));
                    final int bufferingState = extras.getInt("android.support.v4.media.argument.BUFFERING_STATE");
                    PlaybackStateCompat state = (PlaybackStateCompat)extras.getParcelable("android.support.v4.media.argument.PLAYBACK_STATE_COMPAT");
                    if (item == null || state == null) {
                        return;
                    }
                    Object object = MediaController2ImplLegacy.this.mLock;
                    synchronized (object) {
                        MediaController2ImplLegacy.this.mBufferingState = bufferingState;
                        MediaController2ImplLegacy.this.mPlaybackStateCompat = state;
                    }
                    MediaController2ImplLegacy.this.mCallbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MediaController2ImplLegacy.this.mCallback.onBufferingStateChanged(MediaController2ImplLegacy.this.mInstance, item, bufferingState);
                        }
                    });
                    break;
                }
                case "android.support.v4.media.session.event.ON_SEEK_COMPLETED": {
                    final long position = extras.getLong("android.support.v4.media.argument.SEEK_POSITION");
                    PlaybackStateCompat state = (PlaybackStateCompat)extras.getParcelable("android.support.v4.media.argument.PLAYBACK_STATE_COMPAT");
                    if (state == null) {
                        return;
                    }
                    Object object = MediaController2ImplLegacy.this.mLock;
                    synchronized (object) {
                        MediaController2ImplLegacy.this.mPlaybackStateCompat = state;
                    }
                    MediaController2ImplLegacy.this.mCallbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MediaController2ImplLegacy.this.mCallback.onSeekCompleted(MediaController2ImplLegacy.this.mInstance, position);
                        }
                    });
                    break;
                }
            }
        }
    }

    private class ConnectionCallback
    extends MediaBrowserCompat.ConnectionCallback {
        private ConnectionCallback() {
        }

        @Override
        public void onConnected() {
            MediaBrowserCompat browser = MediaController2ImplLegacy.this.getBrowserCompat();
            if (browser != null) {
                MediaController2ImplLegacy.this.connectToSession(browser.getSessionToken());
            } else if (DEBUG) {
                Log.d((String)MediaController2ImplLegacy.TAG, (String)"Controller is closed prematually", (Throwable)new IllegalStateException());
            }
        }

        @Override
        public void onConnectionSuspended() {
            MediaController2ImplLegacy.this.close();
        }

        @Override
        public void onConnectionFailed() {
            MediaController2ImplLegacy.this.close();
        }
    }
}

