/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.app.PendingIntent;
import android.os.Bundle;
import android.os.ResultReceiver;
import android.support.v4.media.IMediaController2;
import android.support.v4.media.IMediaSession2;
import android.support.v4.media.MediaBrowser2;
import android.support.v4.media.MediaController2;
import android.support.v4.media.MediaController2ImplBase;
import android.support.v4.media.MediaItem2;
import android.support.v4.media.MediaMetadata2;
import android.support.v4.media.MediaSession2;
import android.support.v4.media.MediaUtils2;
import android.support.v4.media.SessionCommand2;
import android.support.v4.media.SessionCommandGroup2;
import android.text.TextUtils;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

class MediaController2Stub
extends IMediaController2.Stub {
    private static final String TAG = "MediaController2Stub";
    private static final boolean DEBUG = true;
    private final WeakReference<MediaController2ImplBase> mController;

    MediaController2Stub(MediaController2ImplBase controller) {
        this.mController = new WeakReference<MediaController2ImplBase>(controller);
    }

    @Override
    public void onCurrentMediaItemChanged(Bundle item) {
        MediaController2ImplBase controller;
        try {
            controller = this.getController();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        controller.notifyCurrentMediaItemChanged(MediaItem2.fromBundle(item));
    }

    @Override
    public void onPlayerStateChanged(long eventTimeMs, long positionMs, int state) {
        MediaController2ImplBase controller;
        try {
            controller = this.getController();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        controller.notifyPlayerStateChanges(eventTimeMs, positionMs, state);
    }

    @Override
    public void onPlaybackSpeedChanged(long eventTimeMs, long positionMs, float speed) {
        MediaController2ImplBase controller;
        try {
            controller = this.getController();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        controller.notifyPlaybackSpeedChanges(eventTimeMs, positionMs, speed);
    }

    @Override
    public void onBufferingStateChanged(Bundle itemBundle, int state, long bufferedPositionMs) {
        MediaController2ImplBase controller;
        try {
            controller = this.getController();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        controller.notifyBufferingStateChanged(MediaItem2.fromBundle(itemBundle), state, bufferedPositionMs);
    }

    @Override
    public void onPlaylistChanged(List<Bundle> playlistBundle, Bundle metadataBundle) {
        MediaController2ImplBase controller;
        try {
            controller = this.getController();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        if (playlistBundle == null) {
            Log.w((String)TAG, (String)("onPlaylistChanged(): Ignoring null playlist from " + controller));
            return;
        }
        ArrayList<MediaItem2> playlist = new ArrayList<MediaItem2>();
        for (Bundle bundle : playlistBundle) {
            MediaItem2 item = MediaItem2.fromBundle(bundle);
            if (item == null) {
                Log.w((String)TAG, (String)"onPlaylistChanged(): Ignoring null item in playlist");
                continue;
            }
            playlist.add(item);
        }
        MediaMetadata2 metadata = MediaMetadata2.fromBundle(metadataBundle);
        controller.notifyPlaylistChanges(playlist, metadata);
    }

    @Override
    public void onPlaylistMetadataChanged(Bundle metadataBundle) throws RuntimeException {
        MediaController2ImplBase controller;
        try {
            controller = this.getController();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        MediaMetadata2 metadata = MediaMetadata2.fromBundle(metadataBundle);
        controller.notifyPlaylistMetadataChanges(metadata);
    }

    @Override
    public void onRepeatModeChanged(int repeatMode) {
        MediaController2ImplBase controller;
        try {
            controller = this.getController();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        controller.notifyRepeatModeChanges(repeatMode);
    }

    @Override
    public void onShuffleModeChanged(int shuffleMode) {
        MediaController2ImplBase controller;
        try {
            controller = this.getController();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        controller.notifyShuffleModeChanges(shuffleMode);
    }

    @Override
    public void onPlaybackInfoChanged(Bundle playbackInfo) throws RuntimeException {
        MediaController2ImplBase controller;
        Log.d((String)TAG, (String)"onPlaybackInfoChanged");
        try {
            controller = this.getController();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        MediaController2.PlaybackInfo info = MediaController2.PlaybackInfo.fromBundle(playbackInfo);
        if (info == null) {
            Log.w((String)TAG, (String)"onPlaybackInfoChanged(): Ignoring null playbackInfo");
            return;
        }
        controller.notifyPlaybackInfoChanges(info);
    }

    @Override
    public void onSeekCompleted(long eventTimeMs, long positionMs, long seekPositionMs) {
        MediaController2ImplBase controller;
        try {
            controller = this.getController();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        controller.notifySeekCompleted(eventTimeMs, positionMs, seekPositionMs);
    }

    @Override
    public void onError(int errorCode, Bundle extras) {
        MediaController2ImplBase controller;
        try {
            controller = this.getController();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        controller.notifyError(errorCode, extras);
    }

    @Override
    public void onRoutesInfoChanged(List<Bundle> routes) {
        MediaController2ImplBase controller;
        try {
            controller = this.getController();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        controller.notifyRoutesInfoChanged(routes);
    }

    @Override
    public void onConnected(IMediaSession2 sessionBinder, Bundle commandGroup, int playerState, Bundle currentItem, long positionEventTimeMs, long positionMs, float playbackSpeed, long bufferedPositionMs, Bundle playbackInfo, int shuffleMode, int repeatMode, List<Bundle> itemBundleList, PendingIntent sessionActivity) {
        MediaController2ImplBase controller = (MediaController2ImplBase)this.mController.get();
        if (controller == null) {
            Log.d((String)TAG, (String)"onConnected after MediaController2.close()");
            return;
        }
        ArrayList<MediaItem2> itemList = null;
        if (itemBundleList != null) {
            itemList = new ArrayList<MediaItem2>();
            for (int i = 0; i < itemBundleList.size(); ++i) {
                MediaItem2 item = MediaItem2.fromBundle(itemBundleList.get(i));
                if (item == null) continue;
                itemList.add(item);
            }
        }
        controller.onConnectedNotLocked(sessionBinder, SessionCommandGroup2.fromBundle(commandGroup), playerState, MediaItem2.fromBundle(currentItem), positionEventTimeMs, positionMs, playbackSpeed, bufferedPositionMs, MediaController2.PlaybackInfo.fromBundle(playbackInfo), repeatMode, shuffleMode, itemList, sessionActivity);
    }

    @Override
    public void onDisconnected() {
        MediaController2ImplBase controller = (MediaController2ImplBase)this.mController.get();
        if (controller == null) {
            Log.d((String)TAG, (String)"onDisconnected after MediaController2.close()");
            return;
        }
        controller.getInstance().close();
    }

    @Override
    public void onCustomLayoutChanged(List<Bundle> commandButtonlist) {
        MediaController2ImplBase controller;
        if (commandButtonlist == null) {
            Log.w((String)TAG, (String)"onCustomLayoutChanged(): Ignoring null commandButtonlist");
            return;
        }
        try {
            controller = this.getController();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        if (controller == null) {
            return;
        }
        ArrayList<MediaSession2.CommandButton> layout = new ArrayList<MediaSession2.CommandButton>();
        for (int i = 0; i < commandButtonlist.size(); ++i) {
            MediaSession2.CommandButton button = MediaSession2.CommandButton.fromBundle(commandButtonlist.get(i));
            if (button == null) continue;
            layout.add(button);
        }
        controller.onCustomLayoutChanged(layout);
    }

    @Override
    public void onAllowedCommandsChanged(Bundle commandsBundle) {
        MediaController2ImplBase controller;
        try {
            controller = this.getController();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        if (controller == null) {
            return;
        }
        SessionCommandGroup2 commands = SessionCommandGroup2.fromBundle(commandsBundle);
        if (commands == null) {
            Log.w((String)TAG, (String)"onAllowedCommandsChanged(): Ignoring null commands");
            return;
        }
        controller.onAllowedCommandsChanged(commands);
    }

    @Override
    public void onCustomCommand(Bundle commandBundle, Bundle args, ResultReceiver receiver) {
        MediaController2ImplBase controller;
        try {
            controller = this.getController();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        SessionCommand2 command = SessionCommand2.fromBundle(commandBundle);
        if (command == null) {
            Log.w((String)TAG, (String)"onCustomCommand(): Ignoring null command");
            return;
        }
        controller.onCustomCommand(command, args, receiver);
    }

    @Override
    public void onGetLibraryRootDone(final Bundle rootHints, final String rootMediaId, final Bundle rootExtra) throws RuntimeException {
        MediaBrowser2 browser;
        try {
            browser = this.getBrowser();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        if (browser == null) {
            return;
        }
        browser.getCallbackExecutor().execute(new Runnable(){

            @Override
            public void run() {
                browser.getCallback().onGetLibraryRootDone(browser, rootHints, rootMediaId, rootExtra);
            }
        });
    }

    @Override
    public void onGetItemDone(final String mediaId, final Bundle itemBundle) throws RuntimeException {
        MediaBrowser2 browser;
        if (mediaId == null) {
            Log.w((String)TAG, (String)"onGetItemDone(): Ignoring null mediaId");
            return;
        }
        try {
            browser = this.getBrowser();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        if (browser == null) {
            return;
        }
        browser.getCallbackExecutor().execute(new Runnable(){

            @Override
            public void run() {
                browser.getCallback().onGetItemDone(browser, mediaId, MediaItem2.fromBundle(itemBundle));
            }
        });
    }

    @Override
    public void onGetChildrenDone(final String parentId, final int page, final int pageSize, final List<Bundle> itemBundleList, final Bundle extras) throws RuntimeException {
        MediaBrowser2 browser;
        if (parentId == null) {
            Log.w((String)TAG, (String)"onGetChildrenDone(): Ignoring null parentId");
            return;
        }
        try {
            browser = this.getBrowser();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        if (browser == null) {
            return;
        }
        browser.getCallbackExecutor().execute(new Runnable(){

            @Override
            public void run() {
                browser.getCallback().onGetChildrenDone(browser, parentId, page, pageSize, MediaUtils2.convertBundleListToMediaItem2List(itemBundleList), extras);
            }
        });
    }

    @Override
    public void onSearchResultChanged(final String query, final int itemCount, final Bundle extras) throws RuntimeException {
        MediaBrowser2 browser;
        if (TextUtils.isEmpty((CharSequence)query)) {
            Log.w((String)TAG, (String)"onSearchResultChanged(): Ignoring empty query");
            return;
        }
        try {
            browser = this.getBrowser();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        if (browser == null) {
            return;
        }
        browser.getCallbackExecutor().execute(new Runnable(){

            @Override
            public void run() {
                browser.getCallback().onSearchResultChanged(browser, query, itemCount, extras);
            }
        });
    }

    @Override
    public void onGetSearchResultDone(final String query, final int page, final int pageSize, final List<Bundle> itemBundleList, final Bundle extras) throws RuntimeException {
        MediaBrowser2 browser;
        if (TextUtils.isEmpty((CharSequence)query)) {
            Log.w((String)TAG, (String)"onGetSearchResultDone(): Ignoring empty query");
            return;
        }
        try {
            browser = this.getBrowser();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        if (browser == null) {
            return;
        }
        browser.getCallbackExecutor().execute(new Runnable(){

            @Override
            public void run() {
                browser.getCallback().onGetSearchResultDone(browser, query, page, pageSize, MediaUtils2.convertBundleListToMediaItem2List(itemBundleList), extras);
            }
        });
    }

    @Override
    public void onChildrenChanged(final String parentId, final int itemCount, final Bundle extras) {
        MediaBrowser2 browser;
        if (parentId == null) {
            Log.w((String)TAG, (String)"onChildrenChanged(): Ignoring null parentId");
            return;
        }
        try {
            browser = this.getBrowser();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)"Don't fail silently here. Highly likely a bug");
            return;
        }
        if (browser == null) {
            return;
        }
        browser.getCallbackExecutor().execute(new Runnable(){

            @Override
            public void run() {
                browser.getCallback().onChildrenChanged(browser, parentId, itemCount, extras);
            }
        });
    }

    public void destroy() {
        this.mController.clear();
    }

    private MediaController2ImplBase getController() throws IllegalStateException {
        MediaController2ImplBase controller = (MediaController2ImplBase)this.mController.get();
        if (controller == null) {
            throw new IllegalStateException("Controller is released");
        }
        return controller;
    }

    private MediaBrowser2 getBrowser() throws IllegalStateException {
        MediaController2ImplBase controller = this.getController();
        if (controller.getInstance() instanceof MediaBrowser2) {
            return (MediaBrowser2)controller.getInstance();
        }
        return null;
    }
}

