/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.media.BaseMediaPlayer;
import android.support.v4.media.MediaItem2;
import android.support.v4.media.MediaLibraryService2ImplBase;
import android.support.v4.media.MediaLibrarySessionImplBase;
import android.support.v4.media.MediaPlaylistAgent;
import android.support.v4.media.MediaSession2;
import android.support.v4.media.MediaSessionService2;
import android.support.v4.media.VolumeProviderCompat;
import java.util.List;
import java.util.concurrent.Executor;

public abstract class MediaLibraryService2
extends MediaSessionService2 {
    public static final String SERVICE_INTERFACE = "android.media.MediaLibraryService2";

    @Override
    MediaSessionService2.SupportLibraryImpl createImpl() {
        return new MediaLibraryService2ImplBase();
    }

    @Override
    public void onCreate() {
        super.onCreate();
        MediaSession2 session = this.getSession();
        if (!(session instanceof MediaLibrarySession)) {
            throw new RuntimeException("Expected MediaLibrarySession, but returned MediaSession2");
        }
    }

    @Override
    public IBinder onBind(Intent intent) {
        return super.onBind(intent);
    }

    @Override
    @NonNull
    public abstract MediaLibrarySession onCreateSession(String var1);

    public static final class LibraryRoot {
        public static final String EXTRA_RECENT = "android.media.extra.RECENT";
        public static final String EXTRA_OFFLINE = "android.media.extra.OFFLINE";
        public static final String EXTRA_SUGGESTED = "android.media.extra.SUGGESTED";
        private final String mRootId;
        private final Bundle mExtras;

        public LibraryRoot(@NonNull String rootId, @Nullable Bundle extras) {
            if (rootId == null) {
                throw new IllegalArgumentException("rootId shouldn't be null");
            }
            this.mRootId = rootId;
            this.mExtras = extras;
        }

        public String getRootId() {
            return this.mRootId;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }
    }

    public static final class MediaLibrarySession
    extends MediaSession2 {
        MediaLibrarySession(Context context, String id, BaseMediaPlayer player, MediaPlaylistAgent playlistAgent, VolumeProviderCompat volumeProvider, PendingIntent sessionActivity, Executor callbackExecutor, MediaSession2.SessionCallback callback) {
            super(context, id, player, playlistAgent, volumeProvider, sessionActivity, callbackExecutor, callback);
        }

        @Override
        SupportLibraryImpl createImpl(Context context, String id, BaseMediaPlayer player, MediaPlaylistAgent playlistAgent, VolumeProviderCompat volumeProvider, PendingIntent sessionActivity, Executor callbackExecutor, MediaSession2.SessionCallback callback) {
            return new MediaLibrarySessionImplBase(this, context, id, player, playlistAgent, volumeProvider, sessionActivity, callbackExecutor, callback);
        }

        @Override
        SupportLibraryImpl getImpl() {
            return (SupportLibraryImpl)super.getImpl();
        }

        public void notifyChildrenChanged(@NonNull MediaSession2.ControllerInfo controller, @NonNull String parentId, int itemCount, @Nullable Bundle extras) {
            this.getImpl().notifyChildrenChanged(controller, parentId, itemCount, extras);
        }

        public void notifyChildrenChanged(@NonNull String parentId, int itemCount, @Nullable Bundle extras) {
            this.getImpl().notifyChildrenChanged(parentId, itemCount, extras);
        }

        public void notifySearchResultChanged(@NonNull MediaSession2.ControllerInfo controller, @NonNull String query, int itemCount, @Nullable Bundle extras) {
            this.getImpl().notifySearchResultChanged(controller, query, itemCount, extras);
        }

        @Override
        MediaLibrarySessionCallback getCallback() {
            return (MediaLibrarySessionCallback)super.getCallback();
        }

        static interface SupportLibraryImpl
        extends MediaSession2.SupportLibraryImpl {
            public void notifyChildrenChanged(@NonNull String var1, int var2, @Nullable Bundle var3);

            public void notifyChildrenChanged(@NonNull MediaSession2.ControllerInfo var1, @NonNull String var2, int var3, @Nullable Bundle var4);

            public void notifySearchResultChanged(@NonNull MediaSession2.ControllerInfo var1, @NonNull String var2, int var3, @Nullable Bundle var4);

            public void onGetLibraryRootOnExecutor(@NonNull MediaSession2.ControllerInfo var1, @Nullable Bundle var2);

            public void onGetItemOnExecutor(@NonNull MediaSession2.ControllerInfo var1, @NonNull String var2);

            public void onGetChildrenOnExecutor(@NonNull MediaSession2.ControllerInfo var1, @NonNull String var2, int var3, int var4, @Nullable Bundle var5);

            public void onSubscribeOnExecutor(@NonNull MediaSession2.ControllerInfo var1, @NonNull String var2, @Nullable Bundle var3);

            public void onUnsubscribeOnExecutor(@NonNull MediaSession2.ControllerInfo var1, @NonNull String var2);

            public void onSearchOnExecutor(@NonNull MediaSession2.ControllerInfo var1, @NonNull String var2, @Nullable Bundle var3);

            public void onGetSearchResultOnExecutor(@NonNull MediaSession2.ControllerInfo var1, @NonNull String var2, int var3, int var4, @Nullable Bundle var5);

            @Override
            public MediaLibrarySession getInstance();

            @Override
            public MediaLibrarySessionCallback getCallback();

            public IBinder getLegacySessionBinder();
        }

        public static final class Builder
        extends MediaSession2.BuilderBase<MediaLibrarySession, Builder, MediaLibrarySessionCallback> {
            public Builder(@NonNull MediaLibraryService2 service, @NonNull Executor callbackExecutor, @NonNull MediaLibrarySessionCallback callback) {
                super((Context)service);
                this.setSessionCallback(callbackExecutor, callback);
            }

            @Override
            @NonNull
            public Builder setPlayer(@NonNull BaseMediaPlayer player) {
                return (Builder)super.setPlayer(player);
            }

            @Override
            @NonNull
            public Builder setPlaylistAgent(@NonNull MediaPlaylistAgent playlistAgent) {
                return (Builder)super.setPlaylistAgent(playlistAgent);
            }

            @Override
            @NonNull
            public Builder setVolumeProvider(@Nullable VolumeProviderCompat volumeProvider) {
                return (Builder)super.setVolumeProvider(volumeProvider);
            }

            @Override
            @NonNull
            public Builder setSessionActivity(@Nullable PendingIntent pi) {
                return (Builder)super.setSessionActivity(pi);
            }

            @Override
            @NonNull
            public Builder setId(@NonNull String id) {
                return (Builder)super.setId(id);
            }

            @Override
            @NonNull
            public MediaLibrarySession build() {
                if (this.mCallbackExecutor == null) {
                    this.mCallbackExecutor = new MediaSession2.MainHandlerExecutor(this.mContext);
                }
                if (this.mCallback == null) {
                    this.mCallback = new MediaLibrarySessionCallback(){};
                }
                return new MediaLibrarySession(this.mContext, this.mId, this.mPlayer, this.mPlaylistAgent, this.mVolumeProvider, this.mSessionActivity, this.mCallbackExecutor, this.mCallback);
            }
        }

        public static class MediaLibrarySessionCallback
        extends MediaSession2.SessionCallback {
            @Nullable
            public LibraryRoot onGetLibraryRoot(@NonNull MediaLibrarySession session, @NonNull MediaSession2.ControllerInfo controller, @Nullable Bundle rootHints) {
                return null;
            }

            @Nullable
            public MediaItem2 onGetItem(@NonNull MediaLibrarySession session, @NonNull MediaSession2.ControllerInfo controller, @NonNull String mediaId) {
                return null;
            }

            @Nullable
            public List<MediaItem2> onGetChildren(@NonNull MediaLibrarySession session, @NonNull MediaSession2.ControllerInfo controller, @NonNull String parentId, int page, int pageSize, @Nullable Bundle extras) {
                return null;
            }

            public void onSubscribe(@NonNull MediaLibrarySession session, @NonNull MediaSession2.ControllerInfo controller, @NonNull String parentId, @Nullable Bundle extras) {
            }

            public void onUnsubscribe(@NonNull MediaLibrarySession session, @NonNull MediaSession2.ControllerInfo controller, @NonNull String parentId) {
            }

            public void onSearch(@NonNull MediaLibrarySession session, @NonNull MediaSession2.ControllerInfo controller, @NonNull String query, @Nullable Bundle extras) {
            }

            @Nullable
            public List<MediaItem2> onGetSearchResult(@NonNull MediaLibrarySession session, @NonNull MediaSession2.ControllerInfo controller, @NonNull String query, int page, int pageSize, @Nullable Bundle extras) {
                return null;
            }
        }
    }
}

