/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.os.BadParcelableException;
import android.os.Bundle;
import android.support.v4.media.MediaBrowserCompat;
import android.support.v4.media.MediaBrowserServiceCompat;
import android.support.v4.media.MediaItem2;
import android.support.v4.media.MediaLibraryService2;
import android.support.v4.media.MediaSession2;
import android.support.v4.media.MediaSessionManager;
import android.support.v4.media.MediaUtils2;
import java.util.List;

class MediaLibraryService2LegacyStub
extends MediaBrowserServiceCompat {
    private final MediaLibraryService2.MediaLibrarySession.SupportLibraryImpl mLibrarySession;

    MediaLibraryService2LegacyStub(MediaLibraryService2.MediaLibrarySession.SupportLibraryImpl session) {
        this.mLibrarySession = session;
    }

    @Override
    public MediaBrowserServiceCompat.BrowserRoot onGetRoot(String clientPackageName, int clientUid, Bundle extras) {
        if (MediaUtils2.isDefaultLibraryRootHint(extras)) {
            return MediaUtils2.sDefaultBrowserRoot;
        }
        MediaSession2.ControllerInfo controller = this.getController();
        MediaLibraryService2.LibraryRoot libraryRoot = this.mLibrarySession.getCallback().onGetLibraryRoot(this.mLibrarySession.getInstance(), controller, extras);
        if (libraryRoot == null) {
            return null;
        }
        return new MediaBrowserServiceCompat.BrowserRoot(libraryRoot.getRootId(), libraryRoot.getExtras());
    }

    @Override
    public void onLoadChildren(String parentId, MediaBrowserServiceCompat.Result<List<MediaBrowserCompat.MediaItem>> result) {
        this.onLoadChildren(parentId, result, null);
    }

    @Override
    public void onLoadChildren(final String parentId, final MediaBrowserServiceCompat.Result<List<MediaBrowserCompat.MediaItem>> result, final Bundle options) {
        result.detach();
        final MediaSession2.ControllerInfo controller = this.getController();
        this.mLibrarySession.getCallbackExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (options != null) {
                    options.setClassLoader(MediaLibraryService2LegacyStub.this.mLibrarySession.getContext().getClassLoader());
                    try {
                        int page = options.getInt("android.media.browse.extra.PAGE");
                        int pageSize = options.getInt("android.media.browse.extra.PAGE_SIZE");
                        if (page > 0 && pageSize > 0) {
                            List<MediaItem2> children = MediaLibraryService2LegacyStub.this.mLibrarySession.getCallback().onGetChildren(MediaLibraryService2LegacyStub.this.mLibrarySession.getInstance(), controller, parentId, page, pageSize, options);
                            result.sendResult(MediaUtils2.convertToMediaItemList(children));
                            return;
                        }
                    }
                    catch (BadParcelableException page) {
                        // empty catch block
                    }
                }
                List<MediaItem2> children = MediaLibraryService2LegacyStub.this.mLibrarySession.getCallback().onGetChildren(MediaLibraryService2LegacyStub.this.mLibrarySession.getInstance(), controller, parentId, 1, Integer.MAX_VALUE, null);
                result.sendResult(MediaUtils2.convertToMediaItemList(children));
            }
        });
    }

    @Override
    public void onLoadItem(final String itemId, final MediaBrowserServiceCompat.Result<MediaBrowserCompat.MediaItem> result) {
        result.detach();
        final MediaSession2.ControllerInfo controller = this.getController();
        this.mLibrarySession.getCallbackExecutor().execute(new Runnable(){

            @Override
            public void run() {
                MediaItem2 item = MediaLibraryService2LegacyStub.this.mLibrarySession.getCallback().onGetItem(MediaLibraryService2LegacyStub.this.mLibrarySession.getInstance(), controller, itemId);
                if (item == null) {
                    result.sendResult(null);
                } else {
                    result.sendResult(MediaUtils2.convertToMediaItem(item));
                }
            }
        });
    }

    @Override
    public void onSearch(final String query, final Bundle extras, final MediaBrowserServiceCompat.Result<List<MediaBrowserCompat.MediaItem>> result) {
        result.detach();
        final MediaSession2.ControllerInfo controller = this.getController();
        extras.setClassLoader(this.mLibrarySession.getContext().getClassLoader());
        try {
            final int page = extras.getInt("android.media.browse.extra.PAGE");
            final int pageSize = extras.getInt("android.media.browse.extra.PAGE_SIZE");
            if (page > 0 && pageSize > 0) {
                this.mLibrarySession.getCallbackExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        List<MediaItem2> searchResult = MediaLibraryService2LegacyStub.this.mLibrarySession.getCallback().onGetSearchResult(MediaLibraryService2LegacyStub.this.mLibrarySession.getInstance(), controller, query, page, pageSize, extras);
                        if (searchResult == null) {
                            result.sendResult(null);
                            return;
                        }
                        result.sendResult(MediaUtils2.convertToMediaItemList(searchResult));
                    }
                });
            } else {
                this.mLibrarySession.getCallbackExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        MediaLibraryService2LegacyStub.this.mLibrarySession.getCallback().onSearch(MediaLibraryService2LegacyStub.this.mLibrarySession.getInstance(), controller, query, extras);
                    }
                });
            }
        }
        catch (BadParcelableException badParcelableException) {
            // empty catch block
        }
    }

    @Override
    public void onCustomAction(String action, Bundle extras, MediaBrowserServiceCompat.Result<Bundle> result) {
    }

    private MediaSession2.ControllerInfo getController() {
        List<MediaSession2.ControllerInfo> controllers = this.mLibrarySession.getConnectedControllers();
        MediaSessionManager.RemoteUserInfo info = this.getCurrentBrowserInfo();
        if (info == null) {
            return null;
        }
        for (int i = 0; i < controllers.size(); ++i) {
            MediaSession2.ControllerInfo controller = controllers.get(i);
            if (!controller.getPackageName().equals(info.getPackageName()) || controller.getUid() != info.getUid()) continue;
            return controller;
        }
        return null;
    }
}

