/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.media.DeniedByServerException;
import android.media.MediaDataSource;
import android.media.MediaDrm;
import android.media.MediaFormat;
import android.media.MediaPlayer;
import android.media.MediaTimestamp;
import android.media.PlaybackParams;
import android.media.ResourceBusyException;
import android.media.SubtitleData;
import android.media.SyncParams;
import android.media.TimedMetaData;
import android.media.UnsupportedSchemeException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.media.AudioAttributesCompat;
import android.support.v4.media.BaseMediaPlayer;
import android.support.v4.media.DataSourceDesc;
import android.support.v4.media.Media2DataSource;
import android.support.v4.media.MediaPlayer2;
import android.support.v4.media.MediaTimestamp2;
import android.support.v4.media.PlaybackParams2;
import android.support.v4.media.SubtitleData2;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.Preconditions;
import android.util.Log;
import android.util.Pair;
import android.view.Surface;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

@TargetApi(value=28)
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MediaPlayer2Impl
extends MediaPlayer2 {
    private static final String TAG = "MediaPlayer2Impl";
    private static final int SOURCE_STATE_ERROR = -1;
    private static final int SOURCE_STATE_INIT = 0;
    private static final int SOURCE_STATE_PREPARING = 1;
    private static final int SOURCE_STATE_PREPARED = 2;
    private static ArrayMap<Integer, Integer> sInfoEventMap = new ArrayMap();
    private static ArrayMap<Integer, Integer> sErrorEventMap;
    private static ArrayMap<Integer, Integer> sPrepareDrmStatusMap;
    private static ArrayMap<Integer, Integer> sStateMap;
    private MediaPlayerSourceQueue mPlayer;
    private HandlerThread mHandlerThread;
    private final Handler mEndPositionHandler;
    private final Handler mTaskHandler;
    private final Object mTaskLock = new Object();
    @GuardedBy(value="mTaskLock")
    private final ArrayDeque<Task> mPendingTasks = new ArrayDeque();
    @GuardedBy(value="mTaskLock")
    private Task mCurrentTask;
    private final Object mLock = new Object();
    private Pair<Executor, MediaPlayer2.EventCallback> mMp2EventCallbackRecord;
    private ArrayMap<BaseMediaPlayer.PlayerEventCallback, Executor> mPlayerEventCallbackMap = new ArrayMap();
    private Pair<Executor, MediaPlayer2.DrmEventCallback> mDrmEventCallbackRecord;
    private BaseMediaPlayerImpl mBaseMediaPlayerImpl;

    private void handleDataSourceError(final DataSourceError err) {
        if (err == null) {
            return;
        }
        this.notifyMediaPlayer2Event(new Mp2EventNotifier(){

            @Override
            public void notify(MediaPlayer2.EventCallback callback) {
                callback.onError(MediaPlayer2Impl.this, err.mDSD, err.mWhat, err.mExtra);
            }
        });
    }

    public MediaPlayer2Impl() {
        this.mHandlerThread = new HandlerThread("MediaPlayer2TaskThread");
        this.mHandlerThread.start();
        Looper looper = this.mHandlerThread.getLooper();
        this.mEndPositionHandler = new Handler(looper);
        this.mTaskHandler = new Handler(looper);
        this.mPlayer = new MediaPlayerSourceQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseMediaPlayer getBaseMediaPlayer() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBaseMediaPlayerImpl == null) {
                this.mBaseMediaPlayerImpl = new BaseMediaPlayerImpl();
            }
            return this.mBaseMediaPlayerImpl;
        }
    }

    @Override
    public void close() {
        this.mPlayer.release();
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quitSafely();
            this.mHandlerThread = null;
        }
    }

    @Override
    public void play() {
        this.addTask(new Task(5, false){

            @Override
            void process() {
                MediaPlayer2Impl.this.mPlayer.play();
            }
        });
    }

    @Override
    public void prepare() {
        this.addTask(new Task(6, true){

            @Override
            void process() throws IOException {
                MediaPlayer2Impl.this.mPlayer.prepareAsync();
            }
        });
    }

    @Override
    public void pause() {
        this.addTask(new Task(4, false){

            @Override
            void process() {
                MediaPlayer2Impl.this.mPlayer.pause();
            }
        });
    }

    @Override
    public void skipToNext() {
        this.addTask(new Task(29, false){

            @Override
            void process() {
                MediaPlayer2Impl.this.mPlayer.skipToNext();
            }
        });
    }

    @Override
    public long getCurrentPosition() {
        return this.mPlayer.getCurrentPosition();
    }

    @Override
    public long getDuration() {
        return this.mPlayer.getDuration();
    }

    @Override
    public long getBufferedPosition() {
        return this.mPlayer.getBufferedPosition();
    }

    @Override
    public int getState() {
        return this.mPlayer.getMediaPlayer2State();
    }

    private int getPlayerState() {
        return this.mPlayer.getPlayerState();
    }

    private int getBufferingState() {
        return this.mPlayer.getBufferingState();
    }

    @Override
    public void setAudioAttributes(final @NonNull AudioAttributesCompat attributes) {
        this.addTask(new Task(16, false){

            @Override
            void process() {
                MediaPlayer2Impl.this.mPlayer.setAudioAttributes(attributes);
            }
        });
    }

    @Override
    @Nullable
    public AudioAttributesCompat getAudioAttributes() {
        return this.mPlayer.getAudioAttributes();
    }

    @Override
    public void setDataSource(final @NonNull DataSourceDesc dsd) {
        this.addTask(new Task(19, false){

            @Override
            void process() {
                Preconditions.checkNotNull((Object)dsd, (Object)"the DataSourceDesc cannot be null");
                try {
                    MediaPlayer2Impl.this.mPlayer.setFirst(dsd);
                }
                catch (IOException e) {
                    Log.e((String)MediaPlayer2Impl.TAG, (String)"process: setDataSource", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void setNextDataSource(final @NonNull DataSourceDesc dsd) {
        this.addTask(new Task(22, false){

            @Override
            void process() {
                Preconditions.checkNotNull((Object)dsd, (Object)"the DataSourceDesc cannot be null");
                MediaPlayer2Impl.this.handleDataSourceError(MediaPlayer2Impl.this.mPlayer.setNext(dsd));
            }
        });
    }

    @Override
    public void setNextDataSources(final @NonNull List<DataSourceDesc> dsds) {
        this.addTask(new Task(23, false){

            @Override
            void process() {
                if (dsds == null || dsds.size() == 0) {
                    throw new IllegalArgumentException("data source list cannot be null or empty.");
                }
                for (DataSourceDesc dsd : dsds) {
                    if (dsd != null) continue;
                    throw new IllegalArgumentException("DataSourceDesc in the source list cannot be null.");
                }
                MediaPlayer2Impl.this.handleDataSourceError(MediaPlayer2Impl.this.mPlayer.setNextMultiple(dsds));
            }
        });
    }

    @Override
    @NonNull
    public DataSourceDesc getCurrentDataSource() {
        return this.mPlayer.getFirst().getDSD();
    }

    @Override
    public void loopCurrent(final boolean loop) {
        this.addTask(new Task(3, false){

            @Override
            void process() {
                MediaPlayer2Impl.this.mPlayer.setLooping(loop);
            }
        });
    }

    @Override
    public void setPlayerVolume(final float volume) {
        this.addTask(new Task(26, false){

            @Override
            void process() {
                MediaPlayer2Impl.this.mPlayer.setVolume(volume);
            }
        });
    }

    @Override
    public float getPlayerVolume() {
        return this.mPlayer.getVolume();
    }

    @Override
    public float getMaxPlayerVolume() {
        return 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPlayerEventCallback(@NonNull Executor e, @NonNull BaseMediaPlayer.PlayerEventCallback cb) {
        if (cb == null) {
            throw new IllegalArgumentException("Illegal null PlayerEventCallback");
        }
        if (e == null) {
            throw new IllegalArgumentException("Illegal null Executor for the PlayerEventCallback");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mPlayerEventCallbackMap.put((Object)cb, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterPlayerEventCallback(@NonNull BaseMediaPlayer.PlayerEventCallback cb) {
        if (cb == null) {
            throw new IllegalArgumentException("Illegal null PlayerEventCallback");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mPlayerEventCallbackMap.remove((Object)cb);
        }
    }

    @Override
    public void notifyWhenCommandLabelReached(final Object label) {
        this.addTask(new Task(1003, false){

            @Override
            void process() {
                MediaPlayer2Impl.this.notifyMediaPlayer2Event(new Mp2EventNotifier(){

                    @Override
                    public void notify(MediaPlayer2.EventCallback cb) {
                        cb.onCommandLabelReached(MediaPlayer2Impl.this, label);
                    }
                });
            }
        });
    }

    @Override
    public void setSurface(final Surface surface) {
        this.addTask(new Task(27, false){

            @Override
            void process() {
                MediaPlayer2Impl.this.mPlayer.setSurface(surface);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPendingCommands() {
        Object object = this.mTaskLock;
        synchronized (object) {
            this.mPendingTasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(Task task) {
        Object object = this.mTaskLock;
        synchronized (object) {
            this.mPendingTasks.add(task);
            this.processPendingTask_l();
        }
    }

    @GuardedBy(value="mTaskLock")
    private void processPendingTask_l() {
        if (this.mCurrentTask != null) {
            return;
        }
        if (!this.mPendingTasks.isEmpty()) {
            Task task;
            this.mCurrentTask = task = this.mPendingTasks.removeFirst();
            this.mTaskHandler.post((Runnable)task);
        }
    }

    private static void handleDataSource(MediaPlayerSource src) throws IOException {
        final DataSourceDesc dsd = src.getDSD();
        Preconditions.checkNotNull((Object)dsd, (Object)"the DataSourceDesc cannot be null");
        MediaPlayer player = src.getPlayer();
        switch (dsd.getType()) {
            case 1: {
                player.setDataSource(new MediaDataSource(){
                    Media2DataSource mDataSource;
                    {
                        this.mDataSource = dsd.getMedia2DataSource();
                    }

                    public int readAt(long position, byte[] buffer, int offset, int size) throws IOException {
                        return this.mDataSource.readAt(position, buffer, offset, size);
                    }

                    public long getSize() throws IOException {
                        return this.mDataSource.getSize();
                    }

                    public void close() throws IOException {
                        this.mDataSource.close();
                    }
                });
                break;
            }
            case 2: {
                player.setDataSource(dsd.getFileDescriptor(), dsd.getFileDescriptorOffset(), dsd.getFileDescriptorLength());
                break;
            }
            case 3: {
                player.setDataSource(dsd.getUriContext(), dsd.getUri(), dsd.getUriHeaders(), dsd.getUriCookies());
                break;
            }
        }
    }

    @Override
    public int getVideoWidth() {
        return this.mPlayer.getVideoWidth();
    }

    @Override
    public int getVideoHeight() {
        return this.mPlayer.getVideoHeight();
    }

    @Override
    public PersistableBundle getMetrics() {
        return this.mPlayer.getMetrics();
    }

    @Override
    public void setPlaybackParams(final @NonNull PlaybackParams2 params) {
        this.addTask(new Task(24, false){

            @Override
            void process() {
                MediaPlayer2Impl.this.setPlaybackParamsInternal(params.getPlaybackParams());
            }
        });
    }

    @Override
    @NonNull
    public PlaybackParams2 getPlaybackParams() {
        return new PlaybackParams2.Builder(this.mPlayer.getPlaybackParams()).build();
    }

    @Override
    public void seekTo(final long msec, final int mode) {
        this.addTask(new Task(14, true){

            @Override
            void process() {
                MediaPlayer2Impl.this.mPlayer.seekTo(msec, mode);
            }
        });
    }

    @Override
    @Nullable
    public MediaTimestamp2 getTimestamp() {
        return this.mPlayer.getTimestamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.mPlayer.reset();
        Object object = this.mLock;
        synchronized (object) {
            this.mMp2EventCallbackRecord = null;
            this.mPlayerEventCallbackMap.clear();
            this.mDrmEventCallbackRecord = null;
        }
    }

    @Override
    public void setAudioSessionId(final int sessionId) {
        this.addTask(new Task(17, false){

            @Override
            void process() {
                MediaPlayer2Impl.this.mPlayer.setAudioSessionId(sessionId);
            }
        });
    }

    @Override
    public int getAudioSessionId() {
        return this.mPlayer.getAudioSessionId();
    }

    @Override
    public void attachAuxEffect(final int effectId) {
        this.addTask(new Task(1, false){

            @Override
            void process() {
                MediaPlayer2Impl.this.mPlayer.attachAuxEffect(effectId);
            }
        });
    }

    @Override
    public void setAuxEffectSendLevel(final float level) {
        this.addTask(new Task(18, false){

            @Override
            void process() {
                MediaPlayer2Impl.this.mPlayer.setAuxEffectSendLevel(level);
            }
        });
    }

    @Override
    public List<MediaPlayer2.TrackInfo> getTrackInfo() {
        MediaPlayer.TrackInfo[] list = this.mPlayer.getTrackInfo();
        ArrayList<MediaPlayer2.TrackInfo> trackList = new ArrayList<MediaPlayer2.TrackInfo>();
        for (MediaPlayer.TrackInfo info : list) {
            trackList.add(new TrackInfoImpl(info.getTrackType(), info.getFormat()));
        }
        return trackList;
    }

    @Override
    public int getSelectedTrack(int trackType) {
        return this.mPlayer.getSelectedTrack(trackType);
    }

    @Override
    public void selectTrack(final int index) {
        this.addTask(new Task(15, false){

            @Override
            void process() {
                MediaPlayer2Impl.this.mPlayer.selectTrack(index);
            }
        });
    }

    @Override
    public void deselectTrack(final int index) {
        this.addTask(new Task(2, false){

            @Override
            void process() {
                MediaPlayer2Impl.this.mPlayer.deselectTrack(index);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventCallback(@NonNull Executor executor, @NonNull MediaPlayer2.EventCallback eventCallback) {
        if (eventCallback == null) {
            throw new IllegalArgumentException("Illegal null EventCallback");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Illegal null Executor for the EventCallback");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mMp2EventCallbackRecord = new Pair((Object)executor, (Object)eventCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearEventCallback() {
        Object object = this.mLock;
        synchronized (object) {
            this.mMp2EventCallbackRecord = null;
        }
    }

    @Override
    public void setOnDrmConfigHelper(final MediaPlayer2.OnDrmConfigHelper listener) {
        this.mPlayer.setOnDrmConfigHelper(new MediaPlayer.OnDrmConfigHelper(){

            public void onDrmConfig(MediaPlayer mp) {
                MediaPlayerSource src = MediaPlayer2Impl.this.mPlayer.getSourceForPlayer(mp);
                DataSourceDesc dsd = src == null ? null : src.getDSD();
                listener.onDrmConfig(MediaPlayer2Impl.this, dsd);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDrmEventCallback(@NonNull Executor executor, @NonNull MediaPlayer2.DrmEventCallback eventCallback) {
        if (eventCallback == null) {
            throw new IllegalArgumentException("Illegal null EventCallback");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Illegal null Executor for the EventCallback");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mDrmEventCallbackRecord = new Pair((Object)executor, (Object)eventCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDrmEventCallback() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDrmEventCallbackRecord = null;
        }
    }

    @Override
    public MediaPlayer2.DrmInfo getDrmInfo() {
        MediaPlayer.DrmInfo info = this.mPlayer.getDrmInfo();
        return info == null ? null : new DrmInfoImpl(info.getPssh(), info.getSupportedSchemes());
    }

    @Override
    public void prepareDrm(@NonNull UUID uuid) throws UnsupportedSchemeException, ResourceBusyException, MediaPlayer2.ProvisioningNetworkErrorException, MediaPlayer2.ProvisioningServerErrorException {
        try {
            this.mPlayer.prepareDrm(uuid);
        }
        catch (MediaPlayer.ProvisioningNetworkErrorException e) {
            throw new MediaPlayer2.ProvisioningNetworkErrorException(e.getMessage());
        }
        catch (MediaPlayer.ProvisioningServerErrorException e) {
            throw new MediaPlayer2.ProvisioningServerErrorException(e.getMessage());
        }
    }

    @Override
    public void releaseDrm() throws MediaPlayer2.NoDrmSchemeException {
        try {
            this.mPlayer.releaseDrm();
        }
        catch (MediaPlayer.NoDrmSchemeException e) {
            throw new MediaPlayer2.NoDrmSchemeException(e.getMessage());
        }
    }

    @Override
    @NonNull
    public MediaDrm.KeyRequest getDrmKeyRequest(@Nullable byte[] keySetId, @Nullable byte[] initData, @Nullable String mimeType, int keyType, @Nullable Map<String, String> optionalParameters) throws MediaPlayer2.NoDrmSchemeException {
        try {
            return this.mPlayer.getKeyRequest(keySetId, initData, mimeType, keyType, optionalParameters);
        }
        catch (MediaPlayer.NoDrmSchemeException e) {
            throw new MediaPlayer2.NoDrmSchemeException(e.getMessage());
        }
    }

    @Override
    public byte[] provideDrmKeyResponse(@Nullable byte[] keySetId, @NonNull byte[] response) throws MediaPlayer2.NoDrmSchemeException, DeniedByServerException {
        try {
            return this.mPlayer.provideKeyResponse(keySetId, response);
        }
        catch (MediaPlayer.NoDrmSchemeException e) {
            throw new MediaPlayer2.NoDrmSchemeException(e.getMessage());
        }
    }

    @Override
    public void restoreDrmKeys(@NonNull byte[] keySetId) throws MediaPlayer2.NoDrmSchemeException {
        try {
            this.mPlayer.restoreKeys(keySetId);
        }
        catch (MediaPlayer.NoDrmSchemeException e) {
            throw new MediaPlayer2.NoDrmSchemeException(e.getMessage());
        }
    }

    @Override
    @NonNull
    public String getDrmPropertyString(@NonNull String propertyName) throws MediaPlayer2.NoDrmSchemeException {
        try {
            return this.mPlayer.getDrmPropertyString(propertyName);
        }
        catch (MediaPlayer.NoDrmSchemeException e) {
            throw new MediaPlayer2.NoDrmSchemeException(e.getMessage());
        }
    }

    @Override
    public void setDrmPropertyString(@NonNull String propertyName, @NonNull String value) throws MediaPlayer2.NoDrmSchemeException {
        try {
            this.mPlayer.setDrmPropertyString(propertyName, value);
        }
        catch (MediaPlayer.NoDrmSchemeException e) {
            throw new MediaPlayer2.NoDrmSchemeException(e.getMessage());
        }
    }

    private void setPlaybackParamsInternal(final PlaybackParams params) {
        PlaybackParams current = null;
        try {
            current = this.mPlayer.getPlaybackParams();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.mPlayer.setPlaybackParams(params);
        if (current != null && current.getSpeed() != params.getSpeed()) {
            this.notifyPlayerEvent(new PlayerEventNotifier(){

                @Override
                public void notify(BaseMediaPlayer.PlayerEventCallback cb) {
                    cb.onPlaybackSpeedChanged(MediaPlayer2Impl.this.mBaseMediaPlayerImpl, params.getSpeed());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMediaPlayer2Event(final Mp2EventNotifier notifier) {
        Pair<Executor, MediaPlayer2.EventCallback> record;
        Object object = this.mLock;
        synchronized (object) {
            record = this.mMp2EventCallbackRecord;
        }
        if (record != null) {
            ((Executor)record.first).execute(new Runnable(){

                @Override
                public void run() {
                    notifier.notify((MediaPlayer2.EventCallback)record.second);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPlayerEvent(final PlayerEventNotifier notifier) {
        ArrayMap map;
        Object object = this.mLock;
        synchronized (object) {
            map = new ArrayMap(this.mPlayerEventCallbackMap);
        }
        int callbackCount = map.size();
        for (int i = 0; i < callbackCount; ++i) {
            Executor executor = (Executor)map.valueAt(i);
            final BaseMediaPlayer.PlayerEventCallback cb = (BaseMediaPlayer.PlayerEventCallback)map.keyAt(i);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    notifier.notify(cb);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDrmEvent(final DrmEventNotifier notifier) {
        Pair<Executor, MediaPlayer2.DrmEventCallback> record;
        Object object = this.mLock;
        synchronized (object) {
            record = this.mDrmEventCallbackRecord;
        }
        if (record != null) {
            ((Executor)record.first).execute(new Runnable(){

                @Override
                public void run() {
                    notifier.notify((MediaPlayer2.DrmEventCallback)record.second);
                }
            });
        }
    }

    private void setEndPositionTimerIfNeeded(final MediaPlayer.OnCompletionListener completionListener, final MediaPlayerSource src, MediaTimestamp timedsd) {
        if (src == this.mPlayer.getFirst()) {
            this.mEndPositionHandler.removeCallbacksAndMessages(null);
            DataSourceDesc dsd = src.getDSD();
            if (dsd.getEndPosition() != 0x7FFFFFFFFFFFFFFL && timedsd.getMediaClockRate() > 0.0f) {
                long nowNs = System.nanoTime();
                long elapsedTimeUs = (nowNs - timedsd.getAnchorSytemNanoTime()) / 1000L;
                long nowMediaMs = (timedsd.getAnchorMediaTimeUs() + elapsedTimeUs) / 1000L;
                long timeLeftMs = (long)((float)(dsd.getEndPosition() - nowMediaMs) / timedsd.getMediaClockRate());
                this.mEndPositionHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (MediaPlayer2Impl.this.mPlayer.getFirst() != src) {
                            return;
                        }
                        MediaPlayer2Impl.this.mPlayer.pause();
                        completionListener.onCompletion(src.getPlayer());
                    }
                }, timeLeftMs < 0L ? 0L : timeLeftMs);
            }
        }
    }

    private void setUpListeners(final MediaPlayerSource src) {
        MediaPlayer p = src.getPlayer();
        final MediaPlayer.OnPreparedListener preparedListener = new MediaPlayer.OnPreparedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onPrepared(MediaPlayer mp) {
                MediaPlayer2Impl.this.handleDataSourceError(MediaPlayer2Impl.this.mPlayer.onPrepared(mp));
                MediaPlayer2Impl.this.notifyMediaPlayer2Event(new Mp2EventNotifier(){

                    @Override
                    public void notify(MediaPlayer2.EventCallback callback) {
                        MediaPlayer2Impl mp2 = MediaPlayer2Impl.this;
                        DataSourceDesc dsd = src.getDSD();
                        callback.onInfo(mp2, dsd, 100, 0);
                    }
                });
                MediaPlayer2Impl.this.notifyPlayerEvent(new PlayerEventNotifier(){

                    @Override
                    public void notify(BaseMediaPlayer.PlayerEventCallback cb) {
                        cb.onMediaPrepared(MediaPlayer2Impl.this.mBaseMediaPlayerImpl, src.getDSD());
                    }
                });
                Object object = MediaPlayer2Impl.this.mTaskLock;
                synchronized (object) {
                    if (MediaPlayer2Impl.this.mCurrentTask != null && MediaPlayer2Impl.this.mCurrentTask.mMediaCallType == 6 && MediaPlayer2Impl.this.mCurrentTask.mDSD == src.getDSD() && MediaPlayer2Impl.this.mCurrentTask.mNeedToWaitForEventToComplete) {
                        MediaPlayer2Impl.this.mCurrentTask.sendCompleteNotification(0);
                        MediaPlayer2Impl.this.mCurrentTask = null;
                        MediaPlayer2Impl.this.processPendingTask_l();
                    }
                }
            }
        };
        p.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                if (src.getDSD().getStartPosition() != 0L) {
                    src.getPlayer().seekTo((long)((int)src.getDSD().getStartPosition()), 3);
                } else {
                    preparedListener.onPrepared(mp);
                }
            }
        });
        p.setOnVideoSizeChangedListener(new MediaPlayer.OnVideoSizeChangedListener(){

            public void onVideoSizeChanged(MediaPlayer mp, final int width, final int height) {
                MediaPlayer2Impl.this.notifyMediaPlayer2Event(new Mp2EventNotifier(){

                    @Override
                    public void notify(MediaPlayer2.EventCallback cb) {
                        cb.onVideoSizeChanged(MediaPlayer2Impl.this, src.getDSD(), width, height);
                    }
                });
            }
        });
        p.setOnInfoListener(new MediaPlayer.OnInfoListener(){

            public boolean onInfo(MediaPlayer mp, int what, int extra) {
                switch (what) {
                    case 3: {
                        MediaPlayer2Impl.this.notifyMediaPlayer2Event(new Mp2EventNotifier(){

                            @Override
                            public void notify(MediaPlayer2.EventCallback cb) {
                                cb.onInfo(MediaPlayer2Impl.this, src.getDSD(), 3, 0);
                            }
                        });
                        break;
                    }
                    case 701: {
                        MediaPlayer2Impl.this.mPlayer.setBufferingState(mp, 2);
                        break;
                    }
                    case 702: {
                        MediaPlayer2Impl.this.mPlayer.setBufferingState(mp, 1);
                    }
                }
                return false;
            }
        });
        final MediaPlayer.OnCompletionListener completionListener = new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                MediaPlayer2Impl.this.handleDataSourceError(MediaPlayer2Impl.this.mPlayer.onCompletion(mp));
                MediaPlayer2Impl.this.notifyMediaPlayer2Event(new Mp2EventNotifier(){

                    @Override
                    public void notify(MediaPlayer2.EventCallback cb) {
                        MediaPlayer2Impl mp2 = MediaPlayer2Impl.this;
                        DataSourceDesc dsd = src.getDSD();
                        cb.onInfo(mp2, dsd, 5, 0);
                    }
                });
            }
        };
        p.setOnCompletionListener(completionListener);
        p.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onError(MediaPlayer mp, final int what, final int extra) {
                MediaPlayer2Impl.this.mPlayer.onError(mp);
                Object object = MediaPlayer2Impl.this.mTaskLock;
                synchronized (object) {
                    if (MediaPlayer2Impl.this.mCurrentTask != null && MediaPlayer2Impl.this.mCurrentTask.mNeedToWaitForEventToComplete) {
                        MediaPlayer2Impl.this.mCurrentTask.sendCompleteNotification(Integer.MIN_VALUE);
                        MediaPlayer2Impl.this.mCurrentTask = null;
                        MediaPlayer2Impl.this.processPendingTask_l();
                    }
                }
                MediaPlayer2Impl.this.notifyMediaPlayer2Event(new Mp2EventNotifier(){

                    @Override
                    public void notify(MediaPlayer2.EventCallback cb) {
                        int w = (Integer)sErrorEventMap.getOrDefault((Object)what, (Object)1);
                        cb.onError(MediaPlayer2Impl.this, src.getDSD(), w, extra);
                    }
                });
                return true;
            }
        });
        p.setOnSeekCompleteListener(new MediaPlayer.OnSeekCompleteListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSeekComplete(MediaPlayer mp) {
                if (src.mMp2State == 1001 && src.getDSD().getStartPosition() != 0L) {
                    preparedListener.onPrepared(mp);
                    return;
                }
                Object object = MediaPlayer2Impl.this.mTaskLock;
                synchronized (object) {
                    if (MediaPlayer2Impl.this.mCurrentTask != null && MediaPlayer2Impl.this.mCurrentTask.mMediaCallType == 14 && MediaPlayer2Impl.this.mCurrentTask.mNeedToWaitForEventToComplete) {
                        MediaPlayer2Impl.this.mCurrentTask.sendCompleteNotification(0);
                        MediaPlayer2Impl.this.mCurrentTask = null;
                        MediaPlayer2Impl.this.processPendingTask_l();
                    }
                }
                final long seekPos = MediaPlayer2Impl.this.getCurrentPosition();
                MediaPlayer2Impl.this.notifyPlayerEvent(new PlayerEventNotifier(){

                    @Override
                    public void notify(BaseMediaPlayer.PlayerEventCallback cb) {
                        cb.onSeekCompleted(MediaPlayer2Impl.this.mBaseMediaPlayerImpl, seekPos);
                    }
                });
            }
        });
        p.setOnTimedMetaDataAvailableListener(new MediaPlayer.OnTimedMetaDataAvailableListener(){

            public void onTimedMetaDataAvailable(MediaPlayer mp, final TimedMetaData data) {
                MediaPlayer2Impl.this.notifyMediaPlayer2Event(new Mp2EventNotifier(){

                    @Override
                    public void notify(MediaPlayer2.EventCallback cb) {
                        cb.onTimedMetaDataAvailable(MediaPlayer2Impl.this, src.getDSD(), data);
                    }
                });
            }
        });
        p.setOnInfoListener(new MediaPlayer.OnInfoListener(){

            public boolean onInfo(MediaPlayer mp, final int what, final int extra) {
                MediaPlayer2Impl.this.notifyMediaPlayer2Event(new Mp2EventNotifier(){

                    @Override
                    public void notify(MediaPlayer2.EventCallback cb) {
                        int w = (Integer)sInfoEventMap.getOrDefault((Object)what, (Object)1);
                        cb.onInfo(MediaPlayer2Impl.this, src.getDSD(), w, extra);
                    }
                });
                return true;
            }
        });
        p.setOnBufferingUpdateListener(new MediaPlayer.OnBufferingUpdateListener(){

            public void onBufferingUpdate(MediaPlayer mp, final int percent) {
                if (percent >= 100) {
                    MediaPlayer2Impl.this.mPlayer.setBufferingState(mp, 3);
                }
                src.mBufferedPercentage.set(percent);
                MediaPlayer2Impl.this.notifyMediaPlayer2Event(new Mp2EventNotifier(){

                    @Override
                    public void notify(MediaPlayer2.EventCallback cb) {
                        cb.onInfo(MediaPlayer2Impl.this, src.getDSD(), 704, percent);
                    }
                });
            }
        });
        p.setOnMediaTimeDiscontinuityListener(new MediaPlayer.OnMediaTimeDiscontinuityListener(){

            public void onMediaTimeDiscontinuity(MediaPlayer mp, final MediaTimestamp timestamp) {
                MediaPlayer2Impl.this.notifyMediaPlayer2Event(new Mp2EventNotifier(){

                    @Override
                    public void notify(MediaPlayer2.EventCallback cb) {
                        cb.onMediaTimeDiscontinuity(MediaPlayer2Impl.this, src.getDSD(), new MediaTimestamp2(timestamp));
                    }
                });
                MediaPlayer2Impl.this.setEndPositionTimerIfNeeded(completionListener, src, timestamp);
            }
        });
        p.setOnSubtitleDataListener(new MediaPlayer.OnSubtitleDataListener(){

            public void onSubtitleData(MediaPlayer mp, final SubtitleData data) {
                MediaPlayer2Impl.this.notifyMediaPlayer2Event(new Mp2EventNotifier(){

                    @Override
                    public void notify(MediaPlayer2.EventCallback cb) {
                        cb.onSubtitleData(MediaPlayer2Impl.this, src.getDSD(), new SubtitleData2(data));
                    }
                });
            }
        });
        p.setOnDrmInfoListener(new MediaPlayer.OnDrmInfoListener(){

            public void onDrmInfo(MediaPlayer mp, final MediaPlayer.DrmInfo drmInfo) {
                MediaPlayer2Impl.this.notifyDrmEvent(new DrmEventNotifier(){

                    @Override
                    public void notify(MediaPlayer2.DrmEventCallback cb) {
                        cb.onDrmInfo(MediaPlayer2Impl.this, src.getDSD(), new DrmInfoImpl(drmInfo.getPssh(), drmInfo.getSupportedSchemes()));
                    }
                });
            }
        });
        p.setOnDrmPreparedListener(new MediaPlayer.OnDrmPreparedListener(){

            public void onDrmPrepared(MediaPlayer mp, final int status) {
                MediaPlayer2Impl.this.notifyDrmEvent(new DrmEventNotifier(){

                    @Override
                    public void notify(MediaPlayer2.DrmEventCallback cb) {
                        int s = (Integer)sPrepareDrmStatusMap.getOrDefault((Object)status, (Object)3);
                        cb.onDrmPrepared(MediaPlayer2Impl.this, src.getDSD(), s);
                    }
                });
            }
        });
    }

    static {
        sInfoEventMap.put((Object)1, (Object)1);
        sInfoEventMap.put((Object)2, (Object)2);
        sInfoEventMap.put((Object)3, (Object)3);
        sInfoEventMap.put((Object)700, (Object)700);
        sInfoEventMap.put((Object)701, (Object)701);
        sInfoEventMap.put((Object)702, (Object)702);
        sInfoEventMap.put((Object)800, (Object)800);
        sInfoEventMap.put((Object)801, (Object)801);
        sInfoEventMap.put((Object)802, (Object)802);
        sInfoEventMap.put((Object)804, (Object)804);
        sInfoEventMap.put((Object)805, (Object)805);
        sInfoEventMap.put((Object)901, (Object)901);
        sInfoEventMap.put((Object)902, (Object)902);
        sErrorEventMap = new ArrayMap();
        sErrorEventMap.put((Object)1, (Object)1);
        sErrorEventMap.put((Object)200, (Object)200);
        sErrorEventMap.put((Object)-1004, (Object)-1004);
        sErrorEventMap.put((Object)-1007, (Object)-1007);
        sErrorEventMap.put((Object)-1010, (Object)-1010);
        sErrorEventMap.put((Object)-110, (Object)-110);
        sPrepareDrmStatusMap = new ArrayMap();
        sPrepareDrmStatusMap.put((Object)0, (Object)0);
        sPrepareDrmStatusMap.put((Object)1, (Object)1);
        sPrepareDrmStatusMap.put((Object)2, (Object)2);
        sPrepareDrmStatusMap.put((Object)2, (Object)2);
        sStateMap = new ArrayMap();
        sStateMap.put((Object)1001, (Object)0);
        sStateMap.put((Object)1002, (Object)1);
        sStateMap.put((Object)1003, (Object)1);
        sStateMap.put((Object)1004, (Object)2);
        sStateMap.put((Object)1005, (Object)3);
    }

    private class BaseMediaPlayerImpl
    extends BaseMediaPlayer {
        private BaseMediaPlayerImpl() {
        }

        @Override
        public void play() {
            MediaPlayer2Impl.this.play();
        }

        @Override
        public void prepare() {
            MediaPlayer2Impl.this.prepare();
        }

        @Override
        public void pause() {
            MediaPlayer2Impl.this.pause();
        }

        @Override
        public void reset() {
            MediaPlayer2Impl.this.reset();
        }

        @Override
        public void skipToNext() {
            MediaPlayer2Impl.this.skipToNext();
        }

        @Override
        public void seekTo(long pos) {
            MediaPlayer2Impl.this.seekTo(pos);
        }

        @Override
        public long getCurrentPosition() {
            try {
                return MediaPlayer2Impl.this.getCurrentPosition();
            }
            catch (IllegalStateException e) {
                return -1L;
            }
        }

        @Override
        public long getDuration() {
            try {
                return MediaPlayer2Impl.this.getDuration();
            }
            catch (IllegalStateException e) {
                return -1L;
            }
        }

        @Override
        public long getBufferedPosition() {
            try {
                return MediaPlayer2Impl.this.getBufferedPosition();
            }
            catch (IllegalStateException e) {
                return -1L;
            }
        }

        @Override
        public int getPlayerState() {
            return MediaPlayer2Impl.this.getPlayerState();
        }

        @Override
        public int getBufferingState() {
            return MediaPlayer2Impl.this.getBufferingState();
        }

        @Override
        public void setAudioAttributes(AudioAttributesCompat attributes) {
            MediaPlayer2Impl.this.setAudioAttributes(attributes);
        }

        @Override
        public AudioAttributesCompat getAudioAttributes() {
            return MediaPlayer2Impl.this.getAudioAttributes();
        }

        @Override
        public void setDataSource(DataSourceDesc dsd) {
            MediaPlayer2Impl.this.setDataSource(dsd);
        }

        @Override
        public void setNextDataSource(DataSourceDesc dsd) {
            MediaPlayer2Impl.this.setNextDataSource(dsd);
        }

        @Override
        public void setNextDataSources(List<DataSourceDesc> dsds) {
            MediaPlayer2Impl.this.setNextDataSources(dsds);
        }

        @Override
        public DataSourceDesc getCurrentDataSource() {
            return MediaPlayer2Impl.this.getCurrentDataSource();
        }

        @Override
        public void loopCurrent(boolean loop) {
            MediaPlayer2Impl.this.loopCurrent(loop);
        }

        @Override
        public void setPlaybackSpeed(float speed) {
            MediaPlayer2Impl.this.setPlaybackParams(new PlaybackParams2.Builder(MediaPlayer2Impl.this.getPlaybackParams().getPlaybackParams()).setSpeed(speed).build());
        }

        @Override
        public float getPlaybackSpeed() {
            try {
                return MediaPlayer2Impl.this.getPlaybackParams().getSpeed().floatValue();
            }
            catch (IllegalStateException e) {
                return super.getPlaybackSpeed();
            }
        }

        @Override
        public void setPlayerVolume(float volume) {
            MediaPlayer2Impl.this.setPlayerVolume(volume);
        }

        @Override
        public float getPlayerVolume() {
            return MediaPlayer2Impl.this.getPlayerVolume();
        }

        @Override
        public void registerPlayerEventCallback(Executor e, BaseMediaPlayer.PlayerEventCallback cb) {
            MediaPlayer2Impl.this.registerPlayerEventCallback(e, cb);
        }

        @Override
        public void unregisterPlayerEventCallback(BaseMediaPlayer.PlayerEventCallback cb) {
            MediaPlayer2Impl.this.unregisterPlayerEventCallback(cb);
        }

        @Override
        public void close() throws Exception {
            MediaPlayer2Impl.this.close();
        }
    }

    private class MediaPlayerSourceQueue {
        List<MediaPlayerSource> mQueue = new ArrayList<MediaPlayerSource>();
        Float mVolume = Float.valueOf(1.0f);
        Surface mSurface;
        Integer mAuxEffect;
        Float mAuxEffectSendLevel;
        AudioAttributesCompat mAudioAttributes;
        Integer mAudioSessionId;
        SyncParams mSyncParams;
        PlaybackParams mPlaybackParams;
        PlaybackParams mPlaybackParamsToSetAfterSetDataSource;

        MediaPlayerSourceQueue() {
            this.mQueue.add(new MediaPlayerSource(null));
        }

        synchronized MediaPlayer getCurrentPlayer() {
            return this.mQueue.get(0).getPlayer();
        }

        synchronized MediaPlayerSource getFirst() {
            return this.mQueue.get(0);
        }

        synchronized void setFirst(DataSourceDesc dsd) throws IOException {
            if (this.mQueue.isEmpty()) {
                this.mQueue.add(0, new MediaPlayerSource(dsd));
            } else {
                this.mQueue.get((int)0).mDSD = dsd;
                MediaPlayer2Impl.this.setUpListeners(this.mQueue.get(0));
            }
            MediaPlayer2Impl.handleDataSource(this.mQueue.get(0));
            if (this.mPlaybackParamsToSetAfterSetDataSource != null) {
                this.getCurrentPlayer().setPlaybackParams(this.mPlaybackParamsToSetAfterSetDataSource);
                this.mPlaybackParams = this.mPlaybackParamsToSetAfterSetDataSource;
                this.mPlaybackParamsToSetAfterSetDataSource = null;
            }
        }

        synchronized DataSourceError setNext(DataSourceDesc dsd) {
            MediaPlayerSource src = new MediaPlayerSource(dsd);
            if (this.mQueue.isEmpty()) {
                this.mQueue.add(src);
                return this.prepareAt(0);
            }
            this.mQueue.add(1, src);
            return this.prepareAt(1);
        }

        synchronized DataSourceError setNextMultiple(List<DataSourceDesc> descs) {
            ArrayList<MediaPlayerSource> sources = new ArrayList<MediaPlayerSource>();
            for (DataSourceDesc dsd : descs) {
                sources.add(new MediaPlayerSource(dsd));
            }
            if (this.mQueue.isEmpty()) {
                this.mQueue.addAll(sources);
                return this.prepareAt(0);
            }
            this.mQueue.addAll(1, sources);
            return this.prepareAt(1);
        }

        synchronized void play() {
            MediaPlayerSource src = this.mQueue.get(0);
            if (src.mSourceState != 2) {
                throw new IllegalStateException();
            }
            src.getPlayer().start();
            this.setMp2State(src.getPlayer(), 1004);
        }

        synchronized void prepare() {
            this.getCurrentPlayer().prepareAsync();
        }

        synchronized void release() {
            this.getCurrentPlayer().release();
        }

        synchronized void prepareAsync() {
            MediaPlayer mp = this.getCurrentPlayer();
            mp.prepareAsync();
            this.setBufferingState(mp, 2);
        }

        synchronized void pause() {
            MediaPlayer mp = this.getCurrentPlayer();
            mp.pause();
            this.setMp2State(mp, 1003);
        }

        synchronized long getCurrentPosition() {
            if (this.getFirst().mMp2State == 1001) {
                throw new IllegalStateException();
            }
            return this.getCurrentPlayer().getCurrentPosition();
        }

        synchronized long getDuration() {
            if (this.getFirst().mMp2State == 1001) {
                throw new IllegalStateException();
            }
            return this.getCurrentPlayer().getDuration();
        }

        synchronized long getBufferedPosition() {
            if (this.getFirst().mMp2State == 1001) {
                throw new IllegalStateException();
            }
            MediaPlayerSource src = this.mQueue.get(0);
            return (long)src.getPlayer().getDuration() * (long)src.mBufferedPercentage.get() / 100L;
        }

        synchronized void setAudioAttributes(AudioAttributesCompat attributes) {
            this.mAudioAttributes = attributes;
            AudioAttributes attr = this.mAudioAttributes == null ? null : (AudioAttributes)this.mAudioAttributes.unwrap();
            this.getCurrentPlayer().setAudioAttributes(attr);
        }

        synchronized AudioAttributesCompat getAudioAttributes() {
            return this.mAudioAttributes;
        }

        synchronized DataSourceError onPrepared(MediaPlayer mp) {
            for (int i = 0; i < this.mQueue.size(); ++i) {
                MediaPlayerSource src = this.mQueue.get(i);
                if (mp != src.getPlayer()) continue;
                if (i == 0) {
                    if (src.mPlayPending) {
                        src.mPlayPending = false;
                        src.getPlayer().start();
                        this.setMp2State(src.getPlayer(), 1004);
                    } else {
                        this.setMp2State(src.getPlayer(), 1002);
                    }
                }
                src.mSourceState = 2;
                this.setBufferingState(src.getPlayer(), 1);
                return this.prepareAt(i + 1);
            }
            return null;
        }

        synchronized DataSourceError onCompletion(MediaPlayer mp) {
            if (!this.mQueue.isEmpty() && mp == this.getCurrentPlayer()) {
                if (this.mQueue.size() == 1) {
                    this.setMp2State(mp, 1003);
                    final DataSourceDesc dsd = this.mQueue.get(0).getDSD();
                    MediaPlayer2Impl.this.notifyPlayerEvent(new PlayerEventNotifier(){

                        @Override
                        public void notify(BaseMediaPlayer.PlayerEventCallback cb) {
                            cb.onCurrentDataSourceChanged(MediaPlayer2Impl.this.mBaseMediaPlayerImpl, null);
                        }
                    });
                    MediaPlayer2Impl.this.notifyMediaPlayer2Event(new Mp2EventNotifier(){

                        @Override
                        public void notify(MediaPlayer2.EventCallback callback) {
                            callback.onInfo(MediaPlayer2Impl.this, dsd, 6, 0);
                        }
                    });
                    return null;
                }
                this.moveToNext();
            }
            return this.playCurrent();
        }

        synchronized void moveToNext() {
            MediaPlayerSource src1 = this.mQueue.remove(0);
            src1.getPlayer().release();
            if (this.mQueue.isEmpty()) {
                throw new IllegalStateException("player/source queue emptied");
            }
            final MediaPlayerSource src2 = this.mQueue.get(0);
            if (src1.mPlayerState != src2.mPlayerState) {
                MediaPlayer2Impl.this.notifyPlayerEvent(new PlayerEventNotifier(){

                    @Override
                    public void notify(BaseMediaPlayer.PlayerEventCallback cb) {
                        cb.onPlayerStateChanged(MediaPlayer2Impl.this.mBaseMediaPlayerImpl, src2.mPlayerState);
                    }
                });
            }
            MediaPlayer2Impl.this.notifyPlayerEvent(new PlayerEventNotifier(){

                @Override
                public void notify(BaseMediaPlayer.PlayerEventCallback cb) {
                    cb.onCurrentDataSourceChanged(MediaPlayer2Impl.this.mBaseMediaPlayerImpl, src2.mDSD);
                }
            });
        }

        synchronized DataSourceError playCurrent() {
            DataSourceError err = null;
            final MediaPlayerSource src = this.mQueue.get(0);
            if (this.mSurface != null) {
                src.getPlayer().setSurface(this.mSurface);
            }
            if (this.mVolume != null) {
                src.getPlayer().setVolume(this.mVolume.floatValue(), this.mVolume.floatValue());
            }
            if (this.mAudioAttributes != null) {
                src.getPlayer().setAudioAttributes((AudioAttributes)this.mAudioAttributes.unwrap());
            }
            if (this.mAuxEffect != null) {
                src.getPlayer().attachAuxEffect(this.mAuxEffect.intValue());
            }
            if (this.mAuxEffectSendLevel != null) {
                src.getPlayer().setAuxEffectSendLevel(this.mAuxEffectSendLevel.floatValue());
            }
            if (this.mSyncParams != null) {
                src.getPlayer().setSyncParams(this.mSyncParams);
            }
            if (this.mPlaybackParams != null) {
                src.getPlayer().setPlaybackParams(this.mPlaybackParams);
            }
            if (src.mSourceState == 2) {
                src.getPlayer().start();
                this.setMp2State(src.getPlayer(), 1004);
                MediaPlayer2Impl.this.notifyMediaPlayer2Event(new Mp2EventNotifier(){

                    @Override
                    public void notify(MediaPlayer2.EventCallback callback) {
                        callback.onInfo(MediaPlayer2Impl.this, src.getDSD(), 2, 0);
                    }
                });
                this.prepareAt(1);
            } else {
                if (src.mSourceState == 0) {
                    err = this.prepareAt(0);
                }
                src.mPlayPending = true;
            }
            return err;
        }

        synchronized void onError(MediaPlayer mp) {
            this.setMp2State(mp, 1005);
            this.setBufferingState(mp, 0);
        }

        synchronized DataSourceError prepareAt(int n) {
            if (n >= Math.min(2, this.mQueue.size()) || this.mQueue.get((int)n).mSourceState != 0 || n != 0 && this.getPlayerState() == 0) {
                return null;
            }
            MediaPlayerSource src = this.mQueue.get(n);
            try {
                if (this.mAudioSessionId != null) {
                    src.getPlayer().setAudioSessionId(this.mAudioSessionId.intValue());
                }
                src.mSourceState = 1;
                MediaPlayer2Impl.handleDataSource(src);
                src.getPlayer().prepareAsync();
                return null;
            }
            catch (Exception e) {
                DataSourceDesc dsd = src.getDSD();
                this.setMp2State(src.getPlayer(), 1005);
                return new DataSourceError(dsd, 1, -1010);
            }
        }

        synchronized void skipToNext() {
            if (this.mQueue.size() <= 1) {
                throw new IllegalStateException("No next source available");
            }
            MediaPlayerSource src = this.mQueue.get(0);
            this.moveToNext();
            if (src.mPlayerState == 2 || src.mPlayPending) {
                this.playCurrent();
            }
        }

        synchronized void setLooping(boolean loop) {
            this.getCurrentPlayer().setLooping(loop);
        }

        synchronized void setPlaybackParams(PlaybackParams playbackParams) {
            try {
                this.getCurrentPlayer().setPlaybackParams(playbackParams);
            }
            catch (IllegalStateException e) {
                this.mPlaybackParamsToSetAfterSetDataSource = playbackParams;
                return;
            }
            this.mPlaybackParams = playbackParams;
        }

        synchronized float getVolume() {
            return this.mVolume.floatValue();
        }

        synchronized void setVolume(float volume) {
            this.mVolume = Float.valueOf(volume);
            this.getCurrentPlayer().setVolume(volume, volume);
        }

        synchronized void setSurface(Surface surface) {
            this.mSurface = surface;
            this.getCurrentPlayer().setSurface(surface);
        }

        synchronized int getVideoWidth() {
            return this.getCurrentPlayer().getVideoWidth();
        }

        synchronized int getVideoHeight() {
            return this.getCurrentPlayer().getVideoHeight();
        }

        synchronized PersistableBundle getMetrics() {
            return this.getCurrentPlayer().getMetrics();
        }

        synchronized PlaybackParams getPlaybackParams() {
            return this.getCurrentPlayer().getPlaybackParams();
        }

        synchronized void setSyncParams(SyncParams params) {
            this.getCurrentPlayer().setSyncParams(params);
            this.mSyncParams = params;
        }

        synchronized SyncParams getSyncParams() {
            return this.getCurrentPlayer().getSyncParams();
        }

        synchronized void seekTo(long msec, int mode) {
            this.getCurrentPlayer().seekTo(msec, mode);
        }

        synchronized void reset() {
            MediaPlayerSource src = this.mQueue.get(0);
            src.getPlayer().reset();
            src.mBufferedPercentage.set(0);
            this.mVolume = Float.valueOf(1.0f);
            this.mSurface = null;
            this.mAuxEffect = null;
            this.mAuxEffectSendLevel = null;
            this.mAudioAttributes = null;
            this.mAudioSessionId = null;
            this.mSyncParams = null;
            this.mPlaybackParams = null;
            this.setMp2State(src.getPlayer(), 1001);
            this.setBufferingState(src.getPlayer(), 0);
        }

        synchronized MediaTimestamp2 getTimestamp() {
            MediaTimestamp t = this.getCurrentPlayer().getTimestamp();
            return t == null ? null : new MediaTimestamp2(t);
        }

        synchronized void setAudioSessionId(int sessionId) {
            this.getCurrentPlayer().setAudioSessionId(sessionId);
            this.mAudioSessionId = sessionId;
        }

        synchronized int getAudioSessionId() {
            return this.getCurrentPlayer().getAudioSessionId();
        }

        synchronized void attachAuxEffect(int effectId) {
            this.getCurrentPlayer().attachAuxEffect(effectId);
            this.mAuxEffect = effectId;
        }

        synchronized void setAuxEffectSendLevel(float level) {
            this.getCurrentPlayer().setAuxEffectSendLevel(level);
            this.mAuxEffectSendLevel = Float.valueOf(level);
        }

        synchronized MediaPlayer.TrackInfo[] getTrackInfo() {
            return this.getCurrentPlayer().getTrackInfo();
        }

        synchronized int getSelectedTrack(int trackType) {
            return this.getCurrentPlayer().getSelectedTrack(trackType);
        }

        synchronized void selectTrack(int index) {
            this.getCurrentPlayer().selectTrack(index);
        }

        synchronized void deselectTrack(int index) {
            this.getCurrentPlayer().deselectTrack(index);
        }

        synchronized MediaPlayer.DrmInfo getDrmInfo() {
            return this.getCurrentPlayer().getDrmInfo();
        }

        synchronized void prepareDrm(UUID uuid) throws ResourceBusyException, MediaPlayer.ProvisioningServerErrorException, MediaPlayer.ProvisioningNetworkErrorException, UnsupportedSchemeException {
            this.getCurrentPlayer().prepareDrm(uuid);
        }

        synchronized void releaseDrm() throws MediaPlayer.NoDrmSchemeException {
            this.getCurrentPlayer().stop();
            this.getCurrentPlayer().releaseDrm();
        }

        synchronized byte[] provideKeyResponse(byte[] keySetId, byte[] response) throws DeniedByServerException, MediaPlayer.NoDrmSchemeException {
            return this.getCurrentPlayer().provideKeyResponse(keySetId, response);
        }

        synchronized void restoreKeys(byte[] keySetId) throws MediaPlayer.NoDrmSchemeException {
            this.getCurrentPlayer().restoreKeys(keySetId);
        }

        synchronized String getDrmPropertyString(String propertyName) throws MediaPlayer.NoDrmSchemeException {
            return this.getCurrentPlayer().getDrmPropertyString(propertyName);
        }

        synchronized void setDrmPropertyString(String propertyName, String value) throws MediaPlayer.NoDrmSchemeException {
            this.getCurrentPlayer().setDrmPropertyString(propertyName, value);
        }

        synchronized void setOnDrmConfigHelper(MediaPlayer.OnDrmConfigHelper onDrmConfigHelper) {
            this.getCurrentPlayer().setOnDrmConfigHelper(onDrmConfigHelper);
        }

        synchronized MediaDrm.KeyRequest getKeyRequest(byte[] keySetId, byte[] initData, String mimeType, int keyType, Map<String, String> optionalParameters) throws MediaPlayer.NoDrmSchemeException {
            return this.getCurrentPlayer().getKeyRequest(keySetId, initData, mimeType, keyType, optionalParameters);
        }

        synchronized void setMp2State(MediaPlayer mp, int mp2State) {
            for (MediaPlayerSource src : this.mQueue) {
                if (src.getPlayer() != mp) continue;
                if (src.mMp2State == mp2State) {
                    return;
                }
                src.mMp2State = mp2State;
                final int playerState = (Integer)sStateMap.get((Object)mp2State);
                if (src.mPlayerState == playerState) {
                    return;
                }
                src.mPlayerState = playerState;
                MediaPlayer2Impl.this.notifyPlayerEvent(new PlayerEventNotifier(){

                    @Override
                    public void notify(BaseMediaPlayer.PlayerEventCallback cb) {
                        cb.onPlayerStateChanged(MediaPlayer2Impl.this.mBaseMediaPlayerImpl, playerState);
                    }
                });
                return;
            }
        }

        synchronized void setBufferingState(MediaPlayer mp, final int state) {
            for (final MediaPlayerSource src : this.mQueue) {
                if (src.getPlayer() != mp) continue;
                if (src.mBufferingState == state) {
                    return;
                }
                src.mBufferingState = state;
                MediaPlayer2Impl.this.notifyPlayerEvent(new PlayerEventNotifier(){

                    @Override
                    public void notify(BaseMediaPlayer.PlayerEventCallback cb) {
                        DataSourceDesc dsd = src.getDSD();
                        cb.onBufferingStateChanged(MediaPlayer2Impl.this.mBaseMediaPlayerImpl, dsd, state);
                    }
                });
                return;
            }
        }

        synchronized int getMediaPlayer2State() {
            return this.mQueue.get((int)0).mMp2State;
        }

        synchronized int getBufferingState() {
            return this.mQueue.get((int)0).mBufferingState;
        }

        synchronized int getPlayerState() {
            return this.mQueue.get((int)0).mPlayerState;
        }

        synchronized MediaPlayerSource getSourceForPlayer(MediaPlayer mp) {
            for (MediaPlayerSource src : this.mQueue) {
                if (src.getPlayer() != mp) continue;
                return src;
            }
            return null;
        }
    }

    private class MediaPlayerSource {
        volatile DataSourceDesc mDSD;
        MediaPlayer mPlayer;
        final AtomicInteger mBufferedPercentage = new AtomicInteger(0);
        int mSourceState = 0;
        int mMp2State = 1001;
        int mBufferingState = 0;
        int mPlayerState = 0;
        boolean mPlayPending;

        MediaPlayerSource(DataSourceDesc dsd) {
            this.mDSD = dsd;
            MediaPlayer2Impl.this.setUpListeners(this);
        }

        DataSourceDesc getDSD() {
            return this.mDSD;
        }

        synchronized MediaPlayer getPlayer() {
            if (this.mPlayer == null) {
                this.mPlayer = new MediaPlayer();
            }
            return this.mPlayer;
        }
    }

    private static class DataSourceError {
        final DataSourceDesc mDSD;
        final int mWhat;
        final int mExtra;

        DataSourceError(DataSourceDesc dsd, int what, int extra) {
            this.mDSD = dsd;
            this.mWhat = what;
            this.mExtra = extra;
        }
    }

    private abstract class Task
    implements Runnable {
        private final int mMediaCallType;
        private final boolean mNeedToWaitForEventToComplete;
        private DataSourceDesc mDSD;

        Task(int mediaCallType, boolean needToWaitForEventToComplete) {
            this.mMediaCallType = mediaCallType;
            this.mNeedToWaitForEventToComplete = needToWaitForEventToComplete;
        }

        abstract void process() throws IOException, MediaPlayer2.NoDrmSchemeException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int status = 0;
            try {
                this.process();
            }
            catch (IllegalStateException e) {
                status = 1;
            }
            catch (IllegalArgumentException e) {
                status = 2;
            }
            catch (SecurityException e) {
                status = 3;
            }
            catch (IOException e) {
                status = 4;
            }
            catch (Exception e) {
                status = Integer.MIN_VALUE;
            }
            this.mDSD = MediaPlayer2Impl.this.getCurrentDataSource();
            if (!this.mNeedToWaitForEventToComplete || status != 0) {
                this.sendCompleteNotification(status);
                Object object = MediaPlayer2Impl.this.mTaskLock;
                synchronized (object) {
                    MediaPlayer2Impl.this.mCurrentTask = null;
                    MediaPlayer2Impl.this.processPendingTask_l();
                }
            }
        }

        private void sendCompleteNotification(final int status) {
            if (this.mMediaCallType == 1003) {
                return;
            }
            MediaPlayer2Impl.this.notifyMediaPlayer2Event(new Mp2EventNotifier(){

                @Override
                public void notify(MediaPlayer2.EventCallback cb) {
                    cb.onCallCompleted(MediaPlayer2Impl.this, Task.this.mDSD, Task.this.mMediaCallType, status);
                }
            });
        }
    }

    public static final class ProvisioningServerErrorExceptionImpl
    extends MediaPlayer2.ProvisioningServerErrorException {
        public ProvisioningServerErrorExceptionImpl(String detailMessage) {
            super(detailMessage);
        }
    }

    public static final class ProvisioningNetworkErrorExceptionImpl
    extends MediaPlayer2.ProvisioningNetworkErrorException {
        public ProvisioningNetworkErrorExceptionImpl(String detailMessage) {
            super(detailMessage);
        }
    }

    public static final class NoDrmSchemeExceptionImpl
    extends MediaPlayer2.NoDrmSchemeException {
        public NoDrmSchemeExceptionImpl(String detailMessage) {
            super(detailMessage);
        }
    }

    public static final class DrmInfoImpl
    extends MediaPlayer2.DrmInfo {
        private Map<UUID, byte[]> mMapPssh;
        private UUID[] mSupportedSchemes;

        @Override
        public Map<UUID, byte[]> getPssh() {
            return this.mMapPssh;
        }

        @Override
        public List<UUID> getSupportedSchemes() {
            return Arrays.asList(this.mSupportedSchemes);
        }

        private DrmInfoImpl(Map<UUID, byte[]> pssh, UUID[] supportedSchemes) {
            this.mMapPssh = pssh;
            this.mSupportedSchemes = supportedSchemes;
        }

        private DrmInfoImpl(Parcel parcel) {
            Log.v((String)MediaPlayer2Impl.TAG, (String)("DrmInfoImpl(" + parcel + ") size " + parcel.dataSize()));
            int psshsize = parcel.readInt();
            byte[] pssh = new byte[psshsize];
            parcel.readByteArray(pssh);
            Log.v((String)MediaPlayer2Impl.TAG, (String)("DrmInfoImpl() PSSH: " + this.arrToHex(pssh)));
            this.mMapPssh = this.parsePSSH(pssh, psshsize);
            Log.v((String)MediaPlayer2Impl.TAG, (String)("DrmInfoImpl() PSSH: " + this.mMapPssh));
            int supportedDRMsCount = parcel.readInt();
            this.mSupportedSchemes = new UUID[supportedDRMsCount];
            for (int i = 0; i < supportedDRMsCount; ++i) {
                byte[] uuid = new byte[16];
                parcel.readByteArray(uuid);
                this.mSupportedSchemes[i] = this.bytesToUUID(uuid);
                Log.v((String)MediaPlayer2Impl.TAG, (String)("DrmInfoImpl() supportedScheme[" + i + "]: " + this.mSupportedSchemes[i]));
            }
            Log.v((String)MediaPlayer2Impl.TAG, (String)("DrmInfoImpl() Parcel psshsize: " + psshsize + " supportedDRMsCount: " + supportedDRMsCount));
        }

        private DrmInfoImpl makeCopy() {
            return new DrmInfoImpl(this.mMapPssh, this.mSupportedSchemes);
        }

        private String arrToHex(byte[] bytes) {
            String out = "0x";
            for (int i = 0; i < bytes.length; ++i) {
                out = out + String.format("%02x", bytes[i]);
            }
            return out;
        }

        private UUID bytesToUUID(byte[] uuid) {
            long msb = 0L;
            long lsb = 0L;
            for (int i = 0; i < 8; ++i) {
                msb |= ((long)uuid[i] & 0xFFL) << 8 * (7 - i);
                lsb |= ((long)uuid[i + 8] & 0xFFL) << 8 * (7 - i);
            }
            return new UUID(msb, lsb);
        }

        private Map<UUID, byte[]> parsePSSH(byte[] pssh, int psshsize) {
            HashMap<UUID, byte[]> result = new HashMap<UUID, byte[]>();
            int uuidSize = 16;
            int dataLenSize = 4;
            int len = psshsize;
            int numentries = 0;
            int i = 0;
            while (len > 0) {
                if (len < 16) {
                    Log.w((String)MediaPlayer2Impl.TAG, (String)String.format("parsePSSH: len is too short to parse UUID: (%d < 16) pssh: %d", len, psshsize));
                    return null;
                }
                byte[] subset = Arrays.copyOfRange(pssh, i, i + 16);
                UUID uuid = this.bytesToUUID(subset);
                i += 16;
                if ((len -= 16) < 4) {
                    Log.w((String)MediaPlayer2Impl.TAG, (String)String.format("parsePSSH: len is too short to parse datalen: (%d < 4) pssh: %d", len, psshsize));
                    return null;
                }
                subset = Arrays.copyOfRange(pssh, i, i + 4);
                int datalen = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? (subset[3] & 0xFF) << 24 | (subset[2] & 0xFF) << 16 | (subset[1] & 0xFF) << 8 | subset[0] & 0xFF : (subset[0] & 0xFF) << 24 | (subset[1] & 0xFF) << 16 | (subset[2] & 0xFF) << 8 | subset[3] & 0xFF;
                i += 4;
                if ((len -= 4) < datalen) {
                    Log.w((String)MediaPlayer2Impl.TAG, (String)String.format("parsePSSH: len is too short to parse data: (%d < %d) pssh: %d", len, datalen, psshsize));
                    return null;
                }
                byte[] data = Arrays.copyOfRange(pssh, i, i + datalen);
                i += datalen;
                len -= datalen;
                Log.v((String)MediaPlayer2Impl.TAG, (String)String.format("parsePSSH[%d]: <%s, %s> pssh: %d", numentries, uuid, this.arrToHex(data), psshsize));
                ++numentries;
                result.put(uuid, data);
            }
            return result;
        }
    }

    private static interface DrmEventNotifier {
        public void notify(MediaPlayer2.DrmEventCallback var1);
    }

    private static interface PlayerEventNotifier {
        public void notify(BaseMediaPlayer.PlayerEventCallback var1);
    }

    private static interface Mp2EventNotifier {
        public void notify(MediaPlayer2.EventCallback var1);
    }

    public static final class TrackInfoImpl
    extends MediaPlayer2.TrackInfo {
        final int mTrackType;
        final MediaFormat mFormat;

        @Override
        public int getTrackType() {
            return this.mTrackType;
        }

        @Override
        public String getLanguage() {
            String language = this.mFormat.getString("language");
            return language == null ? "und" : language;
        }

        @Override
        public MediaFormat getFormat() {
            if (this.mTrackType == 3 || this.mTrackType == 4) {
                return this.mFormat;
            }
            return null;
        }

        TrackInfoImpl(int type, MediaFormat format) {
            this.mTrackType = type;
            this.mFormat = format;
        }

        @Override
        public String toString() {
            StringBuilder out = new StringBuilder(128);
            out.append(this.getClass().getName());
            out.append('{');
            switch (this.mTrackType) {
                case 1: {
                    out.append("VIDEO");
                    break;
                }
                case 2: {
                    out.append("AUDIO");
                    break;
                }
                case 3: {
                    out.append("TIMEDTEXT");
                    break;
                }
                case 4: {
                    out.append("SUBTITLE");
                    break;
                }
                default: {
                    out.append("UNKNOWN");
                }
            }
            out.append(", " + this.mFormat.toString());
            out.append("}");
            return out.toString();
        }
    }
}

